'use strict';

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } };

var _inherits = function (subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

exports.__esModule = true;

var _Store2 = require('flummox');

var DropTargetStore = (function (_Store) {
  function DropTargetStore(flux, targetIdPredicate) {
    _classCallCheck(this, DropTargetStore);

    _Store.call(this);
    this.targetIdPredicate = targetIdPredicate;
    this.previousTargetIds = [];

    var dragDropActionIds = flux.dragDropActionIds;
    var registryActionIds = flux.registryActionIds;

    this.register(dragDropActionIds.beginDrag, this.handleBeginDrag);
    this.register(dragDropActionIds.endDrag, this.handleEndDrag);
    this.register(dragDropActionIds.drop, this.handleDrop);
    this.register(dragDropActionIds.hover, this.handleHover);
    this.register(registryActionIds.removeTarget, this.handleRemoveTarget);
  }

  _inherits(DropTargetStore, _Store);

  DropTargetStore.prototype.handleHover = function handleHover(_ref) {
    var targetIds = _ref.targetIds;

    var wasOver = this.previousTargetIds.some(this.targetIdPredicate);
    var isOver = targetIds.some(this.targetIdPredicate);
    this.previousTargetIds = targetIds;

    if (wasOver || isOver) {
      this.forceUpdate();
    }
  };

  DropTargetStore.prototype.handleRemoveTarget = function handleRemoveTarget(_ref2) {
    var targetId = _ref2.targetId;

    if (this.targetIdPredicate(targetId)) {
      this.forceUpdate();
    }
  };

  DropTargetStore.prototype.handleBeginDrag = function handleBeginDrag() {
    this.forceUpdate();
  };

  DropTargetStore.prototype.handleDrop = function handleDrop() {
    this.forceUpdate();
  };

  DropTargetStore.prototype.handleEndDrag = function handleEndDrag() {
    this.forceUpdate();
  };

  return DropTargetStore;
})(_Store2.Store);

exports['default'] = DropTargetStore;
module.exports = exports['default'];