"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

module.exports = toKey;

var invariant = _interopRequire(require("invariant"));

var isArray = _interopRequire(require("lodash/lang/isArray"));

function toKey(key) {
  if (typeof key === "string") {
    return "KEY_" + key;
  } else if (typeof key === "symbol") {
    return key;
  } else if (isArray(key)) {
    return key.join(String.fromCharCode(55357, 56489));
  } else {
    invariant(false, "%s is neither string nor symbol");
  }
}