'use strict';

exports.__esModule = true;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _reduxLibCreateStore = require('redux/lib/createStore');

var _reduxLibCreateStore2 = _interopRequireDefault(_reduxLibCreateStore);

var _reducers = require('./reducers');

var _reducers2 = _interopRequireDefault(_reducers);

var _actionsDragDrop = require('./actions/dragDrop');

var dragDropActions = _interopRequireWildcard(_actionsDragDrop);

var _DragDropMonitor = require('./DragDropMonitor');

var _DragDropMonitor2 = _interopRequireDefault(_DragDropMonitor);

var _HandlerRegistry = require('./HandlerRegistry');

var _HandlerRegistry2 = _interopRequireDefault(_HandlerRegistry);

var DragDropManager = (function () {
  function DragDropManager(createBackend) {
    _classCallCheck(this, DragDropManager);

    var store = _reduxLibCreateStore2['default'](_reducers2['default']);

    this.store = store;
    this.monitor = new _DragDropMonitor2['default'](store);
    this.registry = this.monitor.registry;
    this.backend = createBackend(this);

    store.subscribe(this.handleRefCountChange.bind(this));
  }

  DragDropManager.prototype.handleRefCountChange = function handleRefCountChange() {
    var shouldSetUp = this.store.getState().refCount > 0;
    if (shouldSetUp && !this.isSetUp) {
      this.backend.setup();
      this.isSetUp = true;
    } else if (!shouldSetUp && this.isSetUp) {
      this.backend.teardown();
      this.isSetUp = false;
    }
  };

  DragDropManager.prototype.getMonitor = function getMonitor() {
    return this.monitor;
  };

  DragDropManager.prototype.getBackend = function getBackend() {
    return this.backend;
  };

  DragDropManager.prototype.getRegistry = function getRegistry() {
    return this.registry;
  };

  DragDropManager.prototype.getActions = function getActions() {
    var manager = this;
    var dispatch = this.store.dispatch;

    function bindActionCreator(actionCreator) {
      return function () {
        var action = actionCreator.apply(manager, arguments);
        if (typeof action !== 'undefined') {
          dispatch(action);
        }
      };
    }

    return Object.keys(dragDropActions).filter(function (key) {
      return typeof dragDropActions[key] === 'function';
    }).reduce(function (boundActions, key) {
      boundActions[key] = bindActionCreator(dragDropActions[key]);
      return boundActions;
    }, {});
  };

  return DragDropManager;
})();

exports['default'] = DragDropManager;
module.exports = exports['default'];