'use strict';

exports.__esModule = true;
exports['default'] = createBackend;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodashUtilityNoop = require('lodash/utility/noop');

var _lodashUtilityNoop2 = _interopRequireDefault(_lodashUtilityNoop);

var TestBackend = (function () {
  function TestBackend(manager) {
    _classCallCheck(this, TestBackend);

    this.actions = manager.getActions();
  }

  TestBackend.prototype.setup = function setup() {
    this.didCallSetup = true;
  };

  TestBackend.prototype.teardown = function teardown() {
    this.didCallTeardown = true;
  };

  TestBackend.prototype.connectDragSource = function connectDragSource() {
    return _lodashUtilityNoop2['default'];
  };

  TestBackend.prototype.connectDragPreview = function connectDragPreview() {
    return _lodashUtilityNoop2['default'];
  };

  TestBackend.prototype.connectDropTarget = function connectDropTarget() {
    return _lodashUtilityNoop2['default'];
  };

  TestBackend.prototype.simulateBeginDrag = function simulateBeginDrag(sourceIds, options) {
    this.actions.beginDrag(sourceIds, options);
  };

  TestBackend.prototype.simulatePublishDragSource = function simulatePublishDragSource() {
    this.actions.publishDragSource();
  };

  TestBackend.prototype.simulateHover = function simulateHover(targetIds, options) {
    this.actions.hover(targetIds, options);
  };

  TestBackend.prototype.simulateDrop = function simulateDrop() {
    this.actions.drop();
  };

  TestBackend.prototype.simulateEndDrag = function simulateEndDrag() {
    this.actions.endDrag();
  };

  return TestBackend;
})();

function createBackend(manager) {
  return new TestBackend(manager);
}

module.exports = exports['default'];