'use strict';

exports.__esModule = true;
exports['default'] = dirtyHandlerIds;
exports.areDirty = areDirty;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _lodashXor = require('lodash/xor');

var _lodashXor2 = _interopRequireDefault(_lodashXor);

var _lodashIntersection = require('lodash/intersection');

var _lodashIntersection2 = _interopRequireDefault(_lodashIntersection);

var _actionsDragDrop = require('../actions/dragDrop');

var _actionsRegistry = require('../actions/registry');

var NONE = [];
var ALL = [];

function dirtyHandlerIds(state, action, dragOperation) {
  if (state === undefined) state = NONE;

  switch (action.type) {
    case _actionsDragDrop.HOVER:
      break;
    case _actionsRegistry.ADD_SOURCE:
    case _actionsRegistry.ADD_TARGET:
    case _actionsRegistry.REMOVE_TARGET:
    case _actionsRegistry.REMOVE_SOURCE:
      return NONE;
    case _actionsDragDrop.BEGIN_DRAG:
    case _actionsDragDrop.PUBLISH_DRAG_SOURCE:
    case _actionsDragDrop.END_DRAG:
    case _actionsDragDrop.DROP:
    default:
      return ALL;
  }

  var targetIds = action.targetIds;
  var prevTargetIds = dragOperation.targetIds;

  var dirtyHandlerIds = _lodashXor2['default'](targetIds, prevTargetIds);

  var didChange = false;
  if (dirtyHandlerIds.length === 0) {
    for (var i = 0; i < targetIds.length; i++) {
      if (targetIds[i] !== prevTargetIds[i]) {
        didChange = true;
        break;
      }
    }
  } else {
    didChange = true;
  }

  if (!didChange) {
    return NONE;
  }

  var prevInnermostTargetId = prevTargetIds[prevTargetIds.length - 1];
  var innermostTargetId = targetIds[targetIds.length - 1];

  if (prevInnermostTargetId !== innermostTargetId) {
    if (prevInnermostTargetId) {
      dirtyHandlerIds.push(prevInnermostTargetId);
    }
    if (innermostTargetId) {
      dirtyHandlerIds.push(innermostTargetId);
    }
  }

  return dirtyHandlerIds;
}

function areDirty(state, handlerIds) {
  if (state === NONE) {
    return false;
  }

  if (state === ALL || typeof handlerIds === 'undefined') {
    return true;
  }

  return _lodashIntersection2['default'](handlerIds, state).length > 0;
}