<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [lint][1]
    -   [Parameters][2]
    -   [Examples][3]
-   [build][4]
    -   [Parameters][5]
    -   [Examples][6]
-   [formats][7]
-   [formats.html][8]
    -   [Parameters][9]
    -   [Examples][10]
-   [formats.markdown][11]
    -   [Parameters][12]
    -   [Examples][13]
-   [formats.json][14]
    -   [Parameters][15]
    -   [Examples][16]

## lint

Lint files for non-standard or incorrect documentation
information, returning a potentially-empty string
of lint information intended for human-readable output.

### Parameters

-   `indexes` **([Array][17]&lt;[string][18]> | [string][18])** files to process
-   `args` **[Object][19]** args
    -   `args.external` **[Array][17]&lt;[string][18]>** a string regex / glob match pattern
        that defines what external modules will be whitelisted and included in the
        generated documentation.
    -   `args.shallow` **[boolean][20]** whether to avoid dependency parsing
        even in JavaScript code. (optional, default `false`)
    -   `args.inferPrivate` **[string][18]?** a valid regular expression string
        to infer whether a code element should be private, given its naming structure.
        For instance, you can specify `inferPrivate: '^_'` to automatically treat
        methods named like `_myMethod` as private.
    -   `args.extension` **([string][18] \| [Array][17]&lt;[string][18]>)?** treat additional file extensions
        as JavaScript, extending the default set of `js`, `es6`, and `jsx`.

### Examples

```javascript
documentation.lint('file.js').then(lintOutput => {
  if (lintOutput) {
    console.log(lintOutput);
    process.exit(1);
  } else {
    process.exit(0);
  }
});
```

Returns **[Promise][21]** promise with lint results

## build

Generate JavaScript documentation as a list of parsed JSDoc
comments, given a root file as a path.

### Parameters

-   `indexes` **([Array][17]&lt;[string][18]> | [string][18])** files to process
-   `args` **[Object][19]** args
    -   `args.external` **[Array][17]&lt;[string][18]>** a string regex / glob match pattern
        that defines what external modules will be whitelisted and included in the
        generated documentation.
    -   `args.shallow` **[boolean][20]** whether to avoid dependency parsing
        even in JavaScript code. (optional, default `false`)
    -   `args.order` **[Array][17]&lt;([string][18] \| [Object][19])>** optional array that
        defines sorting order of documentation (optional, default `[]`)
    -   `args.access` **[Array][17]&lt;[string][18]>** an array of access levels
        to output in documentation (optional, default `[]`)
    -   `args.hljs` **[Object][19]?** hljs optional args
        -   `args.hljs.highlightAuto` **[boolean][20]** hljs automatically detect language (optional, default `false`)
        -   `args.hljs.languages` **[Array][17]?** languages for hljs to choose from
    -   `args.inferPrivate` **[string][18]?** a valid regular expression string
        to infer whether a code element should be private, given its naming structure.
        For instance, you can specify `inferPrivate: '^_'` to automatically treat
        methods named like `_myMethod` as private.
    -   `args.extension` **([string][18] \| [Array][17]&lt;[string][18]>)?** treat additional file extensions
        as JavaScript, extending the default set of `js`, `es6`, and `jsx`.

### Examples

```javascript
var documentation = require('documentation');

documentation.build(['index.js'], {
  // only output comments with an explicit @public tag
  access: ['public']
}).then(res => {
  // res is an array of parsed comments with inferred properties
  // and more: everything you need to build documentation or
  // any other kind of code data.
});
```

Returns **[Promise][21]** results

## formats

Documentation's formats are modular methods that take comments
and config as input and return Promises with results,
like stringified JSON, markdown strings, or Vinyl objects for HTML
output.

## formats.html

Formats documentation as HTML.

### Parameters

-   `comments` **[Array][17]&lt;[Comment][22]>** parsed comments
-   `config` **[Object][19]** Options that can customize the output
    -   `config.theme` **[string][18]** Name of a module used for an HTML theme. (optional, default `'default_theme'`)

### Examples

```javascript
var documentation = require('documentation');
var streamArray = require('stream-array');
var vfs = require('vinyl-fs');

documentation.build(['index.js'])
  .then(documentation.formats.html)
  .then(output => {
    streamArray(output).pipe(vfs.dest('./output-directory'));
  });
```

Returns **[Promise][21]&lt;[Array][17]&lt;[Object][19]>>** Promise with results

## formats.markdown

Formats documentation as
[Markdown][23].

### Parameters

-   `comments` **[Array][17]&lt;[Object][19]>** parsed comments
-   `args` **[Object][19]** Options that can customize the output

### Examples

```javascript
var documentation = require('documentation');
var fs = require('fs');

documentation.build(['index.js'])
  .then(documentation.formats.md)
  .then(output => {
    // output is a string of Markdown data
    fs.writeFileSync('./output.md', output);
  });
```

Returns **[Promise][21]&lt;[string][18]>** a promise of the eventual value

## formats.json

Formats documentation as a JSON string.

### Parameters

-   `comments` **[Array][17]&lt;[Comment][22]>** parsed comments

### Examples

```javascript
var documentation = require('documentation');
var fs = require('fs');

documentation.build(['index.js'])
  .then(documentation.formats.json)
  .then(output => {
    // output is a string of JSON data
    fs.writeFileSync('./output.json', output);
  });
```

Returns **[Promise][21]&lt;[string][18]>** 

[1]: #lint

[2]: #parameters

[3]: #examples

[4]: #build

[5]: #parameters-1

[6]: #examples-1

[7]: #formats

[8]: #formatshtml

[9]: #parameters-2

[10]: #examples-2

[11]: #formatsmarkdown

[12]: #parameters-3

[13]: #examples-3

[14]: #formatsjson

[15]: #parameters-4

[16]: #examples-4

[17]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[18]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[19]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[20]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[21]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[22]: https://developer.mozilla.org/docs/Web/API/Comment/Comment

[23]: http://daringfireball.net/projects/markdown/
