"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _require = require("lodash"),
  merge = _require.merge,
  cloneDeep = _require.cloneDeep;
function isPlaceholder(part) {
  return part.type === "placeholder";
}
function _getTags(postParsed) {
  return postParsed.filter(isPlaceholder).reduce(function (tags, part) {
    // Stryker disable all : because this is for the xlsx module
    if (part.cellParsed) {
      part.cellParsed.forEach(function (cp) {
        if (cp.type === "placeholder" && cp.module !== "pro-xml-templating/xls-module-loop") {
          tags[cp.value] = tags[cp.value] || {};
        }
      });
      return tags;
    }
    tags[part.value] = tags[part.value] || {};
    // Stryker restore all

    if (part.subparsed) {
      tags[part.value] = merge(tags[part.value], _getTags(part.subparsed));
    }
    return tags;
  }, {});
}
function _getStructuredTags(postParsed) {
  return postParsed.filter(isPlaceholder).map(function (part) {
    if (part.subparsed) {
      part.subparsed = _getStructuredTags(part.subparsed);
    }
    return part;
  }, {});
}
var InspectModule = /*#__PURE__*/function () {
  function InspectModule() {
    _classCallCheck(this, InspectModule);
    this.name = "InspectModule";
    this.inspect = {};
    this.fullInspected = {};
    this.filePath = null;
  }
  _createClass(InspectModule, [{
    key: "optionsTransformer",
    value: function optionsTransformer(options, docxtemplater) {
      this.fileTypeConfig = docxtemplater.fileTypeConfig;
      this.zip = docxtemplater.zip;
      this.targets = docxtemplater.targets;
      this.fileType = docxtemplater.fileType;
      this.docxtemplater = docxtemplater;
      return options;
    }
    // eslint-disable-next-line complexity
  }, {
    key: "set",
    value: function set(obj) {
      if (obj.data) {
        this.inspect.tags = obj.data;
      }
      if (obj.inspect) {
        if (obj.inspect.filePath) {
          this.filePath = obj.inspect.filePath;
          this.inspect = this.fullInspected[this.filePath] || {};
        }
        if (obj.inspect.content) {
          this.inspect.content = obj.inspect.content;
        } else if (obj.inspect.postparsed) {
          this.inspect.postparsed = cloneDeep(obj.inspect.postparsed);
        } else if (obj.inspect.parsed) {
          this.inspect.parsed = cloneDeep(obj.inspect.parsed);
        } else if (obj.inspect.lexed) {
          this.inspect.lexed = cloneDeep(obj.inspect.lexed);
        } else if (obj.inspect.xmllexed) {
          this.inspect.xmllexed = cloneDeep(obj.inspect.xmllexed);
        }
        if (obj.inspect.resolved) {
          this.inspect.resolved = obj.inspect.resolved;
        }
        this.fullInspected[this.filePath] = this.inspect;
      }
    }
  }, {
    key: "on",
    value: function on(eventName) {
      if (eventName === "attached") {
        this.attached = false;
        this.inspect = {};
        this.fullInspected = {};
        this.filePath = null;
      }
    }
  }, {
    key: "nullGetter",
    value: function nullGetter(part, scopeManager, xt) {
      var inspected = this.fullInspected[xt.filePath];
      inspected.nullValues = inspected.nullValues || {
        summary: [],
        detail: []
      };
      inspected.nullValues.detail.push({
        part: part,
        scopeManager: scopeManager
      });
      inspected.nullValues.summary.push(scopeManager.scopePath.concat(part.value));
    }
  }, {
    key: "getTags",
    value: function getTags(file) {
      file = file || this.fileTypeConfig.textPath(this);
      return _getTags(cloneDeep(this.fullInspected[file].postparsed));
    }
  }, {
    key: "getAllTags",
    value: function getAllTags() {
      var _this = this;
      return Object.keys(this.fullInspected).reduce(function (result, file) {
        return merge(result, _this.getTags(file));
      }, {});
    }
  }, {
    key: "getStructuredTags",
    value: function getStructuredTags(file) {
      file = file || this.fileTypeConfig.textPath(this);
      return _getStructuredTags(cloneDeep(this.fullInspected[file].postparsed));
    }
  }, {
    key: "getAllStructuredTags",
    value: function getAllStructuredTags() {
      var _this2 = this;
      return Object.keys(this.fullInspected).reduce(function (result, file) {
        return result.concat(_this2.getStructuredTags(file));
      }, []);
    }
  }, {
    key: "getFileType",
    value: function getFileType() {
      return this.fileType;
    }
  }, {
    key: "getTemplatedFiles",
    value: function getTemplatedFiles() {
      return this.docxtemplater.templatedFiles;
    }
  }]);
  return InspectModule;
}();
module.exports = function () {
  return new InspectModule();
};