# dom-align

align source html element with target html element flexibly.
port from [kissyteam/component align](https://github.com/kissyteam/component/blob/master/lib/component/extension/align.js)

[![NPM version][npm-image]][npm-url]
[![build status][travis-image]][travis-url]
[![Test coverage][coveralls-image]][coveralls-url]
[![gemnasium deps][gemnasium-image]][gemnasium-url]
[![node version][node-image]][node-url]
[![npm download][download-image]][download-url]

[npm-image]: http://img.shields.io/npm/v/dom-align.svg?style=flat-square
[npm-url]: http://npmjs.org/package/dom-align
[travis-image]: https://img.shields.io/travis/yiminghe/dom-align.svg?style=flat-square
[travis-url]: https://travis-ci.org/yiminghe/dom-align
[coveralls-image]: https://img.shields.io/coveralls/yiminghe/dom-align.svg?style=flat-square
[coveralls-url]: https://coveralls.io/r/yiminghe/dom-align?branch=master
[gemnasium-image]: http://img.shields.io/gemnasium/yiminghe/dom-align.svg?style=flat-square
[gemnasium-url]: https://gemnasium.com/yiminghe/dom-align
[node-image]: https://img.shields.io/badge/node.js-%3E=_0.10-green.svg?style=flat-square
[node-url]: http://nodejs.org/download/
[download-image]: https://img.shields.io/npm/dm/dom-align.svg?style=flat-square
[download-url]: https://npmjs.org/package/dom-align

## Screenshot

<img height=444 src="http://gtms02.alicdn.com/tps/i2/TB1XIp2HXXXXXajaXXXgJfr8XXX-548-888.png">

## Install

[![dom-align](https://nodei.co/npm/dom-align.png)](https://npmjs.org/package/dom-align)

## Feature

* support ie6+ chrome firefox
* support align points and offset
* support auto adjust according to visible area

## Online Demo

* http://spmjs.io/docs/dom-align/examples/

## Usage

```js
var domAlign = require('dom-align');
// use domAlign
// sourceNode's initial style should be position:absolute;left:-9999px;top:-9999px;
domAlign(sourceNode, targetNode, {
  points: ['tl', 'tr'] // align top left point of sourceNode with top right point of targetNode
  offset: [10, 20] // the offset sourceNode by 10px in x and 20px in y
});
```

## API

### void domAlign(source: HTMLElement, target: HTMLElement, alignConfig: Object):Function

#### alignConfig object details

<table class="table table-bordered table-striped">
    <thead>
    <tr>
        <th style="width: 100px;">name</th>
        <th style="width: 50px;">type</th>
        <th>description</th>
    </tr>
    </thead>
    <tbody>
      <tr>
          <td>points</td>
          <td>String[2]</td>
          <td>move point of source node to align with point of target node, such as ['tr','cc'],
          align top right point of source node with center point of target node.
          point can be 't'(top), 'b'(bottom), 'c'(center), 'l'(left), 'r'(right)
      </td>
      </tr>
      <tr>
          <td>offset</td>
          <td>Number[2]</td>
          <td>offset source node by offset[0] in x and offset[1] in y</td>
      </tr>
      <tr>
          <td>overflow</td>
          <td>Object</td>
          <td>if adjustX field is true, then will adjust source node in x direction if source node is invisible.
          if adjustY field is true, then will adjust source node in y direction if source node is invisible.
          </td>
      </tr>
    </tbody>
</table>

## Development

```
npm install
npm start
```

## Example

http://localhost:8000/examples/index.md

## Test Case

http://localhost:8000/tests/runner.html?coverage

## Coverage

http://localhost:8000/node_modules/rc-server/node_modules/node-jscover/lib/front-end/jscoverage.html?w=http://localhost:8000/tests/runner.html?coverage

## License

dom-align is released under the MIT license.