import activeElement from './activeElement';
import addClass from './addClass';
import addEventListener from './addEventListener';
import { cancel as cancelAnimationFrame, request as requestAnimationFrame } from './animationFrame';
import closest from './closest';
import contains from './contains';
import style from './css';
import filter from './filterEventHandler';
import hasClass from './hasClass';
import height from './height';
import listen from './listen';
import matches from './matches';
import offset from './offset';
import offsetParent from './offsetParent';
import ownerDocument from './ownerDocument';
import ownerWindow from './ownerWindow';
import position from './position';
import querySelectorAll from './querySelectorAll';
import removeClass from './removeClass';
import removeEventListener from './removeEventListener';
import scrollParent from './scrollParent';
import scrollTop from './scrollTop';
import toggleClass from './toggleClass';
import width from './width';
export { addEventListener, removeEventListener, filter, listen, style, activeElement, ownerDocument, ownerWindow, requestAnimationFrame, cancelAnimationFrame, matches, height, width, offset, offsetParent, position, contains, scrollParent, scrollTop, querySelectorAll, closest, addClass, removeClass, hasClass, toggleClass, };
declare const _default: {
    addEventListener: typeof addEventListener;
    removeEventListener: typeof removeEventListener;
    filter: typeof filter;
    listen: typeof listen;
    style: typeof style;
    activeElement: typeof activeElement;
    ownerDocument: typeof ownerDocument;
    ownerWindow: typeof ownerWindow;
    requestAnimationFrame: (callback: FrameRequestCallback) => number;
    cancelAnimationFrame: (id: number) => void;
    matches: typeof matches;
    height: typeof height;
    width: typeof width;
    offset: typeof offset;
    offsetParent: typeof offsetParent;
    position: typeof position;
    contains: typeof contains;
    scrollParent: typeof scrollParent;
    scrollTop: {
        (node: Element): number;
        (node: Element, val: number): undefined;
    };
    querySelectorAll: typeof querySelectorAll;
    closest: typeof closest;
    addClass: typeof addClass;
    removeClass: typeof removeClass;
    hasClass: typeof hasClass;
    toggleClass: typeof toggleClass;
};
export default _default;
