# dom-nodes

[![Build Status][travis-image]][travis-url]

[![NPM version][npm-version-image]][npm-url]
[![NPM downloads][npm-downloads-image]][npm-url]
[![MIT License][license-image]][license-url]

## Usage

```js
import {isVoid} from 'dom-nodes'
isVoid('div') // false
isVoid('img') // true
```

`dom-nodes` exports all the methods [listed below](#API) giving you some simple tests to understand which kind of node you are dealing with.

This project includes [html-tags](https://github.com/sindresorhus/html-tags) and [svg-tag-names](https://github.com/wooorm/svg-tag-names) directly in its source code avoiding to rely on third party npm modules for such simple list of strings.
This project couldn't have been made without the projects above!

[travis-image]: https://img.shields.io/travis/riot/dom-nodes.svg?style=flat-square

[travis-url]: https://travis-ci.org/riot/dom-nodes

[license-image]: http://img.shields.io/badge/license-MIT-000000.svg?style=flat-square

[license-url]: LICENSE

[npm-version-image]: http://img.shields.io/npm/v/dom-nodes.svg?style=flat-square

[npm-downloads-image]: http://img.shields.io/npm/dm/dom-nodes.svg?style=flat-square

[npm-url]: https://npmjs.org/package/dom-nodes

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

-   [VOID_SVG_TAGS_LIST](#void_svg_tags_list)
-   [SVG_TAGS_LIST](#svg_tags_list)
-   [VOID_HTML_TAGS_LIST](#void_html_tags_list)
-   [HTML_TAGS_LIST](#html_tags_list)
-   [HTML_TAGS_RE](#html_tags_re)
-   [SVG_TAGS_RE](#svg_tags_re)
-   [VOID_HTML_TAGS_RE](#void_html_tags_re)
-   [VOID_SVG_TAGS_RE](#void_svg_tags_re)
-   [isVoid](#isvoid)
-   [isHtml](#ishtml)
-   [isSvg](#issvg)
-   [isCustom](#iscustom)

### VOID_SVG_TAGS_LIST

SVG void elements that cannot be auto-closed and shouldn't contain child nodes.

### SVG_TAGS_LIST

-   **See: <https://github.com/wooorm/svg-tag-names>**

List of all the available svg tags

### VOID_HTML_TAGS_LIST

-   **See: <http://www.w3.org/TR/html-markup/syntax.html#syntax-elements>**
-   **See: <http://www.w3.org/TR/html5/syntax.html#void-elements>**

HTML void elements that cannot be auto-closed and shouldn't contain child nodes.

### HTML_TAGS_LIST

-   **See: <https://github.com/sindresorhus/html-tags>**

List of all the html tags

### HTML_TAGS_RE

Regex matching all the html tags ignoring the cases

### SVG_TAGS_RE

Regex matching all the svg tags ignoring the cases

### VOID_HTML_TAGS_RE

Regex matching all the void html tags ignoring the cases

### VOID_SVG_TAGS_RE

Regex matching all the void svg tags ignoring the cases

### isVoid

True if it's a self closing tag

**Parameters**

-   `tag` **[String](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** test tag

**Examples**

```javascript
isVoid('meta') // true
isVoid('circle') // true
isVoid('IMG') // true
isVoid('div') // false
isVoid('mask') // false
```

Returns **[Boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)**

### isHtml

True if it's a HTML known tag

**Parameters**

-   `tag` **[String](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** test tag

**Examples**

```javascript
isHtml('img') // true
isHtml('IMG') // true
isHtml('Img') // true
isHtml('path') // false
```

Returns **[Boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)**

### isSvg

True if it's a SVG known tag

**Parameters**

-   `tag` **[String](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** test tag

**Examples**

```javascript
isSvg('g') // true
isSvg('radialGradient') // true
isSvg('radialgradient') // true
isSvg('div') // false
```

Returns **[Boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)**

### isCustom

True if it's not SVG nor a HTML known tag

**Parameters**

-   `tag` **[String](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** test tag

**Examples**

```javascript
isCustom('my-component') // true
isCustom('div') // false
```

Returns **[Boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)**
