/**
 * Dom7 2.0.7
 * Minimalistic JavaScript library for DOM manipulation, with a jQuery-compatible API
 * http://framework7.io/docs/dom.html
 *
 * Copyright 2018, Vladimir Kharlampidi
 * The iDangero.us
 * http://www.idangero.us/
 *
 * Licensed under MIT
 *
 * Released on: June 14, 2018
 */!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):t.Dom7=e()}(this,function(){"use strict";var t="undefined"==typeof document?{body:{},addEventListener:function(){},removeEventListener:function(){},activeElement:{blur:function(){},nodeName:""},querySelector:function(){return null},querySelectorAll:function(){return[]},getElementById:function(){return null},createEvent:function(){return{initEvent:function(){}}},createElement:function(){return{children:[],childNodes:[],style:{},setAttribute:function(){},getElementsByTagName:function(){return[]}}},location:{hash:""}}:document,e="undefined"==typeof window?{document:t,navigator:{userAgent:""},location:{},history:{},CustomEvent:function(){return this},addEventListener:function(){},removeEventListener:function(){},getComputedStyle:function(){return{getPropertyValue:function(){return""}}},Image:function(){},Date:function(){},screen:{},setTimeout:function(){},clearTimeout:function(){}}:window,n=function(t){for(var e=0;e<t.length;e+=1)this[e]=t[e];return this.length=t.length,this};function i(i,r){var o=[],s=0;if(i&&!r&&i instanceof n)return i;if(i)if("string"==typeof i){var a,l,h=i.trim();if(h.indexOf("<")>=0&&h.indexOf(">")>=0){var u="div";for(0===h.indexOf("<li")&&(u="ul"),0===h.indexOf("<tr")&&(u="tbody"),0!==h.indexOf("<td")&&0!==h.indexOf("<th")||(u="tr"),0===h.indexOf("<tbody")&&(u="table"),0===h.indexOf("<option")&&(u="select"),(l=t.createElement(u)).innerHTML=h,s=0;s<l.childNodes.length;s+=1)o.push(l.childNodes[s])}else for(a=r||"#"!==i[0]||i.match(/[ .<>:~]/)?(r||t).querySelectorAll(i.trim()):[t.getElementById(i.trim().split("#")[1])],s=0;s<a.length;s+=1)a[s]&&o.push(a[s])}else if(i.nodeType||i===e||i===t)o.push(i);else if(i.length>0&&i[0].nodeType)for(s=0;s<i.length;s+=1)o.push(i[s]);return new n(o)}function r(t){for(var e=[],n=0;n<t.length;n+=1)-1===e.indexOf(t[n])&&e.push(t[n]);return e}function o(t){return e.requestAnimationFrame?e.requestAnimationFrame(t):e.webkitRequestAnimationFrame?e.webkitRequestAnimationFrame(t):e.setTimeout(t,1e3/60)}i.fn=n.prototype,i.Class=n,i.Dom7=n;var s=Object.freeze({addClass:function(t){if(void 0===t)return this;for(var e=t.split(" "),n=0;n<e.length;n+=1)for(var i=0;i<this.length;i+=1)void 0!==this[i]&&void 0!==this[i].classList&&this[i].classList.add(e[n]);return this},removeClass:function(t){for(var e=t.split(" "),n=0;n<e.length;n+=1)for(var i=0;i<this.length;i+=1)void 0!==this[i]&&void 0!==this[i].classList&&this[i].classList.remove(e[n]);return this},hasClass:function(t){return!!this[0]&&this[0].classList.contains(t)},toggleClass:function(t){for(var e=t.split(" "),n=0;n<e.length;n+=1)for(var i=0;i<this.length;i+=1)void 0!==this[i]&&void 0!==this[i].classList&&this[i].classList.toggle(e[n]);return this},attr:function(t,e){var n=arguments;if(1===arguments.length&&"string"==typeof t)return this[0]?this[0].getAttribute(t):void 0;for(var i=0;i<this.length;i+=1)if(2===n.length)this[i].setAttribute(t,e);else for(var r in t)this[i][r]=t[r],this[i].setAttribute(r,t[r]);return this},removeAttr:function(t){for(var e=0;e<this.length;e+=1)this[e].removeAttribute(t);return this},prop:function(t,e){var n=arguments;if(1!==arguments.length||"string"!=typeof t){for(var i=0;i<this.length;i+=1)if(2===n.length)this[i][t]=e;else for(var r in t)this[i][r]=t[r];return this}if(this[0])return this[0][t]},data:function(t,e){var n;if(void 0!==e){for(var i=0;i<this.length;i+=1)(n=this[i]).dom7ElementDataStorage||(n.dom7ElementDataStorage={}),n.dom7ElementDataStorage[t]=e;return this}if(n=this[0]){if(n.dom7ElementDataStorage&&t in n.dom7ElementDataStorage)return n.dom7ElementDataStorage[t];var r=n.getAttribute("data-"+t);return r||void 0}},removeData:function(t){for(var e=0;e<this.length;e+=1){var n=this[e];n.dom7ElementDataStorage&&n.dom7ElementDataStorage[t]&&(n.dom7ElementDataStorage[t]=null,delete n.dom7ElementDataStorage[t])}},dataset:function(){var t=this[0];if(t){var e,n={};if(t.dataset)for(var i in t.dataset)n[i]=t.dataset[i];else for(var r=0;r<t.attributes.length;r+=1){var o=t.attributes[r];o.name.indexOf("data-")>=0&&(n[(e=o.name.split("data-")[1],e.toLowerCase().replace(/-(.)/g,function(t,e){return e.toUpperCase()}))]=o.value)}for(var s in n)"false"===n[s]?n[s]=!1:"true"===n[s]?n[s]=!0:parseFloat(n[s])===1*n[s]&&(n[s]*=1);return n}},val:function(t){var e=this;if(void 0!==t){for(var n=0;n<e.length;n+=1){var i=e[n];if(Array.isArray(t)&&i.multiple&&"select"===i.nodeName.toLowerCase())for(var r=0;r<i.options.length;r+=1)i.options[r].selected=t.indexOf(i.options[r].value)>=0;else i.value=t}return e}if(e[0]){if(e[0].multiple&&"select"===e[0].nodeName.toLowerCase()){for(var o=[],s=0;s<e[0].selectedOptions.length;s+=1)o.push(e[0].selectedOptions[s].value);return o}return e[0].value}},transform:function(t){for(var e=0;e<this.length;e+=1){var n=this[e].style;n.webkitTransform=t,n.transform=t}return this},transition:function(t){"string"!=typeof t&&(t+="ms");for(var e=0;e<this.length;e+=1){var n=this[e].style;n.webkitTransitionDuration=t,n.transitionDuration=t}return this},on:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var r=e[0],o=e[1],s=e[2],a=e[3];function l(t){var e=t.target;if(e){var n=t.target.dom7EventData||[];if(n.indexOf(t)<0&&n.unshift(t),i(e).is(o))s.apply(e,n);else for(var r=i(e).parents(),a=0;a<r.length;a+=1)i(r[a]).is(o)&&s.apply(r[a],n)}}function h(t){var e=t&&t.target&&t.target.dom7EventData||[];e.indexOf(t)<0&&e.unshift(t),s.apply(this,e)}"function"==typeof e[1]&&(r=(t=e)[0],s=t[1],a=t[2],o=void 0),a||(a=!1);for(var u,f=r.split(" "),c=0;c<this.length;c+=1){var d=this[c];if(o)for(u=0;u<f.length;u+=1){var v=f[u];d.dom7LiveListeners||(d.dom7LiveListeners={}),d.dom7LiveListeners[v]||(d.dom7LiveListeners[v]=[]),d.dom7LiveListeners[v].push({listener:s,proxyListener:l}),d.addEventListener(v,l,a)}else for(u=0;u<f.length;u+=1){var g=f[u];d.dom7Listeners||(d.dom7Listeners={}),d.dom7Listeners[g]||(d.dom7Listeners[g]=[]),d.dom7Listeners[g].push({listener:s,proxyListener:h}),d.addEventListener(g,h,a)}}return this},off:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],o=e[2],s=e[3];"function"==typeof e[1]&&(i=(t=e)[0],o=t[1],s=t[2],r=void 0),s||(s=!1);for(var a=i.split(" "),l=0;l<a.length;l+=1)for(var h=a[l],u=0;u<this.length;u+=1){var f=this[u],c=void 0;if(!r&&f.dom7Listeners?c=f.dom7Listeners[h]:r&&f.dom7LiveListeners&&(c=f.dom7LiveListeners[h]),c&&c.length)for(var d=c.length-1;d>=0;d-=1){var v=c[d];o&&v.listener===o?(f.removeEventListener(h,v.proxyListener,s),c.splice(d,1)):o||(f.removeEventListener(h,v.proxyListener,s),c.splice(d,1))}}return this},once:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=this,r=e[0],o=e[1],s=e[2],a=e[3];return"function"==typeof e[1]&&(r=(t=e)[0],s=t[1],a=t[2],o=void 0),i.on(r,o,function t(){for(var e=[],n=arguments.length;n--;)e[n]=arguments[n];s.apply(this,e),i.off(r,o,t,a)},a)},trigger:function(){for(var n=[],i=arguments.length;i--;)n[i]=arguments[i];for(var r=n[0].split(" "),o=n[1],s=0;s<r.length;s+=1)for(var a=r[s],l=0;l<this.length;l+=1){var h=this[l],u=void 0;try{u=new e.CustomEvent(a,{detail:o,bubbles:!0,cancelable:!0})}catch(e){(u=t.createEvent("Event")).initEvent(a,!0,!0),u.detail=o}h.dom7EventData=n.filter(function(t,e){return e>0}),h.dispatchEvent(u),h.dom7EventData=[],delete h.dom7EventData}return this},transitionEnd:function(t){var e,n=["webkitTransitionEnd","transitionend"],i=this;function r(o){if(o.target===this)for(t.call(this,o),e=0;e<n.length;e+=1)i.off(n[e],r)}if(t)for(e=0;e<n.length;e+=1)i.on(n[e],r);return this},animationEnd:function(t){var e,n=["webkitAnimationEnd","animationend"],i=this;function r(o){if(o.target===this)for(t.call(this,o),e=0;e<n.length;e+=1)i.off(n[e],r)}if(t)for(e=0;e<n.length;e+=1)i.on(n[e],r);return this},width:function(){return this[0]===e?e.innerWidth:this.length>0?parseFloat(this.css("width")):null},outerWidth:function(t){if(this.length>0){if(t){var e=this.styles();return this[0].offsetWidth+parseFloat(e.getPropertyValue("margin-right"))+parseFloat(e.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null},height:function(){return this[0]===e?e.innerHeight:this.length>0?parseFloat(this.css("height")):null},outerHeight:function(t){if(this.length>0){if(t){var e=this.styles();return this[0].offsetHeight+parseFloat(e.getPropertyValue("margin-top"))+parseFloat(e.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null},offset:function(){if(this.length>0){var n=this[0],i=n.getBoundingClientRect(),r=t.body,o=n.clientTop||r.clientTop||0,s=n.clientLeft||r.clientLeft||0,a=n===e?e.scrollY:n.scrollTop,l=n===e?e.scrollX:n.scrollLeft;return{top:i.top+a-o,left:i.left+l-s}}return null},hide:function(){for(var t=0;t<this.length;t+=1)this[t].style.display="none";return this},show:function(){for(var t=0;t<this.length;t+=1){var n=this[t];"none"===n.style.display&&(n.style.display=""),"none"===e.getComputedStyle(n,null).getPropertyValue("display")&&(n.style.display="block")}return this},styles:function(){return this[0]?e.getComputedStyle(this[0],null):{}},css:function(t,n){var i;if(1===arguments.length){if("string"!=typeof t){for(i=0;i<this.length;i+=1)for(var r in t)this[i].style[r]=t[r];return this}if(this[0])return e.getComputedStyle(this[0],null).getPropertyValue(t)}if(2===arguments.length&&"string"==typeof t){for(i=0;i<this.length;i+=1)this[i].style[t]=n;return this}return this},toArray:function(){for(var t=[],e=0;e<this.length;e+=1)t.push(this[e]);return t},each:function(t){if(!t)return this;for(var e=0;e<this.length;e+=1)if(!1===t.call(this[e],e,this[e]))return this;return this},forEach:function(t){if(!t)return this;for(var e=0;e<this.length;e+=1)if(!1===t.call(this[e],this[e],e))return this;return this},filter:function(t){for(var e=[],i=0;i<this.length;i+=1)t.call(this[i],i,this[i])&&e.push(this[i]);return new n(e)},map:function(t){for(var e=[],i=0;i<this.length;i+=1)e.push(t.call(this[i],i,this[i]));return new n(e)},html:function(t){if(void 0===t)return this[0]?this[0].innerHTML:void 0;for(var e=0;e<this.length;e+=1)this[e].innerHTML=t;return this},text:function(t){if(void 0===t)return this[0]?this[0].textContent.trim():null;for(var e=0;e<this.length;e+=1)this[e].textContent=t;return this},is:function(r){var o,s,a=this[0];if(!a||void 0===r)return!1;if("string"==typeof r){if(a.matches)return a.matches(r);if(a.webkitMatchesSelector)return a.webkitMatchesSelector(r);if(a.msMatchesSelector)return a.msMatchesSelector(r);for(o=i(r),s=0;s<o.length;s+=1)if(o[s]===a)return!0;return!1}if(r===t)return a===t;if(r===e)return a===e;if(r.nodeType||r instanceof n){for(o=r.nodeType?[r]:r,s=0;s<o.length;s+=1)if(o[s]===a)return!0;return!1}return!1},indexOf:function(t){for(var e=0;e<this.length;e+=1)if(this[e]===t)return e;return-1},index:function(){var t,e=this[0];if(e){for(t=0;null!==(e=e.previousSibling);)1===e.nodeType&&(t+=1);return t}},eq:function(t){if(void 0===t)return this;var e,i=this.length;return new n(t>i-1?[]:t<0?(e=i+t)<0?[]:[this[e]]:[this[t]])},append:function(){for(var e,i=[],r=arguments.length;r--;)i[r]=arguments[r];for(var o=0;o<i.length;o+=1){e=i[o];for(var s=0;s<this.length;s+=1)if("string"==typeof e){var a=t.createElement("div");for(a.innerHTML=e;a.firstChild;)this[s].appendChild(a.firstChild)}else if(e instanceof n)for(var l=0;l<e.length;l+=1)this[s].appendChild(e[l]);else this[s].appendChild(e)}return this},appendTo:function(t){return i(t).append(this),this},prepend:function(e){var i,r,o=this;for(i=0;i<this.length;i+=1)if("string"==typeof e){var s=t.createElement("div");for(s.innerHTML=e,r=s.childNodes.length-1;r>=0;r-=1)o[i].insertBefore(s.childNodes[r],o[i].childNodes[0])}else if(e instanceof n)for(r=0;r<e.length;r+=1)o[i].insertBefore(e[r],o[i].childNodes[0]);else o[i].insertBefore(e,o[i].childNodes[0]);return this},prependTo:function(t){return i(t).prepend(this),this},insertBefore:function(t){for(var e=i(t),n=0;n<this.length;n+=1)if(1===e.length)e[0].parentNode.insertBefore(this[n],e[0]);else if(e.length>1)for(var r=0;r<e.length;r+=1)e[r].parentNode.insertBefore(this[n].cloneNode(!0),e[r])},insertAfter:function(t){for(var e=i(t),n=0;n<this.length;n+=1)if(1===e.length)e[0].parentNode.insertBefore(this[n],e[0].nextSibling);else if(e.length>1)for(var r=0;r<e.length;r+=1)e[r].parentNode.insertBefore(this[n].cloneNode(!0),e[r].nextSibling)},next:function(t){return this.length>0?t?this[0].nextElementSibling&&i(this[0].nextElementSibling).is(t)?new n([this[0].nextElementSibling]):new n([]):this[0].nextElementSibling?new n([this[0].nextElementSibling]):new n([]):new n([])},nextAll:function(t){var e=[],r=this[0];if(!r)return new n([]);for(;r.nextElementSibling;){var o=r.nextElementSibling;t?i(o).is(t)&&e.push(o):e.push(o),r=o}return new n(e)},prev:function(t){if(this.length>0){var e=this[0];return t?e.previousElementSibling&&i(e.previousElementSibling).is(t)?new n([e.previousElementSibling]):new n([]):e.previousElementSibling?new n([e.previousElementSibling]):new n([])}return new n([])},prevAll:function(t){var e=[],r=this[0];if(!r)return new n([]);for(;r.previousElementSibling;){var o=r.previousElementSibling;t?i(o).is(t)&&e.push(o):e.push(o),r=o}return new n(e)},siblings:function(t){return this.nextAll(t).add(this.prevAll(t))},parent:function(t){for(var e=[],n=0;n<this.length;n+=1)null!==this[n].parentNode&&(t?i(this[n].parentNode).is(t)&&e.push(this[n].parentNode):e.push(this[n].parentNode));return i(r(e))},parents:function(t){for(var e=[],n=0;n<this.length;n+=1)for(var o=this[n].parentNode;o;)t?i(o).is(t)&&e.push(o):e.push(o),o=o.parentNode;return i(r(e))},closest:function(t){var e=this;return void 0===t?new n([]):(e.is(t)||(e=e.parents(t).eq(0)),e)},find:function(t){for(var e=[],i=0;i<this.length;i+=1)for(var r=this[i].querySelectorAll(t),o=0;o<r.length;o+=1)e.push(r[o]);return new n(e)},children:function(t){for(var e=[],o=0;o<this.length;o+=1)for(var s=this[o].childNodes,a=0;a<s.length;a+=1)t?1===s[a].nodeType&&i(s[a]).is(t)&&e.push(s[a]):1===s[a].nodeType&&e.push(s[a]);return new n(r(e))},remove:function(){for(var t=0;t<this.length;t+=1)this[t].parentNode&&this[t].parentNode.removeChild(this[t]);return this},detach:function(){return this.remove()},add:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];var n,r;for(n=0;n<t.length;n+=1){var o=i(t[n]);for(r=0;r<o.length;r+=1)this[this.length]=o[r],this.length+=1}return this},empty:function(){for(var t=0;t<this.length;t+=1){var e=this[t];if(1===e.nodeType){for(var n=0;n<e.childNodes.length;n+=1)e.childNodes[n].parentNode&&e.childNodes[n].parentNode.removeChild(e.childNodes[n]);e.textContent=""}}return this}});var a=Object.freeze({scrollTo:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],s=e[2],a=e[3],l=e[4];return 4===e.length&&"function"==typeof a&&(l=a,i=(t=e)[0],r=t[1],s=t[2],l=t[3],a=t[4]),void 0===a&&(a="swing"),this.each(function(){var t,e,n,h,u,f,c,d,v=this,g=r>0||0===r,p=i>0||0===i;if(void 0===a&&(a="swing"),g&&(t=v.scrollTop,s||(v.scrollTop=r)),p&&(e=v.scrollLeft,s||(v.scrollLeft=i)),s){g&&(n=v.scrollHeight-v.offsetHeight,u=Math.max(Math.min(r,n),0)),p&&(h=v.scrollWidth-v.offsetWidth,f=Math.max(Math.min(i,h),0));var m=null;g&&u===t&&(g=!1),p&&f===e&&(p=!1),o(function n(i){void 0===i&&(i=(new Date).getTime()),null===m&&(m=i);var r,h=Math.max(Math.min((i-m)/s,1),0),y="linear"===a?h:.5-Math.cos(h*Math.PI)/2;g&&(c=t+y*(u-t)),p&&(d=e+y*(f-e)),g&&u>t&&c>=u&&(v.scrollTop=u,r=!0),g&&u<t&&c<=u&&(v.scrollTop=u,r=!0),p&&f>e&&d>=f&&(v.scrollLeft=f,r=!0),p&&f<e&&d<=f&&(v.scrollLeft=f,r=!0),r?l&&l():(g&&(v.scrollTop=c),p&&(v.scrollLeft=d),o(n))})}})},scrollTop:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],o=e[2],s=e[3];return 3===e.length&&"function"==typeof o&&(i=(t=e)[0],r=t[1],s=t[2],o=t[3]),void 0===i?this.length>0?this[0].scrollTop:null:this.scrollTo(void 0,i,r,o,s)},scrollLeft:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],o=e[2],s=e[3];return 3===e.length&&"function"==typeof o&&(i=(t=e)[0],r=t[1],s=t[2],o=t[3]),void 0===i?this.length>0?this[0].scrollLeft:null:this.scrollTo(i,void 0,r,o,s)}});var l=Object.freeze({animate:function(t,n){var i,r=this,s={props:Object.assign({},t),params:Object.assign({duration:300,easing:"swing"},n),elements:r,animating:!1,que:[],easingProgress:function(t,e){return"swing"===t?.5-Math.cos(e*Math.PI)/2:"function"==typeof t?t(e):e},stop:function(){var t;s.frameId&&(t=s.frameId,e.cancelAnimationFrame?e.cancelAnimationFrame(t):e.webkitCancelAnimationFrame?e.webkitCancelAnimationFrame(t):e.clearTimeout(t)),s.animating=!1,s.elements.each(function(t,e){delete e.dom7AnimateInstance}),s.que=[]},done:function(t){if(s.animating=!1,s.elements.each(function(t,e){delete e.dom7AnimateInstance}),t&&t(r),s.que.length>0){var e=s.que.shift();s.animate(e[0],e[1])}},animate:function(t,n){if(s.animating)return s.que.push([t,n]),s;var i=[];s.elements.each(function(n,r){var o,a,l,h,u;r.dom7AnimateInstance||(s.elements[n].dom7AnimateInstance=s),i[n]={container:r},Object.keys(t).forEach(function(s){o=e.getComputedStyle(r,null).getPropertyValue(s).replace(",","."),a=parseFloat(o),l=o.replace(a,""),h=parseFloat(t[s]),u=t[s]+l,i[n][s]={initialFullValue:o,initialValue:a,unit:l,finalValue:h,finalFullValue:u,currentValue:a}})});var a,l,h=null,u=0,f=0,c=!1;return s.animating=!0,s.frameId=o(function e(){var d,v;a=(new Date).getTime(),c||(c=!0,n.begin&&n.begin(r)),null===h&&(h=a),n.progress&&n.progress(r,Math.max(Math.min((a-h)/n.duration,1),0),h+n.duration-a<0?0:h+n.duration-a,h),i.forEach(function(e){var r=e;l||r.done||Object.keys(t).forEach(function(e){if(!l&&!r.done){d=Math.max(Math.min((a-h)/n.duration,1),0),v=s.easingProgress(n.easing,d);var o=r[e],c=o.initialValue,g=o.finalValue,p=o.unit;r[e].currentValue=c+v*(g-c);var m=r[e].currentValue;(g>c&&m>=g||g<c&&m<=g)&&(r.container.style[e]=g+p,(f+=1)===Object.keys(t).length&&(r.done=!0,u+=1),u===i.length&&(l=!0)),l?s.done(n.complete):r.container.style[e]=m+p}})}),l||(s.frameId=o(e))}),s}};if(0===s.elements.length)return r;for(var a=0;a<s.elements.length;a+=1)s.elements[a].dom7AnimateInstance?i=s.elements[a].dom7AnimateInstance:s.elements[a].dom7AnimateInstance=s;return i||(i=s),"stop"===t?i.stop():i.animate(s.props,s.params),r},stop:function(){for(var t=0;t<this.length;t+=1)this[t].dom7AnimateInstance&&this[t].dom7AnimateInstance.stop()}}),h="resize scroll".split(" ");function u(t){for(var e,n=[],r=arguments.length-1;r-- >0;)n[r]=arguments[r+1];if(void 0===n[0]){for(var o=0;o<this.length;o+=1)h.indexOf(t)<0&&(t in this[o]?this[o][t]():i(this[o]).trigger(t));return this}return(e=this).on.apply(e,[t].concat(n))}return[s,a,l,Object.freeze({click:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["click"].concat(t))},blur:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["blur"].concat(t))},focus:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["focus"].concat(t))},focusin:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["focusin"].concat(t))},focusout:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["focusout"].concat(t))},keyup:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["keyup"].concat(t))},keydown:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["keydown"].concat(t))},keypress:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["keypress"].concat(t))},submit:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["submit"].concat(t))},change:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["change"].concat(t))},mousedown:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["mousedown"].concat(t))},mousemove:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["mousemove"].concat(t))},mouseup:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["mouseup"].concat(t))},mouseenter:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["mouseenter"].concat(t))},mouseleave:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["mouseleave"].concat(t))},mouseout:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["mouseout"].concat(t))},mouseover:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["mouseover"].concat(t))},touchstart:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["touchstart"].concat(t))},touchend:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["touchend"].concat(t))},touchmove:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["touchmove"].concat(t))},resize:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["resize"].concat(t))},scroll:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return u.bind(this).apply(void 0,["scroll"].concat(t))}})].forEach(function(t){Object.keys(t).forEach(function(e){i.fn[e]=t[e]})}),i});
//# sourceMappingURL=dom7.min.js.map
