/**
 * Dom7 2.1.2
 * Minimalistic JavaScript library for DOM manipulation, with a jQuery-compatible API
 * http://framework7.io/docs/dom.html
 *
 * Copyright 2018, Vladimir Kharlampidi
 * The iDangero.us
 * http://www.idangero.us/
 *
 * Licensed under MIT
 *
 * Released on: September 13, 2018
 */!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):t.Dom7=e()}(this,function(){"use strict";var h="undefined"==typeof document?{body:{},addEventListener:function(){},removeEventListener:function(){},activeElement:{blur:function(){},nodeName:""},querySelector:function(){return null},querySelectorAll:function(){return[]},getElementById:function(){return null},createEvent:function(){return{initEvent:function(){}}},createElement:function(){return{children:[],childNodes:[],style:{},setAttribute:function(){},getElementsByTagName:function(){return[]}}},location:{hash:""}}:document,y="undefined"==typeof window?{document:h,navigator:{userAgent:""},location:{},history:{},CustomEvent:function(){return this},addEventListener:function(){},removeEventListener:function(){},getComputedStyle:function(){return{getPropertyValue:function(){return""}}},Image:function(){},Date:function(){},screen:{},setTimeout:function(){},clearTimeout:function(){}}:window,l=function(t){for(var e=0;e<t.length;e+=1)this[e]=t[e];return this.length=t.length,this};function g(t,e){var n=[],i=0;if(t&&!e&&t instanceof l)return t;if(t)if("string"==typeof t){var r,o,s=t.trim();if(0<=s.indexOf("<")&&0<=s.indexOf(">")){var a="div";for(0===s.indexOf("<li")&&(a="ul"),0===s.indexOf("<tr")&&(a="tbody"),0!==s.indexOf("<td")&&0!==s.indexOf("<th")||(a="tr"),0===s.indexOf("<tbody")&&(a="table"),0===s.indexOf("<option")&&(a="select"),(o=h.createElement(a)).innerHTML=s,i=0;i<o.childNodes.length;i+=1)n.push(o.childNodes[i])}else for(r=e||"#"!==t[0]||t.match(/[ .<>:~]/)?(e||h).querySelectorAll(t.trim()):[h.getElementById(t.trim().split("#")[1])],i=0;i<r.length;i+=1)r[i]&&n.push(r[i])}else if(t.nodeType||t===y||t===h)n.push(t);else if(0<t.length&&t[0].nodeType)for(i=0;i<t.length;i+=1)n.push(t[i]);return new l(n)}function o(t){for(var e=[],n=0;n<t.length;n+=1)-1===e.indexOf(t[n])&&e.push(t[n]);return e}function b(t){return y.requestAnimationFrame?y.requestAnimationFrame(t):y.webkitRequestAnimationFrame?y.webkitRequestAnimationFrame(t):y.setTimeout(t,1e3/60)}g.fn=l.prototype,g.Class=l,g.Dom7=l;var t=Object.freeze({addClass:function(t){if(void 0===t)return this;for(var e=t.split(" "),n=0;n<e.length;n+=1)for(var i=0;i<this.length;i+=1)void 0!==this[i]&&void 0!==this[i].classList&&this[i].classList.add(e[n]);return this},removeClass:function(t){for(var e=t.split(" "),n=0;n<e.length;n+=1)for(var i=0;i<this.length;i+=1)void 0!==this[i]&&void 0!==this[i].classList&&this[i].classList.remove(e[n]);return this},hasClass:function(t){return!!this[0]&&this[0].classList.contains(t)},toggleClass:function(t){for(var e=t.split(" "),n=0;n<e.length;n+=1)for(var i=0;i<this.length;i+=1)void 0!==this[i]&&void 0!==this[i].classList&&this[i].classList.toggle(e[n]);return this},attr:function(t,e){var n=arguments;if(1===arguments.length&&"string"==typeof t)return this[0]?this[0].getAttribute(t):void 0;for(var i=0;i<this.length;i+=1)if(2===n.length)this[i].setAttribute(t,e);else for(var r in t)this[i][r]=t[r],this[i].setAttribute(r,t[r]);return this},removeAttr:function(t){for(var e=0;e<this.length;e+=1)this[e].removeAttribute(t);return this},prop:function(t,e){var n=arguments;if(1!==arguments.length||"string"!=typeof t){for(var i=0;i<this.length;i+=1)if(2===n.length)this[i][t]=e;else for(var r in t)this[i][r]=t[r];return this}if(this[0])return this[0][t]},data:function(t,e){var n;if(void 0!==e){for(var i=0;i<this.length;i+=1)(n=this[i]).dom7ElementDataStorage||(n.dom7ElementDataStorage={}),n.dom7ElementDataStorage[t]=e;return this}if(n=this[0]){if(n.dom7ElementDataStorage&&t in n.dom7ElementDataStorage)return n.dom7ElementDataStorage[t];var r=n.getAttribute("data-"+t);return r||void 0}},removeData:function(t){for(var e=0;e<this.length;e+=1){var n=this[e];n.dom7ElementDataStorage&&n.dom7ElementDataStorage[t]&&(n.dom7ElementDataStorage[t]=null,delete n.dom7ElementDataStorage[t])}},dataset:function(){var t=this[0];if(t){var e,n={};if(t.dataset)for(var i in t.dataset)n[i]=t.dataset[i];else for(var r=0;r<t.attributes.length;r+=1){var o=t.attributes[r];0<=o.name.indexOf("data-")&&(n[(e=o.name.split("data-")[1],e.toLowerCase().replace(/-(.)/g,function(t,e){return e.toUpperCase()}))]=o.value)}for(var s in n)"false"===n[s]?n[s]=!1:"true"===n[s]?n[s]=!0:parseFloat(n[s])===1*n[s]&&(n[s]*=1);return n}},val:function(t){var e=this;if(void 0!==t){for(var n=0;n<e.length;n+=1){var i=e[n];if(Array.isArray(t)&&i.multiple&&"select"===i.nodeName.toLowerCase())for(var r=0;r<i.options.length;r+=1)i.options[r].selected=0<=t.indexOf(i.options[r].value);else i.value=t}return e}if(e[0]){if(e[0].multiple&&"select"===e[0].nodeName.toLowerCase()){for(var o=[],s=0;s<e[0].selectedOptions.length;s+=1)o.push(e[0].selectedOptions[s].value);return o}return e[0].value}},transform:function(t){for(var e=0;e<this.length;e+=1){var n=this[e].style;n.webkitTransform=t,n.transform=t}return this},transition:function(t){"string"!=typeof t&&(t+="ms");for(var e=0;e<this.length;e+=1){var n=this[e].style;n.webkitTransitionDuration=t,n.transitionDuration=t}return this},on:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],o=e[1],s=e[2],r=e[3];function a(t){var e=t.target;if(e){var n=t.target.dom7EventData||[];if(n.indexOf(t)<0&&n.unshift(t),g(e).is(o))s.apply(e,n);else for(var i=g(e).parents(),r=0;r<i.length;r+=1)g(i[r]).is(o)&&s.apply(i[r],n)}}function l(t){var e=t&&t.target&&t.target.dom7EventData||[];e.indexOf(t)<0&&e.unshift(t),s.apply(this,e)}"function"==typeof e[1]&&(i=(t=e)[0],s=t[1],r=t[2],o=void 0),r||(r=!1);for(var h,u=i.split(" "),f=0;f<this.length;f+=1){var c=this[f];if(o)for(h=0;h<u.length;h+=1){var d=u[h];c.dom7LiveListeners||(c.dom7LiveListeners={}),c.dom7LiveListeners[d]||(c.dom7LiveListeners[d]=[]),c.dom7LiveListeners[d].push({listener:s,proxyListener:a}),c.addEventListener(d,a,r)}else for(h=0;h<u.length;h+=1){var v=u[h];c.dom7Listeners||(c.dom7Listeners={}),c.dom7Listeners[v]||(c.dom7Listeners[v]=[]),c.dom7Listeners[v].push({listener:s,proxyListener:l}),c.addEventListener(v,l,r)}}return this},off:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],o=e[2],s=e[3];"function"==typeof e[1]&&(i=(t=e)[0],o=t[1],s=t[2],r=void 0),s||(s=!1);for(var a=i.split(" "),l=0;l<a.length;l+=1)for(var h=a[l],u=0;u<this.length;u+=1){var f=this[u],c=void 0;if(!r&&f.dom7Listeners?c=f.dom7Listeners[h]:r&&f.dom7LiveListeners&&(c=f.dom7LiveListeners[h]),c&&c.length)for(var d=c.length-1;0<=d;d-=1){var v=c[d];o&&v.listener===o?(f.removeEventListener(h,v.proxyListener,s),c.splice(d,1)):o||(f.removeEventListener(h,v.proxyListener,s),c.splice(d,1))}}return this},once:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=this,r=e[0],o=e[1],s=e[2],a=e[3];return"function"==typeof e[1]&&(r=(t=e)[0],s=t[1],a=t[2],o=void 0),i.on(r,o,function t(){for(var e=[],n=arguments.length;n--;)e[n]=arguments[n];s.apply(this,e),i.off(r,o,t,a)},a)},trigger:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];for(var n=t[0].split(" "),i=t[1],r=0;r<n.length;r+=1)for(var o=n[r],s=0;s<this.length;s+=1){var a=this[s],l=void 0;try{l=new y.CustomEvent(o,{detail:i,bubbles:!0,cancelable:!0})}catch(t){(l=h.createEvent("Event")).initEvent(o,!0,!0),l.detail=i}a.dom7EventData=t.filter(function(t,e){return 0<e}),a.dispatchEvent(l),a.dom7EventData=[],delete a.dom7EventData}return this},transitionEnd:function(e){var n,i=["webkitTransitionEnd","transitionend"],r=this;function o(t){if(t.target===this)for(e.call(this,t),n=0;n<i.length;n+=1)r.off(i[n],o)}if(e)for(n=0;n<i.length;n+=1)r.on(i[n],o);return this},animationEnd:function(e){var n,i=["webkitAnimationEnd","animationend"],r=this;function o(t){if(t.target===this)for(e.call(this,t),n=0;n<i.length;n+=1)r.off(i[n],o)}if(e)for(n=0;n<i.length;n+=1)r.on(i[n],o);return this},width:function(){return this[0]===y?y.innerWidth:0<this.length?parseFloat(this.css("width")):null},outerWidth:function(t){if(0<this.length){if(t){var e=this.styles();return this[0].offsetWidth+parseFloat(e.getPropertyValue("margin-right"))+parseFloat(e.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null},height:function(){return this[0]===y?y.innerHeight:0<this.length?parseFloat(this.css("height")):null},outerHeight:function(t){if(0<this.length){if(t){var e=this.styles();return this[0].offsetHeight+parseFloat(e.getPropertyValue("margin-top"))+parseFloat(e.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null},offset:function(){if(0<this.length){var t=this[0],e=t.getBoundingClientRect(),n=h.body,i=t.clientTop||n.clientTop||0,r=t.clientLeft||n.clientLeft||0,o=t===y?y.scrollY:t.scrollTop,s=t===y?y.scrollX:t.scrollLeft;return{top:e.top+o-i,left:e.left+s-r}}return null},hide:function(){for(var t=0;t<this.length;t+=1)this[t].style.display="none";return this},show:function(){for(var t=0;t<this.length;t+=1){var e=this[t];"none"===e.style.display&&(e.style.display=""),"none"===y.getComputedStyle(e,null).getPropertyValue("display")&&(e.style.display="block")}return this},styles:function(){return this[0]?y.getComputedStyle(this[0],null):{}},css:function(t,e){var n;if(1===arguments.length){if("string"!=typeof t){for(n=0;n<this.length;n+=1)for(var i in t)this[n].style[i]=t[i];return this}if(this[0])return y.getComputedStyle(this[0],null).getPropertyValue(t)}if(2!==arguments.length||"string"!=typeof t)return this;for(n=0;n<this.length;n+=1)this[n].style[t]=e;return this},toArray:function(){for(var t=[],e=0;e<this.length;e+=1)t.push(this[e]);return t},each:function(t){if(!t)return this;for(var e=0;e<this.length;e+=1)if(!1===t.call(this[e],e,this[e]))return this;return this},forEach:function(t){if(!t)return this;for(var e=0;e<this.length;e+=1)if(!1===t.call(this[e],this[e],e))return this;return this},filter:function(t){for(var e=[],n=0;n<this.length;n+=1)t.call(this[n],n,this[n])&&e.push(this[n]);return new l(e)},map:function(t){for(var e=[],n=0;n<this.length;n+=1)e.push(t.call(this[n],n,this[n]));return new l(e)},html:function(t){if(void 0===t)return this[0]?this[0].innerHTML:void 0;for(var e=0;e<this.length;e+=1)this[e].innerHTML=t;return this},text:function(t){if(void 0===t)return this[0]?this[0].textContent.trim():null;for(var e=0;e<this.length;e+=1)this[e].textContent=t;return this},is:function(t){var e,n,i=this[0];if(!i||void 0===t)return!1;if("string"==typeof t){if(i.matches)return i.matches(t);if(i.webkitMatchesSelector)return i.webkitMatchesSelector(t);if(i.msMatchesSelector)return i.msMatchesSelector(t);for(e=g(t),n=0;n<e.length;n+=1)if(e[n]===i)return!0;return!1}if(t===h)return i===h;if(t===y)return i===y;if(t.nodeType||t instanceof l){for(e=t.nodeType?[t]:t,n=0;n<e.length;n+=1)if(e[n]===i)return!0;return!1}return!1},indexOf:function(t){for(var e=0;e<this.length;e+=1)if(this[e]===t)return e;return-1},index:function(){var t,e=this[0];if(e){for(t=0;null!==(e=e.previousSibling);)1===e.nodeType&&(t+=1);return t}},eq:function(t){if(void 0===t)return this;var e,n=this.length;return new l(n-1<t?[]:t<0?(e=n+t)<0?[]:[this[e]]:[this[t]])},append:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];for(var i=0;i<e.length;i+=1){t=e[i];for(var r=0;r<this.length;r+=1)if("string"==typeof t){var o=h.createElement("div");for(o.innerHTML=t;o.firstChild;)this[r].appendChild(o.firstChild)}else if(t instanceof l)for(var s=0;s<t.length;s+=1)this[r].appendChild(t[s]);else this[r].appendChild(t)}return this},appendTo:function(t){return g(t).append(this),this},prepend:function(t){var e,n,i=this;for(e=0;e<this.length;e+=1)if("string"==typeof t){var r=h.createElement("div");for(r.innerHTML=t,n=r.childNodes.length-1;0<=n;n-=1)i[e].insertBefore(r.childNodes[n],i[e].childNodes[0])}else if(t instanceof l)for(n=0;n<t.length;n+=1)i[e].insertBefore(t[n],i[e].childNodes[0]);else i[e].insertBefore(t,i[e].childNodes[0]);return this},prependTo:function(t){return g(t).prepend(this),this},insertBefore:function(t){for(var e=g(t),n=0;n<this.length;n+=1)if(1===e.length)e[0].parentNode.insertBefore(this[n],e[0]);else if(1<e.length)for(var i=0;i<e.length;i+=1)e[i].parentNode.insertBefore(this[n].cloneNode(!0),e[i])},insertAfter:function(t){for(var e=g(t),n=0;n<this.length;n+=1)if(1===e.length)e[0].parentNode.insertBefore(this[n],e[0].nextSibling);else if(1<e.length)for(var i=0;i<e.length;i+=1)e[i].parentNode.insertBefore(this[n].cloneNode(!0),e[i].nextSibling)},next:function(t){return 0<this.length?t?this[0].nextElementSibling&&g(this[0].nextElementSibling).is(t)?new l([this[0].nextElementSibling]):new l([]):this[0].nextElementSibling?new l([this[0].nextElementSibling]):new l([]):new l([])},nextAll:function(t){var e=[],n=this[0];if(!n)return new l([]);for(;n.nextElementSibling;){var i=n.nextElementSibling;t?g(i).is(t)&&e.push(i):e.push(i),n=i}return new l(e)},prev:function(t){if(0<this.length){var e=this[0];return t?e.previousElementSibling&&g(e.previousElementSibling).is(t)?new l([e.previousElementSibling]):new l([]):e.previousElementSibling?new l([e.previousElementSibling]):new l([])}return new l([])},prevAll:function(t){var e=[],n=this[0];if(!n)return new l([]);for(;n.previousElementSibling;){var i=n.previousElementSibling;t?g(i).is(t)&&e.push(i):e.push(i),n=i}return new l(e)},siblings:function(t){return this.nextAll(t).add(this.prevAll(t))},parent:function(t){for(var e=[],n=0;n<this.length;n+=1)null!==this[n].parentNode&&(t?g(this[n].parentNode).is(t)&&e.push(this[n].parentNode):e.push(this[n].parentNode));return g(o(e))},parents:function(t){for(var e=[],n=0;n<this.length;n+=1)for(var i=this[n].parentNode;i;)t?g(i).is(t)&&e.push(i):e.push(i),i=i.parentNode;return g(o(e))},closest:function(t){var e=this;return void 0===t?new l([]):(e.is(t)||(e=e.parents(t).eq(0)),e)},find:function(t){for(var e=[],n=0;n<this.length;n+=1)for(var i=this[n].querySelectorAll(t),r=0;r<i.length;r+=1)e.push(i[r]);return new l(e)},children:function(t){for(var e=[],n=0;n<this.length;n+=1)for(var i=this[n].childNodes,r=0;r<i.length;r+=1)t?1===i[r].nodeType&&g(i[r]).is(t)&&e.push(i[r]):1===i[r].nodeType&&e.push(i[r]);return new l(o(e))},remove:function(){for(var t=0;t<this.length;t+=1)this[t].parentNode&&this[t].parentNode.removeChild(this[t]);return this},detach:function(){return this.remove()},add:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];var n,i;for(n=0;n<t.length;n+=1){var r=g(t[n]);for(i=0;i<r.length;i+=1)this[this.length]=r[i],this.length+=1}return this},empty:function(){for(var t=0;t<this.length;t+=1){var e=this[t];if(1===e.nodeType){for(var n=0;n<e.childNodes.length;n+=1)e.childNodes[n].parentNode&&e.childNodes[n].parentNode.removeChild(e.childNodes[n]);e.textContent=""}}return this}});var e=Object.freeze({scrollTo:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],g=e[2],p=e[3],m=e[4];return 4===e.length&&"function"==typeof p&&(m=p,i=(t=e)[0],r=t[1],g=t[2],m=t[3],p=t[4]),void 0===p&&(p="swing"),this.each(function(){var o,s,t,e,a,l,h,u,f=this,c=0<r||0===r,d=0<i||0===i;if(void 0===p&&(p="swing"),c&&(o=f.scrollTop,g||(f.scrollTop=r)),d&&(s=f.scrollLeft,g||(f.scrollLeft=i)),g){c&&(t=f.scrollHeight-f.offsetHeight,a=Math.max(Math.min(r,t),0)),d&&(e=f.scrollWidth-f.offsetWidth,l=Math.max(Math.min(i,e),0));var v=null;c&&a===o&&(c=!1),d&&l===s&&(d=!1),b(function t(e){void 0===e&&(e=(new Date).getTime()),null===v&&(v=e);var n,i=Math.max(Math.min((e-v)/g,1),0),r="linear"===p?i:.5-Math.cos(i*Math.PI)/2;c&&(h=o+r*(a-o)),d&&(u=s+r*(l-s)),c&&o<a&&a<=h&&(f.scrollTop=a,n=!0),c&&a<o&&h<=a&&(f.scrollTop=a,n=!0),d&&s<l&&l<=u&&(f.scrollLeft=l,n=!0),d&&l<s&&u<=l&&(f.scrollLeft=l,n=!0),n?m&&m():(c&&(f.scrollTop=h),d&&(f.scrollLeft=u),b(t))})}})},scrollTop:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],o=e[2],s=e[3];return 3===e.length&&"function"==typeof o&&(i=(t=e)[0],r=t[1],s=t[2],o=t[3]),void 0===i?0<this.length?this[0].scrollTop:null:this.scrollTo(void 0,i,r,o,s)},scrollLeft:function(){for(var t,e=[],n=arguments.length;n--;)e[n]=arguments[n];var i=e[0],r=e[1],o=e[2],s=e[3];return 3===e.length&&"function"==typeof o&&(i=(t=e)[0],r=t[1],s=t[2],o=t[3]),void 0===i?0<this.length?this[0].scrollLeft:null:this.scrollTo(i,void 0,r,o,s)}});var n=Object.freeze({animate:function(t,e){var n,i=this,m={props:Object.assign({},t),params:Object.assign({duration:300,easing:"swing"},e),elements:i,animating:!1,que:[],easingProgress:function(t,e){return"swing"===t?.5-Math.cos(e*Math.PI)/2:"function"==typeof t?t(e):e},stop:function(){var t;m.frameId&&(t=m.frameId,y.cancelAnimationFrame?y.cancelAnimationFrame(t):y.webkitCancelAnimationFrame?y.webkitCancelAnimationFrame(t):y.clearTimeout(t)),m.animating=!1,m.elements.each(function(t,e){delete e.dom7AnimateInstance}),m.que=[]},done:function(t){if(m.animating=!1,m.elements.each(function(t,e){delete e.dom7AnimateInstance}),t&&t(i),0<m.que.length){var e=m.que.shift();m.animate(e[0],e[1])}},animate:function(h,u){if(m.animating)return m.que.push([h,u]),m;var f=[];m.elements.each(function(e,n){var i,r,o,s,a;n.dom7AnimateInstance||(m.elements[e].dom7AnimateInstance=m),f[e]={container:n},Object.keys(h).forEach(function(t){i=y.getComputedStyle(n,null).getPropertyValue(t).replace(",","."),r=parseFloat(i),o=i.replace(r,""),s=parseFloat(h[t]),a=h[t]+o,f[e][t]={initialFullValue:i,initialValue:r,unit:o,finalValue:s,finalFullValue:a,currentValue:r}})});var c,d,v=null,g=0,p=0,e=!1;return m.animating=!0,m.frameId=b(function t(){var a,l;c=(new Date).getTime(),e||(e=!0,u.begin&&u.begin(i)),null===v&&(v=c),u.progress&&u.progress(i,Math.max(Math.min((c-v)/u.duration,1),0),v+u.duration-c<0?0:v+u.duration-c,v),f.forEach(function(t){var s=t;d||s.done||Object.keys(h).forEach(function(t){if(!d&&!s.done){a=Math.max(Math.min((c-v)/u.duration,1),0),l=m.easingProgress(u.easing,a);var e=s[t],n=e.initialValue,i=e.finalValue,r=e.unit;s[t].currentValue=n+l*(i-n);var o=s[t].currentValue;(n<i&&i<=o||i<n&&o<=i)&&(s.container.style[t]=i+r,(p+=1)===Object.keys(h).length&&(s.done=!0,g+=1),g===f.length&&(d=!0)),d?m.done(u.complete):s.container.style[t]=o+r}})}),d||(m.frameId=b(t))}),m}};if(0===m.elements.length)return i;for(var r=0;r<m.elements.length;r+=1)m.elements[r].dom7AnimateInstance?n=m.elements[r].dom7AnimateInstance:m.elements[r].dom7AnimateInstance=m;return n||(n=m),"stop"===t?n.stop():n.animate(m.props,m.params),i},stop:function(){for(var t=0;t<this.length;t+=1)this[t].dom7AnimateInstance&&this[t].dom7AnimateInstance.stop()}}),s="resize scroll".split(" ");function i(t){for(var e,n=[],i=arguments.length-1;0<i--;)n[i]=arguments[i+1];if(void 0!==n[0])return(e=this).on.apply(e,[t].concat(n));for(var r=0;r<this.length;r+=1)s.indexOf(t)<0&&(t in this[r]?this[r][t]():g(this[r]).trigger(t));return this}return[t,e,n,Object.freeze({click:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["click"].concat(t))},blur:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["blur"].concat(t))},focus:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["focus"].concat(t))},focusin:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["focusin"].concat(t))},focusout:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["focusout"].concat(t))},keyup:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["keyup"].concat(t))},keydown:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["keydown"].concat(t))},keypress:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["keypress"].concat(t))},submit:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["submit"].concat(t))},change:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["change"].concat(t))},mousedown:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["mousedown"].concat(t))},mousemove:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["mousemove"].concat(t))},mouseup:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["mouseup"].concat(t))},mouseenter:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["mouseenter"].concat(t))},mouseleave:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["mouseleave"].concat(t))},mouseout:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["mouseout"].concat(t))},mouseover:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["mouseover"].concat(t))},touchstart:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["touchstart"].concat(t))},touchend:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["touchend"].concat(t))},touchmove:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["touchmove"].concat(t))},resize:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["resize"].concat(t))},scroll:function(){for(var t=[],e=arguments.length;e--;)t[e]=arguments[e];return i.bind(this).apply(void 0,["scroll"].concat(t))}})].forEach(function(e){Object.keys(e).forEach(function(t){g.fn[t]=e[t]})}),g});
//# sourceMappingURL=dom7.min.js.map
