"use strict";
/**
 * Prints a DOT file to stdout containing the thread transition graph.
 */
var threading_1 = require('../src/threading');
var enums_1 = require('../src/enums');
var statuses = Object.keys(threading_1.validTransitions);
process.stdout.write('digraph thread_transition_graph {\n');
// Emit nodes first.
statuses.forEach(function (status) {
    process.stdout.write('\t' + enums_1.ThreadStatus[status] + ' [label="' + enums_1.ThreadStatus[status] + '"];\n');
});
// Emit edges.
statuses.forEach(function (oldStatus) {
    Object.keys(threading_1.validTransitions[oldStatus]).forEach(function (newStatus) {
        process.stdout.write('\t' + enums_1.ThreadStatus[oldStatus] + ' -> ' +
            enums_1.ThreadStatus[newStatus] + ' [label="' +
            threading_1.validTransitions[oldStatus][newStatus] + '"];\n');
    });
});
// End graph.
process.stdout.write('}\n');
//# sourceMappingURL=data:application/json;base64,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