"use strict";
var java_cli_1 = require('../src/java_cli');
var path = require('path');
var os = require('os');
var fs = require('fs');
// Makes our stack traces point to the TypeScript source code lines.
require('source-map-support').install({
    handleUncaughtExceptions: true
});
function doneCb(status) {
    process.exit(status);
}
var jvmState;
process.on('SIGINT', function () {
    console.error('Doppio caught SIGINT');
    process.exit(0);
});
process.on('uncaughtException', function (er) {
    console.log("Encountered error: " + er + "\n" + er.stack);
    fs.appendFileSync('doppio.err', "\n--------------------------------------\n" + er + "\n" + er.stack + "\n");
    if (jvmState) {
        // Dump JVM stack state.
        jvmState.dumpState('doppio.err', function (er) {
            if (!er) {
                console.log("Thread state dumped to doppio.err.");
            }
            else {
                console.log("Error writing doppio.err: " + er + "\n" + er.stack);
            }
        });
    }
    else {
        console.log("JVM state undefined; unable to print debug information.");
    }
    process.exit(1);
});
// Run the JVM. Remove node runner.js from the args.
java_cli_1["default"](process.argv.slice(2), {
    doppioHomePath: path.resolve(__dirname, '..'),
    nativeClasspath: [],
    launcherName: process.argv[0] + " " + path.relative(process.cwd(), process.argv[1]),
    intMode: false,
    dumpJITStats: false,
    tmpDir: os.tmpdir()
}, doneCb, function (jvm) {
    jvmState = jvm;
});
//# sourceMappingURL=data:application/json;base64,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