"use strict";
var testing_1 = require('../src/testing');
var os = require('os');
var fs = require('fs');
var path = require('path');
// Makes our stack traces point to the TypeScript source code lines.
require('source-map-support').install({
    handleUncaughtExceptions: true
});
// Default options.
var opts = {
    doppioHomePath: path.resolve(__dirname, '..'),
    // Override default since we are in node.
    nativeClasspath: [],
    enableSystemAssertions: true,
    enableAssertions: true,
    intMode: false,
    dumpJITStats: false,
    tmpDir: os.tmpdir()
}, passChar, failChar;
if (process.platform.match(/win32/i)) {
    // Windows command prompt doesn't support Unicode characters.
    passChar = "√";
    failChar = "X";
}
else {
    passChar = '✓';
    failChar = '✗';
}
/**
 * Makefile tests are only relevant to the native runner.
 */
function makefileTest(argv) {
    var failpath = path.resolve(__dirname, '../classes/test/failures.txt'), keepGoing = argv.c;
    opts.testClasses = argv._;
    // Enter a domain so we are robust to uncaught errors.
    var errCallback = null;
    function finish(err) {
        // Print out the status of this test.
        process.stdout.write(err ? failChar : passChar);
        if (err) {
            var buff = new Buffer("\n" + err.message + "\n");
            fs.appendFileSync(failpath, buff, {
                flag: 'a'
            });
        }
        // Error code in the event of a failed test.
        process.exit(err ? 1 : 0);
    }
    // This handler should not run when the test exits normally (process.exit() in finish handler circumvents it).
    process.on('beforeExit', function () {
        if (errCallback) {
            errCallback(new Error('Finish callback never triggered.'));
        }
    });
    process.on('uncaughtException', function (err) {
        if (errCallback) {
            errCallback(err);
        }
    });
    testing_1.runTests(opts, true, keepGoing, false, function (cb) {
        errCallback = cb;
    }, finish);
}
function regularTest(argv) {
    var hideDiffs = !argv.diff, quiet = argv.q, keepGoing = argv.c, errCallback = null;
    opts.testClasses = argv._;
    var stdoutW = process.stdout.write, stderrW = process.stderr.write;
    process.on('uncaughtException', function (err) {
        if (errCallback) {
            errCallback(err);
        }
    });
    // This handler should not run when the test exits normally (process.exit() in finish handler circumvents it).
    process.on('beforeExit', function () {
        if (errCallback) {
            errCallback(new Error('Finish callback never triggered.'));
        }
    });
    testing_1.runTests(opts, quiet, keepGoing, hideDiffs, function (cb) {
        errCallback = cb;
    }, function (err) {
        process.exit(err ? 1 : 0);
    });
}
var optimist = require('optimist')
    .boolean(['q', 'h', 'c', 'makefile', 'diff'])
    .default({ diff: true })
    .alias({
    h: 'help',
    q: 'quiet',
    c: 'continue'
}).describe({
    q: 'Suppress in-progress test output',
    diff: 'Show failed test diff output',
    c: 'Keep going after test failure',
    // --makefile is only used from the makefile
    h: 'Show this usage'
}).usage('Usage: $0 path/to/test [flags]');
var argv = optimist.argv;
if (argv.help) {
    optimist.showHelp();
    process.exit(0);
}
if (argv.makefile) {
    makefileTest(argv);
}
else {
    regularTest(argv);
}
//# sourceMappingURL=data:application/json;base64,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