"use strict";
/**
 * A single class lock, used for load/initialization locks.
 */
var ClassLock = (function () {
    function ClassLock() {
        this.queue = [];
    }
    /**
     * Checks if the lock is taken. If so, it enqueues the callback. Otherwise,
     * it takes the lock and returns true.
     */
    ClassLock.prototype.tryLock = function (thread, cb) {
        // We're the owner if the queue was previously empty.
        return this.queue.push({ thread: thread, cb: cb }) === 1;
    };
    /**
     * Releases the lock on the class, and passes the object to all enqueued
     * callbacks.
     */
    ClassLock.prototype.unlock = function (cdata) {
        var i, num = this.queue.length;
        for (i = 0; i < num; i++) {
            this.queue[i].cb(cdata);
        }
        this.queue = [];
    };
    /**
     * Get the owner of this lock.
     */
    ClassLock.prototype.getOwner = function () {
        if (this.queue.length > 0) {
            return this.queue[0].thread;
        }
        return null;
    };
    return ClassLock;
}());
exports.__esModule = true;
exports["default"] = ClassLock;
//# sourceMappingURL=data:application/json;base64,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