"use strict";
/**
 * A safe to use key value map.
 *
 * JavaScript objects cannot be used as general-purpose key value maps, as they
 * contain a number of default fields. This class avoids those issues.
 */
var SafeMap = (function () {
    function SafeMap() {
        this.cache = Object.create(null); // has no defined properties aside from __proto__
    }
    /**
     * Mutates the key so that it cannot possibly conflict with existing object
     * properties.
     */
    SafeMap.prototype.fixKey = function (key) {
        return ';' + key;
    };
    SafeMap.prototype.get = function (key) {
        key = this.fixKey(key);
        if (this.cache[key] !== undefined) {
            return this.cache[key];
        }
        return undefined;
    };
    SafeMap.prototype.has = function (key) {
        return this.get(key) !== undefined;
    };
    SafeMap.prototype.set = function (key, value) {
        this.cache[this.fixKey(key)] = value;
    };
    return SafeMap;
}());
exports.__esModule = true;
exports["default"] = SafeMap;
//# sourceMappingURL=data:application/json;base64,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