"use strict";
/**
 * Utility class. "stream" out string data, and compile into a single string.
 */
var StringOutputStream = (function () {
    function StringOutputStream() {
        this._data = [];
    }
    StringOutputStream.prototype.write = function (data) { this._data.push(data); };
    StringOutputStream.prototype.flush = function () {
        var rv = this._data.join("");
        this._data = [];
        return rv;
    };
    return StringOutputStream;
}());
exports.__esModule = true;
exports["default"] = StringOutputStream;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RyaW5nT3V0cHV0U3RyZWFtLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL1N0cmluZ091dHB1dFN0cmVhbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7O0dBRUc7QUFDSDtJQUFBO1FBQ1UsVUFBSyxHQUFhLEVBQUUsQ0FBQztJQVEvQixDQUFDO0lBUFEsa0NBQUssR0FBWixVQUFhLElBQVksSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDOUMsa0NBQUssR0FBWjtRQUNFLElBQUksRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQzdCLElBQUksQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDO1FBQ2hCLE1BQU0sQ0FBQyxFQUFFLENBQUM7SUFDWixDQUFDO0lBRUgseUJBQUM7QUFBRCxDQUFDLEFBVEQsSUFTQztBQVREO3VDQVNDLENBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFV0aWxpdHkgY2xhc3MuIFwic3RyZWFtXCIgb3V0IHN0cmluZyBkYXRhLCBhbmQgY29tcGlsZSBpbnRvIGEgc2luZ2xlIHN0cmluZy5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3RyaW5nT3V0cHV0U3RyZWFtIHtcbiAgcHJpdmF0ZSBfZGF0YTogc3RyaW5nW10gPSBbXTtcbiAgcHVibGljIHdyaXRlKGRhdGE6IHN0cmluZykgeyB0aGlzLl9kYXRhLnB1c2goZGF0YSk7IH1cbiAgcHVibGljIGZsdXNoKCk6IHN0cmluZyB7XG4gICAgdmFyIHJ2ID0gdGhpcy5fZGF0YS5qb2luKFwiXCIpO1xuICAgIHRoaXMuX2RhdGEgPSBbXTtcbiAgICByZXR1cm4gcnY7XG4gIH1cblxufVxuIl19