"use strict";
/**
 * Stores the file position of every open file descriptor in the JVM.
 * Shared globally amongst JVM instances since this state is global.
 * We need to track this data since Node.js does not expose this OS state.
 */
var FDState = (function () {
    function FDState() {
    }
    FDState.open = function (fd, initialPosition) {
        this._positions[fd] = initialPosition;
    };
    FDState.getPos = function (fd) {
        return this._positions[fd];
    };
    FDState.incrementPos = function (fd, incr) {
        this._positions[fd] += incr;
    };
    FDState.setPos = function (fd, newPos) {
        this._positions[fd] = newPos;
    };
    FDState.close = function (fd) {
        delete this._positions[fd];
    };
    FDState._positions = {};
    return FDState;
}());
exports.__esModule = true;
exports["default"] = FDState;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmRfc3RhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZmRfc3RhdGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7O0dBSUc7QUFDSDtJQUFBO0lBc0JBLENBQUM7SUFuQmUsWUFBSSxHQUFsQixVQUFtQixFQUFVLEVBQUUsZUFBdUI7UUFDcEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUMsR0FBRyxlQUFlLENBQUM7SUFDeEMsQ0FBQztJQUVhLGNBQU0sR0FBcEIsVUFBcUIsRUFBVTtRQUM3QixNQUFNLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUM3QixDQUFDO0lBRWEsb0JBQVksR0FBMUIsVUFBMkIsRUFBVSxFQUFFLElBQVk7UUFDakQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUMsSUFBSSxJQUFJLENBQUM7SUFDOUIsQ0FBQztJQUVhLGNBQU0sR0FBcEIsVUFBcUIsRUFBVSxFQUFFLE1BQWM7UUFDN0MsSUFBSSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUMsR0FBRyxNQUFNLENBQUM7SUFDL0IsQ0FBQztJQUVhLGFBQUssR0FBbkIsVUFBb0IsRUFBVTtRQUM1QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQXBCYyxrQkFBVSxHQUEyQixFQUFFLENBQUM7SUFxQnpELGNBQUM7QUFBRCxDQUFDLEFBdEJELElBc0JDO0FBdEJEOzRCQXNCQyxDQUFBIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTdG9yZXMgdGhlIGZpbGUgcG9zaXRpb24gb2YgZXZlcnkgb3BlbiBmaWxlIGRlc2NyaXB0b3IgaW4gdGhlIEpWTS5cbiAqIFNoYXJlZCBnbG9iYWxseSBhbW9uZ3N0IEpWTSBpbnN0YW5jZXMgc2luY2UgdGhpcyBzdGF0ZSBpcyBnbG9iYWwuXG4gKiBXZSBuZWVkIHRvIHRyYWNrIHRoaXMgZGF0YSBzaW5jZSBOb2RlLmpzIGRvZXMgbm90IGV4cG9zZSB0aGlzIE9TIHN0YXRlLlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBGRFN0YXRlIHtcbiAgcHJpdmF0ZSBzdGF0aWMgX3Bvc2l0aW9uczoge1tmZDogbnVtYmVyXTogbnVtYmVyfSA9IHt9O1xuXG4gIHB1YmxpYyBzdGF0aWMgb3BlbihmZDogbnVtYmVyLCBpbml0aWFsUG9zaXRpb246IG51bWJlcikge1xuICAgIHRoaXMuX3Bvc2l0aW9uc1tmZF0gPSBpbml0aWFsUG9zaXRpb247XG4gIH1cblxuICBwdWJsaWMgc3RhdGljIGdldFBvcyhmZDogbnVtYmVyKTogbnVtYmVyIHtcbiAgICByZXR1cm4gdGhpcy5fcG9zaXRpb25zW2ZkXTtcbiAgfVxuXG4gIHB1YmxpYyBzdGF0aWMgaW5jcmVtZW50UG9zKGZkOiBudW1iZXIsIGluY3I6IG51bWJlcik6IHZvaWQge1xuICAgIHRoaXMuX3Bvc2l0aW9uc1tmZF0gKz0gaW5jcjtcbiAgfVxuXG4gIHB1YmxpYyBzdGF0aWMgc2V0UG9zKGZkOiBudW1iZXIsIG5ld1BvczogbnVtYmVyKTogdm9pZCB7XG4gICAgdGhpcy5fcG9zaXRpb25zW2ZkXSA9IG5ld1BvcztcbiAgfVxuXG4gIHB1YmxpYyBzdGF0aWMgY2xvc2UoZmQ6IG51bWJlcikge1xuICAgIGRlbGV0ZSB0aGlzLl9wb3NpdGlvbnNbZmRdO1xuICB9XG59XG5cbiJdfQ==