"use strict";
/**
 * The only way I could figure out how to get a handle on Node's 'require'
 * function without confusing webpack. Using a Function constructor doesn't work,
 * as require() isn't in its scope!
 *
 * Isolating in its own module so it doesn't mess up mangling in other modules.
 */
function getGlobalRequire() {
    var reqVar = eval('typeof(require)!=="undefined"?require:null');
    return reqVar ? reqVar : function (moduleName) {
        throw new Error("Cannot find module " + moduleName);
    };
}
exports.__esModule = true;
exports["default"] = getGlobalRequire;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2xvYmFsX3JlcXVpcmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZ2xvYmFsX3JlcXVpcmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7R0FNRztBQUNIO0lBQ0UsSUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLDRDQUE0QyxDQUFDLENBQUM7SUFDbEUsTUFBTSxDQUFDLE1BQU0sR0FBRyxNQUFNLEdBQUcsVUFBUyxVQUFrQjtRQUNsRCxNQUFNLElBQUksS0FBSyxDQUFDLHdCQUFzQixVQUFZLENBQUMsQ0FBQztJQUN0RCxDQUFDLENBQUM7QUFDSixDQUFDO0FBTEQ7cUNBS0MsQ0FBQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogVGhlIG9ubHkgd2F5IEkgY291bGQgZmlndXJlIG91dCBob3cgdG8gZ2V0IGEgaGFuZGxlIG9uIE5vZGUncyAncmVxdWlyZSdcbiAqIGZ1bmN0aW9uIHdpdGhvdXQgY29uZnVzaW5nIHdlYnBhY2suIFVzaW5nIGEgRnVuY3Rpb24gY29uc3RydWN0b3IgZG9lc24ndCB3b3JrLFxuICogYXMgcmVxdWlyZSgpIGlzbid0IGluIGl0cyBzY29wZSFcbiAqXG4gKiBJc29sYXRpbmcgaW4gaXRzIG93biBtb2R1bGUgc28gaXQgZG9lc24ndCBtZXNzIHVwIG1hbmdsaW5nIGluIG90aGVyIG1vZHVsZXMuXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGdldEdsb2JhbFJlcXVpcmUoKTogRnVuY3Rpb24ge1xuICBjb25zdCByZXFWYXIgPSBldmFsKCd0eXBlb2YocmVxdWlyZSkhPT1cInVuZGVmaW5lZFwiP3JlcXVpcmU6bnVsbCcpO1xuICByZXR1cm4gcmVxVmFyID8gcmVxVmFyIDogZnVuY3Rpb24obW9kdWxlTmFtZTogc3RyaW5nKTogYW55IHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYENhbm5vdCBmaW5kIG1vZHVsZSAke21vZHVsZU5hbWV9YCk7XG4gIH07XG59Il19