"use strict";
var enums_1 = require('./enums');
var opcodes = require('./opcodes');
function makeOnError(onErrorPushes, pc) {
    return onErrorPushes.length > 0 ? "f.pc=" + pc + ";f.opStack.pushAll(" + onErrorPushes.join(',') + ");" : "f.pc=" + pc + ";";
}
var escapeStringRegEx = /\\/g;
exports.opJitInfo = function () {
    // Intentionally indented higher: emitted code is shorter.
    var table = [];
    table[enums_1.OpCode.ACONST_NULL] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.ICONST_M1] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=-1;" + onSuccess;
        } };
    var load0_32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[0];" + onSuccess;
        } };
    var load1_32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[1];" + onSuccess;
        } };
    var load2_32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[2];" + onSuccess;
        } };
    var load3_32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[3];" + onSuccess;
        } };
    table[enums_1.OpCode.ALOAD_0] = load0_32;
    table[enums_1.OpCode.ILOAD_0] = load0_32;
    table[enums_1.OpCode.FLOAD_0] = load0_32;
    table[enums_1.OpCode.ALOAD_1] = load1_32;
    table[enums_1.OpCode.ILOAD_1] = load1_32;
    table[enums_1.OpCode.FLOAD_1] = load1_32;
    table[enums_1.OpCode.ALOAD_2] = load2_32;
    table[enums_1.OpCode.ILOAD_2] = load2_32;
    table[enums_1.OpCode.FLOAD_2] = load2_32;
    table[enums_1.OpCode.ALOAD_3] = load3_32;
    table[enums_1.OpCode.ILOAD_3] = load3_32;
    table[enums_1.OpCode.FLOAD_3] = load3_32;
    var load0_64 = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[0]," + pushes[1] + "=null;" + onSuccess;
        } };
    var load1_64 = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[1]," + pushes[1] + "=null;" + onSuccess;
        } };
    var load2_64 = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[2]," + pushes[1] + "=null;" + onSuccess;
        } };
    var load3_64 = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=f.locals[3]," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.LLOAD_0] = load0_64;
    table[enums_1.OpCode.DLOAD_0] = load0_64;
    table[enums_1.OpCode.LLOAD_1] = load1_64;
    table[enums_1.OpCode.DLOAD_1] = load1_64;
    table[enums_1.OpCode.LLOAD_2] = load2_64;
    table[enums_1.OpCode.DLOAD_2] = load2_64;
    table[enums_1.OpCode.LLOAD_3] = load3_64;
    table[enums_1.OpCode.DLOAD_3] = load3_64;
    var store0_32 = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[0]=" + pops[0] + ";" + onSuccess;
        } };
    var store1_32 = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[1]=" + pops[0] + ";" + onSuccess;
        } };
    var store2_32 = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[2]=" + pops[0] + ";" + onSuccess;
        } };
    var store3_32 = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[3]=" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.ASTORE_0] = store0_32;
    table[enums_1.OpCode.ISTORE_0] = store0_32;
    table[enums_1.OpCode.FSTORE_0] = store0_32;
    table[enums_1.OpCode.ASTORE_1] = store1_32;
    table[enums_1.OpCode.ISTORE_1] = store1_32;
    table[enums_1.OpCode.FSTORE_1] = store1_32;
    table[enums_1.OpCode.ASTORE_2] = store2_32;
    table[enums_1.OpCode.ISTORE_2] = store2_32;
    table[enums_1.OpCode.FSTORE_2] = store2_32;
    table[enums_1.OpCode.ASTORE_3] = store3_32;
    table[enums_1.OpCode.ISTORE_3] = store3_32;
    table[enums_1.OpCode.FSTORE_3] = store3_32;
    var store_64 = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var offset = code[pc + 1];
            return "f.locals[" + (offset + 1) + "]=" + pops[0] + ";f.locals[" + offset + "]=" + pops[1] + ";" + onSuccess;
        } };
    var store0_64 = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[1]=" + pops[0] + ";f.locals[0]=" + pops[1] + ";" + onSuccess;
        } };
    var store1_64 = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[2]=" + pops[0] + ";f.locals[1]=" + pops[1] + ";" + onSuccess;
        } };
    var store2_64 = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[3]=" + pops[0] + ";f.locals[2]=" + pops[1] + ";" + onSuccess;
        } };
    var store3_64 = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "f.locals[4]=" + pops[0] + ";f.locals[3]=" + pops[1] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.LSTORE] = store_64;
    table[enums_1.OpCode.DSTORE] = store_64;
    table[enums_1.OpCode.LSTORE_0] = store0_64;
    table[enums_1.OpCode.DSTORE_0] = store0_64;
    table[enums_1.OpCode.LSTORE_1] = store1_64;
    table[enums_1.OpCode.DSTORE_1] = store1_64;
    table[enums_1.OpCode.LSTORE_2] = store2_64;
    table[enums_1.OpCode.DSTORE_2] = store2_64;
    table[enums_1.OpCode.LSTORE_3] = store3_64;
    table[enums_1.OpCode.DSTORE_3] = store3_64;
    var const0_32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=0;" + onSuccess;
        } };
    var const1_32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=1;" + onSuccess;
        } };
    var const2_32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=2;" + onSuccess;
        } };
    table[enums_1.OpCode.ICONST_0] = const0_32;
    table[enums_1.OpCode.ICONST_1] = const1_32;
    table[enums_1.OpCode.ICONST_2] = const2_32;
    table[enums_1.OpCode.FCONST_0] = const0_32;
    table[enums_1.OpCode.FCONST_1] = const1_32;
    table[enums_1.OpCode.FCONST_2] = const2_32;
    table[enums_1.OpCode.ICONST_3] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=3;" + onSuccess;
        } };
    table[enums_1.OpCode.ICONST_4] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=4;" + onSuccess;
        } };
    table[enums_1.OpCode.ICONST_5] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=5;" + onSuccess;
        } };
    table[enums_1.OpCode.LCONST_0] = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=u.gLong.ZERO," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.LCONST_1] = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=u.gLong.ONE," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.DCONST_0] = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=0," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.DCONST_1] = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=1," + pushes[1] + "=null;" + onSuccess;
        } };
    var aload32 = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "\nif(!u.isNull(t,f," + pops[1] + ")){\nvar len" + suffix + "=" + pops[1] + ".array.length;\nif(" + pops[0] + "<0||" + pops[0] + ">=len" + suffix + "){\n" + onError + "\nu.throwException(t,f,'Ljava/lang/ArrayIndexOutOfBoundsException;',\"\"+" + pops[0] + "+\" not in length \"+len" + suffix + "+\" array of type \"+" + pops[1] + ".getClass().getInternalName());\n}else{var " + pushes[0] + "=" + pops[1] + ".array[" + pops[0] + "];" + onSuccess + "}\n}else{" + onError + "}";
        } };
    table[enums_1.OpCode.IALOAD] = aload32;
    table[enums_1.OpCode.FALOAD] = aload32;
    table[enums_1.OpCode.AALOAD] = aload32;
    table[enums_1.OpCode.BALOAD] = aload32;
    table[enums_1.OpCode.CALOAD] = aload32;
    table[enums_1.OpCode.SALOAD] = aload32;
    var aload64 = { hasBranch: false, pops: 2, pushes: 2, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "\nif(!u.isNull(t,f," + pops[1] + ")){\nvar len" + suffix + "=" + pops[1] + ".array.length;\nif(" + pops[0] + "<0||" + pops[0] + ">=len" + suffix + "){\n" + onError + "\nu.throwException(t,f,'Ljava/lang/ArrayIndexOutOfBoundsException;',\"\"+" + pops[0] + "+\" not in length \"+len" + suffix + "+\" array of type \"+" + pops[1] + ".getClass().getInternalName());\n}else{var " + pushes[0] + "=" + pops[1] + ".array[" + pops[0] + "]," + pushes[1] + "=null;" + onSuccess + "}\n}else{" + onError + "}";
        } };
    table[enums_1.OpCode.DALOAD] = aload64;
    table[enums_1.OpCode.LALOAD] = aload64;
    var astore32 = { hasBranch: false, pops: 3, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "\nif(!u.isNull(t,f," + pops[2] + ")){\nvar len" + suffix + "=" + pops[2] + ".array.length;\nif(" + pops[1] + "<0||" + pops[1] + ">=len" + suffix + "){\n" + onError + "\nu.throwException(t,f,'Ljava/lang/ArrayIndexOutOfBoundsException;',\"\"+" + pops[1] + "+\" not in length \"+len" + suffix + "+\" array of type \"+" + pops[2] + ".getClass().getInternalName());\n}else{" + pops[2] + ".array[" + pops[1] + "]=" + pops[0] + ";" + onSuccess + "}\n}else{" + onError + "}";
        } };
    table[enums_1.OpCode.IASTORE] = astore32;
    table[enums_1.OpCode.FASTORE] = astore32;
    table[enums_1.OpCode.AASTORE] = astore32;
    table[enums_1.OpCode.BASTORE] = astore32;
    table[enums_1.OpCode.CASTORE] = astore32;
    table[enums_1.OpCode.SASTORE] = astore32;
    var astore64 = { hasBranch: false, pops: 4, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "\nif(!u.isNull(t,f," + pops[3] + ")){\nvar len" + suffix + "=" + pops[3] + ".array.length;\nif(" + pops[2] + "<0||" + pops[2] + ">=len" + suffix + "){\n" + onError + "\nu.throwException(t,f,'Ljava/lang/ArrayIndexOutOfBoundsException;',\"\"+" + pops[2] + "+\" not in length \"+len" + suffix + "+\" array of type \"+" + pops[3] + ".getClass().getInternalName());\n}else{" + pops[3] + ".array[" + pops[2] + "]=" + pops[1] + ";" + onSuccess + "}\n}else{" + onError + "}";
        } };
    table[enums_1.OpCode.DASTORE] = astore64;
    table[enums_1.OpCode.LASTORE] = astore64;
    // TODO: get the constant at JIT time ?
    table[enums_1.OpCode.LDC] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code[pc + 1];
            var onError = makeOnError(onErrorPushes, pc);
            return "\nvar cnst" + suffix + "=f.method.cls.constantPool.get(" + index + ");\nif(cnst" + suffix + ".isResolved()){var " + pushes[0] + "=cnst" + suffix + ".getConstant(t);" + onSuccess + "\n}else{" + onError + "u.resolveCPItem(t,f,cnst" + suffix + ");}";
        } };
    // TODO: get the constant at JIT time ?
    table[enums_1.OpCode.LDC_W] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code.readUInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc);
            return "\nvar cnst" + suffix + "=f.method.cls.constantPool.get(" + index + ");\nif(cnst" + suffix + ".isResolved()){var " + pushes[0] + "=cnst" + suffix + ".getConstant(t);" + onSuccess + "\n}else{" + onError + "u.resolveCPItem(t,f,cnst" + suffix + ");}";
        } };
    // TODO: get the constant at JIT time ?
    table[enums_1.OpCode.LDC2_W] = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return "var " + pushes[0] + "=f.method.cls.constantPool.get(" + index + ").value," + pushes[1] + "=null;" + onSuccess;
        } };
    // TODO: get the field info at JIT time ?
    table[enums_1.OpCode.GETSTATIC_FAST32] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return "var fi" + suffix + "=f.method.cls.constantPool.get(" + index + ")," + pushes[0] + "=fi" + suffix + ".fieldOwnerConstructor[fi" + suffix + ".fullFieldName];" + onSuccess;
        } };
    // TODO: get the field info at JIT time ?
    table[enums_1.OpCode.GETSTATIC_FAST64] = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return "\nvar fi" + suffix + "=f.method.cls.constantPool.get(" + index + ")," + pushes[0] + "=fi" + suffix + ".fieldOwnerConstructor[fi" + suffix + ".fullFieldName],\n" + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.GETFIELD_FAST32] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, "\\\\");
            return "if(!u.isNull(t,f," + pops[0] + ")){var " + pushes[0] + "=" + pops[0] + "['" + name + "'];" + onSuccess + "}else{" + onError + "}";
        } };
    table[enums_1.OpCode.GETFIELD_FAST64] = { hasBranch: false, pops: 1, pushes: 2, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, "\\\\");
            return "if(!u.isNull(t,f," + pops[0] + ")){var " + pushes[0] + "=" + pops[0] + "['" + name + "']," + pushes[1] + "=null;" + onSuccess + "}else{" + onError + "}";
        } };
    table[enums_1.OpCode.PUTFIELD_FAST32] = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, "\\\\");
            return "if(!u.isNull(t,f," + pops[1] + ")){" + pops[1] + "['" + name + "']=" + pops[0] + ";" + onSuccess + "}else{" + onError + "}";
        } };
    table[enums_1.OpCode.PUTFIELD_FAST64] = { hasBranch: false, pops: 3, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, "\\\\");
            return "if(!u.isNull(t,f," + pops[2] + ")){" + pops[2] + "['" + name + "']=" + pops[1] + ";" + onSuccess + "}else{" + onError + "}";
        } };
    // TODO: get the constant at JIT time ?
    table[enums_1.OpCode.INSTANCEOF_FAST] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return "var cls" + suffix + "=f.method.cls.constantPool.get(" + index + ").cls," + pushes[0] + "=" + pops[0] + "!==null?(" + pops[0] + ".getClass().isCastable(cls" + suffix + ")?1:0):0;" + onSuccess;
        } };
    table[enums_1.OpCode.CHECKCAST_FAST] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var index = code.readUInt16BE(pc + 1);
            var classRef = method.cls.constantPool.get(index), targetClass = classRef.cls.getExternalName();
            return "var cls" + suffix + "=f.method.cls.constantPool.get(" + index + ").cls;\nif((" + pops[0] + "!=null)&&!" + pops[0] + ".getClass().isCastable(cls" + suffix + ")){\nu.throwException(t,f,'Ljava/lang/ClassCastException;'," + pops[0] + ".getClass().getExternalName()+' cannot be cast to " + targetClass + "');\n}else{var " + pushes[0] + "=" + pops[0] + ";" + onSuccess + "}";
        } };
    table[enums_1.OpCode.ARRAYLENGTH] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "if(!u.isNull(t,f," + pops[0] + ")){var " + pushes[0] + "=" + pops[0] + ".array.length;" + onSuccess + "}else{" + onError + "}";
        } };
    var load32 = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code[pc + 1];
            return "var " + pushes[0] + "=f.locals[" + index + "];" + onSuccess;
        } };
    table[enums_1.OpCode.ILOAD] = load32;
    table[enums_1.OpCode.ALOAD] = load32;
    table[enums_1.OpCode.FLOAD] = load32;
    var load64 = { hasBranch: false, pops: 0, pushes: 2, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code[pc + 1];
            return "var " + pushes[0] + "=f.locals[" + index + "]," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.LLOAD] = load64;
    table[enums_1.OpCode.DLOAD] = load64;
    var store32 = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code[pc + 1];
            return "f.locals[" + index + "]=" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.ISTORE] = store32;
    table[enums_1.OpCode.ASTORE] = store32;
    table[enums_1.OpCode.FSTORE] = store32;
    table[enums_1.OpCode.BIPUSH] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var value = code.readInt8(pc + 1);
            return "var " + pushes[0] + "=" + value + ";" + onSuccess;
        } };
    table[enums_1.OpCode.SIPUSH] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var value = code.readInt16BE(pc + 1);
            return "var " + pushes[0] + "=" + value + ";" + onSuccess;
        } };
    table[enums_1.OpCode.IINC] = { hasBranch: false, pops: 0, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var idx = code[pc + 1];
            var val = code.readInt8(pc + 2);
            return "f.locals[" + idx + "]=(f.locals[" + idx + "]+" + val + ")|0;" + onSuccess;
        } };
    // This is marked as hasBranch: true to stop further opcode inclusion during JITC. The name of "hasBranch" ought to be changed.
    table[enums_1.OpCode.ATHROW] = { hasBranch: true, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return onError + "t.throwException(" + pops[0] + ");f.returnToThreadLoop=true;";
        } };
    table[enums_1.OpCode.GOTO] = { hasBranch: true, pops: 0, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var offset = code.readInt16BE(pc + 1);
            return "f.pc=" + (pc + offset) + ";" + onSuccess;
        } };
    table[enums_1.OpCode.TABLESWITCH] = { hasBranch: true, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            // Ignore padding bytes. The +1 is to skip the opcode byte.
            var alignedPC = pc + ((4 - (pc + 1) % 4) % 4) + 1;
            var defaultOffset = code.readInt32BE(alignedPC), low = code.readInt32BE(alignedPC + 4), high = code.readInt32BE(alignedPC + 8);
            if ((high - low) < 8) {
                var emitted = "switch(" + pops[0] + "){";
                for (var i = low; i <= high; i++) {
                    var offset = code.readInt32BE(alignedPC + 12 + ((i - low) * 4));
                    emitted += "case " + i + ":f.pc=" + (pc + offset) + ";break;";
                }
                emitted += "default:f.pc=" + (pc + defaultOffset) + "}" + onSuccess;
                return emitted;
            }
            else {
                return "if(" + pops[0] + ">=" + low + "&&" + pops[0] + "<=" + high + "){f.pc=" + pc + "+f.method.getCodeAttribute().getCode().readInt32BE(" + (alignedPC + 12) + "+((" + pops[0] + " - " + low + ")*4))}else{f.pc=" + (pc + defaultOffset) + "}" + onSuccess;
            }
        } };
    var cmpeq = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "===" + pops[1] + "){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IF_ICMPEQ] = cmpeq;
    table[enums_1.OpCode.IF_ACMPEQ] = cmpeq;
    var cmpne = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "!==" + pops[1] + "){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IF_ICMPNE] = cmpne;
    table[enums_1.OpCode.IF_ACMPNE] = cmpne;
    table[enums_1.OpCode.IF_ICMPGE] = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[1] + ">=" + pops[0] + "){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IF_ICMPGT] = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[1] + ">" + pops[0] + "){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IF_ICMPLE] = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[1] + "<=" + pops[0] + "){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IF_ICMPLT] = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[1] + "<" + pops[0] + "){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFNULL] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "==null){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFNONNULL] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "!=null){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFEQ] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "===0){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFNE] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "!==0){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFGT] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + ">0){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFLT] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "<0){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFGE] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + ">=0){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.IFLE] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return "if(" + pops[0] + "<=0){" + onError + "}else{" + onSuccess + "}";
        } };
    table[enums_1.OpCode.LCMP] = { hasBranch: false, pops: 4, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + ".compare(" + pops[1] + ");" + onSuccess;
        } };
    table[enums_1.OpCode.FCMPL] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "===" + pops[1] + "?0:(" + pops[1] + ">" + pops[0] + "?1:-1);" + onSuccess;
        } };
    table[enums_1.OpCode.DCMPL] = { hasBranch: false, pops: 4, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + "===" + pops[1] + "?0:(" + pops[3] + ">" + pops[1] + "?1:-1);" + onSuccess;
        } };
    table[enums_1.OpCode.FCMPG] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "===" + pops[1] + "?0:(" + pops[1] + "<" + pops[0] + "?-1:1);" + onSuccess;
        } };
    table[enums_1.OpCode.DCMPG] = { hasBranch: false, pops: 4, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + "===" + pops[1] + "?0:(" + pops[3] + "<" + pops[1] + "?-1:1);" + onSuccess;
        } };
    table[enums_1.OpCode.RETURN] = { hasBranch: true, pops: 0, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            // TODO: on error pushes
            if (method.accessFlags.isSynchronized()) {
                return "f.pc=" + pc + ";f.returnToThreadLoop=true;if(!f.method.methodLock(t,f).exit(t)){return}t.asyncReturn();";
            }
            else {
                return "f.pc=" + pc + ";f.returnToThreadLoop=true;t.asyncReturn();";
            }
        } };
    var return32 = { hasBranch: true, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            // TODO: on error pushes
            if (method.accessFlags.isSynchronized()) {
                return "f.pc=" + pc + ";f.returnToThreadLoop=true;if(!f.method.methodLock(t,f).exit(t)){return}t.asyncReturn(" + pops[0] + ");";
            }
            else {
                return "f.pc=" + pc + ";f.returnToThreadLoop=true;t.asyncReturn(" + pops[0] + ");";
            }
        } };
    table[enums_1.OpCode.IRETURN] = return32;
    table[enums_1.OpCode.FRETURN] = return32;
    table[enums_1.OpCode.ARETURN] = return32;
    var return64 = { hasBranch: true, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            // TODO: on error pushes
            if (method.accessFlags.isSynchronized()) {
                return "f.pc=" + pc + ";f.returnToThreadLoop=true;if(!f.method.methodLock(t,f).exit(t)){return}t.asyncReturn(" + pops[1] + ",null);";
            }
            else {
                return "f.pc=" + pc + ";f.returnToThreadLoop=true;t.asyncReturn(" + pops[1] + ",null);";
            }
        } };
    table[enums_1.OpCode.LRETURN] = return64;
    table[enums_1.OpCode.DRETURN] = return64;
    table[enums_1.OpCode.MONITOREXIT] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "if(" + pops[0] + ".getMonitor().exit(t)){" + onSuccess + "}else{" + onError + "f.returnToThreadLoop=true;}";
        } };
    table[enums_1.OpCode.IXOR] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "^" + pops[1] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.LXOR] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + ".xor(" + pops[3] + ")," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.IOR] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "|" + pops[1] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.LOR] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + ".or(" + pops[1] + ")," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.IAND] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "&" + pops[1] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.LAND] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + ".and(" + pops[1] + ")," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.IADD] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=(" + pops[0] + "+" + pops[1] + ")|0;" + onSuccess;
        } };
    table[enums_1.OpCode.LADD] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + ".add(" + pops[3] + ")," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.DADD] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + "+" + pops[3] + "," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.IMUL] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=Math.imul(" + pops[0] + ", " + pops[1] + ");" + onSuccess;
        } };
    table[enums_1.OpCode.FMUL] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=u.wrapFloat(" + pops[0] + "*" + pops[1] + ");" + onSuccess;
        } };
    table[enums_1.OpCode.LMUL] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + ".multiply(" + pops[1] + ")," + pushes[1] + "= null;" + onSuccess;
        } };
    table[enums_1.OpCode.DMUL] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + "*" + pops[1] + "," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.IDIV] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "\nif(" + pops[0] + "===0){" + onError + "u.throwException(t,f,'Ljava/lang/ArithmeticException;','/ by zero');\n}else{var " + pushes[0] + "=(" + pops[1] + "===u.Constants.INT_MIN&&" + pops[0] + "===-1)?" + pops[1] + ":((" + pops[1] + "/" + pops[0] + ")|0);" + onSuccess + "}";
        } };
    table[enums_1.OpCode.LDIV] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "\nif(" + pops[1] + ".isZero()){" + onError + "u.throwException(t,f,'Ljava/lang/ArithmeticException;','/ by zero');\n}else{var " + pushes[0] + "=" + pops[3] + ".div(" + pops[1] + ")," + pushes[1] + "=null;" + onSuccess + "}";
        } };
    table[enums_1.OpCode.DDIV] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + "/" + pops[1] + "," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.ISUB] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=(" + pops[1] + "-" + pops[0] + ")|0;" + onSuccess;
        } };
    table[enums_1.OpCode.LSUB] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + ".negate().add(" + pops[3] + ")," + pushes[1] + "= null;" + onSuccess;
        } };
    table[enums_1.OpCode.DSUB] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + "-" + pops[1] + "," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.IREM] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "if(" + pops[0] + "===0){" + onError + "u.throwException(t,f,'Ljava/lang/ArithmeticException;','/ by zero');\n}else{var " + pushes[0] + "=" + pops[1] + "%" + pops[0] + ";" + onSuccess + "}";
        } };
    table[enums_1.OpCode.LREM] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return "if(" + pops[1] + ".isZero()){" + onError + "u.throwException(t,f,'Ljava/lang/ArithmeticException;','/ by zero');\n}else{var " + pushes[0] + "=" + pops[3] + ".modulo(" + pops[1] + ")," + pushes[1] + "=null;" + onSuccess + "}";
        } };
    table[enums_1.OpCode.DREM] = { hasBranch: false, pops: 4, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[3] + "%" + pops[1] + "," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.INEG] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=(-" + pops[0] + ")|0;" + onSuccess;
        } };
    table[enums_1.OpCode.LNEG] = { hasBranch: false, pops: 2, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + ".negate()," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.ISHL] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + "<<" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.LSHL] = { hasBranch: false, pops: 3, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[2] + ".shiftLeft(u.gLong.fromInt(" + pops[0] + "))," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.ISHR] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + ">>" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.LSHR] = { hasBranch: false, pops: 3, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[2] + ".shiftRight(u.gLong.fromInt(" + pops[0] + "))," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.IUSHR] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=(" + pops[1] + ">>>" + pops[0] + ")|0;" + onSuccess;
        } };
    table[enums_1.OpCode.LUSHR] = { hasBranch: false, pops: 3, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[2] + ".shiftRightUnsigned(u.gLong.fromInt(" + pops[0] + "))," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.I2B] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=(" + pops[0] + "<<24)>>24;" + onSuccess;
        } };
    table[enums_1.OpCode.I2S] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=(" + pops[0] + "<<16)>>16;" + onSuccess;
        } };
    table[enums_1.OpCode.I2C] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "&0xFFFF;" + onSuccess;
        } };
    table[enums_1.OpCode.I2L] = { hasBranch: false, pops: 1, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=u.gLong.fromInt(" + pops[0] + ")," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.I2F] = { hasBranch: false, pops: 0, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "" + onSuccess;
        } };
    table[enums_1.OpCode.I2D] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.F2I] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=u.float2int(" + pops[0] + ");" + onSuccess;
        } };
    table[enums_1.OpCode.F2D] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.L2I] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + ".toInt();" + onSuccess;
        } };
    table[enums_1.OpCode.L2D] = { hasBranch: false, pops: 2, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + ".toNumber()," + pushes[1] + "=null;" + onSuccess;
        } };
    table[enums_1.OpCode.D2I] = { hasBranch: false, pops: 2, pushes: 1, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=u.float2int(" + pops[1] + ");" + onSuccess;
        } };
    // TODO: update the DUPs when peeking is supported
    table[enums_1.OpCode.DUP] = { hasBranch: false, pops: 1, pushes: 2, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "," + pushes[1] + "=" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.DUP2] = { hasBranch: false, pops: 2, pushes: 4, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + "," + pushes[1] + "=" + pops[0] + "," + pushes[2] + "=" + pops[1] + "," + pushes[3] + "=" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.DUP_X1] = { hasBranch: false, pops: 2, pushes: 3, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "," + pushes[1] + "=" + pops[1] + "," + pushes[2] + "=" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.DUP_X2] = { hasBranch: false, pops: 3, pushes: 4, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[0] + "," + pushes[1] + "=" + pops[2] + "," + pushes[2] + "=" + pops[1] + "," + pushes[3] + "=" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.DUP2_X1] = { hasBranch: false, pops: 3, pushes: 5, emit: function (pops, pushes, suffix, onSuccess) {
            return "var " + pushes[0] + "=" + pops[1] + "," + pushes[1] + "=" + pops[0] + "," + pushes[2] + "=" + pops[2] + "," + pushes[3] + "=" + pops[1] + "," + pushes[4] + "=" + pops[0] + ";" + onSuccess;
        } };
    table[enums_1.OpCode.NEW_FAST] = { hasBranch: false, pops: 0, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return "var cr" + suffix + "=f.method.cls.constantPool.get(" + index + ")," + pushes[0] + "=(new cr" + suffix + ".clsConstructor(t));" + onSuccess;
        } };
    table[enums_1.OpCode.NEWARRAY] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code[pc + 1];
            var arrayType = "[" + opcodes.ArrayTypes[index];
            var onError = makeOnError(onErrorPushes, pc);
            return "\nvar cls" + suffix + "=f.getLoader().getInitializedClass(t,'" + arrayType + "');\nif(" + pops[0] + ">=0){var " + pushes[0] + "=new (cls" + suffix + ".getConstructor(t))(t," + pops[0] + ");" + onSuccess + "\n}else{" + onError + "u.throwException(t,f,'Ljava/lang/NegativeArraySizeException;','Tried to init " + arrayType + " array with length '+" + pops[0] + ");}";
        } };
    table[enums_1.OpCode.ANEWARRAY_FAST] = { hasBranch: false, pops: 1, pushes: 1, emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code.readUInt16BE(pc + 1);
            var arrayType = "[" + opcodes.ArrayTypes[index];
            var onError = makeOnError(onErrorPushes, pc);
            return "\nvar cr" + suffix + "=f.method.cls.constantPool.get(" + index + ");\nif(" + pops[0] + ">=0){var " + pushes[0] + "=new cr" + suffix + ".arrayClassConstructor(t," + pops[0] + ");" + onSuccess + "\n}else{" + onError + "u.throwException(t,f,'Ljava/lang/NegativeArraySizeException;','Tried to init '+cr" + suffix + ".arrayClass.getInternalName()+' array with length '+" + pops[0] + ");}";
        } };
    table[enums_1.OpCode.NOP] = { hasBranch: false, pops: 0, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "" + onSuccess;
        } };
    table[enums_1.OpCode.POP] = { hasBranch: false, pops: 1, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "" + onSuccess;
        } };
    table[enums_1.OpCode.POP2] = { hasBranch: false, pops: 2, pushes: 0, emit: function (pops, pushes, suffix, onSuccess) {
            return "" + onSuccess;
        } };
    return table;
}();
//# sourceMappingURL=data:application/json;base64,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