"use strict";
var gLong_1 = require('./gLong');
// default module: logging
// used for debugging the stack and local variables
function debug_var(e) {
    if (e === null) {
        return '!';
    }
    else if (e === void 0) {
        return 'undef';
    }
    else if (e.ref != null) {
        return "*" + e.ref;
    }
    else if (e instanceof gLong_1["default"]) {
        return e + "L";
    }
    return e;
}
exports.debug_var = debug_var;
// used for debugging the stack and local variables
function debug_vars(arr) {
    return arr.map(debug_var);
}
exports.debug_vars = debug_vars;
// log levels
// TODO: turn this into an enum, if possible
(function (LogLevel) {
    LogLevel[LogLevel["VTRACE"] = 10] = "VTRACE";
    LogLevel[LogLevel["TRACE"] = 9] = "TRACE";
    LogLevel[LogLevel["DEBUG"] = 5] = "DEBUG";
    LogLevel[LogLevel["ERROR"] = 1] = "ERROR";
})(exports.LogLevel || (exports.LogLevel = {}));
var LogLevel = exports.LogLevel;
exports.logLevel = LogLevel.ERROR;
function setLogLevel(level) {
    exports.logLevel = level;
}
exports.setLogLevel = setLogLevel;
function log(level, msgs) {
    if (level <= exports.logLevel) {
        var msg = msgs.join(' ');
        if (level == 1) {
            console.error(msg);
        }
        else {
            console.log(msg);
        }
    }
}
function vtrace() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.VTRACE, msgs);
}
exports.vtrace = vtrace;
function trace() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.TRACE, msgs);
}
exports.trace = trace;
function debug() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.DEBUG, msgs);
}
exports.debug = debug;
function error() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.ERROR, msgs);
}
exports.error = error;
//# sourceMappingURL=data:application/json;base64,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