"use strict";
var Doppio = require('../doppiojvm');
var logging = Doppio.Debug.Logging;
var LogLevel = logging.LogLevel;
var util = Doppio.VM.Util;
var NodeCrypto = require('crypto');
function default_1() {
    var doppio_Debug = (function () {
        function doppio_Debug() {
        }
        doppio_Debug['SetLogLevel(Ldoppio/Debug$LogLevel;)V'] = function (thread, loglevel) {
            logging.setLogLevel(loglevel['doppio/Debug$LogLevel/level']);
        };
        doppio_Debug['GetLogLevel()Ldoppio/Debug$LogLevel;'] = function (thread) {
            var ll_cls = thread.getBsCl().getInitializedClass(thread, 'Ldoppio/Debug$LogLevel;').getConstructor(thread);
            switch (logging.logLevel) {
                case LogLevel.VTRACE:
                    return ll_cls['doppio/Debug$LogLevel/VTRACE'];
                case LogLevel.TRACE:
                    return ll_cls['doppio/Debug$LogLevel/TRACE'];
                case LogLevel.DEBUG:
                    return ll_cls['doppio/Debug$LogLevel/DEBUG'];
                default:
                    return ll_cls['doppio/Debug$LogLevel/ERROR'];
            }
        };
        return doppio_Debug;
    }());
    var doppio_JavaScript = (function () {
        function doppio_JavaScript() {
        }
        doppio_JavaScript['eval(Ljava/lang/String;)Ljava/lang/String;'] = function (thread, to_eval) {
            try {
                var rv = eval(to_eval.toString());
                // Coerce to string, if possible.
                if (rv != null) {
                    return util.initString(thread.getBsCl(), "" + rv);
                }
                else {
                    return null;
                }
            }
            catch (e) {
                thread.throwNewException('Ljava/lang/Exception;', "Error evaluating string: " + e);
            }
        };
        return doppio_JavaScript;
    }());
    var doppio_security_BrowserPRNG = (function () {
        function doppio_security_BrowserPRNG() {
        }
        doppio_security_BrowserPRNG['isAvailable()Z'] = function (thread) {
            // !! makes it a boolean.
            var crypto = doppio_security_BrowserPRNG.crypto;
            return !!(crypto && crypto.getRandomValues);
        };
        doppio_security_BrowserPRNG['engineSetSeed([B)V'] = function (thread, javaThis, seed) {
            thread.throwNewException('Ljava/security/ProviderException;', 'engineSetSeed() failed.');
        };
        doppio_security_BrowserPRNG['engineNextBytes([B)V'] = function (thread, javaThis, bytes) {
            var crypto = doppio_security_BrowserPRNG.crypto;
            crypto.getRandomValues(bytes.array);
        };
        doppio_security_BrowserPRNG['engineGenerateSeed(I)[B'] = function (thread, javaThis, numBytes) {
            var crypto = doppio_security_BrowserPRNG.crypto;
            var bytes = util.newArrayFromClass(thread, thread.getBsCl().getInitializedClass(thread, '[B'), numBytes);
            crypto.getRandomValues(bytes.array);
            return bytes;
        };
        doppio_security_BrowserPRNG.crypto = typeof (crypto) !== 'undefined' ? crypto : typeof (msCrypto) !== 'undefined' ? msCrypto : null;
        return doppio_security_BrowserPRNG;
    }());
    var doppio_security_NodePRNG = (function () {
        function doppio_security_NodePRNG() {
        }
        doppio_security_NodePRNG['isAvailable()Z'] = function (thread) {
            return !util.are_in_browser();
        };
        doppio_security_NodePRNG['engineSetSeed([B)V'] = function (thread, javaThis, seed) {
            thread.throwNewException('Ljava/security/ProviderException;', 'engineSetSeed() failed.');
        };
        doppio_security_NodePRNG['engineNextBytes([B)V'] = function (thread, javaThis, bytes) {
            var array = bytes.array;
            var len = array.length;
            var data = NodeCrypto.randomBytes(len);
            for (var i = 0; i < len; i++) {
                array[i] = data.readInt8(i);
            }
        };
        doppio_security_NodePRNG['engineGenerateSeed(I)[B'] = function (thread, javaThis, numBytes) {
            var data = NodeCrypto.randomBytes(numBytes);
            var array = util.u82i8(data, 0, data.length);
            return util.newArrayFromDataWithClass(thread, thread.getBsCl().getInitializedClass(thread, '[B'), array);
        };
        return doppio_security_NodePRNG;
    }());
    return {
        'doppio/Debug': doppio_Debug,
        'doppio/JavaScript': doppio_JavaScript,
        "doppio/security/BrowserPRNG": doppio_security_BrowserPRNG,
        "doppio/security/NodePRNG": doppio_security_NodePRNG
    };
}
exports.__esModule = true;
exports["default"] = default_1;
;
//# sourceMappingURL=data:application/json;base64,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