"use strict";
var Doppio = require('../doppiojvm');
var ThreadStatus = Doppio.VM.Enums.ThreadStatus;
function doPrivileged(thread, action, ctx) {
    thread.setStatus(ThreadStatus.ASYNC_WAITING);
    action['run()Ljava/lang/Object;'](thread, null, function (e, rv) {
        if (e) {
            // If e is an UNCHECKED exception, re-throw it.
            // https://docs.oracle.com/javase/tutorial/essential/exceptions/runtime.html
            var eCls = e.getClass();
            var bsCl = thread.getBsCl();
            var errCls = bsCl.getInitializedClass(thread, 'Ljava/lang/Error;');
            var reCls = bsCl.getInitializedClass(thread, 'Ljava/lang/RuntimeException;');
            if ((errCls !== null && eCls.isCastable(errCls)) || (reCls !== null && eCls.isCastable(reCls))) {
                thread.throwException(e);
            }
            else {
                // It is a checked exception. Wrap exception in a PrivilegedActionException, and throw it.
                thread.import('Ljava/security/PrivilegedActionException;', function (paeCons) {
                    var eobj = new paeCons(thread);
                    thread.setStatus(ThreadStatus.ASYNC_WAITING);
                    eobj['<init>(Ljava/lang/Exception;)V'](thread, [e], function (e) {
                        if (e) {
                            // Failed to construct a PrivilegedActionException? Dang.
                            thread.throwException(e);
                        }
                        else {
                            thread.throwException(eobj);
                        }
                    });
                }, false);
            }
        }
        else {
            // Forward return value.
            thread.asyncReturn(rv);
        }
    });
}
function default_1() {
    var java_security_AccessController = (function () {
        function java_security_AccessController() {
        }
        java_security_AccessController['getStackAccessControlContext()Ljava/security/AccessControlContext;'] = function (thread) {
            return null;
        };
        java_security_AccessController['getInheritedAccessControlContext()Ljava/security/AccessControlContext;'] = function (thread) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        java_security_AccessController['doPrivileged(Ljava/security/PrivilegedAction;)Ljava/lang/Object;'] = doPrivileged;
        java_security_AccessController['doPrivileged(Ljava/security/PrivilegedAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;'] = doPrivileged;
        java_security_AccessController['doPrivileged(Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;'] = doPrivileged;
        java_security_AccessController['doPrivileged(Ljava/security/PrivilegedExceptionAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;'] = doPrivileged;
        return java_security_AccessController;
    }());
    return {
        'java/security/AccessController': java_security_AccessController
    };
}
exports.__esModule = true;
exports["default"] = default_1;
;
//# sourceMappingURL=data:application/json;base64,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