"use strict";
var DoppioJVM = require('../doppiojvm');
var util = DoppioJVM.VM.Util;
var Long = DoppioJVM.VM.Long;
var AbstractClasspathJar = DoppioJVM.VM.ClassFile.AbstractClasspathJar;
var BrowserFS = require('browserfs');
var path = require('path');
var fs = require('fs');
var ThreadStatus = DoppioJVM.VM.Enums.ThreadStatus;
var deflate = require('pako/lib/zlib/deflate');
var inflate = require('pako/lib/zlib/inflate');
var crc32 = require('pako/lib/zlib/crc32');
var adler32 = require('pako/lib/zlib/adler32');
var ZStreamCons = require('pako/lib/zlib/zstream');
var i82u8 = util.i82u8;
var isInt8Array = util.isInt8Array;
var u82i8 = util.u82i8;
var BFSUtils = BrowserFS.BFSRequire('bfs_utils');
var MAX_WBITS = 15;
var CanUseCopyFastPath = false;
if (typeof Int8Array !== "undefined") {
    var i8arr = new Int8Array(1);
    var b = new Buffer(i8arr.buffer);
    i8arr[0] = 100;
    CanUseCopyFastPath = i8arr[0] == b.readInt8(0);
}
function default_1() {
    var ZipFiles = {};
    var ZipEntries = {};
    var ZStreams = {};
    // Start at 1, as 0 is interpreted as an error.
    var NextId = 1;
    function OpenItem(item, map) {
        var id = NextId++;
        map[id] = item;
        return id;
    }
    function GetItem(thread, id, map, errMsg) {
        var item = map[id];
        if (!item) {
            thread.throwNewException("Ljava/lang/IllegalStateException;", errMsg);
            return null;
        }
        else {
            return item;
        }
    }
    function CloseItem(id, map) {
        delete map[id];
    }
    function OpenZipFile(zfile) {
        return OpenItem(zfile, ZipFiles);
    }
    function CloseZipFile(id) {
        CloseItem(id, ZipFiles);
    }
    /**
     * Returns the zip file, if it exists.
     * Otherwise, throws an IllegalStateException.
     */
    function GetZipFile(thread, id) {
        return GetItem(thread, id, ZipFiles, "ZipFile not found.");
    }
    function OpenZipEntry(zentry) {
        return OpenItem(zentry, ZipEntries);
    }
    function CloseZipEntry(id) {
        CloseItem(id, ZipEntries);
    }
    /**
     * Returns the zip entry, if it exists.
     * Otherwise, throws an IllegalStateException.
     */
    function GetZipEntry(thread, id) {
        return GetItem(thread, id, ZipEntries, "Invalid ZipEntry.");
    }
    function OpenZStream(inflaterState) {
        return OpenItem(inflaterState, ZStreams);
    }
    function CloseZStream(id) {
        CloseItem(id, ZStreams);
    }
    function GetZStream(thread, id) {
        return GetItem(thread, id, ZStreams, "Inflater not found.");
    }
    var java_util_concurrent_atomic_AtomicLong = (function () {
        function java_util_concurrent_atomic_AtomicLong() {
        }
        java_util_concurrent_atomic_AtomicLong['VMSupportsCS8()Z'] = function (thread) {
            return true;
        };
        return java_util_concurrent_atomic_AtomicLong;
    }());
    var java_util_jar_JarFile = (function () {
        function java_util_jar_JarFile() {
        }
        /**
         * Returns an array of strings representing the names of all entries
         * that begin with "META-INF/" (case ignored). This native method is
         * used in JarFile as an optimization when looking up manifest and
         * signature file entries. Returns null if no entries were found.
         */
        java_util_jar_JarFile['getMetaInfEntryNames()[Ljava/lang/String;'] = function (thread, javaThis) {
            var zip = GetZipFile(thread, javaThis['java/util/zip/ZipFile/jzfile'].toNumber());
            if (zip) {
                if (!zip.existsSync('/META-INF')) {
                    return null;
                }
                var explorePath = ['/META-INF'];
                var bsCl = thread.getBsCl();
                var foundFiles = [util.initString(bsCl, 'META-INF/')];
                while (explorePath.length > 0) {
                    var p = explorePath.pop();
                    var dirListing = zip.readdirSync(p);
                    for (var i = 0; i < dirListing.length; i++) {
                        var newP = p + "/" + dirListing[i];
                        if (zip.statSync(newP, false).isDirectory()) {
                            explorePath.push(newP);
                            // Add a final /, and strip off first /.
                            foundFiles.push(util.initString(bsCl, newP.slice(1) + "/"));
                        }
                        else {
                            // Strip off first /.
                            foundFiles.push(util.initString(bsCl, newP.slice(1)));
                        }
                    }
                    return util.newArrayFromData(thread, bsCl, "[Ljava/lang/String;", foundFiles);
                }
            }
        };
        return java_util_jar_JarFile;
    }());
    var java_util_logging_FileHandler = (function () {
        function java_util_logging_FileHandler() {
        }
        java_util_logging_FileHandler['isSetUID()Z'] = function (thread) {
            // Our FS does not support setUID.
            return false;
        };
        return java_util_logging_FileHandler;
    }());
    var java_util_TimeZone = (function () {
        function java_util_TimeZone() {
        }
        java_util_TimeZone['getSystemTimeZoneID(Ljava/lang/String;)Ljava/lang/String;'] = function (thread, arg0) {
            // NOTE: Can be half of an hour (e.g. Newfoundland is GMT-3.5)
            // NOTE: Is positive for negative offset.
            var offset = new Date().getTimezoneOffset() / 60;
            return thread.getJVM().internString("GMT" + (offset > 0 ? '-' : '+') + offset);
        };
        java_util_TimeZone['getSystemGMTOffsetID()Ljava/lang/String;'] = function (thread) {
            // XXX may not be correct
            return null;
        };
        return java_util_TimeZone;
    }());
    var java_util_zip_Adler32 = (function () {
        function java_util_zip_Adler32() {
        }
        java_util_zip_Adler32['update(II)I'] = function (thread, adler, byte) {
            return adler32(adler, [byte & 0xFF], 1, 0);
        };
        java_util_zip_Adler32['updateBytes(I[BII)I'] = function (thread, adler, b, off, len) {
            return adler32(adler, i82u8(b.array, off, len), len, 0);
        };
        java_util_zip_Adler32['updateByteBuffer(IJII)I'] = function (thread, adler, addr, off, len) {
            var heap = thread.getJVM().getHeap();
            var buff = heap.get_buffer(addr.toNumber() + off, len);
            return adler32(adler, buff, buff.length, 0);
        };
        return java_util_zip_Adler32;
    }());
    var java_util_zip_CRC32 = (function () {
        function java_util_zip_CRC32() {
        }
        java_util_zip_CRC32['update(II)I'] = function (thread, crc, byte) {
            return crc32(crc, [byte & 0xFF], 1, 0);
        };
        java_util_zip_CRC32['updateBytes(I[BII)I'] = function (thread, crc, b, off, len) {
            return crc32(crc, i82u8(b.array, off, len), len, 0);
        };
        java_util_zip_CRC32['updateByteBuffer(IJII)I'] = function (thread, crc, addr, off, len) {
            var heap = thread.getJVM().getHeap();
            var buff = heap.get_buffer(addr.toNumber() + off, len);
            return crc32(crc, buff, buff.length, 0);
        };
        return java_util_zip_CRC32;
    }());
    var java_util_zip_Deflater = (function () {
        function java_util_zip_Deflater() {
        }
        java_util_zip_Deflater['initIDs()V'] = function (thread) { };
        /**
         * Initialize a new deflater. Using the zlib recommended default values.
         */
        java_util_zip_Deflater['init(IIZ)J'] = function (thread, level, strategy, nowrap) {
            var DEF_MEM_LEVEL = 8; // Zlib recommended default
            var Z_DEFLATED = 8; // This value is in the js version of pako under pako.Z_DEFLATED.
            // Possibly it is set to private in the Typescript version. The default value is 8, so this should work fine
            var strm = new ZStreamCons();
            var ret = deflate.deflateInit2(strm, level, Z_DEFLATED, nowrap ? -MAX_WBITS : MAX_WBITS, DEF_MEM_LEVEL, strategy);
            if (ret != 0 /* Z_OK */) {
                var msg = ((strm.msg) ? strm.msg :
                    (ret == -2 /* Z_STREAM_ERROR */) ?
                        "inflateInit2 returned Z_STREAM_ERROR" :
                        "unknown error initializing zlib library");
                thread.throwNewException("Ljava/lang/InternalError;", msg);
            }
            else {
                var num = OpenZStream(strm);
                return Long.fromNumber(num);
            }
        };
        /**
         * Apparently this is explicitly not supported by pako.
         * @see Notes at http://nodeca.github.io/pako/
         */
        java_util_zip_Deflater['setDictionary(J[BII)V'] = function (thread, arg0, arg1, arg2, arg3) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        java_util_zip_Deflater['deflateBytes(J[BIII)I'] = function (thread, javaThis, addr, b, off, len, flush) {
            var strm = GetZStream(thread, addr.toNumber());
            if (!strm)
                return;
            var thisBuf = javaThis['java/util/zip/Deflater/buf'];
            var thisOff = javaThis['java/util/zip/Deflater/off'];
            var thisLen = javaThis['java/util/zip/Deflater/len'];
            var inBuf = thisBuf.array;
            var outBuf = b.array;
            strm.input = i82u8(inBuf, 0, inBuf.length);
            strm.next_in = thisOff;
            strm.avail_in = thisLen;
            strm.output = i82u8(outBuf, 0, outBuf.length);
            strm.next_out = off;
            strm.avail_out = len;
            if (javaThis['java/util/zip/Deflater/setParams']) {
                var level = javaThis['java/util/zip/Deflater/level'];
                var strategy = javaThis['java/util/zip/Deflater/level'];
                //deflateParams is not yet supported by pako. We'll open a new ZStream with the new parameters instead.
                // res = deflate.deflateParams(strm, level, strategy);
                var newStream = new ZStreamCons();
                var res = deflate.deflateInit2(newStream, level, strm.state.method, strm.state.windowBits, strm.state.memLevel, strategy);
                ZStreams[addr.toNumber()] = newStream;
                switch (res) {
                    case 0 /* Z_OK */:
                        javaThis['java/util/zip/Deflater/setParams'] = 0;
                        thisOff += thisLen - strm.avail_in;
                        javaThis['java/util/zip/Deflater/off'] = thisOff;
                        javaThis['java/util/zip/Deflater/len'] = strm.avail_in;
                        return len - strm.avail_out;
                    case -5 /* Z_BUF_ERROR */:
                        javaThis['java/util/zip/Deflater/setParams'] = 0;
                        return 0;
                    default:
                        thread.throwNewException("Ljava/lang/InternalError;", strm.msg);
                }
            }
            else {
                var finish = javaThis['java/util/zip/Deflater/finish'];
                var res = deflate.deflate(strm, finish ? 4 /* Z_FINISH */ : flush);
                switch (res) {
                    case 1 /* Z_STREAM_END */:
                        javaThis['java/util/zip/Deflater/finished'] = 1;
                    // intentionally fall through
                    case 0 /* Z_OK */:
                        thisOff += thisLen - strm.avail_in;
                        javaThis['java/util/zip/Deflater/off'] = thisOff;
                        javaThis['java/util/zip/Deflater/len'] = strm.avail_in;
                        return len - strm.avail_out;
                    case -5 /* Z_BUF_ERROR */:
                        return 0;
                    default:
                        thread.throwNewException('Ljava/lang/InternalError;', strm.msg);
                }
            }
        };
        java_util_zip_Deflater['getAdler(J)I'] = function (thread, addr) {
            var strm = GetZStream(thread, addr.toNumber());
            if (strm) {
                return strm.adler;
            }
        };
        java_util_zip_Deflater['reset(J)V'] = function (thread, addr) {
            var strm = GetZStream(thread, addr.toNumber());
            if (strm) {
                if (deflate.deflateReset(strm) !== 0 /* Z_OK */) {
                    thread.throwNewException('Ljava/lang/InternalError;', strm.msg);
                }
            }
        };
        java_util_zip_Deflater['end(J)V'] = function (thread, addr) {
            var strm = GetZStream(thread, addr.toNumber());
            if (strm) {
                if (deflate.deflateEnd(strm) === -2 /* Z_STREAM_ERROR */) {
                    thread.throwNewException('Ljava/lang/InternalError;', strm.msg);
                }
                else {
                    CloseZStream(addr.toNumber());
                }
            }
        };
        return java_util_zip_Deflater;
    }());
    var java_util_zip_Inflater = (function () {
        function java_util_zip_Inflater() {
        }
        java_util_zip_Inflater['initIDs()V'] = function (thread) {
            // NOP.
        };
        java_util_zip_Inflater['init(Z)J'] = function (thread, nowrap) {
            // Copying logic exactly from Java's native.
            var strm = new ZStreamCons();
            var ret = inflate.inflateInit2(strm, nowrap ? -MAX_WBITS : MAX_WBITS);
            switch (ret) {
                case 0 /* Z_OK */:
                    var num = OpenZStream(strm);
                    return Long.fromNumber(num);
                default:
                    var msg = (strm.msg) ? strm.msg :
                        (ret == -2 /* Z_STREAM_ERROR */) ?
                            "inflateInit2 returned Z_STREAM_ERROR" :
                            "unknown error initializing zlib library";
                    thread.throwNewException("Ljava/lang/InternalError;", msg);
                    break;
            }
        };
        /**
         * Note: This function is explicitly not supported by pako, the library we use
         * for inflation.
         * @see Notes at http://nodeca.github.io/pako/
         */
        java_util_zip_Inflater['setDictionary(J[BII)V'] = function (thread, arg0, arg1, arg2, arg3) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        /**
         * NOTE: inflateBytes modifies the following properties on the Inflate object:
         *
         * - off
         * - len
         * - needDict
         * - finished
         */
        java_util_zip_Inflater['inflateBytes(J[BII)I'] = function (thread, javaThis, addr, b, off, len) {
            var strm = GetZStream(thread, addr.toNumber());
            if (!strm) {
                return;
            }
            var thisBuf = javaThis['java/util/zip/Inflater/buf'];
            var thisOff = javaThis['java/util/zip/Inflater/off'];
            var thisLen = javaThis['java/util/zip/Inflater/len'];
            // Return 0 when the buffer is empty, which tells Java to refill its buffer.
            if (thisLen === 0 || len === 0) {
                return 0;
            }
            var inBuf = thisBuf.array;
            var outBuf = b.array;
            // Set up the zstream.
            strm.input = i82u8(inBuf, 0, inBuf.length);
            strm.next_in = thisOff;
            strm.avail_in = thisLen;
            strm.output = i82u8(outBuf, 0, outBuf.length);
            strm.next_out = off;
            strm.avail_out = len;
            // NOTE: JVM code does a partial flush, but Pako doesn't support it.
            // Thus, we do a sync flush instead.
            var ret = inflate.inflate(strm, 2 /* Z_SYNC_FLUSH */);
            var lenRead = len - strm.avail_out;
            if (!isInt8Array(outBuf)) {
                // Slow path: No typed arrays. Copy decompressed data.
                // u8 -> i8
                var result = strm.output;
                for (var i = 0; i < lenRead; i++) {
                    var byte = result[i + off];
                    if (byte > 127) {
                        // Sign extend.
                        byte |= 0xFFFFFF80;
                    }
                    outBuf[i + off] = byte;
                }
            }
            switch (ret) {
                case 1 /* Z_STREAM_END */:
                    javaThis['java/util/zip/Inflater/finished'] = 1;
                /* fall through */
                case 0 /* Z_OK */:
                    thisOff += thisLen - strm.avail_in;
                    javaThis['java/util/zip/Inflater/off'] = thisOff;
                    javaThis['java/util/zip/Inflater/len'] = strm.avail_in;
                    return lenRead;
                case 2 /* Z_NEED_DICT */:
                    javaThis['java/util/zip/Inflater/needDict'] = 1;
                    /* Might have consumed some input here! */
                    thisOff += thisLen - strm.avail_in;
                    javaThis['java/util/zip/Inflater/off'] = thisOff;
                    javaThis['java/util/zip/Inflater/len'] = strm.avail_in;
                    return 0;
                case -5 /* Z_BUF_ERROR */:
                    return 0;
                case -3 /* Z_DATA_ERROR */:
                    thread.throwNewException('Ljava/util/zip/DataFormatException;', strm.msg);
                    return;
                default:
                    thread.throwNewException('Ljava/lang/InternalError;', strm.msg);
                    return;
            }
        };
        java_util_zip_Inflater['getAdler(J)I'] = function (thread, addr) {
            var strm = GetZStream(thread, addr.toNumber());
            if (strm) {
                return strm.adler;
            }
        };
        java_util_zip_Inflater['reset(J)V'] = function (thread, addr) {
            var addrNum = addr.toNumber();
            var strm = GetZStream(thread, addrNum);
            if (strm) {
                /* There's a bug in Pako that prevents reset from working.
                if (inflate.inflateReset(strm) !== ZlibReturnCode.Z_OK) {
                  thread.throwNewException('Ljava/lang/InternalError;', '');
                }
                */
                // Allocate a new stream, instead.
                var newStrm = new ZStreamCons();
                var ret = inflate.inflateInit2(newStrm, strm.state.wrap ? MAX_WBITS : -MAX_WBITS);
                ZStreams[addrNum] = newStrm;
            }
        };
        java_util_zip_Inflater['end(J)V'] = function (thread, addr) {
            var strm = GetZStream(thread, addr.toNumber());
            if (strm) {
                if (inflate.inflateEnd(strm) === -2 /* Z_STREAM_ERROR */) {
                    thread.throwNewException('Ljava/lang/InternalError;', strm.msg);
                }
                else {
                    CloseZStream(addr.toNumber());
                }
            }
        };
        return java_util_zip_Inflater;
    }());
    var java_util_zip_ZipFile = (function () {
        function java_util_zip_ZipFile() {
        }
        java_util_zip_ZipFile['initIDs()V'] = function (thread) {
            // NOP.
        };
        /**
         * Note: Returns 0 when entry does not exist.
         */
        java_util_zip_ZipFile['getEntry(J[BZ)J'] = function (thread, jzfile, nameBytes, addSlash) {
            // ASSUMPTION: Name is UTF-8.
            // Should actually compare the raw bytes.
            var zipfs = GetZipFile(thread, jzfile.toNumber());
            if (zipfs) {
                var name_1 = new Buffer(nameBytes.array).toString('utf8');
                if (name_1[0] !== '/') {
                    name_1 = "/" + name_1;
                }
                name_1 = path.resolve(name_1);
                try {
                    return Long.fromNumber(OpenZipEntry(zipfs.getCentralDirectoryEntry(name_1)));
                }
                catch (e) {
                    return Long.ZERO;
                }
            }
        };
        java_util_zip_ZipFile['freeEntry(JJ)V'] = function (thread, jzfile, jzentry) {
            CloseZipEntry(jzentry.toNumber());
        };
        java_util_zip_ZipFile['getNextEntry(JI)J'] = function (thread, jzfile, index) {
            var zipfs = GetZipFile(thread, jzfile.toNumber());
            if (zipfs) {
                try {
                    return Long.fromNumber(OpenZipEntry(zipfs.getCentralDirectoryEntryAt(index)));
                }
                catch (e) {
                    return Long.ZERO;
                }
            }
        };
        java_util_zip_ZipFile['close(J)V'] = function (thread, jzfile) {
            CloseZipFile(jzfile.toNumber());
        };
        java_util_zip_ZipFile['open(Ljava/lang/String;IJZ)J'] = function (thread, nameObj, mode, modified, usemmap) {
            // Ignore mmap option.
            var name = nameObj.toString();
            // Optimization: Check if this is a JAR file on the classpath.
            var cpath = thread.getBsCl().getClassPathItems();
            for (var i = 0; i < cpath.length; i++) {
                var cpathItem = cpath[i];
                if (cpathItem instanceof AbstractClasspathJar) {
                    if (path.resolve(cpathItem.getPath()) === path.resolve(name)) {
                        return Long.fromNumber(OpenZipFile(cpathItem.getFS()));
                    }
                }
            }
            // Async path.
            thread.setStatus(ThreadStatus.ASYNC_WAITING);
            fs.readFile(name, function (err, data) {
                if (err) {
                    thread.throwNewException("Ljava/io/IOException;", err.message);
                }
                else {
                    thread.asyncReturn(Long.fromNumber(OpenZipFile(new BrowserFS.FileSystem.ZipFS(data, name))), null);
                }
            });
        };
        java_util_zip_ZipFile['getTotal(J)I'] = function (thread, jzfile) {
            var zipfs = GetZipFile(thread, jzfile.toNumber());
            if (zipfs) {
                return zipfs.getNumberOfCentralDirectoryEntries();
            }
        };
        java_util_zip_ZipFile['startsWithLOC(J)Z'] = function (thread, arg0) {
            // We do not support any zip files that do not begin with the proper signature.
            // Boolean, so 1 === true.
            return 1;
        };
        java_util_zip_ZipFile['read(JJJ[BII)I'] = function (thread, jzfile, jzentry, pos, b, off, len) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            var posNum = pos.toNumber();
            if (zipentry) {
                if (len <= 0) {
                    return 0;
                }
                var data = zipentry.getRawData();
                // Sanity check: Will likely never happen, as Java code ensures that this method is
                // called in a sane manner.
                if (posNum >= data.length) {
                    thread.throwNewException("Ljava/io/IOException;", "End of zip file.");
                    return;
                }
                if (posNum + len > data.length) {
                    len = data.length - posNum;
                }
                var arr = b.array;
                if (CanUseCopyFastPath) {
                    var i8arr = arr;
                    // XXX: DefinitelyTyped typings are out of date.
                    var b_1 = new Buffer(i8arr.buffer);
                    return data.copy(b_1, off + i8arr.byteOffset, posNum, posNum + len);
                }
                else {
                    for (var i = 0; i < len; i++) {
                        arr[off + i] = data.readInt8(posNum + i);
                    }
                    return len;
                }
            }
        };
        java_util_zip_ZipFile['getEntryTime(J)J'] = function (thread, jzentry) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            if (zipentry) {
                return Long.fromNumber(zipentry.rawLastModFileTime());
            }
        };
        java_util_zip_ZipFile['getEntryCrc(J)J'] = function (thread, jzentry) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            if (zipentry) {
                return Long.fromNumber(zipentry.crc32());
            }
        };
        java_util_zip_ZipFile['getEntryCSize(J)J'] = function (thread, jzentry) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            if (zipentry) {
                return Long.fromNumber(zipentry.compressedSize());
            }
        };
        java_util_zip_ZipFile['getEntrySize(J)J'] = function (thread, jzentry) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            if (zipentry) {
                return Long.fromNumber(zipentry.uncompressedSize());
            }
        };
        java_util_zip_ZipFile['getEntryMethod(J)I'] = function (thread, jzentry) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            if (zipentry) {
                return zipentry.compressionMethod();
            }
        };
        java_util_zip_ZipFile['getEntryFlag(J)I'] = function (thread, jzentry) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            if (zipentry) {
                return zipentry.flag();
            }
        };
        java_util_zip_ZipFile['getCommentBytes(J)[B'] = function (thread, jzfile) {
            var zipfile = GetZipFile(thread, jzfile.toNumber());
            if (zipfile) {
                var eocd = zipfile.getEndOfCentralDirectory();
                var comment = eocd.rawCdZipComment();
                // Should be zero-copy in most situations.
                return util.newArrayFromDataWithClass(thread, thread.getBsCl().getInitializedClass(thread, '[B'), u82i8(comment, 0, comment.length));
            }
        };
        java_util_zip_ZipFile['getEntryBytes(JI)[B'] = function (thread, jzentry, type) {
            var zipentry = GetZipEntry(thread, jzentry.toNumber());
            if (zipentry) {
                switch (type) {
                    case 2 /* JZENTRY_COMMENT */:
                        return util.newArrayFromDataWithClass(thread, thread.getBsCl().getInitializedClass(thread, '[B'), u82i8(zipentry.rawFileComment()));
                    case 1 /* JZENTRY_EXTRA */:
                        return util.newArrayFromDataWithClass(thread, thread.getBsCl().getInitializedClass(thread, '[B'), u82i8(zipentry.extraField()));
                    case 0 /* JZENTRY_NAME */:
                        return util.newArrayFromDataWithClass(thread, thread.getBsCl().getInitializedClass(thread, '[B'), u82i8(zipentry.rawFileName()));
                    default:
                        return null;
                }
            }
        };
        /**
         * Called to get an exception message. Should never really need to be called.
         */
        java_util_zip_ZipFile['getZipMessage(J)Ljava/lang/String;'] = function (thread, jzfile) {
            return util.initString(thread.getBsCl(), "Something bad happened.");
        };
        return java_util_zip_ZipFile;
    }());
    return {
        'java/util/concurrent/atomic/AtomicLong': java_util_concurrent_atomic_AtomicLong,
        'java/util/jar/JarFile': java_util_jar_JarFile,
        'java/util/logging/FileHandler': java_util_logging_FileHandler,
        'java/util/TimeZone': java_util_TimeZone,
        'java/util/zip/Adler32': java_util_zip_Adler32,
        'java/util/zip/CRC32': java_util_zip_CRC32,
        'java/util/zip/Deflater': java_util_zip_Deflater,
        'java/util/zip/Inflater': java_util_zip_Inflater,
        'java/util/zip/ZipFile': java_util_zip_ZipFile
    };
}
exports.__esModule = true;
exports["default"] = default_1;
;
//# sourceMappingURL=data:application/json;base64,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