"use strict";
var Doppio = require('../doppiojvm');
var ReferenceClassData = Doppio.VM.ClassFile.ReferenceClassData;
var ArrayClassData = Doppio.VM.ClassFile.ArrayClassData;
var util = Doppio.VM.Util;
var Long = Doppio.VM.Long;
var ThreadStatus = Doppio.VM.Enums.ThreadStatus;
var assert = Doppio.Debug.Assert;
function default_1() {
    function getFieldInfo(thread, unsafe, obj, offset) {
        var fieldName, objBase, objCls = obj.getClass(), cls, compName, unsafeCons = unsafe.getClass().getConstructor(thread), stride = 1;
        if (objCls.getInternalName() === "Ljava/lang/Object;") {
            // Static field. The staticFieldBase is always a pure Object that has a
            // class reference on it.
            // There's no reason to get the field on an Object, as they have no fields.
            cls = obj.$staticFieldBase;
            objBase = cls.getConstructor(thread);
            fieldName = cls.getStaticFieldFromVMIndex(offset.toInt()).fullName;
        }
        else if (objCls instanceof ArrayClassData) {
            compName = util.internal2external[objCls.getInternalName()[1]];
            if (!compName) {
                compName = "OBJECT";
            }
            compName = compName.toUpperCase();
            stride = unsafeCons[("sun/misc/Unsafe/ARRAY_" + compName + "_INDEX_SCALE")];
            if (!stride) {
                stride = 1;
            }
            objBase = obj.array;
            assert(offset.toInt() % stride === 0, "Invalid offset for stride " + stride + ": " + offset.toInt());
            fieldName = "" + (offset.toInt() / stride);
        }
        else {
            cls = obj.getClass();
            objBase = obj;
            fieldName = cls.getObjectFieldFromVMIndex(offset.toInt()).fullName;
        }
        return [objBase, fieldName];
    }
    function unsafeCompareAndSwap(thread, unsafe, obj, offset, expected, x) {
        var fi = getFieldInfo(thread, unsafe, obj, offset), actual = fi[0][fi[1]];
        if (actual === expected) {
            fi[0][fi[1]] = x;
            return true;
        }
        else {
            return false;
        }
    }
    function getFromVMIndex(thread, unsafe, obj, offset) {
        var fi = getFieldInfo(thread, unsafe, obj, offset);
        return fi[0][fi[1]];
    }
    function setFromVMIndex(thread, unsafe, obj, offset, val) {
        var fi = getFieldInfo(thread, unsafe, obj, offset);
        fi[0][fi[1]] = val;
    }
    var sun_misc_GC = (function () {
        function sun_misc_GC() {
        }
        sun_misc_GC['maxObjectInspectionAge()J'] = function (thread) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        return sun_misc_GC;
    }());
    var sun_misc_MessageUtils = (function () {
        function sun_misc_MessageUtils() {
        }
        sun_misc_MessageUtils['toStderr(Ljava/lang/String;)V'] = function (thread, str) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_MessageUtils['toStdout(Ljava/lang/String;)V'] = function (thread, str) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        return sun_misc_MessageUtils;
    }());
    var sun_misc_NativeSignalHandler = (function () {
        function sun_misc_NativeSignalHandler() {
        }
        sun_misc_NativeSignalHandler['handle0(IJ)V'] = function (thread, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        return sun_misc_NativeSignalHandler;
    }());
    var sun_misc_Perf = (function () {
        function sun_misc_Perf() {
        }
        sun_misc_Perf['attach(Ljava/lang/String;II)Ljava/nio/ByteBuffer;'] = function (thread, javaThis, arg0, arg1, arg2) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Perf['detach(Ljava/nio/ByteBuffer;)V'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Perf['createLong(Ljava/lang/String;IIJ)Ljava/nio/ByteBuffer;'] = function (thread, javaThis, name, variability, units, value) {
            thread.import('Ljava/nio/DirectByteBuffer;', function (buffCons) {
                var buff = new buffCons(thread), heap = thread.getJVM().getHeap(), addr = heap.malloc(8);
                buff['<init>(JI)V'](thread, [Long.fromNumber(addr), null, 8], function (e) {
                    if (e) {
                        thread.throwException(e);
                    }
                    else {
                        heap.store_word(addr, value.getLowBits());
                        heap.store_word(addr + 4, value.getHighBits());
                        thread.asyncReturn(buff);
                    }
                });
            });
        };
        sun_misc_Perf['createByteArray(Ljava/lang/String;II[BI)Ljava/nio/ByteBuffer;'] = function (thread, javaThis, arg0, arg1, arg2, arg3, arg4) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Perf['highResCounter()J'] = function (thread, javaThis) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Perf['highResFrequency()J'] = function (thread, javaThis) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Perf['registerNatives()V'] = function (thread) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        return sun_misc_Perf;
    }());
    var sun_misc_Signal = (function () {
        function sun_misc_Signal() {
        }
        sun_misc_Signal['findSignal(Ljava/lang/String;)I'] = function (thread, arg0) {
            // Signifies that we don't know the signal.
            return -1;
        };
        sun_misc_Signal['handle0(IJ)J'] = function (thread, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Signal['raise0(I)V'] = function (thread, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        return sun_misc_Signal;
    }());
    var sun_misc_Unsafe = (function () {
        function sun_misc_Unsafe() {
        }
        sun_misc_Unsafe['getByte(J)B'] = function (thread, javaThis, address) {
            var heap = thread.getJVM().getHeap();
            return heap.get_signed_byte(address.toNumber());
        };
        sun_misc_Unsafe['putByte(JB)V'] = function (thread, javaThis, address, val) {
            var heap = thread.getJVM().getHeap();
            heap.set_signed_byte(address.toNumber(), val);
        };
        sun_misc_Unsafe['getShort(J)S'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_misc_Unsafe['putShort(JS)V'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['getChar(J)C'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_misc_Unsafe['putChar(JC)V'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['getInt(J)I'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_misc_Unsafe['putInt(JI)V'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['getLong(J)J'] = function (thread, javaThis, address) {
            var heap = thread.getJVM().getHeap(), addr = address.toNumber();
            return new Long(heap.get_word(addr), heap.get_word(addr + 4));
        };
        sun_misc_Unsafe['putLong(JJ)V'] = function (thread, javaThis, address, value) {
            var heap = thread.getJVM().getHeap(), addr = address.toNumber();
            // LE
            heap.store_word(addr, value.getLowBits());
            heap.store_word(addr + 4, value.getHighBits());
        };
        sun_misc_Unsafe['getFloat(J)F'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_misc_Unsafe['putFloat(JF)V'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['getDouble(J)D'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_misc_Unsafe['putDouble(JD)V'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['getAddress(J)J'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Unsafe['putAddress(JJ)V'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['allocateMemory(J)J'] = function (thread, javaThis, size) {
            var heap = thread.getJVM().getHeap();
            return Long.fromNumber(heap.malloc(size.toNumber()));
        };
        sun_misc_Unsafe['reallocateMemory(JJ)J'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Unsafe['setMemory(Ljava/lang/Object;JJB)V'] = function (thread, javaThis, obj, address, bytes, value) {
            if (obj === null) {
                // Address is absolute.
                var i, addr = address.toNumber(), bytesNum = bytes.toNumber(), heap = thread.getJVM().getHeap();
                for (i = 0; i < bytesNum; i++) {
                    heap.set_signed_byte(addr + i, value);
                }
            }
            else {
                // I have no idea what the semantics are when the object is specified.
                // I think it means use the object as the starting address... which doesn't
                // make sense for us.
                thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            }
        };
        /**
         * Sets all bytes in a given block of memory to a copy of another
         * block.
         *
         * <p>This method determines each block's base address by means of two parameters,
         * and so it provides (in effect) a <em>double-register</em> addressing mode,
         * as discussed in {@link #getInt(Object,long)}.  When the object reference is null,
         * the offset supplies an absolute base address.
         *
         * <p>The transfers are in coherent (atomic) units of a size determined
         * by the address and length parameters.  If the effective addresses and
         * length are all even modulo 8, the transfer takes place in 'long' units.
         * If the effective addresses and length are (resp.) even modulo 4 or 2,
         * the transfer takes place in units of 'int' or 'short'.
         *
         * @since 1.7
         */
        sun_misc_Unsafe['copyMemory(Ljava/lang/Object;JLjava/lang/Object;JJ)V'] = function (thread, javaThis, srcBase, srcOffset, destBase, destOffset, bytes) {
            var heap = thread.getJVM().getHeap(), srcAddr = srcOffset.toNumber(), destAddr = destOffset.toNumber(), length = bytes.toNumber();
            if (srcBase === null && destBase === null) {
                // memcopy semantics w/ srcoffset/destoffset as absolute offsets.
                heap.memcpy(srcAddr, destAddr, length);
            }
            else if (srcBase === null && destBase !== null) {
                // OK, so... destBase is an array, destOffset is a byte offset from the
                // start of the array. Need to copy data from the heap directly into the array.
                if (util.is_array_type(destBase.getClass().getInternalName()) && util.is_primitive_type(destBase.getClass().getComponentClass().getInternalName())) {
                    var destArray = destBase;
                    switch (destArray.getClass().getComponentClass().getInternalName()) {
                        case 'B':
                            for (var i = 0; i < length; i++) {
                                destArray.array[destAddr + i] = heap.get_signed_byte(srcAddr + i);
                            }
                            break;
                        /*case 'C':
                          break;
                        case 'D':
                          break;
                        case 'F':
                          break;
                        case 'I':
                          break;
                        case 'J':
                          break;
                        case 'S':
                          break;
                        case 'Z':
                          break;*/
                        default:
                            // I have no idea what the appropriate semantics are for this.
                            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented. destArray type: ' + destArray.getClass().getComponentClass().getInternalName());
                            break;
                    }
                }
                else {
                    // I have no idea what the appropriate semantics are for this.
                    thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
                }
            }
            else if (srcBase !== null && destBase === null) {
                // srcBase is an array, destOffset is an address where the contents of srcBase should be copied.
                if (util.is_array_type(srcBase.getClass().getInternalName()) && util.is_primitive_type(srcBase.getClass().getComponentClass().getInternalName())) {
                    var srcArray = srcBase;
                    switch (srcArray.getClass().getComponentClass().getInternalName()) {
                        case 'B':
                        case 'C':
                            for (var i = 0; i < length; i++) {
                                heap.set_signed_byte(destAddr + i, srcArray.array[srcAddr + i]);
                            }
                            break;
                        default:
                            // I have no idea what the appropriate semantics are for this.
                            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented. srcArray:' + srcArray.getClass().getComponentClass().getInternalName());
                            break;
                    }
                }
                else {
                    // I have no idea what the appropriate semantics are for this.
                    thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
                }
            }
            else {
                // I have no idea what the appropriate semantics are for this.
                thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented. Both src and dest are arrays?');
            }
        };
        sun_misc_Unsafe['freeMemory(J)V'] = function (thread, javaThis, address) {
            var heap = thread.getJVM().getHeap();
            heap.free(address.toNumber());
        };
        sun_misc_Unsafe['staticFieldOffset(Ljava/lang/reflect/Field;)J'] = function (thread, javaThis, field) {
            var cls = field['java/lang/reflect/Field/clazz'].$cls;
            return Long.fromNumber(cls.getVMIndexForField(cls.getFieldFromSlot(field['java/lang/reflect/Field/slot'])));
        };
        sun_misc_Unsafe['objectFieldOffset(Ljava/lang/reflect/Field;)J'] = function (thread, javaThis, field) {
            var cls = field['java/lang/reflect/Field/clazz'].$cls;
            return Long.fromNumber(cls.getVMIndexForField(cls.getFieldFromSlot(field['java/lang/reflect/Field/slot'])));
        };
        sun_misc_Unsafe['staticFieldBase(Ljava/lang/reflect/Field;)Ljava/lang/Object;'] = function (thread, javaThis, field) {
            // Return a special JVM object.
            // TODO: Actually create a special DoppioJVM class for this.
            var rv = new (thread.getBsCl().getInitializedClass(thread, 'Ljava/lang/Object;').getConstructor(thread))(thread);
            rv.$staticFieldBase = field['java/lang/reflect/Field/clazz'].$cls;
            return rv;
        };
        sun_misc_Unsafe['ensureClassInitialized(Ljava/lang/Class;)V'] = function (thread, javaThis, cls) {
            if (cls.$cls.isInitialized(thread)) {
                return;
            }
            thread.setStatus(ThreadStatus.ASYNC_WAITING);
            cls.$cls.initialize(thread, function (cdata) {
                if (cdata != null) {
                    thread.asyncReturn();
                }
            }, true);
        };
        sun_misc_Unsafe['arrayBaseOffset(Ljava/lang/Class;)I'] = function (thread, javaThis, arg0) {
            return 0;
        };
        /**
         * Determines the size of elements in an array.
         * e.g. if the array index scale of something is *4*, then each element is 4*minimal addressable unit large.
         * Doppio emulates byte-addressable memory, so a return value of 4 indicates 4 bytes/32-bit large elements.
         */
        sun_misc_Unsafe['arrayIndexScale(Ljava/lang/Class;)I'] = function (thread, javaThis, arg0) {
            var cls = arg0.$cls;
            if (cls instanceof ArrayClassData) {
                switch (cls.getComponentClass().getInternalName()[0]) {
                    case 'L':
                    case '[':
                    case 'F':
                    case 'I':
                        // 32-bits
                        return 4;
                    case 'B':
                    case 'Z':
                        // 8 bit
                        return 1;
                    case 'C':
                    case 'S':
                        // 16-bit
                        return 2;
                    case 'D':
                    case 'J':
                        // 64-bit
                        return 8;
                    default:
                        // Erroneous input.
                        return -1;
                }
            }
            else {
                // Erroneous input.
                return -1;
            }
        };
        sun_misc_Unsafe['addressSize()I'] = function (thread, javaThis) {
            return 4;
        };
        sun_misc_Unsafe['pageSize()I'] = function (thread, javaThis) {
            // Matches the heap.
            return 4096;
        };
        sun_misc_Unsafe['defineClass(Ljava/lang/String;[BIILjava/lang/ClassLoader;Ljava/security/ProtectionDomain;)Ljava/lang/Class;'] = function (thread, javaThis, name, bytes, offset, len, loaderObj, pd) {
            var loader = util.getLoader(thread, loaderObj), cdata = loader.defineClass(thread, util.int_classname(name.toString()), util.byteArray2Buffer(bytes.array, offset, len), pd);
            if (cdata !== null) {
                thread.setStatus(ThreadStatus.ASYNC_WAITING);
                // Resolve the class, since we're handing it back to the application
                // and we expect these things to be resolved.
                cdata.resolve(thread, function (cdata) {
                    if (cdata !== null) {
                        thread.asyncReturn(cdata.getClassObject(thread));
                    }
                });
            }
        };
        sun_misc_Unsafe['allocateInstance(Ljava/lang/Class;)Ljava/lang/Object;'] = function (thread, javaThis, jco) {
            // This can trigger class initialization, so check if the class is
            // initialized.
            var cls = jco.$cls;
            if (cls.isInitialized(thread)) {
                return new (cls.getConstructor(thread))(thread);
            }
            else {
                thread.setStatus(ThreadStatus.ASYNC_WAITING);
                cls.initialize(thread, function () {
                    thread.asyncReturn(new (cls.getConstructor(thread))(thread));
                });
            }
        };
        sun_misc_Unsafe['monitorEnter(Ljava/lang/Object;)V'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['monitorExit(Ljava/lang/Object;)V'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        sun_misc_Unsafe['tryMonitorEnter(Ljava/lang/Object;)Z'] = function (thread, javaThis, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_misc_Unsafe['throwException(Ljava/lang/Throwable;)V'] = function (thread, javaThis, exception) {
            thread.throwException(exception);
        };
        /**
         * Unblock the given thread blocked on park, or, if it is not blocked, cause
         * the subsequent call to park not to block.
         */
        sun_misc_Unsafe['unpark(Ljava/lang/Object;)V'] = function (thread, javaThis, theThread) {
            thread.getJVM().getParker().unpark(theThread.$thread);
        };
        /**
         * Block current thread, returning when a balancing unpark occurs, or a
         * balancing unpark has already occurred, or the thread is interrupted, or,
         * if not absolute and time is not zero, the given time nanoseconds have
         * elapsed, or if absolute, the given deadline in milliseconds since Epoch
         * has passed, or spuriously (i.e., returning for no "reason").
         */
        sun_misc_Unsafe['park(ZJ)V'] = function (thread, javaThis, absolute, time) {
            var timeout = Infinity, parker = thread.getJVM().getParker();
            if (absolute) {
                // Time is an absolute time (milliseconds since Epoch).
                // Calculate the timeout from the current time.
                timeout = time.toNumber() - (new Date()).getTime();
                if (timeout < 0) {
                    // Forbid negative timeouts.
                    timeout = 0;
                }
            }
            else {
                // time is in nanoseconds, but we don't have that
                // type of precision
                if (time.toNumber() > 0) {
                    timeout = time.toNumber() / 1000000;
                }
            }
            // Typed as any due to type discrepency between browser and node.
            var timer;
            if (timeout !== Infinity) {
                timer = setTimeout(function () {
                    parker.completelyUnpark(thread);
                }, timeout);
            }
            parker.park(thread, function () {
                clearTimeout(timer);
                thread.asyncReturn();
            });
        };
        sun_misc_Unsafe['getLoadAverage([DI)I'] = function (thread, javaThis, arg0, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        /**
         * Detect if the given class may need to be initialized. This is often
         * needed in conjunction with obtaining the static field base of a
         * class.
         * @return false only if a call to {@code ensureClassInitialized} would have no effect
         */
        sun_misc_Unsafe['shouldBeInitialized(Ljava/lang/Class;)Z'] = function (thread, javaThis, cls) {
            return !cls.$cls.isInitialized(thread) ? 1 : 0;
        };
        /**
         * Define a class but do not make it known to the class loader or system dictionary.
         *
         * For each CP entry, the corresponding CP patch must either be null or have
         * the format that matches its tag:
         *
         * * Integer, Long, Float, Double: the corresponding wrapper object type from java.lang
         * * Utf8: a string (must have suitable syntax if used as signature or name)
         * * Class: any java.lang.Class object
         * * String: any object (not just a java.lang.String)
         * * InterfaceMethodRef: (NYI) a method handle to invoke on that call site's arguments
         *
         * @params hostClass context for linkage, access control, protection domain, and class loader
         * @params data      bytes of a class file
         * @params cpPatches where non-null entries exist, they replace corresponding CP entries in data
         */
        sun_misc_Unsafe['defineAnonymousClass(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;'] = function (thread, javaThis, hostClass, data, cpPatches) {
            return new ReferenceClassData(new Buffer(data.array), null, hostClass.$cls.getLoader(), cpPatches).getClassObject(thread);
        };
        /**
         * Ensures lack of reordering of loads before the fence
         * with loads or stores after the fence.
         * @since 1.8
         */
        sun_misc_Unsafe['loadFence()V'] = function (thread, javaThis) {
            // NOP
        };
        /**
         * Ensures lack of reordering of stores before the fence
         * with loads or stores after the fence.
         * @since 1.8
         */
        sun_misc_Unsafe['storeFence()V'] = function (thread, javaThis) {
            // NOP
        };
        /**
         * Ensures lack of reordering of loads or stores before the fence
         * with loads or stores after the fence.
         * @since 1.8
         */
        sun_misc_Unsafe['fullFence()V'] = function (thread, javaThis) {
            // NOP
        };
        sun_misc_Unsafe['getInt(Ljava/lang/Object;J)I'] = getFromVMIndex;
        sun_misc_Unsafe['putInt(Ljava/lang/Object;JI)V'] = setFromVMIndex;
        sun_misc_Unsafe['getObject(Ljava/lang/Object;J)Ljava/lang/Object;'] = getFromVMIndex;
        sun_misc_Unsafe['putObject(Ljava/lang/Object;JLjava/lang/Object;)V'] = setFromVMIndex;
        sun_misc_Unsafe['getBoolean(Ljava/lang/Object;J)Z'] = getFromVMIndex;
        sun_misc_Unsafe['putBoolean(Ljava/lang/Object;JZ)V'] = setFromVMIndex;
        sun_misc_Unsafe['getByte(Ljava/lang/Object;J)B'] = getFromVMIndex;
        sun_misc_Unsafe['putByte(Ljava/lang/Object;JB)V'] = setFromVMIndex;
        sun_misc_Unsafe['getShort(Ljava/lang/Object;J)S'] = getFromVMIndex;
        sun_misc_Unsafe['putShort(Ljava/lang/Object;JS)V'] = setFromVMIndex;
        sun_misc_Unsafe['getChar(Ljava/lang/Object;J)C'] = getFromVMIndex;
        sun_misc_Unsafe['putChar(Ljava/lang/Object;JC)V'] = setFromVMIndex;
        sun_misc_Unsafe['getLong(Ljava/lang/Object;J)J'] = getFromVMIndex;
        sun_misc_Unsafe['putLong(Ljava/lang/Object;JJ)V'] = setFromVMIndex;
        sun_misc_Unsafe['getFloat(Ljava/lang/Object;J)F'] = getFromVMIndex;
        sun_misc_Unsafe['putFloat(Ljava/lang/Object;JF)V'] = setFromVMIndex;
        sun_misc_Unsafe['getDouble(Ljava/lang/Object;J)D'] = getFromVMIndex;
        sun_misc_Unsafe['putDouble(Ljava/lang/Object;JD)V'] = setFromVMIndex;
        sun_misc_Unsafe['compareAndSwapObject(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z'] = unsafeCompareAndSwap;
        sun_misc_Unsafe['compareAndSwapInt(Ljava/lang/Object;JII)Z'] = unsafeCompareAndSwap;
        sun_misc_Unsafe['compareAndSwapLong(Ljava/lang/Object;JJJ)Z'] = unsafeCompareAndSwap;
        sun_misc_Unsafe['getObjectVolatile(Ljava/lang/Object;J)Ljava/lang/Object;'] = getFromVMIndex;
        sun_misc_Unsafe['putObjectVolatile(Ljava/lang/Object;JLjava/lang/Object;)V'] = setFromVMIndex;
        sun_misc_Unsafe['getIntVolatile(Ljava/lang/Object;J)I'] = getFromVMIndex;
        sun_misc_Unsafe['putIntVolatile(Ljava/lang/Object;JI)V'] = setFromVMIndex;
        sun_misc_Unsafe['getBooleanVolatile(Ljava/lang/Object;J)Z'] = getFromVMIndex;
        sun_misc_Unsafe['putBooleanVolatile(Ljava/lang/Object;JZ)V'] = setFromVMIndex;
        sun_misc_Unsafe['getByteVolatile(Ljava/lang/Object;J)B'] = getFromVMIndex;
        sun_misc_Unsafe['putByteVolatile(Ljava/lang/Object;JB)V'] = setFromVMIndex;
        sun_misc_Unsafe['getShortVolatile(Ljava/lang/Object;J)S'] = getFromVMIndex;
        sun_misc_Unsafe['putShortVolatile(Ljava/lang/Object;JS)V'] = setFromVMIndex;
        sun_misc_Unsafe['getCharVolatile(Ljava/lang/Object;J)C'] = getFromVMIndex;
        sun_misc_Unsafe['putCharVolatile(Ljava/lang/Object;JC)V'] = setFromVMIndex;
        sun_misc_Unsafe['getLongVolatile(Ljava/lang/Object;J)J'] = getFromVMIndex;
        sun_misc_Unsafe['putLongVolatile(Ljava/lang/Object;JJ)V'] = setFromVMIndex;
        sun_misc_Unsafe['getFloatVolatile(Ljava/lang/Object;J)F'] = getFromVMIndex;
        sun_misc_Unsafe['putFloatVolatile(Ljava/lang/Object;JF)V'] = setFromVMIndex;
        sun_misc_Unsafe['getDoubleVolatile(Ljava/lang/Object;J)D'] = getFromVMIndex;
        sun_misc_Unsafe['putDoubleVolatile(Ljava/lang/Object;JD)V'] = setFromVMIndex;
        sun_misc_Unsafe['putOrderedObject(Ljava/lang/Object;JLjava/lang/Object;)V'] = setFromVMIndex;
        sun_misc_Unsafe['putOrderedInt(Ljava/lang/Object;JI)V'] = setFromVMIndex;
        sun_misc_Unsafe['putOrderedLong(Ljava/lang/Object;JJ)V'] = setFromVMIndex;
        return sun_misc_Unsafe;
    }());
    var sun_misc_Version = (function () {
        function sun_misc_Version() {
        }
        sun_misc_Version['getJvmSpecialVersion()Ljava/lang/String;'] = function (thread) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Version['getJdkSpecialVersion()Ljava/lang/String;'] = function (thread) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_misc_Version['getJvmVersionInfo()Z'] = function (thread) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_misc_Version['getJdkVersionInfo()V'] = function (thread) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
        };
        return sun_misc_Version;
    }());
    var sun_misc_VM = (function () {
        function sun_misc_VM() {
        }
        sun_misc_VM['initialize()V'] = function (thread) {
            return;
        };
        /**
         * Returns the first non-null class loader (not counting class loaders
         * of generated reflection implementation classes) up the execution stack,
         * or null if only code from the null class loader is on the stack.
         */
        sun_misc_VM['latestUserDefinedLoader()Ljava/lang/ClassLoader;'] = function (thread) {
            var stackTrace = thread.getStackTrace(), i, bsCl = thread.getBsCl(), loader;
            for (i = stackTrace.length - 1; i >= 0; i--) {
                loader = stackTrace[i].method.cls.getLoader();
                if (loader !== bsCl) {
                    return loader.getLoaderObject();
                }
            }
            return null;
        };
        return sun_misc_VM;
    }());
    var sun_misc_VMSupport = (function () {
        function sun_misc_VMSupport() {
        }
        sun_misc_VMSupport['initAgentProperties(Ljava/util/Properties;)Ljava/util/Properties;'] = function (thread, arg0) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        return sun_misc_VMSupport;
    }());
    /**
     * URLClassPath has optional support for a lookupcache, which we do not support.
     */
    var sun_misc_URLClassPath = (function () {
        function sun_misc_URLClassPath() {
        }
        sun_misc_URLClassPath['getLookupCacheURLs(Ljava/lang/ClassLoader;)[Ljava/net/URL;'] = function (thread, loader) {
            return null;
        };
        sun_misc_URLClassPath['getLookupCacheForClassLoader(Ljava/lang/ClassLoader;Ljava/lang/String;)[I'] = function (thread, loader, name) {
            return null;
        };
        sun_misc_URLClassPath['knownToNotExist0(Ljava/lang/ClassLoader;Ljava/lang/String;)Z'] = function (thread, loader, name) {
            return false;
        };
        return sun_misc_URLClassPath;
    }());
    return {
        'sun/misc/GC': sun_misc_GC,
        'sun/misc/MessageUtils': sun_misc_MessageUtils,
        'sun/misc/NativeSignalHandler': sun_misc_NativeSignalHandler,
        'sun/misc/Perf': sun_misc_Perf,
        'sun/misc/Signal': sun_misc_Signal,
        'sun/misc/Unsafe': sun_misc_Unsafe,
        'sun/misc/Version': sun_misc_Version,
        'sun/misc/VM': sun_misc_VM,
        'sun/misc/VMSupport': sun_misc_VMSupport,
        'sun/misc/URLClassPath': sun_misc_URLClassPath
    };
}
exports.__esModule = true;
exports["default"] = default_1;
;
//# sourceMappingURL=data:application/json;base64,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