"use strict";
var Doppio = require('../doppiojvm');
var util = Doppio.VM.Util;
var ThreadStatus = Doppio.VM.Enums.ThreadStatus;
var assert = Doppio.Debug.Assert;
function default_1() {
    var sun_reflect_ConstantPool = (function () {
        function sun_reflect_ConstantPool() {
        }
        sun_reflect_ConstantPool['getSize0(Ljava/lang/Object;)I'] = function (thread, javaThis, cp) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_reflect_ConstantPool['getClassAt0(Ljava/lang/Object;I)Ljava/lang/Class;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getClassAtIfLoaded0(Ljava/lang/Object;I)Ljava/lang/Class;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getMethodAt0(Ljava/lang/Object;I)Ljava/lang/reflect/Member;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getMethodAtIfLoaded0(Ljava/lang/Object;I)Ljava/lang/reflect/Member;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getFieldAt0(Ljava/lang/Object;I)Ljava/lang/reflect/Field;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getFieldAtIfLoaded0(Ljava/lang/Object;I)Ljava/lang/reflect/Field;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getMemberRefInfoAt0(Ljava/lang/Object;I)[Ljava/lang/String;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getIntAt0(Ljava/lang/Object;I)I'] = function (thread, javaThis, cp, idx) {
            return cp.get(idx).value;
        };
        sun_reflect_ConstantPool['getLongAt0(Ljava/lang/Object;I)J'] = function (thread, javaThis, cp, idx) {
            return cp.get(idx).value;
        };
        sun_reflect_ConstantPool['getFloatAt0(Ljava/lang/Object;I)F'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_reflect_ConstantPool['getDoubleAt0(Ljava/lang/Object;I)D'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return 0;
        };
        sun_reflect_ConstantPool['getStringAt0(Ljava/lang/Object;I)Ljava/lang/String;'] = function (thread, javaThis, cp, arg1) {
            thread.throwNewException('Ljava/lang/UnsatisfiedLinkError;', 'Native method not implemented.');
            // Satisfy TypeScript return type.
            return null;
        };
        sun_reflect_ConstantPool['getUTF8At0(Ljava/lang/Object;I)Ljava/lang/String;'] = function (thread, javaThis, cp, idx) {
            return util.initString(thread.getBsCl(), cp.get(idx).value);
        };
        return sun_reflect_ConstantPool;
    }());
    var sun_reflect_NativeConstructorAccessorImpl = (function () {
        function sun_reflect_NativeConstructorAccessorImpl() {
        }
        sun_reflect_NativeConstructorAccessorImpl['newInstance0(Ljava/lang/reflect/Constructor;[Ljava/lang/Object;)Ljava/lang/Object;'] = function (thread, m, params) {
            var cls = m['java/lang/reflect/Constructor/clazz'], slot = m['java/lang/reflect/Constructor/slot'];
            thread.setStatus(ThreadStatus.ASYNC_WAITING);
            cls.$cls.initialize(thread, function (cls) {
                if (cls !== null) {
                    var method = cls.getMethodFromSlot(slot), obj = new (cls.getConstructor(thread))(thread), cb = function (e) {
                        if (e) {
                            // Wrap in a java.lang.reflect.InvocationTargetException
                            thread.getBsCl().initializeClass(thread, 'Ljava/lang/reflect/InvocationTargetException;', function (cdata) {
                                if (cdata !== null) {
                                    var wrappedE = new (cdata.getConstructor(thread))(thread);
                                    wrappedE['<init>(Ljava/lang/Throwable;)V'](thread, [e], function (e) {
                                        thread.throwException(e ? e : wrappedE);
                                    });
                                }
                            });
                        }
                        else {
                            // rv is not defined, since constructors do not return a value.
                            // Return the object we passed to the constructor.
                            thread.asyncReturn(obj);
                        }
                    };
                    var paramTypes = m['java/lang/reflect/Constructor/parameterTypes'].array.map(function (pType) { return pType.$cls.getInternalName(); });
                    assert(slot >= 0, "Found a constructor without a slot?!");
                    obj[method.signature](thread, params ? util.unboxArguments(thread, paramTypes, params.array) : null, cb);
                }
            }, true);
        };
        return sun_reflect_NativeConstructorAccessorImpl;
    }());
    var sun_reflect_NativeMethodAccessorImpl = (function () {
        function sun_reflect_NativeMethodAccessorImpl() {
        }
        /**
         * Invoke the specified method on the given object with the given parameters.
         * If the method is an interface method, perform a virtual method dispatch.
         */
        sun_reflect_NativeMethodAccessorImpl['invoke0(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;'] = function (thread, mObj, obj, params) {
            var cls = mObj['java/lang/reflect/Method/clazz'].$cls, slot = mObj['java/lang/reflect/Method/slot'], retType = mObj['java/lang/reflect/Method/returnType'], m = cls.getMethodFromSlot(slot), args = [], cb = function (e, rv) {
                if (e) {
                    // Wrap in a java.lang.reflect.InvocationTargetException
                    thread.getBsCl().initializeClass(thread, 'Ljava/lang/reflect/InvocationTargetException;', function (cdata) {
                        if (cdata !== null) {
                            var wrappedE = new (cdata.getConstructor(thread))(thread);
                            wrappedE['<init>(Ljava/lang/Throwable;)V'](thread, [e], function (e) {
                                thread.throwException(e ? e : wrappedE);
                            });
                        }
                    });
                }
                else {
                    if (util.is_primitive_type(m.returnType)) {
                        if (m.returnType === 'V') {
                            // apparently the JVM returns NULL when there's a void return value,
                            // rather than autoboxing a Void object. Go figure!
                            thread.asyncReturn(null);
                        }
                        else {
                            // wrap up primitives in their Object box
                            thread.asyncReturn(retType.$cls.createWrapperObject(thread, rv));
                        }
                    }
                    else {
                        thread.asyncReturn(rv);
                    }
                }
            };
            if (params !== null) {
                args = util.unboxArguments(thread, m.parameterTypes, params.array);
            }
            thread.setStatus(ThreadStatus.ASYNC_WAITING);
            if (m.accessFlags.isStatic()) {
                cls.getConstructor(thread)[m.fullSignature](thread, args, cb);
            }
            else {
                obj[m.signature](thread, args, cb);
            }
        };
        return sun_reflect_NativeMethodAccessorImpl;
    }());
    /**
     * From JDK documentation:
     *   Returns the class of the method realFramesToSkip frames up the stack
     *   (zero-based), ignoring frames associated with
     *   java.lang.reflect.Method.invoke() and its implementation. The first
     *   frame is that associated with this method, so getCallerClass(0) returns
     *   the Class object for sun.reflect.Reflection. Frames associated with
     *   java.lang.reflect.Method.invoke() and its implementation are completely
     *   ignored and do not count toward the number of "real" frames skipped.
     */
    function getCallerClass(thread, framesToSkip) {
        var caller = thread.getStackTrace(), idx = caller.length - 1 - framesToSkip, frame = caller[idx];
        while (frame.method.fullSignature.indexOf('java/lang/reflect/Method/invoke') === 0) {
            if (idx === 0) {
                // No more stack to search!
                // XXX: What does the JDK do here, throw an exception?
                return null;
            }
            frame = caller[--idx];
        }
        return frame.method.cls.getClassObject(thread);
    }
    var sun_reflect_Reflection = (function () {
        function sun_reflect_Reflection() {
        }
        sun_reflect_Reflection['getCallerClass()Ljava/lang/Class;'] = function (thread) {
            // 0th item is Reflection class, 1st item is the class that called us,
            // and 2nd item is the caller of our caller, which is correct.
            return getCallerClass(thread, 2);
        };
        sun_reflect_Reflection['getClassAccessFlags(Ljava/lang/Class;)I'] = function (thread, classObj) {
            return classObj.$cls.accessFlags.getRawByte();
        };
        sun_reflect_Reflection['getCallerClass(I)Ljava/lang/Class;'] = getCallerClass;
        return sun_reflect_Reflection;
    }());
    return {
        'sun/reflect/ConstantPool': sun_reflect_ConstantPool,
        'sun/reflect/NativeConstructorAccessorImpl': sun_reflect_NativeConstructorAccessorImpl,
        'sun/reflect/NativeMethodAccessorImpl': sun_reflect_NativeMethodAccessorImpl,
        'sun/reflect/Reflection': sun_reflect_Reflection
    };
}
exports.__esModule = true;
exports["default"] = default_1;
;
//# sourceMappingURL=data:application/json;base64,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