'use strict';
var path = require('path');
var ClassData_1 = require('../src/ClassData');
var jvm_1 = require('../src/jvm');
var classpath_1 = require('../src/classpath');
var util_1 = require('../src/util');
var jvmObject, classpath;
function getEditDistance(a, b) {
    var matrix = [], i, j;
    if (a.length == 0)
        return b.length;
    if (b.length == 0)
        return a.length;
    for (i = 0; i <= b.length; i++) {
        matrix[i] = [i];
    }
    for (j = 0; j <= a.length; j++) {
        matrix[0][j] = j;
    }
    for (i = 1; i <= b.length; i++) {
        for (j = 1; j <= a.length; j++) {
            if (b.charAt(i - 1) == a.charAt(j - 1)) {
                matrix[i][j] = matrix[i - 1][j - 1];
            } else {
                matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, Math.min(matrix[i][j - 1] + 1, matrix[i - 1][j] + 1));
            }
        }
    }
    return matrix[b.length][a.length];
}
function getNativeSigs(className) {
    var rv = [], i;
    for (i = 0; i < classpath.length; i++) {
        var klassData = classpath[i].tryLoadClassSync(className);
        if (klassData !== null) {
            var klass = new ClassData_1.ReferenceClassData(klassData);
            var methods = klass.getMethods();
            methods.forEach(function (m) {
                if (m.accessFlags.isNative()) {
                    rv.push(m.signature);
                }
            });
        }
    }
    return rv;
}
function getClassesWithImplementedNatives() {
    var nativeImpls = jvmObject.getNatives(), methods = {};
    Object.keys(nativeImpls).forEach(function (clsName) {
        methods[clsName] = Object.keys(nativeImpls[clsName]);
    });
    return methods;
}
function missingFromArray(items, arr) {
    var rv = [], i;
    for (i = 0; i < items.length; i++) {
        if (arr.indexOf(items[i]) === -1) {
            rv.push(items[i]);
        }
    }
    return rv;
}
function getSimilar(strs, candidates) {
    var minEditDistance, bestCandidate, i, j, str, tmp, rv = {};
    for (i = 0; i < strs.length; i++) {
        minEditDistance = 999999999999999;
        str = strs[i];
        for (j = 0; j < candidates.length; j++) {
            tmp = getEditDistance(str, candidates[j]);
            if (tmp < minEditDistance) {
                minEditDistance = tmp;
                bestCandidate = candidates[j];
            }
        }
        if (bestCandidate != null) {
            rv[str] = bestCandidate;
        } else {
            rv[str] = '';
        }
    }
    return rv;
}
function formatKlass(title, data) {
    var left, output = [];
    output.push(title);
    for (left in data) {
        output.push('\n\tMissing: ' + left);
        output.push('\n\tMatch? : ' + data[left] + '\n');
    }
    return output.join('');
}
function printResult(result) {
    var klassName, printed = false;
    for (klassName in result) {
        printed = true;
        if (result.hasOwnProperty(klassName)) {
            console.log(formatKlass(klassName, result[klassName]) + '\n');
        }
    }
    if (!printed) {
        console.log('All native method implementations match native methods in your class files.');
    }
}
function main() {
    var implNatives = getClassesWithImplementedNatives(), klassNatives, klassImplNatives, klassName, missingNatives, similarMap = {};
    for (klassName in implNatives) {
        if (implNatives.hasOwnProperty(klassName)) {
            klassNatives = getNativeSigs(klassName);
            klassImplNatives = implNatives[klassName];
            missingNatives = missingFromArray(klassImplNatives, klassNatives);
            if (missingNatives.length > 0) {
                similarMap[klassName] = getSimilar(missingNatives, klassNatives);
            }
        }
    }
    printResult(similarMap);
}
var JAVA_HOME = path.resolve(__dirname, '../vendor/java_home');
var DOPPIO_HOME = path.resolve(__dirname, '..');
var opts = util_1.merge(jvm_1['default'].getDefaultOptions(DOPPIO_HOME), { nativeClasspath: [path.resolve(__dirname, '../src/natives')] });
new jvm_1['default'](opts, function (err, _jvmObject) {
    if (err) {
        throw err;
    }
    jvmObject = _jvmObject;
    classpath_1.ClasspathFactory(JAVA_HOME, opts.bootstrapClasspath, function (items) {
        classpath = items;
        main();
    });
});
//# sourceMappingURL=find_invalid_natives.js.map