'use strict';
var threading_1 = require('../src/threading');
var enums_1 = require('../src/enums');
var statuses = Object.keys(threading_1.validTransitions);
process.stdout.write('digraph thread_transition_graph {\n');
statuses.forEach(function (status) {
    process.stdout.write('\t' + enums_1.ThreadStatus[status] + ' [label="' + enums_1.ThreadStatus[status] + '"];\n');
});
statuses.forEach(function (oldStatus) {
    Object.keys(threading_1.validTransitions[oldStatus]).forEach(function (newStatus) {
        process.stdout.write('\t' + enums_1.ThreadStatus[oldStatus] + ' -> ' + enums_1.ThreadStatus[newStatus] + ' [label="' + threading_1.validTransitions[oldStatus][newStatus] + '"];\n');
    });
});
process.stdout.write('}\n');
//# sourceMappingURL=generate_thread_transition_graph.js.map