'use strict';
var java_cli_1 = require('../src/java_cli');
var path = require('path');
var os = require('os');
var fs = require('fs');
require('source-map-support').install({ handleUncaughtExceptions: true });
function doneCb(status) {
    process.exit(status);
}
var jvmState;
process.on('SIGINT', function () {
    console.error('Doppio caught SIGINT');
    process.exit(0);
});
process.on('uncaughtException', function (er) {
    console.log('Encountered error: ' + er + '\n' + er.stack);
    fs.appendFileSync('doppio.err', '\n--------------------------------------\n' + er + '\n' + er.stack + '\n');
    if (jvmState) {
        jvmState.dumpState('doppio.err', function (er) {
            if (!er) {
                console.log('Thread state dumped to doppio.err.');
            } else {
                console.log('Error writing doppio.err: ' + er + '\n' + er.stack);
            }
        });
    } else {
        console.log('JVM state undefined; unable to print debug information.');
    }
    process.exit(1);
});
java_cli_1['default'](process.argv.slice(2), {
    doppioHomePath: path.resolve(__dirname, '..'),
    nativeClasspath: [],
    launcherName: process.argv[0] + ' ' + path.relative(process.cwd(), process.argv[1]),
    intMode: false,
    dumpJITStats: false,
    tmpDir: os.tmpdir()
}, doneCb, function (jvm) {
    jvmState = jvm;
});
//# sourceMappingURL=runner.js.map