'use strict';
var testing_1 = require('../src/testing');
var os = require('os');
var fs = require('fs');
var path = require('path');
require('source-map-support').install({ handleUncaughtExceptions: true });
var opts = {
        doppioHomePath: path.resolve(__dirname, '..'),
        nativeClasspath: [],
        enableSystemAssertions: true,
        enableAssertions: true,
        intMode: false,
        dumpJITStats: false,
        tmpDir: os.tmpdir()
    }, passChar, failChar;
if (process.platform.match(/win32/i)) {
    passChar = '\u221A';
    failChar = 'X';
} else {
    passChar = '\u2713';
    failChar = '\u2717';
}
function makefileTest(argv) {
    var failpath = path.resolve(__dirname, '../classes/test/failures.txt'), keepGoing = argv.c;
    opts.testClasses = argv._;
    var errCallback = null;
    function finish(err) {
        process.stdout.write(err ? failChar : passChar);
        if (err) {
            var buff = new Buffer('\n' + err.message + '\n');
            fs.appendFileSync(failpath, buff, { flag: 'a' });
        }
        process.exit(err ? 1 : 0);
    }
    process.on('beforeExit', function () {
        if (errCallback) {
            errCallback(new Error('Finish callback never triggered.'));
        }
    });
    process.on('uncaughtException', function (err) {
        if (errCallback) {
            errCallback(err);
        }
    });
    testing_1.runTests(opts, true, keepGoing, false, function (cb) {
        errCallback = cb;
    }, finish);
}
function regularTest(argv) {
    var hideDiffs = !argv.diff, quiet = argv.q, keepGoing = argv.c, errCallback = null;
    opts.testClasses = argv._;
    var stdoutW = process.stdout.write, stderrW = process.stderr.write;
    process.on('uncaughtException', function (err) {
        if (errCallback) {
            errCallback(err);
        }
    });
    process.on('beforeExit', function () {
        if (errCallback) {
            errCallback(new Error('Finish callback never triggered.'));
        }
    });
    testing_1.runTests(opts, quiet, keepGoing, hideDiffs, function (cb) {
        errCallback = cb;
    }, function (err) {
        process.exit(err ? 1 : 0);
    });
}
var optimist = require('optimist').boolean([
    'q',
    'h',
    'c',
    'makefile',
    'diff'
]).default({ diff: true }).alias({
    h: 'help',
    q: 'quiet',
    c: 'continue'
}).describe({
    q: 'Suppress in-progress test output',
    diff: 'Show failed test diff output',
    c: 'Keep going after test failure',
    h: 'Show this usage'
}).usage('Usage: $0 path/to/test [flags]');
var argv = optimist.argv;
if (argv.help) {
    optimist.showHelp();
    process.exit(0);
}
if (argv.makefile) {
    makefileTest(argv);
} else {
    regularTest(argv);
}
//# sourceMappingURL=test_runner.js.map