'use strict';
var __extends = this && this.__extends || function (d, b) {
    for (var p in b)
        if (b.hasOwnProperty(p))
            d[p] = b[p];
    function __() {
        this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var util_1 = require('./util');
var util = require('./util');
var ByteStream_1 = require('./ByteStream');
var ConstantPool_1 = require('./ConstantPool');
var attributes_1 = require('./attributes');
var threading_1 = require('./threading');
var logging = require('./logging');
var methods_1 = require('./methods');
var ClassLoader_1 = require('./ClassLoader');
var enums_1 = require('./enums');
var ClassLock_1 = require('./ClassLock');
var assert_1 = require('./assert');
var gLong_1 = require('./gLong');
var StringOutputStream_1 = require('./StringOutputStream');
var Monitor_1 = require('./Monitor');
var trace = logging.trace;
var debug = logging.debug;
var global_1 = require('./global');
if (typeof RELEASE === 'undefined')
    global_1['default'].RELEASE = false;
var ref = 1;
function getRef() {
    return ref++;
}
var injectedFields = {
    'Ljava/lang/invoke/MemberName;': {
        vmtarget: [
            '(thread: JVMThread, descriptor: string, args: any[], cb?: (e?: JVMTypes.java_lang_Throwable, rv?: any) => void) => void',
            'null'
        ],
        vmindex: [
            'number',
            '-1'
        ]
    },
    'Ljava/lang/Object;': {
        'ref': [
            'number',
            'getRef()'
        ],
        '$monitor': [
            'Monitor',
            'null'
        ]
    },
    'Ljava/net/PlainSocketImpl;': {
        '$is_shutdown': [
            'boolean',
            'false'
        ],
        '$ws': [
            'Interfaces.IWebsock',
            'null'
        ]
    },
    'Ljava/lang/Class;': {
        '$cls': [
            'ClassData',
            'null'
        ],
        'signers': [
            'JVMTypes.java_lang_Object[]',
            'null'
        ]
    },
    'Ljava/lang/ClassLoader;': {
        '$loader': [
            'ClassLoader',
            'new CustomClassLoader(thread.getBsCl(), this);'
        ]
    },
    'Ljava/lang/Thread;': {
        '$thread': [
            'JVMThread',
            'thread ? new thread.constructor(thread.getJVM(), thread.getThreadPool(), this) : null'
        ]
    }
};
var injectedMethods = {
    'Ljava/lang/Object;': {
        'getClass': [
            '(): ClassData',
            'function() { return this.constructor.cls }'
        ],
        'getMonitor': [
            '(): Monitor',
            'function() {\n  if (this.$monitor === null) {\n    this.$monitor = new Monitor();\n  }\n  return this.$monitor;\n}'
        ]
    },
    'Ljava/lang/String;': {
        'toString': [
            '(): string',
            'function() { return util.chars2jsStr(this[\'java/lang/String/value\']); }'
        ]
    },
    'Ljava/lang/Byte;': {
        'unbox': [
            '(): number',
            'function() { return this[\'java/lang/Byte/value\']; }'
        ]
    },
    'Ljava/lang/Character;': {
        'unbox': [
            '(): number',
            'function() { return this[\'java/lang/Character/value\']; }'
        ]
    },
    'Ljava/lang/Double;': {
        'unbox': [
            '(): number',
            'function() { return this[\'java/lang/Double/value\']; }'
        ]
    },
    'Ljava/lang/Float;': {
        'unbox': [
            '(): number',
            'function() { return this[\'java/lang/Float/value\']; }'
        ]
    },
    'Ljava/lang/Integer;': {
        'unbox': [
            '(): number',
            'function() { return this[\'java/lang/Integer/value\']; }'
        ]
    },
    'Ljava/lang/Long;': {
        'unbox': [
            '(): Long',
            'function() { return this[\'java/lang/Long/value\']; }'
        ]
    },
    'Ljava/lang/Short;': {
        'unbox': [
            '(): number',
            'function() { return this[\'java/lang/Short/value\']; }'
        ]
    },
    'Ljava/lang/Boolean;': {
        'unbox': [
            '(): number',
            'function() { return this[\'java/lang/Boolean/value\']; }'
        ]
    },
    'Ljava/lang/Void;': {
        'unbox': [
            '(): number',
            'function() { throw new Error("Cannot unbox a Void type."); }'
        ]
    },
    'Ljava/lang/invoke/MethodType;': {
        'toString': [
            '(): string',
            'function() { return "(" + this[\'java/lang/invoke/MethodType/ptypes\'].array.map(function (type) { return type.$cls.getInternalName(); }).join("") + ")" + this[\'java/lang/invoke/MethodType/rtype\'].$cls.getInternalName(); }'
        ]
    }
};
var injectedStaticMethods = {
    'Ljava/lang/Byte;': {
        'box': [
            '(val: number): java_lang_Byte',
            'function(val) { var rv = new this(null); rv[\'java/lang/Byte/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Character;': {
        'box': [
            '(val: number): java_lang_Character',
            'function(val) { var rv = new this(null); rv[\'java/lang/Character/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Double;': {
        'box': [
            '(val: number): java_lang_Double',
            'function(val) { var rv = new this(null); rv[\'java/lang/Double/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Float;': {
        'box': [
            '(val: number): java_lang_Float',
            'function(val) { var rv = new this(null); rv[\'java/lang/Float/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Integer;': {
        'box': [
            '(val: number): java_lang_Integer',
            'function(val) { var rv = new this(null); rv[\'java/lang/Integer/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Long;': {
        'box': [
            '(val: Long): java_lang_Long',
            'function(val) { var rv = new this(null); rv[\'java/lang/Long/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Short;': {
        'box': [
            '(val: number): java_lang_Short',
            'function(val) { var rv = new this(null); rv[\'java/lang/Short/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Boolean;': {
        'box': [
            '(val: number): java_lang_Boolean',
            'function(val) { var rv = new this(null); rv[\'java/lang/Boolean/value\'] = val; return rv; }'
        ]
    },
    'Ljava/lang/Void;': {
        'box': [
            '(): java_lang_Void',
            'function() { return new this(null); }'
        ]
    }
};
function extendClass(cls, superCls) {
    function __() {
        this.constructor = cls;
    }
    __.prototype = superCls.prototype;
    cls.prototype = new __();
}
var ClassData = function () {
    function ClassData(loader) {
        this.accessFlags = null;
        this.state = enums_1.ClassState.LOADED;
        this.jco = null;
        this.superClass = null;
        this.loader = loader;
    }
    ClassData.prototype.getExternalName = function () {
        return util_1.ext_classname(this.className);
    };
    ClassData.prototype.getInternalName = function () {
        return this.className;
    };
    ClassData.prototype.getPackageName = function () {
        var extName = this.getExternalName(), i;
        for (i = extName.length - 1; i >= 0 && extName[i] !== '.'; i--) {
        }
        if (i >= 0) {
            return extName.slice(0, i);
        } else {
            return '';
        }
    };
    ClassData.prototype.getLoader = function () {
        return this.loader;
    };
    ClassData.prototype.getSuperClass = function () {
        return this.superClass;
    };
    ClassData.prototype.getInterfaces = function () {
        return [];
    };
    ClassData.prototype.getInjectedFields = function () {
        var rv = {};
        if (injectedFields[this.getInternalName()] !== undefined) {
            var fields = injectedFields[this.getInternalName()];
            Object.keys(fields).forEach(function (fieldName) {
                rv[fieldName] = fields[fieldName][0];
            });
        }
        return rv;
    };
    ClassData.prototype.getInjectedMethods = function () {
        var rv = {}, lookupName = this.getInternalName();
        if (lookupName[0] === '[') {
            lookupName = '[';
        }
        if (injectedMethods[lookupName] !== undefined) {
            var methods = injectedMethods[lookupName];
            Object.keys(methods).forEach(function (methodName) {
                rv[methodName] = methods[methodName][0];
            });
        }
        return rv;
    };
    ClassData.prototype.getInjectedStaticMethods = function () {
        var rv = {}, lookupName = this.getInternalName();
        if (lookupName[0] === '[') {
            lookupName = '[';
        }
        if (injectedStaticMethods[lookupName] !== undefined) {
            var methods = injectedStaticMethods[lookupName];
            Object.keys(methods).forEach(function (methodName) {
                rv[methodName] = methods[methodName][0];
            });
        }
        return rv;
    };
    ClassData.prototype.getClassObject = function (thread) {
        if (this.jco === null) {
            this.jco = new (thread.getBsCl().getResolvedClass('Ljava/lang/Class;').getConstructor(thread))(thread);
            this.jco.$cls = this;
            this.jco['java/lang/Class/classLoader'] = this.getLoader().getLoaderObject();
        }
        return this.jco;
    };
    ClassData.prototype.getProtectionDomain = function () {
        return null;
    };
    ClassData.prototype.getMethod = function (methodSignature) {
        return null;
    };
    ClassData.prototype.getMethods = function () {
        return [];
    };
    ClassData.prototype.getFields = function () {
        return [];
    };
    ClassData.prototype.setState = function (state) {
        this.state = state;
    };
    ClassData.prototype.getState = function () {
        if (this.state === enums_1.ClassState.RESOLVED && this.getMethod('<clinit>()V') === null) {
            var scls = this.getSuperClass();
            if (scls !== null && scls.getState() === enums_1.ClassState.INITIALIZED) {
                this.state = enums_1.ClassState.INITIALIZED;
            }
        }
        return this.state;
    };
    ClassData.prototype.isInitialized = function (thread) {
        return this.getState() === enums_1.ClassState.INITIALIZED;
    };
    ClassData.prototype.isResolved = function () {
        return this.getState() !== enums_1.ClassState.LOADED;
    };
    ClassData.prototype.isSubinterface = function (target) {
        return false;
    };
    ClassData.prototype.isSubclass = function (target) {
        if (this === target) {
            return true;
        }
        if (this.getSuperClass() === null) {
            return false;
        }
        return this.getSuperClass().isSubclass(target);
    };
    ClassData.prototype.resolve = function (thread, cb, explicit) {
        if (explicit === void 0) {
            explicit = true;
        }
        throw new Error('Unimplemented.');
    };
    ClassData.prototype.initialize = function (thread, cb, explicit) {
        if (explicit === void 0) {
            explicit = true;
        }
        throw new Error('Unimplemented.');
    };
    ClassData.prototype.outputInjectedMethods = function (jsClassName, outputStream) {
        var lookupName = this.getInternalName();
        if (lookupName[0] === '[') {
            lookupName = '[';
        }
        if (injectedMethods[lookupName] !== undefined) {
            var methods = injectedMethods[lookupName];
            Object.keys(methods).forEach(function (methodName) {
                outputStream.write('  ' + jsClassName + '.prototype.' + methodName + ' = ' + methods[methodName][1] + ';\n');
            });
        }
        if (injectedStaticMethods[lookupName] !== undefined) {
            var staticMethods = injectedStaticMethods[lookupName];
            Object.keys(staticMethods).forEach(function (methodName) {
                outputStream.write('  ' + jsClassName + '.' + methodName + ' = ' + staticMethods[methodName][1] + ';\n');
            });
        }
    };
    return ClassData;
}();
exports.ClassData = ClassData;
var PrimitiveClassData = function (_super) {
    __extends(PrimitiveClassData, _super);
    function PrimitiveClassData(className, loader) {
        _super.call(this, loader);
        this.className = className;
        this.accessFlags = new util_1.Flags(1041);
        this.setState(enums_1.ClassState.INITIALIZED);
    }
    PrimitiveClassData.prototype.isCastable = function (target) {
        return this.className === target.getInternalName();
    };
    PrimitiveClassData.prototype.boxClassName = function () {
        return util_1.boxClassName(this.className);
    };
    PrimitiveClassData.prototype.createWrapperObject = function (thread, value) {
        var boxName = this.boxClassName();
        var boxCls = thread.getBsCl().getInitializedClass(thread, boxName);
        var boxCons = boxCls.getConstructor(thread);
        var wrapped = new boxCons(thread);
        if (boxName !== 'V') {
            wrapped[util_1.descriptor2typestr(boxName) + '/value'] = value;
            assert_1['default'](typeof value === 'number' || typeof value === 'boolean' || typeof value.low_ === 'number', 'Invalid primitive value: ' + value);
        }
        return wrapped;
    };
    PrimitiveClassData.prototype.tryToResolve = function () {
        return true;
    };
    PrimitiveClassData.prototype.tryToInitialize = function () {
        return true;
    };
    PrimitiveClassData.prototype.resolve = function (thread, cb, explicit) {
        var _this = this;
        if (explicit === void 0) {
            explicit = true;
        }
        setImmediate(function () {
            return cb(_this);
        });
    };
    return PrimitiveClassData;
}(ClassData);
exports.PrimitiveClassData = PrimitiveClassData;
var ArrayClassData = function (_super) {
    __extends(ArrayClassData, _super);
    function ArrayClassData(componentType, loader) {
        _super.call(this, loader);
        this._constructor = null;
        this.className = '[' + componentType;
        this.accessFlags = new util_1.Flags(1041);
        this.componentClassName = componentType;
    }
    ArrayClassData.prototype.methodLookup = function (signature) {
        return this.superClass.methodLookup(signature);
    };
    ArrayClassData.prototype.fieldLookup = function (name) {
        return this.superClass.fieldLookup(name);
    };
    ArrayClassData.prototype.resolve = function (thread, cb, explicit) {
        var _this = this;
        if (explicit === void 0) {
            explicit = true;
        }
        if (this.isResolved()) {
            setImmediate(function () {
                return cb(_this);
            });
            return;
        }
        util_1.asyncForEach([
            'Ljava/lang/Object;',
            this.componentClassName
        ], function (cls, nextItem) {
            _this.loader.resolveClass(thread, cls, function (cdata) {
                if (cdata !== null) {
                    nextItem();
                } else {
                    nextItem('Failed.');
                }
            });
        }, function (err) {
            if (!err) {
                _this.setResolved(_this.loader.getResolvedClass('Ljava/lang/Object;'), _this.loader.getResolvedClass(_this.componentClassName));
                cb(_this);
            } else {
                cb(null);
            }
        });
    };
    ArrayClassData.prototype.getComponentClass = function () {
        return this.componentClass;
    };
    ArrayClassData.prototype.setResolved = function (super_class_cdata, component_class_cdata) {
        this.superClass = super_class_cdata;
        this.componentClass = component_class_cdata;
        this.setState(enums_1.ClassState.INITIALIZED);
    };
    ArrayClassData.prototype.tryToResolve = function () {
        var loader = this.loader, superClassCdata = loader.getResolvedClass('Ljava/lang/Object;'), componentClassCdata = loader.getResolvedClass(this.componentClassName);
        if (superClassCdata === null || componentClassCdata === null) {
            return false;
        } else {
            this.setResolved(superClassCdata, componentClassCdata);
            return true;
        }
    };
    ArrayClassData.prototype.tryToInitialize = function () {
        return this.tryToResolve();
    };
    ArrayClassData.prototype.isCastable = function (target) {
        if (!(target instanceof ArrayClassData)) {
            if (target instanceof PrimitiveClassData) {
                return false;
            }
            if (target.accessFlags.isInterface()) {
                var type = target.getInternalName();
                return type === 'Ljava/lang/Cloneable;' || type === 'Ljava/io/Serializable;';
            }
            return target.getInternalName() === 'Ljava/lang/Object;';
        }
        return this.getComponentClass().isCastable(target.getComponentClass());
    };
    ArrayClassData.prototype.initialize = function (thread, cb, explicit) {
        if (explicit === void 0) {
            explicit = true;
        }
        this.resolve(thread, cb, explicit);
    };
    ArrayClassData.prototype.getJSArrayConstructor = function () {
        if (!util_1.typedArraysSupported) {
            return 'Array';
        }
        switch (this.componentClassName) {
        case 'B':
            return 'Int8Array';
        case 'C':
            return 'Uint16Array';
        case 'S':
            return 'Int16Array';
        case 'I':
            return 'Int32Array';
        case 'F':
            return 'Float32Array';
        case 'D':
            return 'Float64Array';
        default:
            return 'Array';
        }
    };
    ArrayClassData.prototype.getJSDefaultArrayElement = function () {
        switch (this.componentClassName[0]) {
        case '[':
            return 'new (cls.getComponentClass().getConstructor())(thread, otherLengths)';
        case 'L':
            return 'null';
        case 'J':
            return 'gLongZero';
        default:
            return '0';
        }
    };
    ArrayClassData.prototype._getSliceMethod = function () {
        var output = new StringOutputStream_1['default'](), jsArrCons = this.getJSArrayConstructor();
        output.write('function(start, end) {\n    var newObj = new this.constructor(null, 0);\n');
        if (jsArrCons === 'Array') {
            output.write('    newObj.array = this.array.slice(start, end);\n');
        } else {
            var elementSize;
            switch (jsArrCons) {
            case 'Int8Array':
                elementSize = 1;
                break;
            case 'Int16Array':
            case 'Uint16Array':
                elementSize = 2;
                break;
            case 'Int32Array':
            case 'Float32Array':
                elementSize = 4;
                break;
            case 'Float64Array':
                elementSize = 8;
                break;
            default:
                assert_1['default'](false, 'Illegal array type returned??');
            }
            output.write('    if (end === undefined) end = this.array.length;\n      ' + (elementSize > 1 ? 'start *= ' + elementSize + ';\nend *= ' + elementSize + ';' : '') + '\n      newObj.array = new ' + jsArrCons + '(this.array.buffer.slice(start, end));\n');
        }
        output.write('    return newObj;\n  }');
        return output.flush();
    };
    ArrayClassData.prototype._constructConstructor = function (thread) {
        assert_1['default'](this._constructor === null, 'Tried to construct constructor twice for ' + this.getExternalName() + '!');
        var outputStream = new StringOutputStream_1['default'](), jsClassName = util_1.jvmName2JSName(this.getInternalName());
        outputStream.write('extendClass(' + jsClassName + ', superCls.getConstructor(thread));\n  function ' + jsClassName + '(thread, lengths) {\n');
        this.superClass.outputInjectedFields(outputStream);
        if (this.componentClassName[0] !== '[') {
            outputStream.write('    this.array = new ' + this.getJSArrayConstructor() + '(lengths);\n');
            if (this.getJSArrayConstructor() === 'Array') {
                outputStream.write('    for (var i = 0; i < lengths; i++) {\n      this.array[i] = ' + this.getJSDefaultArrayElement() + ';\n    }\n');
            }
        } else {
            outputStream.write('    if (typeof lengths === \'number\') {\n        this.array = new ' + this.getJSArrayConstructor() + '(lengths);\n        for (var i = 0; i < length; i++) {\n          this.array[i] = null;\n        }\n      } else {\n        var length = lengths[0], otherLengths = lengths.length > 2 ? lengths.slice(1) : lengths[1];\n        this.array = new ' + this.getJSArrayConstructor() + '(length);\n        for (var i = 0; i < length; i++) {\n          this.array[i] = ' + this.getJSDefaultArrayElement() + ';\n        }\n      }\n');
        }
        outputStream.write('  }\n\n  ' + jsClassName + '.prototype.slice = ' + this._getSliceMethod() + ';\n  ' + jsClassName + '.cls = cls;\n');
        this.outputInjectedMethods(jsClassName, outputStream);
        outputStream.write('\n  return ' + jsClassName + ';');
        var fcn = new Function('extendClass', 'cls', 'superCls', 'gLongZero', 'thread', 'getRef', 'util', outputStream.flush());
        return fcn(extendClass, this, this.superClass, gLong_1['default'].ZERO, thread, getRef, util);
    };
    ArrayClassData.prototype.getConstructor = function (thread) {
        assert_1['default'](this.isResolved(), 'Tried to get constructor for class ' + this.getInternalName() + ' before it was resolved.');
        if (this._constructor === null) {
            this._constructor = this._constructConstructor(thread);
        }
        return this._constructor;
    };
    return ArrayClassData;
}(ClassData);
exports.ArrayClassData = ArrayClassData;
var ReferenceClassData = function (_super) {
    __extends(ReferenceClassData, _super);
    function ReferenceClassData(buffer, protectionDomain, loader, cpPatches) {
        _super.call(this, loader);
        this.interfaceClasses = null;
        this.superClassRef = null;
        this.initLock = new ClassLock_1['default']();
        this._constructor = null;
        this._fieldLookup = {};
        this._objectFields = [];
        this._staticFields = [];
        this._methodLookup = {};
        this._vmTable = [];
        this._uninheritedDefaultMethods = [];
        this._protectionDomain = protectionDomain ? protectionDomain : null;
        var byteStream = new ByteStream_1['default'](buffer), i = 0;
        if (byteStream.getUint32() !== 3405691582) {
            throw new Error('Magic number invalid');
        }
        this.minorVersion = byteStream.getUint16();
        this.majorVersion = byteStream.getUint16();
        if (!(45 <= this.majorVersion && this.majorVersion <= 52)) {
            throw new Error('Major version invalid');
        }
        this.constantPool = new ConstantPool_1.ConstantPool();
        this.constantPool.parse(byteStream, cpPatches);
        this.accessFlags = new util_1.Flags(byteStream.getUint16());
        this.className = this.constantPool.get(byteStream.getUint16()).name;
        var superRef = byteStream.getUint16();
        if (superRef !== 0) {
            this.superClassRef = this.constantPool.get(superRef);
        }
        var isize = byteStream.getUint16();
        this.interfaceRefs = new Array(isize);
        for (i = 0; i < isize; ++i) {
            this.interfaceRefs[i] = this.constantPool.get(byteStream.getUint16());
        }
        var numFields = byteStream.getUint16();
        this.fields = new Array(numFields);
        for (i = 0; i < numFields; ++i) {
            this.fields[i] = new methods_1.Field(this, this.constantPool, i, byteStream);
        }
        var numMethods = byteStream.getUint16();
        this.methods = new Array(numMethods);
        for (i = 0; i < numMethods; i++) {
            var m = new methods_1.Method(this, this.constantPool, i, byteStream);
            this.methods[i] = m;
        }
        this.attrs = attributes_1.makeAttributes(byteStream, this.constantPool);
        if (byteStream.hasBytes()) {
            throw 'Leftover bytes in classfile: ' + byteStream;
        }
    }
    ReferenceClassData.prototype.getSuperClassReference = function () {
        return this.superClassRef;
    };
    ReferenceClassData.prototype.getInterfaceClassReferences = function () {
        return this.interfaceRefs.slice(0);
    };
    ReferenceClassData.prototype.getInterfaces = function () {
        return this.interfaceClasses;
    };
    ReferenceClassData.prototype.getFields = function () {
        return this.fields;
    };
    ReferenceClassData.prototype.getVMTable = function () {
        return this._vmTable;
    };
    ReferenceClassData.prototype.getVMIndexForMethod = function (m) {
        return this._vmTable.indexOf(this.methodLookup(m.signature));
    };
    ReferenceClassData.prototype.getMethodFromVMIndex = function (i) {
        if (this._vmTable[i] !== undefined) {
            return this._vmTable[i];
        }
        return null;
    };
    ReferenceClassData.prototype.getVMIndexForField = function (f) {
        if (f.accessFlags.isStatic()) {
            assert_1['default'](f.cls === this, 'Looks like we actually need to support static field lookups!');
            return this._staticFields.indexOf(f);
        } else {
            return this._objectFields.indexOf(f);
        }
    };
    ReferenceClassData.prototype.getStaticFieldFromVMIndex = function (index) {
        var f = this._staticFields[index];
        if (f !== undefined) {
            return f;
        }
        return null;
    };
    ReferenceClassData.prototype.getObjectFieldFromVMIndex = function (index) {
        var f = this._objectFields[index];
        if (f !== undefined) {
            return f;
        }
        return null;
    };
    ReferenceClassData.prototype.getFieldFromSlot = function (slot) {
        return this.fields[slot];
    };
    ReferenceClassData.prototype.getMethodFromSlot = function (slot) {
        return this.methods[slot];
    };
    ReferenceClassData.prototype.getMethod = function (sig) {
        var m = this._methodLookup[sig];
        if (m.cls === this) {
            return m;
        }
        return null;
    };
    ReferenceClassData.prototype.getSpecificMethod = function (definingCls, sig) {
        if (this.getInternalName() === definingCls) {
            return this.getMethod(sig);
        }
        var searchClasses = this.interfaceClasses.slice(0), m;
        if (this.superClass) {
            searchClasses.push(this.superClass);
        }
        for (var i = 0; i < searchClasses.length; i++) {
            if (null !== (m = searchClasses[i].getSpecificMethod(definingCls, sig))) {
                return m;
            }
        }
        return null;
    };
    ReferenceClassData.prototype.getMethods = function () {
        return this.methods;
    };
    ReferenceClassData.prototype.getUninheritedDefaultMethods = function () {
        return this._uninheritedDefaultMethods;
    };
    ReferenceClassData.prototype.getProtectionDomain = function () {
        return this._protectionDomain;
    };
    ReferenceClassData.prototype._resolveMethods = function () {
        var _this = this;
        if (this.superClass !== null) {
            this._vmTable = this._vmTable.concat(this.superClass._vmTable);
            Object.keys(this.superClass._methodLookup).forEach(function (m) {
                _this._methodLookup[m] = _this.superClass._methodLookup[m];
            });
        }
        this.methods.forEach(function (m) {
            var superM = _this._methodLookup[m.signature];
            if (!m.accessFlags.isStatic() && m.name !== '<init>') {
                if (superM === undefined) {
                    _this._vmTable.push(m);
                } else {
                    _this._vmTable[_this._vmTable.indexOf(superM)] = m;
                }
            }
            _this._methodLookup[m.signature] = m;
        });
        this.interfaceClasses.forEach(function (iface) {
            Object.keys(iface._methodLookup).forEach(function (ifaceMethodSig) {
                var ifaceM = iface._methodLookup[ifaceMethodSig];
                if (_this._methodLookup[ifaceMethodSig] === undefined) {
                    if (!ifaceM.accessFlags.isStatic()) {
                        _this._vmTable.push(ifaceM);
                    }
                    _this._methodLookup[ifaceMethodSig] = ifaceM;
                } else if (ifaceM.isDefault()) {
                    _this._uninheritedDefaultMethods.push(ifaceM);
                }
            });
        });
    };
    ReferenceClassData.prototype._resolveFields = function () {
        var _this = this;
        if (this.superClass !== null) {
            this._objectFields = this._objectFields.concat(this.superClass._objectFields);
            Object.keys(this.superClass._fieldLookup).forEach(function (f) {
                _this._fieldLookup[f] = _this.superClass._fieldLookup[f];
            });
        }
        this.interfaceClasses.forEach(function (iface) {
            Object.keys(iface._fieldLookup).forEach(function (ifaceFieldName) {
                var ifaceF = iface._fieldLookup[ifaceFieldName];
                assert_1['default'](ifaceF.accessFlags.isStatic(), 'Interface fields must be static.');
                _this._fieldLookup[ifaceFieldName] = ifaceF;
            });
        });
        this.fields.forEach(function (f) {
            _this._fieldLookup[f.name] = f;
            if (f.accessFlags.isStatic()) {
                _this._staticFields.push(f);
            } else {
                _this._objectFields.push(f);
            }
        });
    };
    ReferenceClassData.prototype.methodLookup = function (signature) {
        var m = this._methodLookup[signature];
        if (m !== undefined) {
            return m;
        } else {
            return null;
        }
    };
    ReferenceClassData.prototype.signaturePolymorphicAwareMethodLookup = function (signature) {
        var m;
        if (null !== (m = this.methodLookup(signature))) {
            return m;
        } else if (this.className === 'Ljava/lang/invoke/MethodHandle;') {
            var polySig = signature.slice(0, signature.indexOf('(')) + '([Ljava/lang/Object;)Ljava/lang/Object;', m = this._methodLookup[polySig];
            if (m !== undefined && m.accessFlags.isNative() && m.accessFlags.isVarArgs() && m.cls === this) {
                return m;
            }
        } else if (this.superClass !== null) {
            return this.superClass.signaturePolymorphicAwareMethodLookup(signature);
        }
        return null;
    };
    ReferenceClassData.prototype.fieldLookup = function (name) {
        var f = this._fieldLookup[name];
        if (f !== undefined) {
            return f;
        } else {
            return null;
        }
    };
    ReferenceClassData.prototype.getAttribute = function (name) {
        var attrs = this.attrs;
        for (var i = 0; i < attrs.length; i++) {
            var attr = attrs[i];
            if (attr.getName() === name) {
                return attr;
            }
        }
        return null;
    };
    ReferenceClassData.prototype.getAttributes = function (name) {
        var attrs = this.attrs;
        var results = [];
        for (var i = 0; i < attrs.length; i++) {
            var attr = attrs[i];
            if (attr.getName() === name) {
                results.push(attr);
            }
        }
        return results;
    };
    ReferenceClassData.prototype.getBootstrapMethod = function (idx) {
        var bms = this.getAttribute('BootstrapMethods');
        return bms.bootstrapMethods[idx];
    };
    ReferenceClassData.prototype._getInitialStaticFieldValue = function (thread, name) {
        var f = this.fieldLookup(name);
        if (f !== null && f.accessFlags.isStatic()) {
            var cva = f.getAttribute('ConstantValue');
            if (cva !== null) {
                switch (cva.value.getType()) {
                case enums_1.ConstantPoolItemType.STRING:
                    var stringCPI = cva.value;
                    if (stringCPI.value === null) {
                        stringCPI.value = thread.getJVM().internString(stringCPI.stringValue);
                    }
                    return stringCPI.value;
                default:
                    return cva.value.value;
                }
            } else {
                return util_1.initialValue(f.rawDescriptor);
            }
        }
        assert_1['default'](false, 'Tried to construct a static field value that ' + (f !== null ? 'isn\'t static' : 'doesn\'t exist') + ': ' + (f !== null ? f.cls.getInternalName() : this.getInternalName()) + ' ' + name);
    };
    ReferenceClassData.prototype.setResolved = function (superClazz, interfaceClazzes) {
        this.superClass = superClazz;
        ;
        this.interfaceClasses = interfaceClazzes;
        this._resolveMethods();
        this._resolveFields();
        this.setState(enums_1.ClassState.RESOLVED);
    };
    ReferenceClassData.prototype.tryToResolve = function () {
        if (this.getState() === enums_1.ClassState.LOADED) {
            var loader = this.loader, toResolve = this.superClassRef !== null ? this.interfaceRefs.concat(this.superClassRef) : this.interfaceRefs, allGood = true, resolvedItems = [], i, item;
            for (i = 0; i < toResolve.length; i++) {
                item = toResolve[i];
                if (item.tryResolve(loader)) {
                    resolvedItems.push(item.cls);
                } else {
                    return false;
                }
            }
            this.setResolved(this.superClassRef !== null ? resolvedItems.pop() : null, resolvedItems);
        }
        return true;
    };
    ReferenceClassData.prototype.tryToInitialize = function () {
        if (this.getState() === enums_1.ClassState.INITIALIZED) {
            return true;
        }
        if (this.getState() === enums_1.ClassState.RESOLVED || this.tryToResolve()) {
            if (this.superClass !== null && !this.superClass.tryToInitialize()) {
                return false;
            }
            var clinit = this.getMethod('<clinit>()V');
            if (clinit !== null) {
                return false;
            } else {
                this.setState(enums_1.ClassState.INITIALIZED);
                return true;
            }
        }
        return false;
    };
    ReferenceClassData.prototype.isCastable = function (target) {
        if (!(target instanceof ReferenceClassData)) {
            return false;
        }
        if (this.accessFlags.isInterface()) {
            if (target.accessFlags.isInterface()) {
                return this.isSubinterface(target);
            }
            if (!target.accessFlags.isInterface()) {
                return target.getInternalName() === 'Ljava/lang/Object;';
            }
        } else {
            if (target.accessFlags.isInterface()) {
                return this.isSubinterface(target);
            }
            return this.isSubclass(target);
        }
    };
    ReferenceClassData.prototype.isSubinterface = function (target) {
        if (this.className === target.getInternalName()) {
            return true;
        }
        var ifaces = this.getInterfaces();
        for (var i = 0; i < ifaces.length; i++) {
            var superIface = ifaces[i];
            if (superIface.isSubinterface(target)) {
                return true;
            }
        }
        if (this.getSuperClass() == null) {
            return false;
        }
        return this.getSuperClass().isSubinterface(target);
    };
    ReferenceClassData.prototype.initialize = function (thread, cb, explicit) {
        var _this = this;
        if (explicit === void 0) {
            explicit = true;
        }
        if (this.isResolved()) {
            if (this.isInitialized(thread)) {
                setImmediate(function () {
                    cb(_this);
                });
            } else if (this.initLock.tryLock(thread, cb)) {
                if (this.superClass != null) {
                    this.superClass.initialize(thread, function (cdata) {
                        if (cdata == null) {
                            _this.initLock.unlock(null);
                        } else {
                            _this._initialize(thread, function (cdata) {
                                _this.initLock.unlock(cdata);
                            });
                        }
                    }, explicit);
                } else {
                    this._initialize(thread, function (cdata) {
                        _this.initLock.unlock(cdata);
                    });
                }
            }
        } else {
            this.resolve(thread, function (cdata) {
                if (cdata !== null) {
                    _this.initialize(thread, cb, explicit);
                } else {
                    cb(cdata);
                }
            }, explicit);
        }
    };
    ReferenceClassData.prototype._initialize = function (thread, cb) {
        var _this = this;
        var cons = this.getConstructor(thread);
        if (cons['<clinit>()V'] !== undefined) {
            ;
            cons['<clinit>()V'](thread, null, function (e) {
                if (e) {
                    ;
                    _this.setState(enums_1.ClassState.RESOLVED);
                    if (e.getClass().isCastable(thread.getBsCl().getResolvedClass('Ljava/lang/Error;'))) {
                        thread.throwException(e);
                        cb(null);
                    } else {
                        thread.getBsCl().initializeClass(thread, 'Ljava/lang/ExceptionInInitializerError;', function (cdata) {
                            if (cdata == null) {
                                cb(null);
                            } else {
                                var eCons = cdata.getConstructor(thread), e2 = new eCons(thread);
                                e2['<init>(Ljava/lang/Throwable;)V'](thread, [e], function (e) {
                                    thread.throwException(e2);
                                    cb(null);
                                });
                            }
                        });
                    }
                } else {
                    _this.setState(enums_1.ClassState.INITIALIZED);
                    ;
                    cb(_this);
                }
            });
        } else {
            this.setState(enums_1.ClassState.INITIALIZED);
            cb(this);
        }
    };
    ReferenceClassData.prototype.isInitialized = function (thread) {
        return this.getState() === enums_1.ClassState.INITIALIZED || this.initLock.getOwner() === thread;
    };
    ReferenceClassData.prototype.resolve = function (thread, cb, explicit) {
        var _this = this;
        if (explicit === void 0) {
            explicit = true;
        }
        var toResolve = this.interfaceRefs.slice(0);
        if (this.superClassRef !== null) {
            toResolve.push(this.superClassRef);
        }
        toResolve = toResolve.filter(function (item) {
            return !item.isResolved();
        });
        util_1.asyncForEach(toResolve, function (clsRef, nextItem) {
            clsRef.resolve(thread, _this.loader, _this, function (status) {
                if (!status) {
                    nextItem('Failed.');
                } else {
                    nextItem();
                }
            }, explicit);
        }, function (err) {
            if (!err) {
                _this.setResolved(_this.superClassRef !== null ? _this.superClassRef.cls : null, _this.interfaceRefs.map(function (ref) {
                    return ref.cls;
                }));
                cb(_this);
            } else {
                cb(null);
            }
        });
    };
    ReferenceClassData.prototype.getMirandaAndDefaultMethods = function () {
        var _this = this;
        var superClsMethodTable = this.superClass !== null ? this.superClass.getVMTable() : [];
        return this.getVMTable().slice(superClsMethodTable.length).filter(function (method) {
            return method.cls !== _this;
        });
    };
    ReferenceClassData.prototype.outputInjectedFields = function (outputStream) {
        if (this.superClass !== null) {
            this.superClass.outputInjectedFields(outputStream);
        }
        var injected = injectedFields[this.getInternalName()];
        if (injected !== undefined) {
            Object.keys(injected).forEach(function (fieldName) {
                outputStream.write('this.' + fieldName + ' = ' + injected[fieldName][1] + ';\n');
            });
        }
    };
    ReferenceClassData.prototype._constructConstructor = function (thread) {
        assert_1['default'](this._constructor === null, 'Attempted to construct constructor twice for class ' + this.getExternalName() + '!');
        var jsClassName = util_1.jvmName2JSName(this.getInternalName()), outputStream = new StringOutputStream_1['default']();
        outputStream.write('if (cls.superClass !== null) {\n    extendClass(' + jsClassName + ', cls.superClass.getConstructor(thread));\n  }\n  function ' + jsClassName + '(thread) {\n');
        this.outputInjectedFields(outputStream);
        this._objectFields.forEach(function (f) {
            return f.outputJavaScriptField(jsClassName, outputStream);
        });
        outputStream.write('  }\n  ' + jsClassName + '.cls = cls;\n');
        this.outputInjectedMethods(jsClassName, outputStream);
        this._staticFields.forEach(function (f) {
            return f.outputJavaScriptField(jsClassName, outputStream);
        });
        this.getMethods().forEach(function (m) {
            return m.outputJavaScriptFunction(jsClassName, outputStream);
        });
        this.getMirandaAndDefaultMethods().forEach(function (m) {
            return m.outputJavaScriptFunction(jsClassName, outputStream);
        });
        this.getUninheritedDefaultMethods().forEach(function (m) {
            return m.outputJavaScriptFunction(jsClassName, outputStream, true);
        });
        outputStream.write('  return ' + jsClassName + ';');
        var evalText = outputStream.flush();
        if (!RELEASE && thread !== null && thread.getJVM().shouldDumpCompiledCode()) {
            thread.getJVM().dumpObjectDefinition(this, evalText);
        }
        var fcn = new Function('extendClass', 'cls', 'InternalStackFrame', 'NativeStackFrame', 'BytecodeStackFrame', 'gLongZero', 'CustomClassLoader', 'Monitor', 'thread', 'getRef', 'util', evalText);
        return fcn(extendClass, this, threading_1.InternalStackFrame, threading_1.NativeStackFrame, threading_1.BytecodeStackFrame, gLong_1['default'].ZERO, ClassLoader_1.CustomClassLoader, Monitor_1['default'], thread, getRef, util);
    };
    ReferenceClassData.prototype.getConstructor = function (thread) {
        if (this._constructor == null) {
            assert_1['default'](this.isResolved(), 'Cannot construct ' + this.getInternalName() + '\'s constructor until it is resolved.');
            this._constructor = this._constructConstructor(thread);
        }
        return this._constructor;
    };
    return ReferenceClassData;
}(ClassData);
exports.ReferenceClassData = ReferenceClassData;
//# sourceMappingURL=ClassData.js.map