'use strict';
var ClassLock = function () {
    function ClassLock() {
        this.queue = [];
    }
    ClassLock.prototype.tryLock = function (thread, cb) {
        return this.queue.push({
            thread: thread,
            cb: cb
        }) === 1;
    };
    ClassLock.prototype.unlock = function (cdata) {
        var i, num = this.queue.length;
        for (i = 0; i < num; i++) {
            this.queue[i].cb(cdata);
        }
        this.queue = [];
    };
    ClassLock.prototype.getOwner = function () {
        if (this.queue.length > 0) {
            return this.queue[0].thread;
        }
        return null;
    };
    return ClassLock;
}();
exports.__esModule = true;
exports['default'] = ClassLock;
//# sourceMappingURL=ClassLock.js.map