'use strict';
var SafeMap = function () {
    function SafeMap() {
        this.cache = Object.create(null);
    }
    SafeMap.prototype.fixKey = function (key) {
        return ';' + key;
    };
    SafeMap.prototype.get = function (key) {
        key = this.fixKey(key);
        if (this.cache[key] !== undefined) {
            return this.cache[key];
        }
        return undefined;
    };
    SafeMap.prototype.has = function (key) {
        return this.get(key) !== undefined;
    };
    SafeMap.prototype.set = function (key, value) {
        this.cache[this.fixKey(key)] = value;
    };
    return SafeMap;
}();
exports.__esModule = true;
exports['default'] = SafeMap;
//# sourceMappingURL=SafeMap.js.map