'use strict';
function text_diff(a_lines, b_lines, context) {
    return new SequenceMatcher(a_lines, b_lines).text_diff(context);
}
exports.text_diff = text_diff;
function __ntuplecomp(a, b) {
    var mlen = Math.max(a.length, b.length);
    for (var i = 0; i < mlen; i++) {
        if (a[i] < b[i])
            return -1;
        if (a[i] > b[i])
            return 1;
    }
    return a.length == b.length ? 0 : a.length < b.length ? -1 : 1;
}
function __dictget(dict, key, defaultValue) {
    return dict.hasOwnProperty(key) ? dict[key] : defaultValue;
}
var SequenceMatcher = function () {
    function SequenceMatcher(a, b) {
        this.a = a;
        this.b = b;
        this.b2j = {};
        for (var i = 0; i < b.length; i++) {
            var elt = b[i];
            if (this.b2j.hasOwnProperty(elt)) {
                this.b2j[elt].push(i);
            } else {
                this.b2j[elt] = [i];
            }
        }
    }
    SequenceMatcher.prototype.find_longest_match = function (alo, ahi, blo, bhi) {
        var a = this.a;
        var b = this.b;
        var b2j = this.b2j;
        var besti = alo;
        var bestj = blo;
        var bestsize = 0;
        var j2len = {};
        for (var i = alo; i < ahi; i++) {
            var newj2len = {};
            var jdict = __dictget(b2j, a[i], []);
            for (var jkey in jdict) {
                if (jdict.hasOwnProperty(jkey)) {
                    var j = jdict[jkey];
                    if (j < blo)
                        continue;
                    if (j >= bhi)
                        break;
                    var k = __dictget(j2len, j - 1, 0) + 1;
                    newj2len[j] = k;
                    if (k > bestsize) {
                        besti = i - k + 1;
                        bestj = j - k + 1;
                        bestsize = k;
                    }
                }
            }
            j2len = newj2len;
        }
        while (besti > alo && bestj > blo && a[besti - 1] == b[bestj - 1]) {
            besti--;
            bestj--;
            bestsize++;
        }
        while (besti + bestsize < ahi && bestj + bestsize < bhi && a[besti + bestsize] == b[bestj + bestsize]) {
            bestsize++;
        }
        return [
            besti,
            bestj,
            bestsize
        ];
    };
    SequenceMatcher.prototype.get_matching_blocks = function () {
        if (this.matching_blocks != null)
            return this.matching_blocks;
        var la = this.a.length;
        var lb = this.b.length;
        var queue = [[
                0,
                la,
                0,
                lb
            ]];
        var matching_blocks = [];
        while (queue.length) {
            var qi = queue.pop();
            var alo = qi[0];
            var ahi = qi[1];
            var blo = qi[2];
            var bhi = qi[3];
            var x = this.find_longest_match(alo, ahi, blo, bhi);
            var i = x[0];
            var j = x[1];
            var k = x[2];
            if (k) {
                matching_blocks.push(x);
                if (alo < i && blo < j)
                    queue.push([
                        alo,
                        i,
                        blo,
                        j
                    ]);
                if (i + k < ahi && j + k < bhi)
                    queue.push([
                        i + k,
                        ahi,
                        j + k,
                        bhi
                    ]);
            }
        }
        matching_blocks.sort(__ntuplecomp);
        var i1 = 0, j1 = 0, k1 = 0;
        var non_adjacent = [];
        for (var idx = 0; idx < matching_blocks.length; idx++) {
            var block = matching_blocks[idx];
            var i2 = block[0];
            var j2 = block[1];
            var k2 = block[2];
            if (i1 + k1 == i2 && j1 + k1 == j2) {
                k1 += k2;
            } else {
                if (k1)
                    non_adjacent.push([
                        i1,
                        j1,
                        k1
                    ]);
                i1 = i2;
                j1 = j2;
                k1 = k2;
            }
        }
        if (k1)
            non_adjacent.push([
                i1,
                j1,
                k1
            ]);
        non_adjacent.push([
            la,
            lb,
            0
        ]);
        this.matching_blocks = non_adjacent;
        return this.matching_blocks;
    };
    SequenceMatcher.prototype.get_opcodes = function () {
        if (this.opcodes != null)
            return this.opcodes;
        var i = 0;
        var j = 0;
        var answer = [];
        this.opcodes = answer;
        var blocks = this.get_matching_blocks();
        for (var idx = 0; idx < blocks.length; idx++) {
            var block = blocks[idx];
            var ai = block[0];
            var bj = block[1];
            var size = block[2];
            var tag = '';
            if (i < ai && j < bj) {
                tag = 'replace';
            } else if (i < ai) {
                tag = 'delete';
            } else if (j < bj) {
                tag = 'insert';
            }
            if (tag)
                answer.push([
                    tag,
                    i,
                    ai,
                    j,
                    bj
                ]);
            i = ai + size;
            j = bj + size;
            if (size)
                answer.push([
                    'equal',
                    ai,
                    i,
                    bj,
                    j
                ]);
        }
        return answer;
    };
    SequenceMatcher.prototype.text_diff = function (context) {
        var opcodes = this.get_opcodes();
        var diff = [];
        var a_side = [];
        var b_side = [];
        var a_max_len = 0;
        var last_seen = -1;
        for (var op_idx = 0; op_idx < opcodes.length; op_idx++) {
            var op = opcodes[op_idx];
            if (op[0] === 'equal')
                continue;
            var ai = op[1];
            var bi = op[3];
            var aj = op[2] - 1;
            var bj = op[4] - 1;
            var start = Math.min(ai, bi);
            var end = Math.max(aj, bj);
            var c = '';
            switch (op[0]) {
            case 'delete':
                c = ' < ';
                break;
            case 'insert':
                c = ' > ';
                break;
            case 'replace':
                c = ' | ';
                break;
            }
            for (var i = Math.max(last_seen + 1, start - context); i < start; i++) {
                var prefix = i + ': ';
                if (i < this.a.length) {
                    a_side.push(prefix + this.a[i]);
                    a_max_len = Math.max(a_max_len, this.a[i].length + prefix.length);
                } else {
                    a_side.push(prefix);
                }
                if (i < this.b.length) {
                    b_side.push(this.b[i]);
                } else {
                    b_side.push('');
                }
                diff.push('   ');
            }
            for (var i = start; i <= end; i++) {
                var prefix = i + ': ';
                if (i >= ai && i <= aj) {
                    a_side.push(prefix + this.a[i]);
                    a_max_len = Math.max(a_max_len, this.a[i].length + prefix.length);
                } else {
                    a_side.push(prefix);
                }
                if (i >= bi && i <= bj) {
                    b_side.push(this.b[i]);
                } else {
                    b_side.push('');
                }
                diff.push(c);
            }
            last_seen = end;
        }
        for (var i = 0; i < diff.length; i++) {
            var a = a_side[i];
            var b = b_side[i];
            if (a.length < a_max_len)
                a += new Array(a_max_len - a.length + 1).join(' ');
            diff[i] = a + diff[i] + b;
        }
        return diff;
    };
    return SequenceMatcher;
}();
exports.SequenceMatcher = SequenceMatcher;
//# sourceMappingURL=difflib.js.map