'use strict';
var gLong = function () {
    function gLong(low, high) {
        this.low_ = low | 0;
        this.high_ = high | 0;
    }
    gLong.fromInt = function (value) {
        if (-128 <= value && value < 128) {
            var cachedObj = gLong.IntCache_[value];
            if (cachedObj) {
                return cachedObj;
            }
        }
        var obj = new gLong(value, value < 0 ? -1 : 0);
        if (-128 <= value && value < 128) {
            gLong.IntCache_[value] = obj;
        }
        return obj;
    };
    gLong.fromNumber = function (value) {
        if (isNaN(value) || !isFinite(value)) {
            return gLong.ZERO;
        } else if (value <= -gLong.TWO_PWR_63_DBL_) {
            return gLong.MIN_VALUE;
        } else if (value + 1 >= gLong.TWO_PWR_63_DBL_) {
            return gLong.MAX_VALUE;
        } else if (value < 0) {
            return gLong.fromNumber(-value).negate();
        } else {
            return new gLong(value % gLong.TWO_PWR_32_DBL_ | 0, value / gLong.TWO_PWR_32_DBL_ | 0);
        }
    };
    gLong.fromBits = function (lowBits, highBits) {
        return new gLong(lowBits, highBits);
    };
    gLong.fromString = function (str, opt_radix) {
        if (str.length == 0) {
            throw Error('number format error: empty string');
        }
        var radix = opt_radix || 10;
        if (radix < 2 || 36 < radix) {
            throw Error('radix out of range: ' + radix);
        }
        if (str.charAt(0) == '-') {
            return gLong.fromString(str.substring(1), radix).negate();
        } else if (str.indexOf('-') >= 0) {
            throw Error('number format error: interior "-" character: ' + str);
        }
        var radixToPower = gLong.fromNumber(Math.pow(radix, 8));
        var result = gLong.ZERO;
        for (var i = 0; i < str.length; i += 8) {
            var size = Math.min(8, str.length - i);
            var value = parseInt(str.substring(i, i + size), radix);
            if (size < 8) {
                var power = gLong.fromNumber(Math.pow(radix, size));
                result = result.multiply(power).add(gLong.fromNumber(value));
            } else {
                result = result.multiply(radixToPower);
                result = result.add(gLong.fromNumber(value));
            }
        }
        return result;
    };
    gLong.prototype.toInt = function () {
        return this.low_;
    };
    gLong.prototype.toNumber = function () {
        return this.high_ * gLong.TWO_PWR_32_DBL_ + this.getLowBitsUnsigned();
    };
    gLong.prototype.toString = function (opt_radix) {
        var radix = opt_radix || 10;
        if (radix < 2 || 36 < radix) {
            throw Error('radix out of range: ' + radix);
        }
        if (this.isZero()) {
            return '0';
        }
        if (this.isNegative()) {
            if (this.equals(gLong.MIN_VALUE)) {
                var radixLong = gLong.fromNumber(radix);
                var div = this.div(radixLong);
                var rem = div.multiply(radixLong).subtract(this);
                return div.toString(radix) + rem.toInt().toString(radix);
            } else {
                return '-' + this.negate().toString(radix);
            }
        }
        var radixToPower = gLong.fromNumber(Math.pow(radix, 6));
        var rem = this;
        var result = '';
        while (true) {
            var remDiv = rem.div(radixToPower);
            var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt();
            var digits = intval.toString(radix);
            rem = remDiv;
            if (rem.isZero()) {
                return digits + result;
            } else {
                while (digits.length < 6) {
                    digits = '0' + digits;
                }
                result = '' + digits + result;
            }
        }
    };
    gLong.prototype.getHighBits = function () {
        return this.high_;
    };
    gLong.prototype.getLowBits = function () {
        return this.low_;
    };
    gLong.prototype.getLowBitsUnsigned = function () {
        return this.low_ >= 0 ? this.low_ : gLong.TWO_PWR_32_DBL_ + this.low_;
    };
    gLong.prototype.getNumBitsAbs = function () {
        if (this.isNegative()) {
            if (this.equals(gLong.MIN_VALUE)) {
                return 64;
            } else {
                return this.negate().getNumBitsAbs();
            }
        } else {
            var val = this.high_ != 0 ? this.high_ : this.low_;
            for (var bit = 31; bit > 0; bit--) {
                if ((val & 1 << bit) != 0) {
                    break;
                }
            }
            return this.high_ != 0 ? bit + 33 : bit + 1;
        }
    };
    gLong.prototype.isZero = function () {
        return this.high_ == 0 && this.low_ == 0;
    };
    gLong.prototype.isNegative = function () {
        return this.high_ < 0;
    };
    gLong.prototype.isOdd = function () {
        return (this.low_ & 1) == 1;
    };
    gLong.prototype.equals = function (other) {
        return this.high_ == other.high_ && this.low_ == other.low_;
    };
    gLong.prototype.notEquals = function (other) {
        return this.high_ != other.high_ || this.low_ != other.low_;
    };
    gLong.prototype.lessThan = function (other) {
        return this.compare(other) < 0;
    };
    gLong.prototype.lessThanOrEqual = function (other) {
        return this.compare(other) <= 0;
    };
    gLong.prototype.greaterThan = function (other) {
        return this.compare(other) > 0;
    };
    gLong.prototype.greaterThanOrEqual = function (other) {
        return this.compare(other) >= 0;
    };
    gLong.prototype.compare = function (other) {
        if (this.equals(other)) {
            return 0;
        }
        var thisNeg = this.isNegative();
        var otherNeg = other.isNegative();
        if (thisNeg && !otherNeg) {
            return -1;
        }
        if (!thisNeg && otherNeg) {
            return 1;
        }
        if (this.subtract(other).isNegative()) {
            return -1;
        } else {
            return 1;
        }
    };
    gLong.prototype.negate = function () {
        if (this.equals(gLong.MIN_VALUE)) {
            return gLong.MIN_VALUE;
        } else {
            return this.not().add(gLong.ONE);
        }
    };
    gLong.prototype.add = function (other) {
        var a48 = this.high_ >>> 16;
        var a32 = this.high_ & 65535;
        var a16 = this.low_ >>> 16;
        var a00 = this.low_ & 65535;
        var b48 = other.high_ >>> 16;
        var b32 = other.high_ & 65535;
        var b16 = other.low_ >>> 16;
        var b00 = other.low_ & 65535;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 + b00;
        c16 += c00 >>> 16;
        c00 &= 65535;
        c16 += a16 + b16;
        c32 += c16 >>> 16;
        c16 &= 65535;
        c32 += a32 + b32;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c48 += a48 + b48;
        c48 &= 65535;
        return gLong.fromBits(c16 << 16 | c00, c48 << 16 | c32);
    };
    gLong.prototype.subtract = function (other) {
        return this.add(other.negate());
    };
    gLong.prototype.multiply = function (other) {
        if (this.isZero()) {
            return gLong.ZERO;
        } else if (other.isZero()) {
            return gLong.ZERO;
        }
        if (this.equals(gLong.MIN_VALUE)) {
            return other.isOdd() ? gLong.MIN_VALUE : gLong.ZERO;
        } else if (other.equals(gLong.MIN_VALUE)) {
            return this.isOdd() ? gLong.MIN_VALUE : gLong.ZERO;
        }
        if (this.isNegative()) {
            if (other.isNegative()) {
                return this.negate().multiply(other.negate());
            } else {
                return this.negate().multiply(other).negate();
            }
        } else if (other.isNegative()) {
            return this.multiply(other.negate()).negate();
        }
        if (this.lessThan(gLong.TWO_PWR_24_) && other.lessThan(gLong.TWO_PWR_24_)) {
            return gLong.fromNumber(this.toNumber() * other.toNumber());
        }
        var a48 = this.high_ >>> 16;
        var a32 = this.high_ & 65535;
        var a16 = this.low_ >>> 16;
        var a00 = this.low_ & 65535;
        var b48 = other.high_ >>> 16;
        var b32 = other.high_ & 65535;
        var b16 = other.low_ >>> 16;
        var b00 = other.low_ & 65535;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 * b00;
        c16 += c00 >>> 16;
        c00 &= 65535;
        c16 += a16 * b00;
        c32 += c16 >>> 16;
        c16 &= 65535;
        c16 += a00 * b16;
        c32 += c16 >>> 16;
        c16 &= 65535;
        c32 += a32 * b00;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c32 += a16 * b16;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c32 += a00 * b32;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
        c48 &= 65535;
        return gLong.fromBits(c16 << 16 | c00, c48 << 16 | c32);
    };
    gLong.prototype.div = function (other) {
        if (other.isZero()) {
            throw Error('division by zero');
        } else if (this.isZero()) {
            return gLong.ZERO;
        }
        if (this.equals(gLong.MIN_VALUE)) {
            if (other.equals(gLong.ONE) || other.equals(gLong.NEG_ONE)) {
                return gLong.MIN_VALUE;
            } else if (other.equals(gLong.MIN_VALUE)) {
                return gLong.ONE;
            } else {
                var halfThis = this.shiftRight(1);
                var l_approx = halfThis.div(other).shiftLeft(1);
                if (l_approx.equals(gLong.ZERO)) {
                    return other.isNegative() ? gLong.ONE : gLong.NEG_ONE;
                } else {
                    var rem = this.subtract(other.multiply(l_approx));
                    var result = l_approx.add(rem.div(other));
                    return result;
                }
            }
        } else if (other.equals(gLong.MIN_VALUE)) {
            return gLong.ZERO;
        }
        if (this.isNegative()) {
            if (other.isNegative()) {
                return this.negate().div(other.negate());
            } else {
                return this.negate().div(other).negate();
            }
        } else if (other.isNegative()) {
            return this.div(other.negate()).negate();
        }
        var res = gLong.ZERO;
        var rem = this;
        while (rem.greaterThanOrEqual(other)) {
            var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
            var log2 = Math.ceil(Math.log(approx) / Math.LN2);
            var delta = 1;
            if (log2 > 48)
                delta = Math.pow(2, log2 - 48);
            var approxRes = gLong.fromNumber(approx);
            var approxRem = approxRes.multiply(other);
            while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
                approx -= delta;
                approxRes = gLong.fromNumber(approx);
                approxRem = approxRes.multiply(other);
            }
            if (approxRes.isZero()) {
                approxRes = gLong.ONE;
            }
            res = res.add(approxRes);
            rem = rem.subtract(approxRem);
        }
        return res;
    };
    gLong.prototype.modulo = function (other) {
        return this.subtract(this.div(other).multiply(other));
    };
    gLong.prototype.not = function () {
        return gLong.fromBits(~this.low_, ~this.high_);
    };
    gLong.prototype.and = function (other) {
        return gLong.fromBits(this.low_ & other.low_, this.high_ & other.high_);
    };
    gLong.prototype.or = function (other) {
        return gLong.fromBits(this.low_ | other.low_, this.high_ | other.high_);
    };
    gLong.prototype.xor = function (other) {
        return gLong.fromBits(this.low_ ^ other.low_, this.high_ ^ other.high_);
    };
    gLong.prototype.shiftLeft = function (numBits) {
        numBits &= 63;
        if (numBits == 0) {
            return this;
        } else {
            var low = this.low_;
            if (numBits < 32) {
                var high = this.high_;
                return gLong.fromBits(low << numBits, high << numBits | low >>> 32 - numBits);
            } else {
                return gLong.fromBits(0, low << numBits - 32);
            }
        }
    };
    gLong.prototype.shiftRight = function (numBits) {
        numBits &= 63;
        if (numBits == 0) {
            return this;
        } else {
            var high = this.high_;
            if (numBits < 32) {
                var low = this.low_;
                return gLong.fromBits(low >>> numBits | high << 32 - numBits, high >> numBits);
            } else {
                return gLong.fromBits(high >> numBits - 32, high >= 0 ? 0 : -1);
            }
        }
    };
    gLong.prototype.shiftRightUnsigned = function (numBits) {
        numBits &= 63;
        if (numBits == 0) {
            return this;
        } else {
            var high = this.high_;
            if (numBits < 32) {
                var low = this.low_;
                return gLong.fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits);
            } else if (numBits == 32) {
                return gLong.fromBits(high, 0);
            } else {
                return gLong.fromBits(high >>> numBits - 32, 0);
            }
        }
    };
    gLong.IntCache_ = {};
    gLong.TWO_PWR_16_DBL_ = 1 << 16;
    gLong.TWO_PWR_24_DBL_ = 1 << 24;
    gLong.TWO_PWR_32_DBL_ = gLong.TWO_PWR_16_DBL_ * gLong.TWO_PWR_16_DBL_;
    gLong.TWO_PWR_31_DBL_ = gLong.TWO_PWR_32_DBL_ / 2;
    gLong.TWO_PWR_48_DBL_ = gLong.TWO_PWR_32_DBL_ * gLong.TWO_PWR_16_DBL_;
    gLong.TWO_PWR_64_DBL_ = gLong.TWO_PWR_32_DBL_ * gLong.TWO_PWR_32_DBL_;
    gLong.TWO_PWR_63_DBL_ = gLong.TWO_PWR_64_DBL_ / 2;
    gLong.ZERO = gLong.fromInt(0);
    gLong.ONE = gLong.fromInt(1);
    gLong.NEG_ONE = gLong.fromInt(-1);
    gLong.MAX_VALUE = gLong.fromBits(4294967295, 2147483647);
    gLong.MIN_VALUE = gLong.fromBits(0, 2147483648);
    gLong.TWO_PWR_24_ = gLong.fromInt(gLong.TWO_PWR_24_DBL_);
    return gLong;
}();
exports.__esModule = true;
exports['default'] = gLong;
//# sourceMappingURL=gLong.js.map