'use strict';
var path = require('path');
var fs = require('fs');
var JAR = function () {
    function JAR(dir, doneCb) {
        var _this = this;
        this.attributes = {};
        this.classpath = [];
        fs.readFile(path.resolve(dir, 'META-INF/MANIFEST.MF'), function (err, data) {
            if (err)
                return doneCb(err);
            var currentAttribute = null;
            var currentValue = '';
            var ending = '\n';
            var dataStr = data.toString('utf8');
            var npos = dataStr.indexOf('\n');
            var rpos = dataStr.indexOf('\r');
            if (npos === rpos + 1)
                ending = '\r\n';
            else if (rpos > -1)
                ending = '\r';
            var lines = dataStr.split(ending);
            for (var i = 0; i < lines.length; i++) {
                var line = lines[i];
                if (line === '\r') {
                    continue;
                }
                if (line.length === 0) {
                    if (currentAttribute !== null) {
                        _this._setAttribute(currentAttribute, currentValue);
                        currentAttribute = null;
                    }
                } else if (line.charAt(0) === ' ') {
                    currentValue += line.substr(1);
                } else {
                    if (currentAttribute !== null) {
                        _this._setAttribute(currentAttribute, currentValue);
                    }
                    var split = line.split(':');
                    currentAttribute = split[0];
                    currentValue = split[1].substr(1);
                }
            }
            doneCb();
        });
    }
    JAR.prototype._setAttribute = function (attribute, value) {
        attribute = attribute.toLowerCase();
        this.attributes[attribute] = value;
        if (attribute === 'class-path') {
            var words = value.split(' ');
            for (var i = 0; i < words.length; i++) {
                var word = words[i];
                if (word.substr(-4) === '.jar') {
                    this.classpath.push(word);
                }
            }
        }
    };
    JAR.prototype.getClassPath = function () {
        return this.classpath.slice(0);
    };
    JAR.prototype.getAttribute = function (attribute) {
        return this.attributes[attribute.toLowerCase()];
    };
    JAR.prototype.toString = function () {
        return JSON.stringify(this.attributes);
    };
    return JAR;
}();
exports.__esModule = true;
exports['default'] = JAR;
//# sourceMappingURL=jar.js.map