'use strict';
var enums_1 = require('./enums');
var opcodes = require('./opcodes');
function makeOnError(onErrorPushes, pc) {
    return onErrorPushes.length > 0 ? 'f.pc=' + pc + ';f.opStack.pushAll(' + onErrorPushes.join(',') + ');' : 'f.pc=' + pc + ';';
}
var escapeStringRegEx = /\\/g;
exports.opJitInfo = function () {
    var table = [];
    table[enums_1.OpCode.ACONST_NULL] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ICONST_M1] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=-1;' + onSuccess;
        }
    };
    var load0_32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[0];' + onSuccess;
        }
    };
    var load1_32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[1];' + onSuccess;
        }
    };
    var load2_32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[2];' + onSuccess;
        }
    };
    var load3_32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[3];' + onSuccess;
        }
    };
    table[enums_1.OpCode.ALOAD_0] = load0_32;
    table[enums_1.OpCode.ILOAD_0] = load0_32;
    table[enums_1.OpCode.FLOAD_0] = load0_32;
    table[enums_1.OpCode.ALOAD_1] = load1_32;
    table[enums_1.OpCode.ILOAD_1] = load1_32;
    table[enums_1.OpCode.FLOAD_1] = load1_32;
    table[enums_1.OpCode.ALOAD_2] = load2_32;
    table[enums_1.OpCode.ILOAD_2] = load2_32;
    table[enums_1.OpCode.FLOAD_2] = load2_32;
    table[enums_1.OpCode.ALOAD_3] = load3_32;
    table[enums_1.OpCode.ILOAD_3] = load3_32;
    table[enums_1.OpCode.FLOAD_3] = load3_32;
    var load0_64 = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[0],' + pushes[1] + '=null;' + onSuccess;
        }
    };
    var load1_64 = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[1],' + pushes[1] + '=null;' + onSuccess;
        }
    };
    var load2_64 = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[2],' + pushes[1] + '=null;' + onSuccess;
        }
    };
    var load3_64 = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=f.locals[3],' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LLOAD_0] = load0_64;
    table[enums_1.OpCode.DLOAD_0] = load0_64;
    table[enums_1.OpCode.LLOAD_1] = load1_64;
    table[enums_1.OpCode.DLOAD_1] = load1_64;
    table[enums_1.OpCode.LLOAD_2] = load2_64;
    table[enums_1.OpCode.DLOAD_2] = load2_64;
    table[enums_1.OpCode.LLOAD_3] = load3_64;
    table[enums_1.OpCode.DLOAD_3] = load3_64;
    var store0_32 = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[0]=' + pops[0] + ';' + onSuccess;
        }
    };
    var store1_32 = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[1]=' + pops[0] + ';' + onSuccess;
        }
    };
    var store2_32 = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[2]=' + pops[0] + ';' + onSuccess;
        }
    };
    var store3_32 = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[3]=' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.ASTORE_0] = store0_32;
    table[enums_1.OpCode.ISTORE_0] = store0_32;
    table[enums_1.OpCode.FSTORE_0] = store0_32;
    table[enums_1.OpCode.ASTORE_1] = store1_32;
    table[enums_1.OpCode.ISTORE_1] = store1_32;
    table[enums_1.OpCode.FSTORE_1] = store1_32;
    table[enums_1.OpCode.ASTORE_2] = store2_32;
    table[enums_1.OpCode.ISTORE_2] = store2_32;
    table[enums_1.OpCode.FSTORE_2] = store2_32;
    table[enums_1.OpCode.ASTORE_3] = store3_32;
    table[enums_1.OpCode.ISTORE_3] = store3_32;
    table[enums_1.OpCode.FSTORE_3] = store3_32;
    var store_64 = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var offset = code[pc + 1];
            return 'f.locals[' + (offset + 1) + ']=' + pops[0] + ';f.locals[' + offset + ']=' + pops[1] + ';' + onSuccess;
        }
    };
    var store0_64 = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[1]=' + pops[0] + ';f.locals[0]=' + pops[1] + ';' + onSuccess;
        }
    };
    var store1_64 = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[2]=' + pops[0] + ';f.locals[1]=' + pops[1] + ';' + onSuccess;
        }
    };
    var store2_64 = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[3]=' + pops[0] + ';f.locals[2]=' + pops[1] + ';' + onSuccess;
        }
    };
    var store3_64 = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'f.locals[4]=' + pops[0] + ';f.locals[3]=' + pops[1] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.LSTORE] = store_64;
    table[enums_1.OpCode.DSTORE] = store_64;
    table[enums_1.OpCode.LSTORE_0] = store0_64;
    table[enums_1.OpCode.DSTORE_0] = store0_64;
    table[enums_1.OpCode.LSTORE_1] = store1_64;
    table[enums_1.OpCode.DSTORE_1] = store1_64;
    table[enums_1.OpCode.LSTORE_2] = store2_64;
    table[enums_1.OpCode.DSTORE_2] = store2_64;
    table[enums_1.OpCode.LSTORE_3] = store3_64;
    table[enums_1.OpCode.DSTORE_3] = store3_64;
    var const0_32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=0;' + onSuccess;
        }
    };
    var const1_32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=1;' + onSuccess;
        }
    };
    var const2_32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=2;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ICONST_0] = const0_32;
    table[enums_1.OpCode.ICONST_1] = const1_32;
    table[enums_1.OpCode.ICONST_2] = const2_32;
    table[enums_1.OpCode.FCONST_0] = const0_32;
    table[enums_1.OpCode.FCONST_1] = const1_32;
    table[enums_1.OpCode.FCONST_2] = const2_32;
    table[enums_1.OpCode.ICONST_3] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=3;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ICONST_4] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=4;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ICONST_5] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=5;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LCONST_0] = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=u.gLong.ZERO,' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LCONST_1] = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=u.gLong.ONE,' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.DCONST_0] = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=0,' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.DCONST_1] = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=1,' + pushes[1] + '=null;' + onSuccess;
        }
    };
    var aload32 = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return '\nif(!u.isNull(t,f,' + pops[1] + ')){\nvar len' + suffix + '=' + pops[1] + '.array.length;\nif(' + pops[0] + '<0||' + pops[0] + '>=len' + suffix + '){\n' + onError + '\nu.throwException(t,f,\'Ljava/lang/ArrayIndexOutOfBoundsException;\',""+' + pops[0] + '+" not in length "+len' + suffix + '+" array of type "+' + pops[1] + '.getClass().getInternalName());\n}else{var ' + pushes[0] + '=' + pops[1] + '.array[' + pops[0] + '];' + onSuccess + '}\n}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.IALOAD] = aload32;
    table[enums_1.OpCode.FALOAD] = aload32;
    table[enums_1.OpCode.AALOAD] = aload32;
    table[enums_1.OpCode.BALOAD] = aload32;
    table[enums_1.OpCode.CALOAD] = aload32;
    table[enums_1.OpCode.SALOAD] = aload32;
    var aload64 = {
        hasBranch: false,
        pops: 2,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return '\nif(!u.isNull(t,f,' + pops[1] + ')){\nvar len' + suffix + '=' + pops[1] + '.array.length;\nif(' + pops[0] + '<0||' + pops[0] + '>=len' + suffix + '){\n' + onError + '\nu.throwException(t,f,\'Ljava/lang/ArrayIndexOutOfBoundsException;\',""+' + pops[0] + '+" not in length "+len' + suffix + '+" array of type "+' + pops[1] + '.getClass().getInternalName());\n}else{var ' + pushes[0] + '=' + pops[1] + '.array[' + pops[0] + '],' + pushes[1] + '=null;' + onSuccess + '}\n}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.DALOAD] = aload64;
    table[enums_1.OpCode.LALOAD] = aload64;
    var astore32 = {
        hasBranch: false,
        pops: 3,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return '\nif(!u.isNull(t,f,' + pops[2] + ')){\nvar len' + suffix + '=' + pops[2] + '.array.length;\nif(' + pops[1] + '<0||' + pops[1] + '>=len' + suffix + '){\n' + onError + '\nu.throwException(t,f,\'Ljava/lang/ArrayIndexOutOfBoundsException;\',""+' + pops[1] + '+" not in length "+len' + suffix + '+" array of type "+' + pops[2] + '.getClass().getInternalName());\n}else{' + pops[2] + '.array[' + pops[1] + ']=' + pops[0] + ';' + onSuccess + '}\n}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.IASTORE] = astore32;
    table[enums_1.OpCode.FASTORE] = astore32;
    table[enums_1.OpCode.AASTORE] = astore32;
    table[enums_1.OpCode.BASTORE] = astore32;
    table[enums_1.OpCode.CASTORE] = astore32;
    table[enums_1.OpCode.SASTORE] = astore32;
    var astore64 = {
        hasBranch: false,
        pops: 4,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return '\nif(!u.isNull(t,f,' + pops[3] + ')){\nvar len' + suffix + '=' + pops[3] + '.array.length;\nif(' + pops[2] + '<0||' + pops[2] + '>=len' + suffix + '){\n' + onError + '\nu.throwException(t,f,\'Ljava/lang/ArrayIndexOutOfBoundsException;\',""+' + pops[2] + '+" not in length "+len' + suffix + '+" array of type "+' + pops[3] + '.getClass().getInternalName());\n}else{' + pops[3] + '.array[' + pops[2] + ']=' + pops[1] + ';' + onSuccess + '}\n}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.DASTORE] = astore64;
    table[enums_1.OpCode.LASTORE] = astore64;
    table[enums_1.OpCode.LDC] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code[pc + 1];
            var onError = makeOnError(onErrorPushes, pc);
            return '\nvar cnst' + suffix + '=f.method.cls.constantPool.get(' + index + ');\nif(cnst' + suffix + '.isResolved()){var ' + pushes[0] + '=cnst' + suffix + '.getConstant(t);' + onSuccess + '\n}else{' + onError + 'u.resolveCPItem(t,f,cnst' + suffix + ');}';
        }
    };
    table[enums_1.OpCode.LDC_W] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code.readUInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc);
            return '\nvar cnst' + suffix + '=f.method.cls.constantPool.get(' + index + ');\nif(cnst' + suffix + '.isResolved()){var ' + pushes[0] + '=cnst' + suffix + '.getConstant(t);' + onSuccess + '\n}else{' + onError + 'u.resolveCPItem(t,f,cnst' + suffix + ');}';
        }
    };
    table[enums_1.OpCode.LDC2_W] = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return 'var ' + pushes[0] + '=f.method.cls.constantPool.get(' + index + ').value,' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.GETSTATIC_FAST32] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return 'var fi' + suffix + '=f.method.cls.constantPool.get(' + index + '),' + pushes[0] + '=fi' + suffix + '.fieldOwnerConstructor[fi' + suffix + '.fullFieldName];' + onSuccess;
        }
    };
    table[enums_1.OpCode.GETSTATIC_FAST64] = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return '\nvar fi' + suffix + '=f.method.cls.constantPool.get(' + index + '),' + pushes[0] + '=fi' + suffix + '.fieldOwnerConstructor[fi' + suffix + '.fullFieldName],\n' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.GETFIELD_FAST32] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, '\\\\');
            return 'if(!u.isNull(t,f,' + pops[0] + ')){var ' + pushes[0] + '=' + pops[0] + '[\'' + name + '\'];' + onSuccess + '}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.GETFIELD_FAST64] = {
        hasBranch: false,
        pops: 1,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, '\\\\');
            return 'if(!u.isNull(t,f,' + pops[0] + ')){var ' + pushes[0] + '=' + pops[0] + '[\'' + name + '\'],' + pushes[1] + '=null;' + onSuccess + '}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.PUTFIELD_FAST32] = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, '\\\\');
            return 'if(!u.isNull(t,f,' + pops[1] + ')){' + pops[1] + '[\'' + name + '\']=' + pops[0] + ';' + onSuccess + '}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.PUTFIELD_FAST64] = {
        hasBranch: false,
        pops: 3,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var onError = makeOnError(onErrorPushes, pc);
            var index = code.readUInt16BE(pc + 1);
            var fieldInfo = method.cls.constantPool.get(index);
            var name = fieldInfo.fullFieldName.replace(escapeStringRegEx, '\\\\');
            return 'if(!u.isNull(t,f,' + pops[2] + ')){' + pops[2] + '[\'' + name + '\']=' + pops[1] + ';' + onSuccess + '}else{' + onError + '}';
        }
    };
    table[enums_1.OpCode.INSTANCEOF_FAST] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return 'var cls' + suffix + '=f.method.cls.constantPool.get(' + index + ').cls,' + pushes[0] + '=' + pops[0] + '!==null?(' + pops[0] + '.getClass().isCastable(cls' + suffix + ')?1:0):0;' + onSuccess;
        }
    };
    table[enums_1.OpCode.CHECKCAST_FAST] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            var index = code.readUInt16BE(pc + 1);
            var classRef = method.cls.constantPool.get(index), targetClass = classRef.cls.getExternalName();
            return 'var cls' + suffix + '=f.method.cls.constantPool.get(' + index + ').cls;\nif((' + pops[0] + '!=null)&&!' + pops[0] + '.getClass().isCastable(cls' + suffix + ')){\nu.throwException(t,f,\'Ljava/lang/ClassCastException;\',' + pops[0] + '.getClass().getExternalName()+\' cannot be cast to ' + targetClass + '\');\n}else{var ' + pushes[0] + '=' + pops[0] + ';' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.ARRAYLENGTH] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return 'if(!u.isNull(t,f,' + pops[0] + ')){var ' + pushes[0] + '=' + pops[0] + '.array.length;' + onSuccess + '}else{' + onError + '}';
        }
    };
    var load32 = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code[pc + 1];
            return 'var ' + pushes[0] + '=f.locals[' + index + '];' + onSuccess;
        }
    };
    table[enums_1.OpCode.ILOAD] = load32;
    table[enums_1.OpCode.ALOAD] = load32;
    table[enums_1.OpCode.FLOAD] = load32;
    var load64 = {
        hasBranch: false,
        pops: 0,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code[pc + 1];
            return 'var ' + pushes[0] + '=f.locals[' + index + '],' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LLOAD] = load64;
    table[enums_1.OpCode.DLOAD] = load64;
    var store32 = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code[pc + 1];
            return 'f.locals[' + index + ']=' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.ISTORE] = store32;
    table[enums_1.OpCode.ASTORE] = store32;
    table[enums_1.OpCode.FSTORE] = store32;
    table[enums_1.OpCode.BIPUSH] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var value = code.readInt8(pc + 1);
            return 'var ' + pushes[0] + '=' + value + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.SIPUSH] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var value = code.readInt16BE(pc + 1);
            return 'var ' + pushes[0] + '=' + value + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.IINC] = {
        hasBranch: false,
        pops: 0,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var idx = code[pc + 1];
            var val = code.readInt8(pc + 2);
            return 'f.locals[' + idx + ']=(f.locals[' + idx + ']+' + val + ')|0;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ATHROW] = {
        hasBranch: true,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return onError + 't.throwException(' + pops[0] + ');f.returnToThreadLoop=true;';
        }
    };
    table[enums_1.OpCode.GOTO] = {
        hasBranch: true,
        pops: 0,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var offset = code.readInt16BE(pc + 1);
            return 'f.pc=' + (pc + offset) + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.TABLESWITCH] = {
        hasBranch: true,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var alignedPC = pc + (4 - (pc + 1) % 4) % 4 + 1;
            var defaultOffset = code.readInt32BE(alignedPC), low = code.readInt32BE(alignedPC + 4), high = code.readInt32BE(alignedPC + 8);
            if (high - low < 8) {
                var emitted = 'switch(' + pops[0] + '){';
                for (var i = low; i <= high; i++) {
                    var offset = code.readInt32BE(alignedPC + 12 + (i - low) * 4);
                    emitted += 'case ' + i + ':f.pc=' + (pc + offset) + ';break;';
                }
                emitted += 'default:f.pc=' + (pc + defaultOffset) + '}' + onSuccess;
                return emitted;
            } else {
                return 'if(' + pops[0] + '>=' + low + '&&' + pops[0] + '<=' + high + '){f.pc=' + pc + '+f.method.getCodeAttribute().getCode().readInt32BE(' + (alignedPC + 12) + '+((' + pops[0] + ' - ' + low + ')*4))}else{f.pc=' + (pc + defaultOffset) + '}' + onSuccess;
            }
        }
    };
    var cmpeq = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '===' + pops[1] + '){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IF_ICMPEQ] = cmpeq;
    table[enums_1.OpCode.IF_ACMPEQ] = cmpeq;
    var cmpne = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '!==' + pops[1] + '){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IF_ICMPNE] = cmpne;
    table[enums_1.OpCode.IF_ACMPNE] = cmpne;
    table[enums_1.OpCode.IF_ICMPGE] = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[1] + '>=' + pops[0] + '){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IF_ICMPGT] = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[1] + '>' + pops[0] + '){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IF_ICMPLE] = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[1] + '<=' + pops[0] + '){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IF_ICMPLT] = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[1] + '<' + pops[0] + '){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFNULL] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '==null){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFNONNULL] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '!=null){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFEQ] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '===0){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFNE] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '!==0){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFGT] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '>0){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFLT] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '<0){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFGE] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '>=0){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.IFLE] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var offset = code.readInt16BE(pc + 1);
            var onError = makeOnError(onErrorPushes, pc + offset);
            return 'if(' + pops[0] + '<=0){' + onError + '}else{' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.LCMP] = {
        hasBranch: false,
        pops: 4,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '.compare(' + pops[1] + ');' + onSuccess;
        }
    };
    table[enums_1.OpCode.FCMPL] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + '===' + pops[1] + '?0:(' + pops[1] + '>' + pops[0] + '?1:-1);' + onSuccess;
        }
    };
    table[enums_1.OpCode.DCMPL] = {
        hasBranch: false,
        pops: 4,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '===' + pops[1] + '?0:(' + pops[3] + '>' + pops[1] + '?1:-1);' + onSuccess;
        }
    };
    table[enums_1.OpCode.FCMPG] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + '===' + pops[1] + '?0:(' + pops[1] + '<' + pops[0] + '?-1:1);' + onSuccess;
        }
    };
    table[enums_1.OpCode.DCMPG] = {
        hasBranch: false,
        pops: 4,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '===' + pops[1] + '?0:(' + pops[3] + '<' + pops[1] + '?-1:1);' + onSuccess;
        }
    };
    table[enums_1.OpCode.RETURN] = {
        hasBranch: true,
        pops: 0,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            if (method.accessFlags.isSynchronized()) {
                return 'f.pc=' + pc + ';f.returnToThreadLoop=true;if(!f.method.methodLock(t,f).exit(t)){return}t.asyncReturn();';
            } else {
                return 'f.pc=' + pc + ';f.returnToThreadLoop=true;t.asyncReturn();';
            }
        }
    };
    var return32 = {
        hasBranch: true,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            if (method.accessFlags.isSynchronized()) {
                return 'f.pc=' + pc + ';f.returnToThreadLoop=true;if(!f.method.methodLock(t,f).exit(t)){return}t.asyncReturn(' + pops[0] + ');';
            } else {
                return 'f.pc=' + pc + ';f.returnToThreadLoop=true;t.asyncReturn(' + pops[0] + ');';
            }
        }
    };
    table[enums_1.OpCode.IRETURN] = return32;
    table[enums_1.OpCode.FRETURN] = return32;
    table[enums_1.OpCode.ARETURN] = return32;
    var return64 = {
        hasBranch: true,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes, method) {
            if (method.accessFlags.isSynchronized()) {
                return 'f.pc=' + pc + ';f.returnToThreadLoop=true;if(!f.method.methodLock(t,f).exit(t)){return}t.asyncReturn(' + pops[1] + ',null);';
            } else {
                return 'f.pc=' + pc + ';f.returnToThreadLoop=true;t.asyncReturn(' + pops[1] + ',null);';
            }
        }
    };
    table[enums_1.OpCode.LRETURN] = return64;
    table[enums_1.OpCode.DRETURN] = return64;
    table[enums_1.OpCode.MONITOREXIT] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return 'if(' + pops[0] + '.getMonitor().exit(t)){' + onSuccess + '}else{' + onError + 'f.returnToThreadLoop=true;}';
        }
    };
    table[enums_1.OpCode.IXOR] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + '^' + pops[1] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.LXOR] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '.xor(' + pops[3] + '),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.IOR] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + '|' + pops[1] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.LOR] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '.or(' + pops[1] + '),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.IAND] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + '&' + pops[1] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.LAND] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '.and(' + pops[1] + '),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.IADD] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=(' + pops[0] + '+' + pops[1] + ')|0;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LADD] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '.add(' + pops[3] + '),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.DADD] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '+' + pops[3] + ',' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.IMUL] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=Math.imul(' + pops[0] + ', ' + pops[1] + ');' + onSuccess;
        }
    };
    table[enums_1.OpCode.FMUL] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=u.wrapFloat(' + pops[0] + '*' + pops[1] + ');' + onSuccess;
        }
    };
    table[enums_1.OpCode.LMUL] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '.multiply(' + pops[1] + '),' + pushes[1] + '= null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.DMUL] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '*' + pops[1] + ',' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.IDIV] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return '\nif(' + pops[0] + '===0){' + onError + 'u.throwException(t,f,\'Ljava/lang/ArithmeticException;\',\'/ by zero\');\n}else{var ' + pushes[0] + '=(' + pops[1] + '===u.Constants.INT_MIN&&' + pops[0] + '===-1)?' + pops[1] + ':((' + pops[1] + '/' + pops[0] + ')|0);' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.LDIV] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return '\nif(' + pops[1] + '.isZero()){' + onError + 'u.throwException(t,f,\'Ljava/lang/ArithmeticException;\',\'/ by zero\');\n}else{var ' + pushes[0] + '=' + pops[3] + '.div(' + pops[1] + '),' + pushes[1] + '=null;' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.DDIV] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '/' + pops[1] + ',' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ISUB] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=(' + pops[1] + '-' + pops[0] + ')|0;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LSUB] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '.negate().add(' + pops[3] + '),' + pushes[1] + '= null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.DSUB] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '-' + pops[1] + ',' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.IREM] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return 'if(' + pops[0] + '===0){' + onError + 'u.throwException(t,f,\'Ljava/lang/ArithmeticException;\',\'/ by zero\');\n}else{var ' + pushes[0] + '=' + pops[1] + '%' + pops[0] + ';' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.LREM] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var onError = makeOnError(onErrorPushes, pc);
            return 'if(' + pops[1] + '.isZero()){' + onError + 'u.throwException(t,f,\'Ljava/lang/ArithmeticException;\',\'/ by zero\');\n}else{var ' + pushes[0] + '=' + pops[3] + '.modulo(' + pops[1] + '),' + pushes[1] + '=null;' + onSuccess + '}';
        }
    };
    table[enums_1.OpCode.DREM] = {
        hasBranch: false,
        pops: 4,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[3] + '%' + pops[1] + ',' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.INEG] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=(-' + pops[0] + ')|0;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LNEG] = {
        hasBranch: false,
        pops: 2,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '.negate(),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ISHL] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '<<' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.LSHL] = {
        hasBranch: false,
        pops: 3,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[2] + '.shiftLeft(u.gLong.fromInt(' + pops[0] + ')),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.ISHR] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '>>' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.LSHR] = {
        hasBranch: false,
        pops: 3,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[2] + '.shiftRight(u.gLong.fromInt(' + pops[0] + ')),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.IUSHR] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=(' + pops[1] + '>>>' + pops[0] + ')|0;' + onSuccess;
        }
    };
    table[enums_1.OpCode.LUSHR] = {
        hasBranch: false,
        pops: 3,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[2] + '.shiftRightUnsigned(u.gLong.fromInt(' + pops[0] + ')),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.I2B] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=(' + pops[0] + '<<24)>>24;' + onSuccess;
        }
    };
    table[enums_1.OpCode.I2S] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=(' + pops[0] + '<<16)>>16;' + onSuccess;
        }
    };
    table[enums_1.OpCode.I2C] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + '&0xFFFF;' + onSuccess;
        }
    };
    table[enums_1.OpCode.I2L] = {
        hasBranch: false,
        pops: 1,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=u.gLong.fromInt(' + pops[0] + '),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.I2F] = {
        hasBranch: false,
        pops: 0,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return '' + onSuccess;
        }
    };
    table[enums_1.OpCode.I2D] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.F2I] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=u.float2int(' + pops[0] + ');' + onSuccess;
        }
    };
    table[enums_1.OpCode.F2D] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.L2I] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '.toInt();' + onSuccess;
        }
    };
    table[enums_1.OpCode.L2D] = {
        hasBranch: false,
        pops: 2,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + '.toNumber(),' + pushes[1] + '=null;' + onSuccess;
        }
    };
    table[enums_1.OpCode.D2I] = {
        hasBranch: false,
        pops: 2,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=u.float2int(' + pops[1] + ');' + onSuccess;
        }
    };
    table[enums_1.OpCode.DUP] = {
        hasBranch: false,
        pops: 1,
        pushes: 2,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + ',' + pushes[1] + '=' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.DUP2] = {
        hasBranch: false,
        pops: 2,
        pushes: 4,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + ',' + pushes[1] + '=' + pops[0] + ',' + pushes[2] + '=' + pops[1] + ',' + pushes[3] + '=' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.DUP_X1] = {
        hasBranch: false,
        pops: 2,
        pushes: 3,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + ',' + pushes[1] + '=' + pops[1] + ',' + pushes[2] + '=' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.DUP_X2] = {
        hasBranch: false,
        pops: 3,
        pushes: 4,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[0] + ',' + pushes[1] + '=' + pops[2] + ',' + pushes[2] + '=' + pops[1] + ',' + pushes[3] + '=' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.DUP2_X1] = {
        hasBranch: false,
        pops: 3,
        pushes: 5,
        emit: function (pops, pushes, suffix, onSuccess) {
            return 'var ' + pushes[0] + '=' + pops[1] + ',' + pushes[1] + '=' + pops[0] + ',' + pushes[2] + '=' + pops[2] + ',' + pushes[3] + '=' + pops[1] + ',' + pushes[4] + '=' + pops[0] + ';' + onSuccess;
        }
    };
    table[enums_1.OpCode.NEW_FAST] = {
        hasBranch: false,
        pops: 0,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc) {
            var index = code.readUInt16BE(pc + 1);
            return 'var cr' + suffix + '=f.method.cls.constantPool.get(' + index + '),' + pushes[0] + '=(new cr' + suffix + '.clsConstructor(t));' + onSuccess;
        }
    };
    table[enums_1.OpCode.NEWARRAY] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code[pc + 1];
            var arrayType = '[' + opcodes.ArrayTypes[index];
            var onError = makeOnError(onErrorPushes, pc);
            return '\nvar cls' + suffix + '=f.getLoader().getInitializedClass(t,\'' + arrayType + '\');\nif(' + pops[0] + '>=0){var ' + pushes[0] + '=new (cls' + suffix + '.getConstructor(t))(t,' + pops[0] + ');' + onSuccess + '\n}else{' + onError + 'u.throwException(t,f,\'Ljava/lang/NegativeArraySizeException;\',\'Tried to init ' + arrayType + ' array with length \'+' + pops[0] + ');}';
        }
    };
    table[enums_1.OpCode.ANEWARRAY_FAST] = {
        hasBranch: false,
        pops: 1,
        pushes: 1,
        emit: function (pops, pushes, suffix, onSuccess, code, pc, onErrorPushes) {
            var index = code.readUInt16BE(pc + 1);
            var arrayType = '[' + opcodes.ArrayTypes[index];
            var onError = makeOnError(onErrorPushes, pc);
            return '\nvar cr' + suffix + '=f.method.cls.constantPool.get(' + index + ');\nif(' + pops[0] + '>=0){var ' + pushes[0] + '=new cr' + suffix + '.arrayClassConstructor(t,' + pops[0] + ');' + onSuccess + '\n}else{' + onError + 'u.throwException(t,f,\'Ljava/lang/NegativeArraySizeException;\',\'Tried to init \'+cr' + suffix + '.arrayClass.getInternalName()+\' array with length \'+' + pops[0] + ');}';
        }
    };
    table[enums_1.OpCode.NOP] = {
        hasBranch: false,
        pops: 0,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return '' + onSuccess;
        }
    };
    table[enums_1.OpCode.POP] = {
        hasBranch: false,
        pops: 1,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return '' + onSuccess;
        }
    };
    table[enums_1.OpCode.POP2] = {
        hasBranch: false,
        pops: 2,
        pushes: 0,
        emit: function (pops, pushes, suffix, onSuccess) {
            return '' + onSuccess;
        }
    };
    return table;
}();
//# sourceMappingURL=jit.js.map