'use strict';
var gLong_1 = require('./gLong');
function debug_var(e) {
    if (e === null) {
        return '!';
    } else if (e === void 0) {
        return 'undef';
    } else if (e.ref != null) {
        return '*' + e.ref;
    } else if (e instanceof gLong_1['default']) {
        return e + 'L';
    }
    return e;
}
exports.debug_var = debug_var;
function debug_vars(arr) {
    return arr.map(debug_var);
}
exports.debug_vars = debug_vars;
(function (LogLevel) {
    LogLevel[LogLevel['VTRACE'] = 10] = 'VTRACE';
    LogLevel[LogLevel['TRACE'] = 9] = 'TRACE';
    LogLevel[LogLevel['DEBUG'] = 5] = 'DEBUG';
    LogLevel[LogLevel['ERROR'] = 1] = 'ERROR';
}(exports.LogLevel || (exports.LogLevel = {})));
var LogLevel = exports.LogLevel;
exports.logLevel = LogLevel.ERROR;
function setLogLevel(level) {
    exports.logLevel = level;
}
exports.setLogLevel = setLogLevel;
function log(level, msgs) {
    if (level <= exports.logLevel) {
        var msg = msgs.join(' ');
        if (level == 1) {
            console.error(msg);
        } else {
            console.log(msg);
        }
    }
}
function vtrace() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.VTRACE, msgs);
}
exports.vtrace = vtrace;
function trace() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.TRACE, msgs);
}
exports.trace = trace;
function debug() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.DEBUG, msgs);
}
exports.debug = debug;
function error() {
    var msgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        msgs[_i - 0] = arguments[_i];
    }
    log(LogLevel.ERROR, msgs);
}
exports.error = error;
//# sourceMappingURL=logging.js.map