'use strict';
var enums_1 = require('./enums');
var assert_1 = require('./assert');
var Parker = function () {
    function Parker() {
        this._parkCounts = {};
        this._parkCallbacks = {};
    }
    Parker.prototype.park = function (thread, cb) {
        var ref = thread.getRef();
        assert_1['default'](!this._parkCallbacks[ref] && thread.getStatus() !== enums_1.ThreadStatus.PARKED, 'Thread ' + ref + ' is doubly parked? Should be impossible.');
        this._parkCallbacks[ref] = cb;
        this._mutateParkCount(thread, 1);
        if (this.isParked(thread)) {
            thread.setStatus(enums_1.ThreadStatus.PARKED);
        }
    };
    Parker.prototype.unpark = function (thread) {
        this._mutateParkCount(thread, -1);
    };
    Parker.prototype.completelyUnpark = function (thread) {
        var ref = thread.getRef(), count = this._parkCounts[ref];
        if (count) {
            this._mutateParkCount(thread, -count);
        }
    };
    Parker.prototype._mutateParkCount = function (thread, delta) {
        var ref = thread.getRef(), cb;
        if (!this._parkCounts[ref]) {
            this._parkCounts[ref] = 0;
        }
        if (0 === (this._parkCounts[ref] += delta)) {
            assert_1['default'](!!this._parkCallbacks[ref], 'Balancing unpark for thread ' + ref + ' with no callback? Should be impossible.');
            cb = this._parkCallbacks[ref];
            delete this._parkCounts[ref];
            delete this._parkCallbacks[ref];
            if (thread.getStatus() === enums_1.ThreadStatus.PARKED) {
                thread.setStatus(enums_1.ThreadStatus.ASYNC_WAITING);
                cb();
            }
        }
    };
    Parker.prototype.isParked = function (thread) {
        return !!this._parkCounts[thread.getRef()];
    };
    return Parker;
}();
exports.__esModule = true;
exports['default'] = Parker;
//# sourceMappingURL=parker.js.map