'use strict';
var gLong_1 = require('./gLong');
var enums_1 = require('./enums');
var BrowserFS = require('browserfs');
var BFSUtils = BrowserFS.BFSRequire('bfs_utils');
function merge() {
    var literals = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        literals[_i - 0] = arguments[_i];
    }
    var newObject = {};
    literals.forEach(function (literal) {
        Object.keys(literal).forEach(function (key) {
            newObject[key] = literal[key];
        });
    });
    return newObject;
}
exports.merge = merge;
function are_in_browser() {
    return process.platform === 'browser';
}
exports.are_in_browser = are_in_browser;
exports.typedArraysSupported = typeof ArrayBuffer !== 'undefined';
function jvmName2JSName(jvmName) {
    switch (jvmName[0]) {
    case 'L':
        return jvmName.slice(1, jvmName.length - 1).replace(/_/g, '__').replace(/[\/.;$<>\[\]:\\=^-]/g, '_');
    case '[':
        return 'ARR_' + jvmName2JSName(jvmName.slice(1));
    default:
        return jvmName;
    }
}
exports.jvmName2JSName = jvmName2JSName;
function reescapeJVMName(jvmName) {
    return jvmName.replace(/\\/g, '\\\\');
}
exports.reescapeJVMName = reescapeJVMName;
function asyncForEach(lst, fn, done_cb) {
    var i = -1;
    function processItem(err) {
        if (err) {
            done_cb(err);
        } else {
            i++;
            if (i < lst.length) {
                fn(lst[i], processItem);
            } else {
                done_cb();
            }
        }
    }
    processItem();
}
exports.asyncForEach = asyncForEach;
function asyncSeries(tasks, doneCb) {
    var i = -1;
    function processItem(err) {
        if (err) {
            doneCb(err);
        } else {
            i++;
            if (i < tasks.length) {
                tasks[i](processItem);
            } else {
                doneCb();
            }
        }
    }
    processItem();
}
exports.asyncSeries = asyncSeries;
function asyncFind(lst, fn, done_cb) {
    var i = -1;
    function processItem(success) {
        if (success) {
            done_cb(lst[i]);
        } else {
            i++;
            if (i < lst.length) {
                fn(lst[i], processItem);
            } else {
                done_cb();
            }
        }
    }
    processItem(false);
}
exports.asyncFind = asyncFind;
if (!Math['imul']) {
    Math['imul'] = function (a, b) {
        var ah = a >>> 16 & 65535;
        var al = a & 65535;
        var bh = b >>> 16 & 65535;
        var bl = b & 65535;
        return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
    };
}
if (!Math['expm1']) {
    Math['expm1'] = function (x) {
        if (Math.abs(x) < 0.00001) {
            return x + 0.5 * x * x;
        } else {
            return Math.exp(x) - 1;
        }
    };
}
if (!Math['sinh']) {
    Math['sinh'] = function (a) {
        var exp = Math.exp(a);
        return (exp - 1 / exp) / 2;
    };
}
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (searchElement, fromIndex) {
        if (this == null) {
            throw new TypeError();
        }
        var t = Object(this);
        var len = t.length >>> 0;
        if (len === 0) {
            return -1;
        }
        var n = 0;
        if (fromIndex !== undefined) {
            n = Number(fromIndex);
            if (n != n) {
                n = 0;
            } else if (n != 0 && n != Infinity && n != -Infinity) {
                n = ((n > 0 ? 1 : 0) || -1) * Math.floor(Math.abs(n));
            }
        }
        if (n >= len) {
            return -1;
        }
        var k = n >= 0 ? n : Math.max(len - Math.abs(n), 0);
        for (; k < len; k++) {
            if (k in t && t[k] === searchElement) {
                return k;
            }
        }
        return -1;
    };
}
function checkAccess(accessingCls, owningCls, accessFlags) {
    if (accessFlags.isPublic()) {
        return true;
    } else if (accessFlags.isProtected()) {
        return accessingCls.getPackageName() === owningCls.getPackageName() || accessingCls.isSubclass(owningCls);
    } else if (accessFlags.isPrivate()) {
        return accessingCls === owningCls;
    } else {
        return accessingCls.getPackageName() === owningCls.getPackageName();
    }
}
exports.checkAccess = checkAccess;
function float2int(a) {
    if (a > enums_1.Constants.INT_MAX) {
        return enums_1.Constants.INT_MAX;
    } else if (a < enums_1.Constants.INT_MIN) {
        return enums_1.Constants.INT_MIN;
    } else {
        return a | 0;
    }
}
exports.float2int = float2int;
var supportsArrayBuffers = typeof ArrayBuffer !== 'undefined';
function byteArray2Buffer(bytes, offset, len) {
    if (offset === void 0) {
        offset = 0;
    }
    if (len === void 0) {
        len = bytes.length;
    }
    if (supportsArrayBuffers && ArrayBuffer.isView(bytes)) {
        var offset_1 = bytes.byteOffset;
        return new Buffer(bytes.buffer.slice(offset_1, offset_1 + bytes.length));
    } else {
        var buff = new Buffer(len), i;
        for (i = 0; i < len; i++) {
            buff.writeInt8(bytes[offset + i], i);
        }
        return buff;
    }
}
exports.byteArray2Buffer = byteArray2Buffer;
function isUint8Array(arr) {
    if (arr && typeof Uint8Array !== 'undefined' && arr instanceof Uint8Array) {
        return true;
    }
    return false;
}
exports.isUint8Array = isUint8Array;
function isInt8Array(arr) {
    if (arr && typeof Int8Array !== 'undefined' && arr instanceof Int8Array) {
        return true;
    }
    return false;
}
exports.isInt8Array = isInt8Array;
function i82u8(arr, start, len) {
    if (isInt8Array(arr)) {
        return new Uint8Array(arr.buffer, arr.byteOffset + start, len);
    } else if (Array.isArray(arr)) {
        if (typeof Uint8Array !== 'undefined') {
            var i8arr = new Int8Array(len);
            if (start === 0 && len === arr.length) {
                i8arr.set(arr, 0);
            } else {
                i8arr.set(arr.slice(start, start + len), 0);
            }
            return new Uint8Array(i8arr.buffer);
        } else {
            var rv = new Array(len);
            for (var i = 0; i < len; i++) {
                rv[i] = arr[start + i] & 255;
            }
            return rv;
        }
    } else {
        throw new TypeError('Invalid array.');
    }
}
exports.i82u8 = i82u8;
function u82i8(arr, start, len) {
    if (start === void 0) {
        start = 0;
    }
    if (len === void 0) {
        len = arr.length;
    }
    if (isUint8Array(arr)) {
        return new Int8Array(arr.buffer, arr.byteOffset + start, len);
    } else if (Array.isArray(arr)) {
        if (typeof Int8Array !== 'undefined') {
            var u8arr = new Uint8Array(len);
            if (start === 0 && len === arr.length) {
                u8arr.set(arr, 0);
            } else {
                u8arr.set(arr.slice(start, start + len), 0);
            }
            return new Int8Array(u8arr.buffer);
        } else {
            var rv = new Array(len);
            for (var i = 0; i < len; i++) {
                rv[i] = arr[start + i];
                if (rv[i] > 127) {
                    rv[i] |= 4294967168;
                }
            }
            return rv;
        }
    } else {
        throw new TypeError('Invalid array.');
    }
}
exports.u82i8 = u82i8;
function wrapFloat(a) {
    if (a > 3.4028234663852886e+38) {
        return Number.POSITIVE_INFINITY;
    }
    if (0 < a && a < 1.401298464324817e-45) {
        return 0;
    }
    if (a < -3.4028234663852886e+38) {
        return Number.NEGATIVE_INFINITY;
    }
    if (0 > a && a > -1.401298464324817e-45) {
        return 0;
    }
    return a;
}
exports.wrapFloat = wrapFloat;
function chars2jsStr(jvmCarr, offset, count) {
    if (offset === void 0) {
        offset = 0;
    }
    if (count === void 0) {
        count = jvmCarr.array.length;
    }
    var i, carrArray = jvmCarr.array, rv = '', endOffset = offset + count;
    for (i = offset; i < endOffset; i++) {
        rv += String.fromCharCode(carrArray[i]);
    }
    return rv;
}
exports.chars2jsStr = chars2jsStr;
function bytestr2Array(byteStr) {
    var rv = [];
    for (var i = 0; i < byteStr.length; i++) {
        rv.push(byteStr.charCodeAt(i));
    }
    return rv;
}
exports.bytestr2Array = bytestr2Array;
function array2bytestr(byteArray) {
    var rv = '';
    for (var i = 0; i < byteArray.length; i++) {
        rv += String.fromCharCode(byteArray[i]);
    }
    return rv;
}
exports.array2bytestr = array2bytestr;
(function (FlagMasks) {
    FlagMasks[FlagMasks['PUBLIC'] = 1] = 'PUBLIC';
    FlagMasks[FlagMasks['PRIVATE'] = 2] = 'PRIVATE';
    FlagMasks[FlagMasks['PROTECTED'] = 4] = 'PROTECTED';
    FlagMasks[FlagMasks['STATIC'] = 8] = 'STATIC';
    FlagMasks[FlagMasks['FINAL'] = 16] = 'FINAL';
    FlagMasks[FlagMasks['SYNCHRONIZED'] = 32] = 'SYNCHRONIZED';
    FlagMasks[FlagMasks['SUPER'] = 32] = 'SUPER';
    FlagMasks[FlagMasks['VOLATILE'] = 64] = 'VOLATILE';
    FlagMasks[FlagMasks['TRANSIENT'] = 128] = 'TRANSIENT';
    FlagMasks[FlagMasks['VARARGS'] = 128] = 'VARARGS';
    FlagMasks[FlagMasks['NATIVE'] = 256] = 'NATIVE';
    FlagMasks[FlagMasks['INTERFACE'] = 512] = 'INTERFACE';
    FlagMasks[FlagMasks['ABSTRACT'] = 1024] = 'ABSTRACT';
    FlagMasks[FlagMasks['STRICT'] = 2048] = 'STRICT';
}(exports.FlagMasks || (exports.FlagMasks = {})));
var FlagMasks = exports.FlagMasks;
var Flags = function () {
    function Flags(byte) {
        this.byte = byte;
    }
    Flags.prototype.isPublic = function () {
        return (this.byte & FlagMasks.PUBLIC) > 0;
    };
    Flags.prototype.isPrivate = function () {
        return (this.byte & FlagMasks.PRIVATE) > 0;
    };
    Flags.prototype.isProtected = function () {
        return (this.byte & FlagMasks.PROTECTED) > 0;
    };
    Flags.prototype.isStatic = function () {
        return (this.byte & FlagMasks.STATIC) > 0;
    };
    Flags.prototype.isFinal = function () {
        return (this.byte & FlagMasks.FINAL) > 0;
    };
    Flags.prototype.isSynchronized = function () {
        return (this.byte & FlagMasks.SYNCHRONIZED) > 0;
    };
    Flags.prototype.isSuper = function () {
        return (this.byte & FlagMasks.SUPER) > 0;
    };
    Flags.prototype.isVolatile = function () {
        return (this.byte & FlagMasks.VOLATILE) > 0;
    };
    Flags.prototype.isTransient = function () {
        return (this.byte & FlagMasks.TRANSIENT) > 0;
    };
    Flags.prototype.isNative = function () {
        return (this.byte & FlagMasks.NATIVE) > 0;
    };
    Flags.prototype.isInterface = function () {
        return (this.byte & FlagMasks.INTERFACE) > 0;
    };
    Flags.prototype.isAbstract = function () {
        return (this.byte & FlagMasks.ABSTRACT) > 0;
    };
    Flags.prototype.isStrict = function () {
        return (this.byte & FlagMasks.STRICT) > 0;
    };
    Flags.prototype.setNative = function (n) {
        if (n) {
            this.byte = this.byte | FlagMasks.NATIVE;
        } else {
            this.byte = this.byte & ~FlagMasks.NATIVE;
        }
    };
    Flags.prototype.isVarArgs = function () {
        return (this.byte & FlagMasks.VARARGS) > 0;
    };
    Flags.prototype.getRawByte = function () {
        return this.byte;
    };
    return Flags;
}();
exports.Flags = Flags;
function initialValue(type_str) {
    if (type_str === 'J')
        return gLong_1['default'].ZERO;
    var c = type_str[0];
    if (c === '[' || c === 'L')
        return null;
    return 0;
}
exports.initialValue = initialValue;
function ext_classname(str) {
    return descriptor2typestr(str).replace(/\//g, '.');
}
exports.ext_classname = ext_classname;
function int_classname(str) {
    return typestr2descriptor(str.replace(/\./g, '/'));
}
exports.int_classname = int_classname;
function verify_int_classname(str) {
    var array_nesting = str.match(/^\[*/)[0].length;
    if (array_nesting > 255) {
        return false;
    }
    if (array_nesting > 0) {
        str = str.slice(array_nesting);
    }
    if (str[0] === 'L') {
        if (str[str.length - 1] !== ';') {
            return false;
        }
        str = str.slice(1, -1);
    }
    if (str in exports.internal2external) {
        return true;
    }
    if (str.match(/\/{2,}/)) {
        return false;
    }
    var parts = str.split('/');
    for (var i = 0; i < parts.length; i++) {
        if (parts[i].match(/[^$_a-z0-9]/i)) {
            return false;
        }
    }
    return true;
}
exports.verify_int_classname = verify_int_classname;
exports.internal2external = {
    B: 'byte',
    C: 'char',
    D: 'double',
    F: 'float',
    I: 'int',
    J: 'long',
    S: 'short',
    V: 'void',
    Z: 'boolean'
};
exports.external2internal = {};
for (var k in exports.internal2external) {
    exports.external2internal[exports.internal2external[k]] = k;
}
function getTypes(methodDescriptor) {
    var i = 0, types = [], endIdx;
    for (i = 0; i < methodDescriptor.length; i++) {
        switch (methodDescriptor.charAt(i)) {
        case '(':
        case ')':
            break;
        case 'L':
            endIdx = methodDescriptor.indexOf(';', i);
            types.push(methodDescriptor.slice(i, endIdx + 1));
            i = endIdx;
            break;
        case '[':
            endIdx = i + 1;
            while (methodDescriptor.charAt(endIdx) === '[') {
                endIdx++;
            }
            if (methodDescriptor.charAt(endIdx) === 'L') {
                endIdx = methodDescriptor.indexOf(';', endIdx);
                types.push(methodDescriptor.slice(i, endIdx + 1));
            } else {
                types.push(methodDescriptor.slice(i, endIdx + 1));
            }
            i = endIdx;
            break;
        default:
            types.push(methodDescriptor.charAt(i));
            break;
        }
    }
    return types;
}
exports.getTypes = getTypes;
function get_component_type(type_str) {
    return type_str.slice(1);
}
exports.get_component_type = get_component_type;
function is_array_type(type_str) {
    return type_str[0] === '[';
}
exports.is_array_type = is_array_type;
function is_primitive_type(type_str) {
    return type_str in exports.internal2external;
}
exports.is_primitive_type = is_primitive_type;
function is_reference_type(type_str) {
    return type_str[0] === 'L';
}
exports.is_reference_type = is_reference_type;
function descriptor2typestr(type_str) {
    var c = type_str[0];
    if (c in exports.internal2external)
        return exports.internal2external[c];
    if (c === 'L')
        return type_str.slice(1, -1);
    if (c === '[')
        return type_str;
    throw new Error('Unrecognized type string: ' + type_str);
}
exports.descriptor2typestr = descriptor2typestr;
function carr2descriptor(carr) {
    var c = carr.shift();
    if (c == null)
        return null;
    if (exports.internal2external[c] !== void 0)
        return c;
    if (c === 'L') {
        var rv = 'L';
        while ((c = carr.shift()) !== ';') {
            rv += c;
        }
        return rv + ';';
    }
    if (c === '[')
        return '[' + carr2descriptor(carr);
    carr.unshift(c);
    throw new Error('Unrecognized descriptor: ' + carr.join(''));
}
exports.carr2descriptor = carr2descriptor;
function typestr2descriptor(type_str) {
    if (exports.external2internal[type_str] !== void 0) {
        return exports.external2internal[type_str];
    } else if (type_str[0] === '[') {
        return type_str;
    } else {
        return 'L' + type_str + ';';
    }
}
exports.typestr2descriptor = typestr2descriptor;
function unboxArguments(thread, paramTypes, args) {
    var rv = [], i, type, arg;
    for (i = 0; i < paramTypes.length; i++) {
        type = paramTypes[i];
        arg = args[i];
        if (is_primitive_type(type)) {
            rv.push(arg.unbox());
            if (type === 'J' || type === 'D') {
                rv.push(null);
            }
        } else {
            rv.push(arg);
        }
    }
    return rv;
}
exports.unboxArguments = unboxArguments;
function createMethodType(thread, cl, descriptor, cb) {
    cl.initializeClass(thread, 'Ljava/lang/invoke/MethodHandleNatives;', function (cdata) {
        if (cdata !== null) {
            var jsCons = cdata.getConstructor(thread), classes = getTypes(descriptor);
            classes.push('[Ljava/lang/Class;');
            cl.resolveClasses(thread, classes, function (classMap) {
                var types = classes.map(function (cls) {
                    return classMap[cls].getClassObject(thread);
                });
                types.pop();
                var rtype = types.pop(), clsArrCons = classMap['[Ljava/lang/Class;'].getConstructor(thread), ptypes = new clsArrCons(thread, types.length);
                ptypes.array = types;
                jsCons['java/lang/invoke/MethodHandleNatives/findMethodHandleType(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/invoke/MethodType;'](thread, [
                    rtype,
                    ptypes
                ], cb);
            });
        }
    });
}
exports.createMethodType = createMethodType;
function getMethodDescriptorWordSize(descriptor) {
    var parsedDescriptor = getTypes(descriptor), words = parsedDescriptor.length - 1, i, p;
    parsedDescriptor.pop();
    for (i = 0; i < parsedDescriptor.length; i++) {
        p = parsedDescriptor[i];
        if (p === 'D' || p === 'J') {
            words++;
        }
    }
    return words;
}
exports.getMethodDescriptorWordSize = getMethodDescriptorWordSize;
function getDescriptorString(rtype, ptypes) {
    var rv = '(';
    if (ptypes !== undefined && ptypes !== null) {
        ptypes.array.forEach(function (ptype) {
            rv += ptype.$cls.getInternalName();
        });
    }
    rv += ')' + rtype.$cls.getInternalName();
    return rv;
}
exports.getDescriptorString = getDescriptorString;
function getLoader(thread, jclo) {
    if (jclo != null && jclo.$loader != null) {
        return jclo.$loader;
    }
    return thread.getBsCl();
}
exports.getLoader = getLoader;
function arraycopyNoCheck(src, srcPos, dest, destPos, length) {
    var j = destPos;
    var end = srcPos + length;
    for (var i = srcPos; i < end; i++) {
        dest.array[j++] = src.array[i];
    }
}
exports.arraycopyNoCheck = arraycopyNoCheck;
function arraycopyCheck(thread, src, srcPos, dest, destPos, length) {
    var j = destPos;
    var end = srcPos + length;
    var destCompCls = dest.getClass().getComponentClass();
    for (var i = srcPos; i < end; i++) {
        if (src.array[i] === null || src.array[i].getClass().isCastable(destCompCls)) {
            dest.array[j] = src.array[i];
        } else {
            thread.throwNewException('Ljava/lang/ArrayStoreException;', 'Array element in src cannot be cast to dest array type.');
            return;
        }
        j++;
    }
}
exports.arraycopyCheck = arraycopyCheck;
function initString(cl, str) {
    var carr = initCarr(cl, str);
    var strCons = cl.getResolvedClass('Ljava/lang/String;').getConstructor(null);
    var strObj = new strCons(null);
    strObj['java/lang/String/value'] = carr;
    return strObj;
}
exports.initString = initString;
function initCarr(cl, str) {
    var arrClsCons = cl.getInitializedClass(null, '[C').getConstructor(null), carr = new arrClsCons(null, str.length), carrArray = carr.array;
    for (var i = 0; i < str.length; i++) {
        carrArray[i] = str.charCodeAt(i);
    }
    return carr;
}
exports.initCarr = initCarr;
function newArrayFromClass(thread, clazz, length) {
    return new (clazz.getConstructor(thread))(thread, length);
}
exports.newArrayFromClass = newArrayFromClass;
function newArray(thread, cl, desc, length) {
    var cls = cl.getInitializedClass(thread, desc);
    return newArrayFromClass(thread, cls, length);
}
exports.newArray = newArray;
function multiNewArray(thread, cl, desc, lengths) {
    var cls = cl.getInitializedClass(thread, desc);
    return new (cls.getConstructor(thread))(thread, lengths);
}
exports.multiNewArray = multiNewArray;
function newObjectFromClass(thread, clazz) {
    return new (clazz.getConstructor(thread))(thread);
}
exports.newObjectFromClass = newObjectFromClass;
function newObject(thread, cl, desc) {
    var cls = cl.getInitializedClass(thread, desc);
    return newObjectFromClass(thread, cls);
}
exports.newObject = newObject;
function getStaticFields(thread, cl, desc) {
    return cl.getInitializedClass(thread, desc).getConstructor(thread);
}
exports.getStaticFields = getStaticFields;
function newArrayFromDataWithClass(thread, cls, data) {
    var arr = newArrayFromClass(thread, cls, 0);
    arr.array = data;
    return arr;
}
exports.newArrayFromDataWithClass = newArrayFromDataWithClass;
function newArrayFromData(thread, cl, desc, data) {
    var arr = newArray(thread, cl, desc, 0);
    arr.array = data;
    return arr;
}
exports.newArrayFromData = newArrayFromData;
function boxClassName(primType) {
    switch (primType) {
    case 'B':
        return 'Ljava/lang/Byte;';
    case 'C':
        return 'Ljava/lang/Character;';
    case 'D':
        return 'Ljava/lang/Double;';
    case 'F':
        return 'Ljava/lang/Float;';
    case 'I':
        return 'Ljava/lang/Integer;';
    case 'J':
        return 'Ljava/lang/Long;';
    case 'S':
        return 'Ljava/lang/Short;';
    case 'Z':
        return 'Ljava/lang/Boolean;';
    case 'V':
        return 'Ljava/lang/Void;';
    default:
        throw new Error('Tried to box a non-primitive class: ' + this.className);
    }
}
exports.boxClassName = boxClassName;
function boxPrimitiveValue(thread, type, val) {
    var primCls = thread.getBsCl().getInitializedClass(thread, boxClassName(type)), primClsCons = primCls.getConstructor(thread);
    return primClsCons.box(val);
}
exports.boxPrimitiveValue = boxPrimitiveValue;
function boxArguments(thread, objArrCls, descriptor, data, isStatic, skipArgs) {
    if (skipArgs === void 0) {
        skipArgs = 0;
    }
    var paramTypes = getTypes(descriptor), boxedArgs = newArrayFromClass(thread, objArrCls, paramTypes.length - (isStatic ? 1 : 2) - skipArgs), i, j = 0, boxedArgsArr = boxedArgs.array, type;
    paramTypes.pop();
    if (!isStatic) {
        paramTypes.shift();
    }
    if (skipArgs > 0) {
        paramTypes = paramTypes.slice(skipArgs);
        data = data.slice(skipArgs);
    }
    for (i = 0; i < paramTypes.length; i++) {
        type = paramTypes[i];
        switch (type[0]) {
        case '[':
        case 'L':
            boxedArgsArr[i] = data[j];
            break;
        case 'J':
        case 'D':
            boxedArgsArr[i] = boxPrimitiveValue(thread, type, data[j]);
            j++;
            break;
        default:
            boxedArgsArr[i] = boxPrimitiveValue(thread, type, data[j]);
            break;
        }
        j++;
    }
    return boxedArgs;
}
exports.boxArguments = boxArguments;
function forwardResult(thread) {
    return function (e, rv) {
        if (e) {
            thread.throwException(e);
        } else {
            thread.asyncReturn(rv);
        }
    };
}
exports.forwardResult = forwardResult;
//# sourceMappingURL=util.js.map