"use strict";function validateThreadTransition(a,b){var c=exports.validTransitions.hasOwnProperty(""+a)&&exports.validTransitions[a].hasOwnProperty(""+b);return c}function validateReturnValue(a,b,c,d,e,f,g){if("java/lang/invoke/MethodHandle/invokeBasic([Ljava/lang/Object;)Ljava/lang/Object;"===b.fullSignature)return!0;var h;if(util_1.is_primitive_type(c))switch(c){case"Z":assert_1["default"](void 0===g,"Second return value must be undefined for Boolean type."),assert_1["default"](1===f||0===f,"Booleans must be 0 or 1.");break;case"B":assert_1["default"](void 0===g,"Second return value must be undefined for Byte type."),assert_1["default"](f<=127&&f>=-128,"Byte value for method "+b.name+" is out of bounds: "+f);break;case"C":assert_1["default"](void 0===g,"Second return value must be undefined for Character type."),assert_1["default"](f<=65535&&f>=0,"Character value is out of bounds: "+f);break;case"S":assert_1["default"](void 0===g,"Second return value must be undefined for Short type."),assert_1["default"](f<=32767&&f>=-32768,"Short value is out of bounds: "+f);break;case"I":assert_1["default"](void 0===g,"Second return value must be undefined for Int type."),assert_1["default"](f<=2147483647&&f>=-2147483648,"Int value is out of bounds: "+f);break;case"J":assert_1["default"](null===g,"Second return value must be NULL for Long type."),assert_1["default"](f.lessThanOrEqual(gLong_1["default"].MAX_VALUE)&&f.greaterThanOrEqual(gLong_1["default"].MIN_VALUE),"Long value is out of bounds: "+f);break;case"F":assert_1["default"](void 0===g,"Second return value must be undefined for Float type."),assert_1["default"](util_1.wrapFloat(f)===f||isNaN(f)&&isNaN(util_1.wrapFloat(f)),"Float value is out of bounds: "+f);break;case"D":assert_1["default"](null===g,"Second return value must be NULL for Double type."),assert_1["default"]("number"==typeof f,"Invalid double value: "+f);break;case"V":assert_1["default"](void 0===f&&void 0===g,"Return values must be undefined for Void type")}else util_1.is_array_type(c)?(assert_1["default"](void 0===g,"Second return value must be undefined for array type."),assert_1["default"](null===f||"object"==typeof f&&"function"==typeof f.getClass,"Invalid array object: "+f),null!=f&&(h=assertClassInitializedOrResolved(a,e,c,!0),assert_1["default"](f.getClass().isCastable(h),"Return value of type "+f.getClass().getInternalName()+" unable to be cast to return type "+c+"."))):(assert_1["default"](util_1.is_reference_type(c),"Invalid reference type: "+c),assert_1["default"](void 0===g,"Second return value must be undefined for reference type."),assert_1["default"](null===f||f instanceof d.getInitializedClass(a,"Ljava/lang/Object;").getConstructor(a),"Reference return type must be an instance of Object; value: "+f),null!=f&&(h=assertClassInitializedOrResolved(a,e,c,!1),h.accessFlags.isInterface()||assertClassInitializedOrResolved(a,e,c,!0),assert_1["default"](f.getClass().isCastable(h),"Unable to cast "+f.getClass().getInternalName()+" to "+c+".")));return!0}function assertClassInitializedOrResolved(a,b,c,d){for(var e=null;null===e;)e=d?b.getInitializedClass(a,c):b.getResolvedClass(c),null!==b.getLoaderObject()?b=null===b.getLoaderObject()["java/lang/ClassLoader/parent"]?a.getBsCl():b.getLoaderObject()["java/lang/ClassLoader/parent"].$loader:assert_1["default"](null!==e,"Unable to get initialized class for type "+c+".");return e}function printConstantPoolItem(a){switch(a.getType()){case enums_1.ConstantPoolItemType.METHODREF:var b=a;return util_1.ext_classname(b.classInfo.name)+"."+b.signature;case enums_1.ConstantPoolItemType.INTERFACE_METHODREF:var c=a;return util_1.ext_classname(c.classInfo.name)+"."+c.signature;case enums_1.ConstantPoolItemType.FIELDREF:var d=a;return util_1.ext_classname(d.classInfo.name)+"."+d.nameAndTypeInfo.name+":"+util_1.ext_classname(d.nameAndTypeInfo.descriptor);case enums_1.ConstantPoolItemType.NAME_AND_TYPE:var e=a;return e.name+":"+e.descriptor;case enums_1.ConstantPoolItemType.CLASS:var f=a;return util_1.ext_classname(f.name);default:return logging_1.debug_var(a.value)}}function annotateOpcode(a,b,c,d){return exports.OpcodeLayoutPrinters[enums_1.OpcodeLayouts[a]](b,c,d)}var enums_1=require("./enums"),assert_1=require("./assert"),gLong_1=require("./gLong"),opcodes_1=require("./opcodes"),logging_1=require("./logging"),logging=require("./logging"),util_1=require("./util"),debug=logging.debug,vtrace=logging.vtrace,trace=logging.trace,maxMethodResumes=1e4,methodResumesLeft=maxMethodResumes,numSamples=1,PreAllocatedStack=function(){function a(a){this.curr=0,this.store=new Array(a)}return a.prototype.push=function(a){this.store[this.curr++]=a},a.prototype.pushAll=function(){for(var a=arguments.length,b=0;b<a;b++)this.store[this.curr++]=arguments[b]},a.prototype.pushWithNull=function(a){this.store[this.curr]=a,this.curr+=2},a.prototype.push6=function(a,b,c,d,e,f){this.store[this.curr++]=a,this.store[this.curr++]=b,this.store[this.curr++]=c,this.store[this.curr++]=d,this.store[this.curr++]=e,this.store[this.curr++]=f},a.prototype.swap=function(){var a=this.store[this.curr-1];this.store[this.curr-1]=this.store[this.curr-2],this.store[this.curr-2]=a},a.prototype.dup=function(){this.store[this.curr]=this.store[this.curr-1],this.curr++},a.prototype.dup2=function(){this.store[this.curr]=this.store[this.curr-2],this.store[this.curr+1]=this.store[this.curr-1],this.curr+=2},a.prototype.dup_x1=function(){var a=this.store[this.curr-1];this.store[this.curr-1]=this.store[this.curr-2],this.store[this.curr]=a,this.store[this.curr-2]=a,this.curr++},a.prototype.dup_x2=function(){var a=this.store[this.curr-1];this.store[this.curr-1]=this.store[this.curr-2],this.store[this.curr-2]=this.store[this.curr-3],this.store[this.curr]=a,this.store[this.curr-3]=a,this.curr++},a.prototype.dup2_x1=function(){var a=this.store[this.curr-1],b=this.store[this.curr-2];this.store[this.curr]=b,this.store[this.curr+1]=a,this.store[this.curr-1]=this.store[this.curr-3],this.store[this.curr-2]=a,this.store[this.curr-3]=b,this.curr+=2},a.prototype.pop=function(){return this.store[--this.curr]},a.prototype.pop2=function(){return this.curr-=2,this.store[this.curr]},a.prototype.bottom=function(){return this.store[0]},a.prototype.top=function(){return this.store[this.curr-1]},a.prototype.fromTop=function(a){return this.store[this.curr-(a+1)]},a.prototype.sliceFromBottom=function(a){return this.store.slice(a,this.curr)},a.prototype.sliceFromTop=function(a){return this.store.slice(this.curr-a,this.curr)},a.prototype.dropFromTop=function(a){this.curr-=a},a.prototype.sliceAndDropFromTop=function(a){var b=this.curr;return this.curr-=a,this.store.slice(b-a,b)},a.prototype.getRaw=function(){return this.store.slice(0,this.curr)},a.prototype.clear=function(){this.curr=0},a}();exports.PreAllocatedStack=PreAllocatedStack;var jitUtil={isNull:opcodes_1.isNull,resolveCPItem:opcodes_1.resolveCPItem,throwException:opcodes_1.throwException,gLong:gLong_1["default"],float2int:util_1.float2int,wrapFloat:util_1.wrapFloat,Constants:enums_1.Constants},BytecodeStackFrame=function(){function a(a,b){this.pc=0,this.returnToThreadLoop=!1,this.lockedMethodLock=!1,this.type=enums_1.StackFrameType.BYTECODE,this.method=a,a.incrBBEntries(),assert_1["default"](!a.accessFlags.isNative(),"Cannot run a native method using a BytecodeStackFrame."),assert_1["default"](!a.accessFlags.isAbstract(),"Cannot run an abstract method!"),this.locals=b,this.opStack=new PreAllocatedStack(a.getCodeAttribute().getMaxStack())}return a.prototype.run=function(a){var b=this,c=this.method,d=this.method.getCodeAttribute().getCode(),e=opcodes_1.LookupTable;if(c.accessFlags.isSynchronized()&&!this.lockedMethodLock&&(this.lockedMethodLock=c.methodLock(a,this).enter(a,function(){b.lockedMethodLock=!0}),!this.lockedMethodLock))return void assert_1["default"](a.getStatus()===enums_1.ThreadStatus.BLOCKED,"Failed to enter a monitor. Thread must be BLOCKED.");if(this.returnToThreadLoop=!1,a.getJVM().isJITDisabled())for(;!this.returnToThreadLoop;){var f=d[this.pc];e[f](a,this,d)}else for(;!this.returnToThreadLoop;){var g=c.getOp(this.pc,d,a);"function"==typeof g?g(this,a,jitUtil):e[g](a,this,d)}},a.prototype.scheduleResume=function(a,b,c){var d=this.method.getCodeAttribute().getCode()[this.pc];switch(d){case enums_1.OpCode.INVOKEINTERFACE:case enums_1.OpCode.INVOKEINTERFACE_FAST:this.pc+=5;break;case enums_1.OpCode.INVOKESPECIAL:case enums_1.OpCode.INVOKESTATIC:case enums_1.OpCode.INVOKEVIRTUAL:case enums_1.OpCode.INVOKESTATIC_FAST:case enums_1.OpCode.INVOKENONVIRTUAL_FAST:case enums_1.OpCode.INVOKEVIRTUAL_FAST:case enums_1.OpCode.INVOKEHANDLE:case enums_1.OpCode.INVOKEBASIC:case enums_1.OpCode.LINKTOSPECIAL:case enums_1.OpCode.LINKTOVIRTUAL:case enums_1.OpCode.INVOKEDYNAMIC:case enums_1.OpCode.INVOKEDYNAMIC_FAST:this.pc+=3;break;default:assert_1["default"](!1,"Resuming from a non-invoke opcode! Opcode: "+enums_1.OpCode[d]+" ["+d+"]")}void 0!==b&&this.opStack.push(b),void 0!==c&&this.opStack.push(c)},a.prototype.scheduleException=function(a,b){for(var c,d=this.method.getCodeAttribute(),e=this.pc,f=this.method,g=d.exceptionHandlers,h=b.getClass(),i=0;i<g.length;i++){var j=g[i];if(j.startPC<=e&&e<j.endPC){if("<any>"===j.catchType){c=j;break}var k=f.cls.getLoader().getResolvedClass(j.catchType);if(null==k){for(var l=[],m=0;m<g.length;m++){var n=g[m];"<any>"!==n.catchType&&l.push(n.catchType)}return a.setStatus(enums_1.ThreadStatus.ASYNC_WAITING),f.cls.getLoader().resolveClasses(a,l,function(c){null!==c&&a.throwException(b)}),!0}if(h.isCastable(k)){c=j;break}}}return null!=c?(this.opStack.clear(),this.opStack.push(b),this.pc=c.handlerPC,!0):(f.accessFlags.isSynchronized()&&f.methodLock(a,this).exit(a),!1)},a.prototype.getLoader=function(){return this.method.cls.getLoader()},a.prototype.getStackTraceFrame=function(){return{method:this.method,pc:this.pc,stack:this.opStack.sliceFromBottom(0),locals:this.locals.slice(0)}},a}();exports.BytecodeStackFrame=BytecodeStackFrame;var NativeStackFrame=function(){function a(a,b){this.type=enums_1.StackFrameType.NATIVE,this.method=a,this.args=b,assert_1["default"](a.accessFlags.isNative()),this.nativeMethod=a.getNativeFunction()}return a.prototype.run=function(a){var b=this.nativeMethod.apply(null,this.method.convertArgs(a,this.args));if(a.getStatus()===enums_1.ThreadStatus.RUNNABLE&&a.currentMethod()===this.method){var c=this.method.returnType;switch(c){case"J":case"D":a.asyncReturn(b,null);break;case"Z":a.asyncReturn(b?1:0);break;default:a.asyncReturn(b)}}},a.prototype.scheduleResume=function(a,b,c){},a.prototype.scheduleException=function(a,b){return!1},a.prototype.getStackTraceFrame=function(){return{method:this.method,pc:-1,stack:[],locals:[]}},a.prototype.getLoader=function(){return this.method.cls.getLoader()},a}();exports.NativeStackFrame=NativeStackFrame;var InternalStackFrame=function(){function a(a){this.isException=!1,this.type=enums_1.StackFrameType.INTERNAL,this.cb=a}return a.prototype.run=function(a){a.framePop(),a.setStatus(enums_1.ThreadStatus.ASYNC_WAITING),this.isException?this.cb(this.val):this.cb(null,this.val)},a.prototype.scheduleResume=function(a,b){this.isException=!1,this.val=b},a.prototype.scheduleException=function(a,b){return this.isException=!0,this.val=b,!0},a.prototype.getStackTraceFrame=function(){return null},a.prototype.getLoader=function(){throw new Error("Internal stack frames have no loader.")},a}();exports.InternalStackFrame=InternalStackFrame;var JVMThread=function(){function a(a,b,c){this.status=enums_1.ThreadStatus.NEW,this.stack=[],this.interrupted=!1,this.monitor=null,this.jvm=a,this.bsCl=a.getBootstrapClassLoader(),this.tpool=b,this.jvmThreadObj=c}return a.prototype.getJVMObject=function(){return this.jvmThreadObj},a.prototype.isDaemon=function(){return 0!==this.jvmThreadObj["java/lang/Thread/daemon"]},a.prototype.getPriority=function(){return this.jvmThreadObj["java/lang/Thread/priority"]},a.prototype.setJVMObject=function(a){a["java/lang/Thread/threadStatus"]=this.jvmThreadObj["java/lang/Thread/threadStatus"],this.jvmThreadObj=a},a.prototype.getRef=function(){return this.jvmThreadObj.ref},a.prototype.isInterrupted=function(){return this.interrupted},a.prototype.currentMethod=function(){for(var a,b=this.stack,c=b.length;--c>=0;)if(a=b[c].getStackTraceFrame().method,null!==a)return a;return null},a.prototype.setInterrupted=function(a){this.interrupted=a},a.prototype.getBsCl=function(){return this.bsCl},a.prototype.getLoader=function(){var a=this.stack[this.stack.length-1].getLoader();if(a)return a;for(var b=this.stack.length,c=2;c<=b;c++)if(a=this.stack[b-c].getLoader())return a;throw new Error("Unable to find loader.")},a.prototype["import"]=function(a,b,c){var d=this;void 0===c&&(c=!0);var e=this.getLoader();if(this.setStatus(enums_1.ThreadStatus.ASYNC_WAITING),Array.isArray(a)){var f=[];util_1.asyncForEach(a,function(a,b){d._import(a,e,function(a){f.push(a),b()},c)},function(a){b(f)})}else this._import(a,e,b,c)},a.prototype._import=function(a,b,c,d){var e=this,f=b.getInitializedClass(this,a);f?setImmediate(function(){return c(f.getConstructor(e))}):b.initializeClass(this,a,function(a){a&&c(a.getConstructor(e))},d)},a.prototype.getJVM=function(){return this.jvm},a.prototype.getThreadPool=function(){return this.tpool},a.prototype.getStackTrace=function(){var a,b,c=[];for(a=0;a<this.stack.length;a++)b=this.stack[a].getStackTraceFrame(),null!=b&&c.push(b);return c},a.prototype.getPrintableStackTrace=function(){var a="";return this.getStackTrace().reverse().forEach(function(b){if(a+="\tat "+util_1.ext_classname(b.method.cls.getInternalName())+"::"+b.method.name+"(",b.pc>=0){var c=b.method.getCodeAttribute(),d=c.getAttribute("LineNumberTable"),e=b.method.cls.getAttribute("SourceFile");if(a+=null!=e?e.filename:"unknown",null!=d){var f=d.getLineNumber(b.pc);a+=":"+f,a+=" Bytecode offset: "+b.pc}}else a+="native";a+=")\n"}),a},a.prototype.run=function(){var a=this.stack,b=(new Date).getTime();for(methodResumesLeft=maxMethodResumes;this.status===enums_1.ThreadStatus.RUNNABLE&&a.length>0;){var c=a[a.length-1];if(c.run(this),0===--methodResumesLeft){var d=(new Date).getTime(),e=d-b,f=maxMethodResumes/e*this.jvm.getResponsiveness()|0;maxMethodResumes=(f+numSamples*maxMethodResumes)/(numSamples+1)|0,maxMethodResumes<=0&&(maxMethodResumes=10),numSamples++,this.tpool.quantumOver(this);break}}0===a.length&&this.setStatus(enums_1.ThreadStatus.TERMINATED)},a.prototype.sanityCheck=function(){switch(this.status){case enums_1.ThreadStatus.NEW:return!0;case enums_1.ThreadStatus.RUNNABLE:return assert_1["default"](this.stack.length>0,"A runnable thread must not have an empty stack."),!0;case enums_1.ThreadStatus.TIMED_WAITING:return assert_1["default"](null!=this.monitor&&this.monitor.isTimedWaiting(this),"A timed waiting thread must be waiting on a monitor."),!0;case enums_1.ThreadStatus.WAITING:return assert_1["default"](null!=this.monitor&&this.monitor.isWaiting(this),"A waiting thread must be waiting on a monitor."),!0;case enums_1.ThreadStatus.BLOCKED:case enums_1.ThreadStatus.UNINTERRUPTABLY_BLOCKED:return assert_1["default"](null!=this.monitor&&this.monitor.isBlocked(this),"A blocked thread must be blocked on a monitor"),!0;case enums_1.ThreadStatus.ASYNC_WAITING:return!0;case enums_1.ThreadStatus.TERMINATED:return assert_1["default"](0===this.stack.length,"A terminated thread must have an empty stack."),!0;case enums_1.ThreadStatus.PARKED:return assert_1["default"](this.jvm.getParker().isParked(this),"A parked thread must be parked."),!0;default:return!1}},a.prototype.rawSetStatus=function(a){var b=0,c=this.status;switch(logging_1.logLevel===logging_1.LogLevel.VTRACE,assert_1["default"](validateThreadTransition(c,a),"Invalid thread transition: "+enums_1.ThreadStatus[c]+" => "+enums_1.ThreadStatus[a]),this.status=a,a){case enums_1.ThreadStatus.NEW:b|=enums_1.JVMTIThreadState.ALIVE;break;case enums_1.ThreadStatus.RUNNABLE:b|=enums_1.JVMTIThreadState.RUNNABLE;break;case enums_1.ThreadStatus.BLOCKED:case enums_1.ThreadStatus.UNINTERRUPTABLY_BLOCKED:b|=enums_1.JVMTIThreadState.BLOCKED_ON_MONITOR_ENTER;break;case enums_1.ThreadStatus.WAITING:case enums_1.ThreadStatus.ASYNC_WAITING:case enums_1.ThreadStatus.PARKED:b|=enums_1.JVMTIThreadState.WAITING_INDEFINITELY;break;case enums_1.ThreadStatus.TIMED_WAITING:b|=enums_1.JVMTIThreadState.WAITING_WITH_TIMEOUT;break;case enums_1.ThreadStatus.TERMINATED:b|=enums_1.JVMTIThreadState.TERMINATED;break;default:b=enums_1.JVMTIThreadState.RUNNABLE}this.jvmThreadObj["java/lang/Thread/threadStatus"]=b,this.tpool.statusChange(this,c,this.status)},a.prototype.setStatus=function(a,b){if(void 0===b&&(b=null),this.status!==a){this.status;this.monitor=b,a!==enums_1.ThreadStatus.TERMINATED?this.rawSetStatus(a):this.exit(),assert_1["default"](this.sanityCheck(),"Invalid thread status.")}},a.prototype.exit=function(){var a=this,b=this.jvmThreadObj.getMonitor();if(!b.isBlocked(this)&&b.getOwner()!==this&&this.status!==enums_1.ThreadStatus.TERMINATED)if(0===this.stack.length){if(this.setStatus(enums_1.ThreadStatus.ASYNC_WAITING),this.jvm.hasVMBooted()){var c=function(){a.jvmThreadObj["exit()V"](a,null,function(c){b.notifyAll(a),b.exit(a),a.rawSetStatus(enums_1.ThreadStatus.TERMINATED)})};b.enter(this,c)&&c()}}else{for(;this.stack.length>0;)this.stack.pop();this.rawSetStatus(enums_1.ThreadStatus.TERMINATED)}},a.prototype.signalPriorityChange=function(){this.tpool.priorityChange(this)},a.prototype.getMonitorBlock=function(){return this.monitor},a.prototype.getStatus=function(){return this.status},a.prototype.asyncReturn=function(a,b){var c=this.stack;assert_1["default"](this.status===enums_1.ThreadStatus.RUNNABLE||this.status===enums_1.ThreadStatus.ASYNC_WAITING),assert_1["default"]("boolean"!=typeof a&&null==b);var d=c.pop();if(d.type!=enums_1.StackFrameType.INTERNAL){var e=d;d.type===enums_1.StackFrameType.BYTECODE,assert_1["default"](validateReturnValue(this,e.method,e.method.returnType,this.bsCl,e.method.cls.getLoader(),a,b),"Invalid return value for method "+e.method.getFullSignature())}var f=c.length-1;f>=0&&c[f].scheduleResume(this,a,b),this.setStatus(enums_1.ThreadStatus.RUNNABLE)},a.prototype.framePop=function(){this.stack.pop()},a.prototype.throwException=function(a){assert_1["default"](this.status===enums_1.ThreadStatus.RUNNABLE||this.status===enums_1.ThreadStatus.ASYNC_WAITING,"Tried to throw exception while thread was in state "+enums_1.ThreadStatus[this.status]);var b=this.stack,c=b.length-1;if(c>=0)for(b[c].type===enums_1.StackFrameType.INTERNAL&&(b.pop(),c--),this.setStatus(enums_1.ThreadStatus.RUNNABLE);b.length>0&&!b[c].scheduleException(this,a);)b.pop(),c--;0===b.length&&this.handleUncaughtException(a)},a.prototype.throwNewException=function(a,b){var c=this,d=this.getLoader().getInitializedClass(this,a),e=function(){var a=d.getConstructor(c),e=new a(c);e["<init>(Ljava/lang/String;)V"](c,[util_1.initString(c.bsCl,b)],function(a){a?c.throwException(a):c.throwException(e)})};null!=d?e():(this.setStatus(enums_1.ThreadStatus.ASYNC_WAITING),this.getLoader().initializeClass(this,a,function(a){null!=a&&(d=a,e())},!1))},a.prototype.handleUncaughtException=function(a){this.jvmThreadObj["dispatchUncaughtException(Ljava/lang/Throwable;)V"](this,[a])},a.prototype.close=function(){this.jvm=null},a}();exports.JVMThread=JVMThread,exports.validTransitions={},exports.validTransitions[enums_1.ThreadStatus.NEW]={},exports.validTransitions[enums_1.ThreadStatus.NEW][enums_1.ThreadStatus.RUNNABLE]="RunMethod invoked on new thread",exports.validTransitions[enums_1.ThreadStatus.NEW][enums_1.ThreadStatus.ASYNC_WAITING]="[JVM bootup only] Internal operation occurs on new thread",exports.validTransitions[enums_1.ThreadStatus.NEW][enums_1.ThreadStatus.TERMINATED]="[JVM halt0 only] When the JVM shuts down, it terminates all threads, including those that have never been run.",exports.validTransitions[enums_1.ThreadStatus.ASYNC_WAITING]={},exports.validTransitions[enums_1.ThreadStatus.ASYNC_WAITING][enums_1.ThreadStatus.RUNNABLE]="Async operation completes",exports.validTransitions[enums_1.ThreadStatus.ASYNC_WAITING][enums_1.ThreadStatus.TERMINATED]="RunMethod completes and callstack is empty",exports.validTransitions[enums_1.ThreadStatus.BLOCKED]={},exports.validTransitions[enums_1.ThreadStatus.BLOCKED][enums_1.ThreadStatus.RUNNABLE]="Acquires monitor, or is interrupted",exports.validTransitions[enums_1.ThreadStatus.BLOCKED][enums_1.ThreadStatus.TERMINATED]="Thread is terminated whilst blocked.",exports.validTransitions[enums_1.ThreadStatus.PARKED]={},exports.validTransitions[enums_1.ThreadStatus.PARKED][enums_1.ThreadStatus.ASYNC_WAITING]="Balancing unpark, or is interrupted",exports.validTransitions[enums_1.ThreadStatus.PARKED][enums_1.ThreadStatus.TERMINATED]="Thread is terminated whilst parked.",exports.validTransitions[enums_1.ThreadStatus.RUNNABLE]={},exports.validTransitions[enums_1.ThreadStatus.RUNNABLE][enums_1.ThreadStatus.ASYNC_WAITING]="Thread performs an asynchronous JavaScript operation",exports.validTransitions[enums_1.ThreadStatus.RUNNABLE][enums_1.ThreadStatus.TERMINATED]="Callstack is empty",exports.validTransitions[enums_1.ThreadStatus.RUNNABLE][enums_1.ThreadStatus.BLOCKED]="Thread waits to acquire monitor",exports.validTransitions[enums_1.ThreadStatus.RUNNABLE][enums_1.ThreadStatus.WAITING]="Thread waits on monitor (Object.wait)",exports.validTransitions[enums_1.ThreadStatus.RUNNABLE][enums_1.ThreadStatus.TIMED_WAITING]="Thread waits on monitor with timeout (Object.wait)",exports.validTransitions[enums_1.ThreadStatus.RUNNABLE][enums_1.ThreadStatus.PARKED]="Thread parks itself",exports.validTransitions[enums_1.ThreadStatus.TERMINATED]={},exports.validTransitions[enums_1.ThreadStatus.TERMINATED][enums_1.ThreadStatus.NEW]="Thread is resurrected for re-use",exports.validTransitions[enums_1.ThreadStatus.TERMINATED][enums_1.ThreadStatus.RUNNABLE]="Thread is resurrected for re-use",exports.validTransitions[enums_1.ThreadStatus.TERMINATED][enums_1.ThreadStatus.ASYNC_WAITING]="[JVM Bootup] Thread is resurrected for internal operation",exports.validTransitions[enums_1.ThreadStatus.TIMED_WAITING]={},exports.validTransitions[enums_1.ThreadStatus.TIMED_WAITING][enums_1.ThreadStatus.RUNNABLE]="Timer expires, or thread is interrupted, and thread immediately acquires lock",exports.validTransitions[enums_1.ThreadStatus.TIMED_WAITING][enums_1.ThreadStatus.UNINTERRUPTABLY_BLOCKED]="Thread is interrupted or notified, or timer expires, and lock already owned",exports.validTransitions[enums_1.ThreadStatus.TIMED_WAITING][enums_1.ThreadStatus.TERMINATED]="Thread is terminated whilst waiting.",exports.validTransitions[enums_1.ThreadStatus.UNINTERRUPTABLY_BLOCKED]={},exports.validTransitions[enums_1.ThreadStatus.UNINTERRUPTABLY_BLOCKED][enums_1.ThreadStatus.RUNNABLE]="Thread acquires monitor",exports.validTransitions[enums_1.ThreadStatus.UNINTERRUPTABLY_BLOCKED][enums_1.ThreadStatus.TERMINATED]="Thread is terminated whilst blocked.",exports.validTransitions[enums_1.ThreadStatus.WAITING]={},exports.validTransitions[enums_1.ThreadStatus.WAITING][enums_1.ThreadStatus.RUNNABLE]="Thread is interrupted, and immediately acquires lock",exports.validTransitions[enums_1.ThreadStatus.WAITING][enums_1.ThreadStatus.UNINTERRUPTABLY_BLOCKED]="Thread is notified or interrupted, and does not immediately acquire lock",exports.validTransitions[enums_1.ThreadStatus.WAITING][enums_1.ThreadStatus.TERMINATED]="Thread is terminated whilst waiting.",exports.OpcodeLayoutPrinters={},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.OPCODE_ONLY]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.CONSTANT_POOL]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+printConstantPoolItem(a.cls.constantPool.get(b.readUInt16BE(c+1)))},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.CONSTANT_POOL_UINT8]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+printConstantPoolItem(a.cls.constantPool.get(b[c+1]))},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.CONSTANT_POOL_AND_UINT8_VALUE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+printConstantPoolItem(a.cls.constantPool.get(b.readUInt16BE(c+1)))+" "+b[c+3]},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.UINT8_VALUE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+b[c+1]},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.UINT8_AND_INT8_VALUE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+b[c+1]+" "+b[c+2]},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.INT8_VALUE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+b.readInt8(c+1)},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.INT16_VALUE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+b.readInt16BE(c+1)},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.INT32_VALUE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+b.readInt32BE(c+1)},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.ARRAY_TYPE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()+" "+opcodes_1.ArrayTypes[b[c+1]]},exports.OpcodeLayoutPrinters[enums_1.OpcodeLayoutType.WIDE]=function(a,b,c){return enums_1.OpCode[b[c]].toLowerCase()},exports.annotateOpcode=annotateOpcode;
//# sourceMappingURL=threading.js.map