// TypeScript declaration file for JVM types. Automatically generated by doppioh.
// http://github.com/plasma-umass/doppio
import * as DoppioJVM from '../src/doppiojvm';
import JVMThread = DoppioJVM.VM.Threading.JVMThread;
import Long = DoppioJVM.VM.Long;
import ClassData = DoppioJVM.VM.ClassFile.ClassData;
import ArrayClassData = DoppioJVM.VM.ClassFile.ArrayClassData;
import ReferenceClassData = DoppioJVM.VM.ClassFile.ReferenceClassData;
import Monitor = DoppioJVM.VM.Monitor;
import ClassLoader = DoppioJVM.VM.ClassFile.ClassLoader;
import Interfaces = DoppioJVM.VM.Interfaces;

declare module JVMTypes {
  export class JVMArray<T> extends java_lang_Object {
    /**
     * NOTE: Our arrays are either JS arrays, or TypedArrays for primitive
     * types.
     */
    public array: T[];
    public getClass(): ArrayClassData<T>;
    /**
     * Create a new JVM array of this type that starts at start, and ends at
     * end. End defaults to the end of the array.
     */
    public slice(start: number, end?: number): JVMArray<T>;
  }
  // Basic, valid JVM types.
  export type BasicType = number | java_lang_Object | Long;
  export type JVMFunction = (thread: JVMThread, args: BasicType[], cb: (e?: JVMTypes.java_lang_Object, rv?: BasicType) => void) => void;
  export interface java_lang_reflect_Member extends java_lang_Object {
    "getDeclaringClass()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    "getName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "getModifiers()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isSynthetic()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class sun_reflect_Reflection extends java_lang_Object {
    public static "sun/reflect/Reflection/fieldFilterMap": java_util_Map;
    public static "sun/reflect/Reflection/methodFilterMap": java_util_Map;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/Reflection/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getCallerClass()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "sun/reflect/Reflection/getCallerClass()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "getCallerClass(I)Ljava/lang/Class;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "sun/reflect/Reflection/getCallerClass(I)Ljava/lang/Class;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "getClassAccessFlags(Ljava/lang/Class;)I"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/getClassAccessFlags(Ljava/lang/Class;)I"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "quickCheckMemberAccess(Ljava/lang/Class;I)Z"(thread: JVMThread, args: [java_lang_Class, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/quickCheckMemberAccess(Ljava/lang/Class;I)Z"(thread: JVMThread, args: [java_lang_Class, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "ensureMemberAccess(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Object;I)V"(thread: JVMThread, args: [java_lang_Class, java_lang_Class, java_lang_Object, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/reflect/Reflection/ensureMemberAccess(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Object;I)V"(thread: JVMThread, args: [java_lang_Class, java_lang_Class, java_lang_Object, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "verifyMemberAccess(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Object;I)Z"(thread: JVMThread, args: [java_lang_Class, java_lang_Class, java_lang_Object, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/verifyMemberAccess(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Object;I)Z"(thread: JVMThread, args: [java_lang_Class, java_lang_Class, java_lang_Object, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "isSameClassPackage(Ljava/lang/Class;Ljava/lang/Class;)Z"(thread: JVMThread, args: [java_lang_Class, java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/isSameClassPackage(Ljava/lang/Class;Ljava/lang/Class;)Z"(thread: JVMThread, args: [java_lang_Class, java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "isSameClassPackage(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/ClassLoader;Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_ClassLoader, java_lang_String, java_lang_ClassLoader, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/isSameClassPackage(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/ClassLoader;Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_ClassLoader, java_lang_String, java_lang_ClassLoader, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "isSubclassOf(Ljava/lang/Class;Ljava/lang/Class;)Z"(thread: JVMThread, args: [java_lang_Class, java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/isSubclassOf(Ljava/lang/Class;Ljava/lang/Class;)Z"(thread: JVMThread, args: [java_lang_Class, java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "registerFieldsToFilter(Ljava/lang/Class;[Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/reflect/Reflection/registerFieldsToFilter(Ljava/lang/Class;[Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "registerMethodsToFilter(Ljava/lang/Class;[Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/reflect/Reflection/registerMethodsToFilter(Ljava/lang/Class;[Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "registerFilter(Ljava/util/Map;Ljava/lang/Class;[Ljava/lang/String;)Ljava/util/Map;"(thread: JVMThread, args: [java_util_Map, java_lang_Class, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable, rv?: java_util_Map) => void): void;
    public static "sun/reflect/Reflection/registerFilter(Ljava/util/Map;Ljava/lang/Class;[Ljava/lang/String;)Ljava/util/Map;"(thread: JVMThread, args: [java_util_Map, java_lang_Class, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable, rv?: java_util_Map) => void): void;
    public static "filterFields(Ljava/lang/Class;[Ljava/lang/reflect/Field;)[Ljava/lang/reflect/Field;"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_reflect_Field>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_reflect_Field>) => void): void;
    public static "sun/reflect/Reflection/filterFields(Ljava/lang/Class;[Ljava/lang/reflect/Field;)[Ljava/lang/reflect/Field;"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_reflect_Field>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_reflect_Field>) => void): void;
    public static "filterMethods(Ljava/lang/Class;[Ljava/lang/reflect/Method;)[Ljava/lang/reflect/Method;"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_reflect_Method>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_reflect_Method>) => void): void;
    public static "sun/reflect/Reflection/filterMethods(Ljava/lang/Class;[Ljava/lang/reflect/Method;)[Ljava/lang/reflect/Method;"(thread: JVMThread, args: [java_lang_Class, JVMArray<java_lang_reflect_Method>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_reflect_Method>) => void): void;
    public static "filter([Ljava/lang/reflect/Member;[Ljava/lang/String;)[Ljava/lang/reflect/Member;"(thread: JVMThread, args: [JVMArray<java_lang_reflect_Member>, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_reflect_Member>) => void): void;
    public static "sun/reflect/Reflection/filter([Ljava/lang/reflect/Member;[Ljava/lang/String;)[Ljava/lang/reflect/Member;"(thread: JVMThread, args: [JVMArray<java_lang_reflect_Member>, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_reflect_Member>) => void): void;
    public static "isCallerSensitive(Ljava/lang/reflect/Method;)Z"(thread: JVMThread, args: [java_lang_reflect_Method], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/isCallerSensitive(Ljava/lang/reflect/Method;)Z"(thread: JVMThread, args: [java_lang_reflect_Method], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "isExtClassLoader(Ljava/lang/ClassLoader;)Z"(thread: JVMThread, args: [java_lang_ClassLoader], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/reflect/Reflection/isExtClassLoader(Ljava/lang/ClassLoader;)Z"(thread: JVMThread, args: [java_lang_ClassLoader], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/reflect/Reflection/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_Map extends java_lang_Object {
    "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "containsKey(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "containsValue(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "get(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "remove(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "putAll(Ljava/util/Map;)V"(thread: JVMThread, args: [java_util_Map], cb?: (e?: java_lang_Throwable) => void): void;
    "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "keySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    "values()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    "entrySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "forEach(Ljava/util/function/BiConsumer;)V"(thread: JVMThread, args: [java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "replaceAll(Ljava/util/function/BiFunction;)V"(thread: JVMThread, args: [java_util_function_BiFunction], cb?: (e?: java_lang_Throwable) => void): void;
    "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "remove(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_function_Function extends java_lang_Object {
    "apply(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "compose(Ljava/util/function/Function;)Ljava/util/function/Function;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Function) => void): void;
    "andThen(Ljava/util/function/Function;)Ljava/util/function/Function;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Function) => void): void;
    "lambda$andThen$1(Ljava/util/function/Function;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Function, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "lambda$compose$0(Ljava/util/function/Function;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Function, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_function_BiFunction extends java_lang_Object {
    "apply(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "andThen(Ljava/util/function/Function;)Ljava/util/function/BiFunction;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_function_BiFunction) => void): void;
    "lambda$andThen$0(Ljava/util/function/Function;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Function, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_function_BiConsumer extends java_lang_Object {
    "accept(Ljava/lang/Object;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "andThen(Ljava/util/function/BiConsumer;)Ljava/util/function/BiConsumer;"(thread: JVMThread, args: [java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_BiConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/BiConsumer;Ljava/lang/Object;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_util_function_BiConsumer, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_Collection extends java_lang_Object, java_lang_Iterable {
    "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "containsAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "addAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "retainAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
  }
  export interface java_util_function_Consumer extends java_lang_Object {
    "accept(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "andThen(Ljava/util/function/Consumer;)Ljava/util/function/Consumer;"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Consumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/Consumer;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_util_function_Consumer, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_stream_Stream extends java_lang_Object, java_util_stream_BaseStream {
    "filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "map(Ljava/util/function/Function;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "mapToInt(Ljava/util/function/ToIntFunction;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_ToIntFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "mapToLong(Ljava/util/function/ToLongFunction;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_ToLongFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "mapToDouble(Ljava/util/function/ToDoubleFunction;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_ToDoubleFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "flatMap(Ljava/util/function/Function;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "flatMapToInt(Ljava/util/function/Function;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "flatMapToLong(Ljava/util/function/Function;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "flatMapToDouble(Ljava/util/function/Function;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "distinct()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "sorted()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "sorted(Ljava/util/Comparator;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_Comparator], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "peek(Ljava/util/function/Consumer;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "limit(J)Ljava/util/stream/Stream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "skip(J)Ljava/util/stream/Stream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachOrdered(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "toArray(Ljava/util/function/IntFunction;)[Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_IntFunction], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "reduce(Ljava/lang/Object;Ljava/util/function/BinaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "reduce(Ljava/util/function/BinaryOperator;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_function_BinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    "reduce(Ljava/lang/Object;Ljava/util/function/BiFunction;Ljava/util/function/BinaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction, java_util_function_BinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "collect(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier, java_util_function_BiConsumer, java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "collect(Ljava/util/stream/Collector;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_stream_Collector], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "min(Ljava/util/Comparator;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_Comparator], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    "max(Ljava/util/Comparator;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_Comparator], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    "count()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "anyMatch(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "allMatch(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "noneMatch(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "findFirst()Ljava/util/Optional;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    "findAny()Ljava/util/Optional;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "isParallel()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "sequential()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "parallel()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "unordered()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "onClose(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_lang_Runnable extends java_lang_Object {
    "run()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_UnaryOperator extends java_lang_Object, java_util_function_Function {
    "apply(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "compose(Ljava/util/function/Function;)Ljava/util/function/Function;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Function) => void): void;
    "andThen(Ljava/util/function/Function;)Ljava/util/function/Function;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Function) => void): void;
    "lambda$andThen$1(Ljava/util/function/Function;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Function, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "lambda$compose$0(Ljava/util/function/Function;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Function, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_stream_Stream$Builder extends java_lang_Object, java_util_function_Consumer {
    "accept(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "add(Ljava/lang/Object;)Ljava/util/stream/Stream$Builder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream$Builder) => void): void;
    "build()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "andThen(Ljava/util/function/Consumer;)Ljava/util/function/Consumer;"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Consumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/Consumer;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_util_function_Consumer, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_stream_Collector extends java_lang_Object {
    "supplier()Ljava/util/function/Supplier;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Supplier) => void): void;
    "accumulator()Ljava/util/function/BiConsumer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_BiConsumer) => void): void;
    "combiner()Ljava/util/function/BinaryOperator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_BinaryOperator) => void): void;
    "finisher()Ljava/util/function/Function;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Function) => void): void;
    "characteristics()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
  }
  export class java_util_stream_Collector$Characteristics extends java_lang_Enum {
    public static "java/util/stream/Collector$Characteristics/CONCURRENT": java_util_stream_Collector$Characteristics;
    public static "java/util/stream/Collector$Characteristics/UNORDERED": java_util_stream_Collector$Characteristics;
    public static "java/util/stream/Collector$Characteristics/IDENTITY_FINISH": java_util_stream_Collector$Characteristics;
    public static "java/util/stream/Collector$Characteristics/$VALUES": JVMArray<java_util_stream_Collector$Characteristics>;
    public static "values()[Ljava/util/stream/Collector$Characteristics;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_util_stream_Collector$Characteristics>) => void): void;
    public static "java/util/stream/Collector$Characteristics/values()[Ljava/util/stream/Collector$Characteristics;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_util_stream_Collector$Characteristics>) => void): void;
    public static "valueOf(Ljava/lang/String;)Ljava/util/stream/Collector$Characteristics;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Collector$Characteristics) => void): void;
    public static "java/util/stream/Collector$Characteristics/valueOf(Ljava/lang/String;)Ljava/util/stream/Collector$Characteristics;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Collector$Characteristics) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/stream/Collector$Characteristics/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/stream/Collector$Characteristics/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_Enum extends java_lang_Object implements java_lang_Comparable, java_io_Serializable {
    public "java/lang/Enum/name": java_lang_String;
    public "java/lang/Enum/ordinal": number;
    public "name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/Enum/name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "ordinal()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Enum/ordinal()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Enum/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/Enum/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Enum/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Enum/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/lang/Enum/clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "compareTo(Ljava/lang/Enum;)I"(thread: JVMThread, args: [java_lang_Enum], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Enum/compareTo(Ljava/lang/Enum;)I"(thread: JVMThread, args: [java_lang_Enum], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getDeclaringClass()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public "java/lang/Enum/getDeclaringClass()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "valueOf(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;"(thread: JVMThread, args: [java_lang_Class, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Enum) => void): void;
    public static "java/lang/Enum/valueOf(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;"(thread: JVMThread, args: [java_lang_Class, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Enum) => void): void;
    public "finalize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Enum/finalize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Enum/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObjectNoData()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Enum/readObjectNoData()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Enum/compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_io_Serializable extends java_lang_Object {
  }
  export interface java_lang_Comparable extends java_lang_Object {
    "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_Supplier extends java_lang_Object {
    "get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class java_util_Optional extends java_lang_Object {
    public static "java/util/Optional/EMPTY": java_util_Optional;
    public "java/util/Optional/value": java_lang_Object;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Optional/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "empty()Ljava/util/Optional;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public static "java/util/Optional/empty()Ljava/util/Optional;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "<init>(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Optional/<init>(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public static "of(Ljava/lang/Object;)Ljava/util/Optional;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public static "java/util/Optional/of(Ljava/lang/Object;)Ljava/util/Optional;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public static "ofNullable(Ljava/lang/Object;)Ljava/util/Optional;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public static "java/util/Optional/ofNullable(Ljava/lang/Object;)Ljava/util/Optional;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/Optional/get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Optional/isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ifPresent(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Optional/ifPresent(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "filter(Ljava/util/function/Predicate;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "java/util/Optional/filter(Ljava/util/function/Predicate;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "map(Ljava/util/function/Function;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "java/util/Optional/map(Ljava/util/function/Function;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "flatMap(Ljava/util/function/Function;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "java/util/Optional/flatMap(Ljava/util/function/Function;)Ljava/util/Optional;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_Optional) => void): void;
    public "orElse(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/Optional/orElse(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "orElseGet(Ljava/util/function/Supplier;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/Optional/orElseGet(Ljava/util/function/Supplier;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "orElseThrow(Ljava/util/function/Supplier;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/Optional/orElseThrow(Ljava/util/function/Supplier;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Optional/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Optional/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/Optional/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/Optional/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_BinaryOperator extends java_lang_Object, java_util_function_BiFunction {
    "apply(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "andThen(Ljava/util/function/Function;)Ljava/util/function/BiFunction;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_function_BiFunction) => void): void;
    "lambda$andThen$0(Ljava/util/function/Function;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Function, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_function_IntFunction extends java_lang_Object {
    "apply(I)Ljava/lang/Object;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_Comparator extends java_lang_Object {
    "compare(Ljava/lang/Object;Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "reversed()Ljava/util/Comparator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "thenComparing(Ljava/util/Comparator;)Ljava/util/Comparator;"(thread: JVMThread, args: [java_util_Comparator], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "thenComparing(Ljava/util/function/Function;Ljava/util/Comparator;)Ljava/util/Comparator;"(thread: JVMThread, args: [java_util_function_Function, java_util_Comparator], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "thenComparing(Ljava/util/function/Function;)Ljava/util/Comparator;"(thread: JVMThread, args: [java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "thenComparingInt(Ljava/util/function/ToIntFunction;)Ljava/util/Comparator;"(thread: JVMThread, args: [java_util_function_ToIntFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "thenComparingLong(Ljava/util/function/ToLongFunction;)Ljava/util/Comparator;"(thread: JVMThread, args: [java_util_function_ToLongFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "thenComparingDouble(Ljava/util/function/ToDoubleFunction;)Ljava/util/Comparator;"(thread: JVMThread, args: [java_util_function_ToDoubleFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "lambda$thenComparing$36697e65$1(Ljava/util/Comparator;Ljava/lang/Object;Ljava/lang/Object;)I"(thread: JVMThread, args: [java_util_Comparator, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_lang_invoke_SerializedLambda extends java_lang_Object implements java_io_Serializable {
    public static "java/lang/invoke/SerializedLambda/serialVersionUID": Long;
    public "java/lang/invoke/SerializedLambda/capturingClass": java_lang_Class;
    public "java/lang/invoke/SerializedLambda/functionalInterfaceClass": java_lang_String;
    public "java/lang/invoke/SerializedLambda/functionalInterfaceMethodName": java_lang_String;
    public "java/lang/invoke/SerializedLambda/functionalInterfaceMethodSignature": java_lang_String;
    public "java/lang/invoke/SerializedLambda/implClass": java_lang_String;
    public "java/lang/invoke/SerializedLambda/implMethodName": java_lang_String;
    public "java/lang/invoke/SerializedLambda/implMethodSignature": java_lang_String;
    public "java/lang/invoke/SerializedLambda/implMethodKind": number;
    public "java/lang/invoke/SerializedLambda/instantiatedMethodType": java_lang_String;
    public "java/lang/invoke/SerializedLambda/capturedArgs": JVMArray<java_lang_Object>;
    public "<init>(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Class, java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String, java_lang_String, java_lang_String, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/invoke/SerializedLambda/<init>(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Class, java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String, java_lang_String, java_lang_String, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable) => void): void;
    public "getCapturingClass()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getCapturingClass()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getFunctionalInterfaceClass()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getFunctionalInterfaceClass()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getFunctionalInterfaceMethodName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getFunctionalInterfaceMethodName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getFunctionalInterfaceMethodSignature()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getFunctionalInterfaceMethodSignature()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getImplClass()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getImplClass()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getImplMethodName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getImplMethodName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getImplMethodSignature()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getImplMethodSignature()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getImplMethodKind()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/invoke/SerializedLambda/getImplMethodKind()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getInstantiatedMethodType()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/getInstantiatedMethodType()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getCapturedArgCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/invoke/SerializedLambda/getCapturedArgCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getCapturedArg(I)Ljava/lang/Object;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/lang/invoke/SerializedLambda/getCapturedArg(I)Ljava/lang/Object;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "readResolve()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/lang/invoke/SerializedLambda/readResolve()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/invoke/SerializedLambda/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$000(Ljava/lang/invoke/SerializedLambda;)Ljava/lang/Class;"(thread: JVMThread, args: [java_lang_invoke_SerializedLambda], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "java/lang/invoke/SerializedLambda/access$000(Ljava/lang/invoke/SerializedLambda;)Ljava/lang/Class;"(thread: JVMThread, args: [java_lang_invoke_SerializedLambda], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
  }
  export interface java_util_function_ToDoubleFunction extends java_lang_Object {
    "applyAsDouble(Ljava/lang/Object;)D"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_stream_DoubleStream extends java_lang_Object, java_util_stream_BaseStream {
    "filter(Ljava/util/function/DoublePredicate;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_DoublePredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "map(Ljava/util/function/DoubleUnaryOperator;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_DoubleUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "mapToObj(Ljava/util/function/DoubleFunction;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_function_DoubleFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "mapToInt(Ljava/util/function/DoubleToIntFunction;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_DoubleToIntFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "mapToLong(Ljava/util/function/DoubleToLongFunction;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_DoubleToLongFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "flatMap(Ljava/util/function/DoubleFunction;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_DoubleFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "distinct()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "sorted()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "peek(Ljava/util/function/DoubleConsumer;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "limit(J)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "skip(J)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "forEach(Ljava/util/function/DoubleConsumer;)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachOrdered(Ljava/util/function/DoubleConsumer;)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "toArray()[D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    "reduce(DLjava/util/function/DoubleBinaryOperator;)D"(thread: JVMThread, args: [number, any, java_util_function_DoubleBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "reduce(Ljava/util/function/DoubleBinaryOperator;)Ljava/util/OptionalDouble;"(thread: JVMThread, args: [java_util_function_DoubleBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "collect(Ljava/util/function/Supplier;Ljava/util/function/ObjDoubleConsumer;Ljava/util/function/BiConsumer;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier, java_util_function_ObjDoubleConsumer, java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "sum()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "min()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "max()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "count()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "average()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "summaryStatistics()Ljava/util/DoubleSummaryStatistics;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_DoubleSummaryStatistics) => void): void;
    "anyMatch(Ljava/util/function/DoublePredicate;)Z"(thread: JVMThread, args: [java_util_function_DoublePredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "allMatch(Ljava/util/function/DoublePredicate;)Z"(thread: JVMThread, args: [java_util_function_DoublePredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "noneMatch(Ljava/util/function/DoublePredicate;)Z"(thread: JVMThread, args: [java_util_function_DoublePredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "findFirst()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "findAny()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "boxed()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "sequential()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "parallel()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "iterator()Ljava/util/PrimitiveIterator$OfDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_PrimitiveIterator$OfDouble) => void): void;
    "spliterator()Ljava/util/Spliterator$OfDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfDouble) => void): void;
    "parallel()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "sequential()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "isParallel()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "unordered()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "onClose(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_DoubleSupplier extends java_lang_Object {
    "getAsDouble()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_stream_DoubleStream$Builder extends java_lang_Object, java_util_function_DoubleConsumer {
    "accept(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    "add(D)Ljava/util/stream/DoubleStream$Builder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream$Builder) => void): void;
    "build()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "andThen(Ljava/util/function/DoubleConsumer;)Ljava/util/function/DoubleConsumer;"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoubleConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/DoubleConsumer;D)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer, number, any], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_Spliterator$OfDouble extends java_lang_Object, java_util_Spliterator$OfPrimitive {
    "trySplit()Ljava/util/Spliterator$OfDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfDouble) => void): void;
    "tryAdvance(Ljava/util/function/DoubleConsumer;)Z"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/DoubleConsumer;)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "tryAdvance(Ljava/util/function/Consumer;)Z"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "tryAdvance(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "trySplit()Ljava/util/Spliterator$OfPrimitive;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfPrimitive) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "estimateSize()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "getExactSizeIfKnown()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "characteristics()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hasCharacteristics(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getComparator()Ljava/util/Comparator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_Spliterator$OfPrimitive extends java_lang_Object, java_util_Spliterator {
    "trySplit()Ljava/util/Spliterator$OfPrimitive;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfPrimitive) => void): void;
    "tryAdvance(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "tryAdvance(Ljava/util/function/Consumer;)Z"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "estimateSize()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "getExactSizeIfKnown()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "characteristics()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hasCharacteristics(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getComparator()Ljava/util/Comparator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
  }
  export interface java_util_PrimitiveIterator$OfDouble extends java_lang_Object, java_util_PrimitiveIterator {
    "nextDouble()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/DoubleConsumer;)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "next()Ljava/lang/Double;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Double) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "next()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "hasNext()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_PrimitiveIterator extends java_lang_Object, java_util_Iterator {
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "hasNext()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "next()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_DoubleSummaryStatistics extends java_lang_Object implements java_util_function_DoubleConsumer {
    public "java/util/DoubleSummaryStatistics/count": Long;
    public "java/util/DoubleSummaryStatistics/sum": number;
    public "java/util/DoubleSummaryStatistics/sumCompensation": number;
    public "java/util/DoubleSummaryStatistics/simpleSum": number;
    public "java/util/DoubleSummaryStatistics/min": number;
    public "java/util/DoubleSummaryStatistics/max": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/DoubleSummaryStatistics/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "accept(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/DoubleSummaryStatistics/accept(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "combine(Ljava/util/DoubleSummaryStatistics;)V"(thread: JVMThread, args: [java_util_DoubleSummaryStatistics], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/DoubleSummaryStatistics/combine(Ljava/util/DoubleSummaryStatistics;)V"(thread: JVMThread, args: [java_util_DoubleSummaryStatistics], cb?: (e?: java_lang_Throwable) => void): void;
    public "sumWithCompensation(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/DoubleSummaryStatistics/sumWithCompensation(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "getCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/DoubleSummaryStatistics/getCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getSum()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/DoubleSummaryStatistics/getSum()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getMin()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/DoubleSummaryStatistics/getMin()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getMax()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/DoubleSummaryStatistics/getMax()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAverage()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/DoubleSummaryStatistics/getAverage()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/DoubleSummaryStatistics/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "andThen(Ljava/util/function/DoubleConsumer;)Ljava/util/function/DoubleConsumer;"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoubleConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/DoubleConsumer;D)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer, number, any], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_ObjDoubleConsumer extends java_lang_Object {
    "accept(Ljava/lang/Object;D)V"(thread: JVMThread, args: [java_lang_Object, number, any], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_OptionalDouble extends java_lang_Object {
    public static "java/util/OptionalDouble/EMPTY": java_util_OptionalDouble;
    public "java/util/OptionalDouble/isPresent": number;
    public "java/util/OptionalDouble/value": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalDouble/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "empty()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    public static "java/util/OptionalDouble/empty()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    public "<init>(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalDouble/<init>(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "of(D)Ljava/util/OptionalDouble;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    public static "java/util/OptionalDouble/of(D)Ljava/util/OptionalDouble;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    public "getAsDouble()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalDouble/getAsDouble()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalDouble/isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ifPresent(Ljava/util/function/DoubleConsumer;)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalDouble/ifPresent(Ljava/util/function/DoubleConsumer;)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "orElse(D)D"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalDouble/orElse(D)D"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "orElseGet(Ljava/util/function/DoubleSupplier;)D"(thread: JVMThread, args: [java_util_function_DoubleSupplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalDouble/orElseGet(Ljava/util/function/DoubleSupplier;)D"(thread: JVMThread, args: [java_util_function_DoubleSupplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "orElseThrow(Ljava/util/function/Supplier;)D"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalDouble/orElseThrow(Ljava/util/function/Supplier;)D"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalDouble/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalDouble/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/OptionalDouble/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/OptionalDouble/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_DoubleBinaryOperator extends java_lang_Object {
    "applyAsDouble(DD)D"(thread: JVMThread, args: [number, any, number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_DoubleConsumer extends java_lang_Object {
    "accept(D)V"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable) => void): void;
    "andThen(Ljava/util/function/DoubleConsumer;)Ljava/util/function/DoubleConsumer;"(thread: JVMThread, args: [java_util_function_DoubleConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoubleConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/DoubleConsumer;D)V"(thread: JVMThread, args: [java_util_function_DoubleConsumer, number, any], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_DoubleToLongFunction extends java_lang_Object {
    "applyAsLong(D)J"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export interface java_util_function_DoubleToIntFunction extends java_lang_Object {
    "applyAsInt(D)I"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_DoubleFunction extends java_lang_Object {
    "apply(D)Ljava/lang/Object;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_function_DoubleUnaryOperator extends java_lang_Object {
    "applyAsDouble(D)D"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "compose(Ljava/util/function/DoubleUnaryOperator;)Ljava/util/function/DoubleUnaryOperator;"(thread: JVMThread, args: [java_util_function_DoubleUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoubleUnaryOperator) => void): void;
    "andThen(Ljava/util/function/DoubleUnaryOperator;)Ljava/util/function/DoubleUnaryOperator;"(thread: JVMThread, args: [java_util_function_DoubleUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoubleUnaryOperator) => void): void;
    "lambda$andThen$1(Ljava/util/function/DoubleUnaryOperator;D)D"(thread: JVMThread, args: [java_util_function_DoubleUnaryOperator, number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$compose$0(Ljava/util/function/DoubleUnaryOperator;D)D"(thread: JVMThread, args: [java_util_function_DoubleUnaryOperator, number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_DoublePredicate extends java_lang_Object {
    "test(D)Z"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "and(Ljava/util/function/DoublePredicate;)Ljava/util/function/DoublePredicate;"(thread: JVMThread, args: [java_util_function_DoublePredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoublePredicate) => void): void;
    "negate()Ljava/util/function/DoublePredicate;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoublePredicate) => void): void;
    "or(Ljava/util/function/DoublePredicate;)Ljava/util/function/DoublePredicate;"(thread: JVMThread, args: [java_util_function_DoublePredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_DoublePredicate) => void): void;
    "lambda$or$2(Ljava/util/function/DoublePredicate;D)Z"(thread: JVMThread, args: [java_util_function_DoublePredicate, number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$negate$1(D)Z"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$and$0(Ljava/util/function/DoublePredicate;D)Z"(thread: JVMThread, args: [java_util_function_DoublePredicate, number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_ToLongFunction extends java_lang_Object {
    "applyAsLong(Ljava/lang/Object;)J"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export interface java_util_stream_LongStream extends java_lang_Object, java_util_stream_BaseStream {
    "filter(Ljava/util/function/LongPredicate;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_LongPredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "map(Ljava/util/function/LongUnaryOperator;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_LongUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "mapToObj(Ljava/util/function/LongFunction;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_function_LongFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "mapToInt(Ljava/util/function/LongToIntFunction;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_LongToIntFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "mapToDouble(Ljava/util/function/LongToDoubleFunction;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_LongToDoubleFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "flatMap(Ljava/util/function/LongFunction;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_LongFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "distinct()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "sorted()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "peek(Ljava/util/function/LongConsumer;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "limit(J)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "skip(J)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "forEach(Ljava/util/function/LongConsumer;)V"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachOrdered(Ljava/util/function/LongConsumer;)V"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "toArray()[J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<Long>) => void): void;
    "reduce(JLjava/util/function/LongBinaryOperator;)J"(thread: JVMThread, args: [Long, any, java_util_function_LongBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "reduce(Ljava/util/function/LongBinaryOperator;)Ljava/util/OptionalLong;"(thread: JVMThread, args: [java_util_function_LongBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    "collect(Ljava/util/function/Supplier;Ljava/util/function/ObjLongConsumer;Ljava/util/function/BiConsumer;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier, java_util_function_ObjLongConsumer, java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "sum()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "min()Ljava/util/OptionalLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    "max()Ljava/util/OptionalLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    "count()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "average()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "summaryStatistics()Ljava/util/LongSummaryStatistics;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_LongSummaryStatistics) => void): void;
    "anyMatch(Ljava/util/function/LongPredicate;)Z"(thread: JVMThread, args: [java_util_function_LongPredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "allMatch(Ljava/util/function/LongPredicate;)Z"(thread: JVMThread, args: [java_util_function_LongPredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "noneMatch(Ljava/util/function/LongPredicate;)Z"(thread: JVMThread, args: [java_util_function_LongPredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "findFirst()Ljava/util/OptionalLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    "findAny()Ljava/util/OptionalLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    "asDoubleStream()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "boxed()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "sequential()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "parallel()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "iterator()Ljava/util/PrimitiveIterator$OfLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_PrimitiveIterator$OfLong) => void): void;
    "spliterator()Ljava/util/Spliterator$OfLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfLong) => void): void;
    "parallel()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "sequential()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "isParallel()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "unordered()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "onClose(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_LongSupplier extends java_lang_Object {
    "getAsLong()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export interface java_util_stream_LongStream$Builder extends java_lang_Object, java_util_function_LongConsumer {
    "accept(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    "add(J)Ljava/util/stream/LongStream$Builder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream$Builder) => void): void;
    "build()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "andThen(Ljava/util/function/LongConsumer;)Ljava/util/function/LongConsumer;"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/LongConsumer;J)V"(thread: JVMThread, args: [java_util_function_LongConsumer, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_Spliterator$OfLong extends java_lang_Object, java_util_Spliterator$OfPrimitive {
    "trySplit()Ljava/util/Spliterator$OfLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfLong) => void): void;
    "tryAdvance(Ljava/util/function/LongConsumer;)Z"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/LongConsumer;)V"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "tryAdvance(Ljava/util/function/Consumer;)Z"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "tryAdvance(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "trySplit()Ljava/util/Spliterator$OfPrimitive;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfPrimitive) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "estimateSize()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "getExactSizeIfKnown()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "characteristics()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hasCharacteristics(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getComparator()Ljava/util/Comparator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_PrimitiveIterator$OfLong extends java_lang_Object, java_util_PrimitiveIterator {
    "nextLong()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "forEachRemaining(Ljava/util/function/LongConsumer;)V"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "next()Ljava/lang/Long;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "next()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "hasNext()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_Long extends java_lang_Number implements java_lang_Comparable {
    public unbox(): Long;
    public static box(val: Long): java_lang_Long;
    public static "java/lang/Long/MIN_VALUE": Long;
    public static "java/lang/Long/MAX_VALUE": Long;
    public static "java/lang/Long/TYPE": java_lang_Class;
    public "java/lang/Long/value": Long;
    public static "java/lang/Long/SIZE": number;
    public static "java/lang/Long/BYTES": number;
    public static "java/lang/Long/serialVersionUID": Long;
    public static "toString(JI)Ljava/lang/String;"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toString(JI)Ljava/lang/String;"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toUnsignedString(JI)Ljava/lang/String;"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toUnsignedString(JI)Ljava/lang/String;"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toUnsignedBigInteger(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/lang/Long/toUnsignedBigInteger(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "toHexString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toHexString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toOctalString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toOctalString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toBinaryString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toBinaryString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toUnsignedString0(JI)Ljava/lang/String;"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toUnsignedString0(JI)Ljava/lang/String;"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "formatUnsignedLong(JI[CII)I"(thread: JVMThread, args: [Long, any, number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/formatUnsignedLong(JI[CII)I"(thread: JVMThread, args: [Long, any, number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "toString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toUnsignedString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Long/toUnsignedString(J)Ljava/lang/String;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "getChars(JI[C)V"(thread: JVMThread, args: [Long, any, number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/Long/getChars(JI[C)V"(thread: JVMThread, args: [Long, any, number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "stringSize(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/stringSize(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "parseLong(Ljava/lang/String;I)J"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/parseLong(Ljava/lang/String;I)J"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "parseLong(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/parseLong(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "parseUnsignedLong(Ljava/lang/String;I)J"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/parseUnsignedLong(Ljava/lang/String;I)J"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "parseUnsignedLong(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/parseUnsignedLong(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "valueOf(Ljava/lang/String;I)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "java/lang/Long/valueOf(Ljava/lang/String;I)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "valueOf(Ljava/lang/String;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "java/lang/Long/valueOf(Ljava/lang/String;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "valueOf(J)Ljava/lang/Long;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "java/lang/Long/valueOf(J)Ljava/lang/Long;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "decode(Ljava/lang/String;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "java/lang/Long/decode(Ljava/lang/String;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public "<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Long/<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Long/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "byteValue()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/byteValue()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "shortValue()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/shortValue()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/lang/Long/longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/Long/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "hashCode(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/hashCode(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "getLong(Ljava/lang/String;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "java/lang/Long/getLong(Ljava/lang/String;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "getLong(Ljava/lang/String;J)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "java/lang/Long/getLong(Ljava/lang/String;J)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "getLong(Ljava/lang/String;Ljava/lang/Long;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String, java_lang_Long], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public static "java/lang/Long/getLong(Ljava/lang/String;Ljava/lang/Long;)Ljava/lang/Long;"(thread: JVMThread, args: [java_lang_String, java_lang_Long], cb?: (e?: java_lang_Throwable, rv?: java_lang_Long) => void): void;
    public "compareTo(Ljava/lang/Long;)I"(thread: JVMThread, args: [java_lang_Long], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/compareTo(Ljava/lang/Long;)I"(thread: JVMThread, args: [java_lang_Long], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "compare(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/compare(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "compareUnsigned(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/compareUnsigned(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "divideUnsigned(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/divideUnsigned(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "remainderUnsigned(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/remainderUnsigned(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "highestOneBit(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/highestOneBit(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "lowestOneBit(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/lowestOneBit(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "numberOfLeadingZeros(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/numberOfLeadingZeros(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "numberOfTrailingZeros(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/numberOfTrailingZeros(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "bitCount(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/bitCount(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "rotateLeft(JI)J"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/rotateLeft(JI)J"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "rotateRight(JI)J"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/rotateRight(JI)J"(thread: JVMThread, args: [Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "reverse(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/reverse(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "signum(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Long/signum(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "reverseBytes(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/reverseBytes(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sum(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/sum(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "max(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/max(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "min(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Long/min(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Long/compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/Long/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_math_BigInteger extends java_lang_Number implements java_lang_Comparable {
    public "java/math/BigInteger/signum": number;
    public "java/math/BigInteger/mag": JVMArray<number>;
    public "java/math/BigInteger/bitCount": number;
    public "java/math/BigInteger/bitLength": number;
    public "java/math/BigInteger/lowestSetBit": number;
    public "java/math/BigInteger/firstNonzeroIntNum": number;
    public static "java/math/BigInteger/LONG_MASK": Long;
    public static "java/math/BigInteger/MAX_MAG_LENGTH": number;
    public static "java/math/BigInteger/PRIME_SEARCH_BIT_LENGTH_LIMIT": number;
    public static "java/math/BigInteger/KARATSUBA_THRESHOLD": number;
    public static "java/math/BigInteger/TOOM_COOK_THRESHOLD": number;
    public static "java/math/BigInteger/KARATSUBA_SQUARE_THRESHOLD": number;
    public static "java/math/BigInteger/TOOM_COOK_SQUARE_THRESHOLD": number;
    public static "java/math/BigInteger/BURNIKEL_ZIEGLER_THRESHOLD": number;
    public static "java/math/BigInteger/BURNIKEL_ZIEGLER_OFFSET": number;
    public static "java/math/BigInteger/SCHOENHAGE_BASE_CONVERSION_THRESHOLD": number;
    public static "java/math/BigInteger/MULTIPLY_SQUARE_THRESHOLD": number;
    public static "java/math/BigInteger/bitsPerDigit": JVMArray<Long>;
    public static "java/math/BigInteger/SMALL_PRIME_THRESHOLD": number;
    public static "java/math/BigInteger/DEFAULT_PRIME_CERTAINTY": number;
    public static "java/math/BigInteger/SMALL_PRIME_PRODUCT": java_math_BigInteger;
    public static "java/math/BigInteger/MAX_CONSTANT": number;
    public static "java/math/BigInteger/posConst": JVMArray<java_math_BigInteger>;
    public static "java/math/BigInteger/negConst": JVMArray<java_math_BigInteger>;
    public static "java/math/BigInteger/powerCache": JVMArray<JVMArray<java_math_BigInteger>>;
    public static "java/math/BigInteger/logCache": JVMArray<number>;
    public static "java/math/BigInteger/LOG_TWO": number;
    public static "java/math/BigInteger/ZERO": java_math_BigInteger;
    public static "java/math/BigInteger/ONE": java_math_BigInteger;
    public static "java/math/BigInteger/TWO": java_math_BigInteger;
    public static "java/math/BigInteger/NEGATIVE_ONE": java_math_BigInteger;
    public static "java/math/BigInteger/TEN": java_math_BigInteger;
    public static "java/math/BigInteger/bnExpModThreshTable": JVMArray<number>;
    public static "java/math/BigInteger/zeros": JVMArray<java_lang_String>;
    public static "java/math/BigInteger/digitsPerLong": JVMArray<number>;
    public static "java/math/BigInteger/longRadix": JVMArray<java_math_BigInteger>;
    public static "java/math/BigInteger/digitsPerInt": JVMArray<number>;
    public static "java/math/BigInteger/intRadix": JVMArray<number>;
    public static "java/math/BigInteger/serialVersionUID": Long;
    public static "java/math/BigInteger/serialPersistentFields": JVMArray<java_io_ObjectStreamField>;
    public static "java/math/BigInteger/$assertionsDisabled": number;
    public "<init>([B)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>([B)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>([I)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>([I)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I[B)V"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>(I[B)V"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I[I)V"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>(I[I)V"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>([CII)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>([CII)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "parseInt([CII)I"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/parseInt([CII)I"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "destructiveMulAdd([III)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/math/BigInteger/destructiveMulAdd([III)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(ILjava/util/Random;)V"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>(ILjava/util/Random;)V"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable) => void): void;
    public static "randomBits(ILjava/util/Random;)[B"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/randomBits(ILjava/util/Random;)[B"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "<init>(IILjava/util/Random;)V"(thread: JVMThread, args: [number, number, java_util_Random], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>(IILjava/util/Random;)V"(thread: JVMThread, args: [number, number, java_util_Random], cb?: (e?: java_lang_Throwable) => void): void;
    public static "probablePrime(ILjava/util/Random;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/probablePrime(ILjava/util/Random;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "smallPrime(IILjava/util/Random;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/smallPrime(IILjava/util/Random;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "largePrime(IILjava/util/Random;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/largePrime(IILjava/util/Random;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "nextProbablePrime()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/nextProbablePrime()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "getPrimeSearchLen(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/getPrimeSearchLen(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "primeToCertainty(ILjava/util/Random;)Z"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/primeToCertainty(ILjava/util/Random;)Z"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "passesLucasLehmer()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/passesLucasLehmer()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "jacobiSymbol(ILjava/math/BigInteger;)I"(thread: JVMThread, args: [number, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/jacobiSymbol(ILjava/math/BigInteger;)I"(thread: JVMThread, args: [number, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "lucasLehmerSequence(ILjava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/lucasLehmerSequence(ILjava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "passesMillerRabin(ILjava/util/Random;)Z"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/passesMillerRabin(ILjava/util/Random;)Z"(thread: JVMThread, args: [number, java_util_Random], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "<init>([II)V"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>([II)V"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>([BI)V"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>([BI)V"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkRange()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/checkRange()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "reportOverflow()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/math/BigInteger/reportOverflow()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "valueOf(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/valueOf(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "valueOf([I)Ljava/math/BigInteger;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/valueOf([I)Ljava/math/BigInteger;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "add(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/add(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "add(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/add(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "add([IJ)[I"(thread: JVMThread, args: [JVMArray<number>, Long, any], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/add([IJ)[I"(thread: JVMThread, args: [JVMArray<number>, Long, any], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "add([I[I)[I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/add([I[I)[I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "subtract(J[I)[I"(thread: JVMThread, args: [Long, any, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/subtract(J[I)[I"(thread: JVMThread, args: [Long, any, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "subtract([IJ)[I"(thread: JVMThread, args: [JVMArray<number>, Long, any], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/subtract([IJ)[I"(thread: JVMThread, args: [JVMArray<number>, Long, any], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "subtract(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/subtract(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "subtract([I[I)[I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/subtract([I[I)[I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "multiply(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/multiply(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "multiplyByInt([III)Ljava/math/BigInteger;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/multiplyByInt([III)Ljava/math/BigInteger;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "multiply(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/multiply(J)Ljava/math/BigInteger;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "multiplyToLen([II[II[I)[I"(thread: JVMThread, args: [JVMArray<number>, number, JVMArray<number>, number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "java/math/BigInteger/multiplyToLen([II[II[I)[I"(thread: JVMThread, args: [JVMArray<number>, number, JVMArray<number>, number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "multiplyKaratsuba(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/multiplyKaratsuba(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "multiplyToomCook3(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/multiplyToomCook3(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "getToomSlice(IIII)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number, number, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/getToomSlice(IIII)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number, number, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "exactDivideBy3()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/exactDivideBy3()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "getLower(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/getLower(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "getUpper(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/getUpper(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "square()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/square()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "squareToLen([II[I)[I"(thread: JVMThread, args: [JVMArray<number>, number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/squareToLen([II[I)[I"(thread: JVMThread, args: [JVMArray<number>, number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "squareKaratsuba()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/squareKaratsuba()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "squareToomCook3()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/squareToomCook3()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "divide(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/divide(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "divideKnuth(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/divideKnuth(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "divideAndRemainder(Ljava/math/BigInteger;)[Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_math_BigInteger>) => void): void;
    public "java/math/BigInteger/divideAndRemainder(Ljava/math/BigInteger;)[Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_math_BigInteger>) => void): void;
    public "divideAndRemainderKnuth(Ljava/math/BigInteger;)[Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_math_BigInteger>) => void): void;
    public "java/math/BigInteger/divideAndRemainderKnuth(Ljava/math/BigInteger;)[Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_math_BigInteger>) => void): void;
    public "remainder(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/remainder(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "remainderKnuth(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/remainderKnuth(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "divideBurnikelZiegler(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/divideBurnikelZiegler(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "remainderBurnikelZiegler(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/remainderBurnikelZiegler(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "divideAndRemainderBurnikelZiegler(Ljava/math/BigInteger;)[Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_math_BigInteger>) => void): void;
    public "java/math/BigInteger/divideAndRemainderBurnikelZiegler(Ljava/math/BigInteger;)[Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_math_BigInteger>) => void): void;
    public "pow(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/pow(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "gcd(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/gcd(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "bitLengthForInt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/bitLengthForInt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "leftShift([III)[I"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/leftShift([III)[I"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "primitiveRightShift([III)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/math/BigInteger/primitiveRightShift([III)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "primitiveLeftShift([III)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/math/BigInteger/primitiveLeftShift([III)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "bitLength([II)I"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/bitLength([II)I"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "abs()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/abs()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "negate()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/negate()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "signum()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/signum()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "mod(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/mod(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "modPow(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/modPow(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "oddModPow(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/oddModPow(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "montReduce([I[III)[I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/montReduce([I[III)[I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "intArrayCmpToLen([I[II)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/intArrayCmpToLen([I[II)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "subN([I[II)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/subN([I[II)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "mulAdd([I[IIII)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/mulAdd([I[IIII)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "addOne([IIII)I"(thread: JVMThread, args: [JVMArray<number>, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/math/BigInteger/addOne([IIII)I"(thread: JVMThread, args: [JVMArray<number>, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "modPow2(Ljava/math/BigInteger;I)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/modPow2(Ljava/math/BigInteger;I)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "mod2(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/mod2(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "modInverse(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/modInverse(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "shiftLeft(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/shiftLeft(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "shiftLeft([II)[I"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/shiftLeft([II)[I"(thread: JVMThread, args: [JVMArray<number>, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "shiftRight(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/shiftRight(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "shiftRightImpl(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/shiftRightImpl(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "javaIncrement([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "java/math/BigInteger/javaIncrement([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "and(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/and(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "or(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/or(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "xor(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/xor(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "not()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/not()Ljava/math/BigInteger;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "andNot(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/andNot(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "testBit(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/testBit(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setBit(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/setBit(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "clearBit(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/clearBit(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "flipBit(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/flipBit(I)Ljava/math/BigInteger;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "getLowestSetBit()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/getLowestSetBit()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "bitLength()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/bitLength()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "bitCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/bitCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isProbablePrime(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/isProbablePrime(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareTo(Ljava/math/BigInteger;)I"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/compareTo(Ljava/math/BigInteger;)I"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareMagnitude(Ljava/math/BigInteger;)I"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/compareMagnitude(Ljava/math/BigInteger;)I"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareMagnitude(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/compareMagnitude(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "min(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/min(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "max(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "java/math/BigInteger/max(Ljava/math/BigInteger;)Ljava/math/BigInteger;"(thread: JVMThread, args: [java_math_BigInteger], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/math/BigInteger/toString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "smallToString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/math/BigInteger/smallToString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toString(Ljava/math/BigInteger;Ljava/lang/StringBuilder;II)V"(thread: JVMThread, args: [java_math_BigInteger, java_lang_StringBuilder, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/math/BigInteger/toString(Ljava/math/BigInteger;Ljava/lang/StringBuilder;II)V"(thread: JVMThread, args: [java_math_BigInteger, java_lang_StringBuilder, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getRadixConversionCache(II)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public static "java/math/BigInteger/getRadixConversionCache(II)Ljava/math/BigInteger;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_math_BigInteger) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/math/BigInteger/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "toByteArray()[B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "java/math/BigInteger/toByteArray()[B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/math/BigInteger/longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "stripLeadingZeroInts([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/stripLeadingZeroInts([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "trustedStripLeadingZeroInts([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/trustedStripLeadingZeroInts([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "stripLeadingZeroBytes([B)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/stripLeadingZeroBytes([B)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "makePositive([B)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/makePositive([B)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "makePositive([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public static "java/math/BigInteger/makePositive([I)[I"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "intLength()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/intLength()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "signBit()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/signBit()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "signInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/signInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getInt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/getInt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "firstNonzeroIntNum()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/firstNonzeroIntNum()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/math/BigInteger/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "magSerializedForm()[B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "java/math/BigInteger/magSerializedForm()[B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "longValueExact()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/math/BigInteger/longValueExact()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "intValueExact()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/intValueExact()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "shortValueExact()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/shortValueExact()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "byteValueExact()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/byteValueExact()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/math/BigInteger/compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/math/BigInteger/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_StringBuilder extends java_lang_AbstractStringBuilder implements java_io_Serializable, java_lang_CharSequence {
    public static "java/lang/StringBuilder/serialVersionUID": Long;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/CharSequence;)V"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/<init>(Ljava/lang/CharSequence;)V"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable) => void): void;
    public "append(Ljava/lang/Object;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/Object;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(Ljava/lang/String;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/String;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(Ljava/lang/StringBuffer;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/StringBuffer;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/CharSequence;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/CharSequence;II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append([C)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append([C)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append([CII)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append([CII)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(Z)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Z)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(C)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(C)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(I)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(I)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(J)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(J)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(F)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(F)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "append(D)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/append(D)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "appendCodePoint(I)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/appendCodePoint(I)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "delete(II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/delete(II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "deleteCharAt(I)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/deleteCharAt(I)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "replace(IILjava/lang/String;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/replace(IILjava/lang/String;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(I[CII)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(I[CII)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(ILjava/lang/Object;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/Object;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(ILjava/lang/String;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/String;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(I[C)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(I[C)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/CharSequence;)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/CharSequence;II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(IZ)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IZ)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(IC)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IC)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(II)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(IJ)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IJ)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(IF)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IF)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "insert(ID)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ID)Ljava/lang/StringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "indexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/indexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "indexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/indexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lastIndexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/lastIndexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lastIndexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/lastIndexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "reverse()Ljava/lang/StringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "java/lang/StringBuilder/reverse()Ljava/lang/StringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuilder) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/StringBuilder/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "reverse()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/reverse()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ID)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ID)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IF)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IF)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IJ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IJ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IC)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IC)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IZ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(IZ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(I[C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(I[C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(ILjava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(I[CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/insert(I[CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "substring(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/StringBuilder/substring(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "subSequence(II)Ljava/lang/CharSequence;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_CharSequence) => void): void;
    public "java/lang/StringBuilder/subSequence(II)Ljava/lang/CharSequence;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_CharSequence) => void): void;
    public "substring(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/StringBuilder/substring(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "replace(IILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/replace(IILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "deleteCharAt(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/deleteCharAt(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "appendCodePoint(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/appendCodePoint(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "delete(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/delete(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(D)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(D)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(F)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(F)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(J)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(J)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Z)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Z)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append([CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append([CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append([C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append([C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/StringBuffer;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/StringBuffer;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "setCharAt(IC)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/setCharAt(IC)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getChars(II[CI)V"(thread: JVMThread, args: [number, number, JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/getChars(II[CI)V"(thread: JVMThread, args: [number, number, JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "offsetByCodePoints(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/offsetByCodePoints(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointCount(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/codePointCount(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointBefore(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/codePointBefore(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointAt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/codePointAt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "charAt(I)C"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/charAt(I)C"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setLength(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/setLength(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "trimToSize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/trimToSize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "ensureCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuilder/ensureCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "length()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuilder/length()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "append(C)Ljava/lang/Appendable;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/StringBuilder/append(C)Ljava/lang/Appendable;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/StringBuilder/append(Ljava/lang/CharSequence;)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    "chars()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "codePoints()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
  }
  export interface java_lang_Appendable extends java_lang_Object {
    "append(Ljava/lang/CharSequence;)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    "append(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    "append(C)Ljava/lang/Appendable;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
  }
  export class java_lang_StringBuffer extends java_lang_AbstractStringBuilder implements java_io_Serializable, java_lang_CharSequence {
    public "java/lang/StringBuffer/toStringCache": JVMArray<number>;
    public static "java/lang/StringBuffer/serialVersionUID": Long;
    public static "java/lang/StringBuffer/serialPersistentFields": JVMArray<java_io_ObjectStreamField>;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/CharSequence;)V"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/<init>(Ljava/lang/CharSequence;)V"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable) => void): void;
    public "length()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/length()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ensureCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/ensureCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "trimToSize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/trimToSize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setLength(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/setLength(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "charAt(I)C"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/charAt(I)C"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointAt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/codePointAt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointBefore(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/codePointBefore(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointCount(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/codePointCount(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "offsetByCodePoints(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/offsetByCodePoints(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getChars(II[CI)V"(thread: JVMThread, args: [number, number, JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/getChars(II[CI)V"(thread: JVMThread, args: [number, number, JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "setCharAt(IC)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/setCharAt(IC)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "append(Ljava/lang/Object;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/Object;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(Ljava/lang/String;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/String;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(Ljava/lang/StringBuffer;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/StringBuffer;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(Ljava/lang/AbstractStringBuilder;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_AbstractStringBuilder], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/AbstractStringBuilder;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_AbstractStringBuilder], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/CharSequence;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/CharSequence;II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append([C)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append([C)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append([CII)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append([CII)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(Z)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(Z)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(C)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(C)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(I)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(I)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "appendCodePoint(I)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/appendCodePoint(I)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(J)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(J)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(F)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(F)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "append(D)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/append(D)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "delete(II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/delete(II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "deleteCharAt(I)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/deleteCharAt(I)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "replace(IILjava/lang/String;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/replace(IILjava/lang/String;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "substring(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/StringBuffer/substring(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "subSequence(II)Ljava/lang/CharSequence;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_CharSequence) => void): void;
    public "java/lang/StringBuffer/subSequence(II)Ljava/lang/CharSequence;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_CharSequence) => void): void;
    public "substring(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/StringBuffer/substring(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "insert(I[CII)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(I[CII)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(ILjava/lang/Object;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/Object;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(ILjava/lang/String;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/String;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(I[C)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(I[C)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(ILjava/lang/CharSequence;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/CharSequence;)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(ILjava/lang/CharSequence;II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/CharSequence;II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(IZ)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(IZ)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(IC)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(IC)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(II)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(IJ)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(IJ)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(IF)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(IF)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "insert(ID)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/insert(ID)Ljava/lang/StringBuffer;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "indexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/indexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "indexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/indexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lastIndexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/lastIndexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lastIndexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/StringBuffer/lastIndexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "reverse()Ljava/lang/StringBuffer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "java/lang/StringBuffer/reverse()Ljava/lang/StringBuffer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_StringBuffer) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/StringBuffer/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/StringBuffer/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "reverse()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/reverse()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ID)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(ID)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IF)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(IF)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IJ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(IJ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IC)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(IC)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IZ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(IZ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(I[C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(I[C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(ILjava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(I[CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/insert(I[CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "replace(IILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/replace(IILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "deleteCharAt(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/deleteCharAt(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "appendCodePoint(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/appendCodePoint(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "delete(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/delete(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(D)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(D)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(F)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(F)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(J)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(J)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Z)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(Z)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append([CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append([CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append([C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append([C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/AbstractStringBuilder;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_AbstractStringBuilder], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/AbstractStringBuilder;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_AbstractStringBuilder], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/StringBuffer;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/StringBuffer;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(C)Ljava/lang/Appendable;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/StringBuffer/append(C)Ljava/lang/Appendable;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/StringBuffer/append(Ljava/lang/CharSequence;)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/StringBuffer/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "chars()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "codePoints()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
  }
  export interface java_lang_CharSequence extends java_lang_Object {
    "length()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "charAt(I)C"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "subSequence(II)Ljava/lang/CharSequence;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_CharSequence) => void): void;
    "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "chars()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "codePoints()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "lambda$codePoints$1()Ljava/util/Spliterator$OfInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfInt) => void): void;
    "lambda$chars$0()Ljava/util/Spliterator$OfInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfInt) => void): void;
  }
  export interface java_util_Spliterator$OfInt extends java_lang_Object, java_util_Spliterator$OfPrimitive {
    "trySplit()Ljava/util/Spliterator$OfInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfInt) => void): void;
    "tryAdvance(Ljava/util/function/IntConsumer;)Z"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/IntConsumer;)V"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "tryAdvance(Ljava/util/function/Consumer;)Z"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "tryAdvance(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "trySplit()Ljava/util/Spliterator$OfPrimitive;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfPrimitive) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "estimateSize()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "getExactSizeIfKnown()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "characteristics()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hasCharacteristics(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getComparator()Ljava/util/Comparator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_IntConsumer extends java_lang_Object {
    "accept(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    "andThen(Ljava/util/function/IntConsumer;)Ljava/util/function/IntConsumer;"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/IntConsumer;I)V"(thread: JVMThread, args: [java_util_function_IntConsumer, number], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_AbstractStringBuilder extends java_lang_Object implements java_lang_Appendable, java_lang_CharSequence {
    public "java/lang/AbstractStringBuilder/value": JVMArray<number>;
    public "java/lang/AbstractStringBuilder/count": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "length()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/length()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ensureCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/ensureCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "ensureCapacityInternal(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/ensureCapacityInternal(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "expandCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/expandCapacity(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "trimToSize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/trimToSize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setLength(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/setLength(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "charAt(I)C"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/charAt(I)C"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointAt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/codePointAt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointBefore(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/codePointBefore(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "codePointCount(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/codePointCount(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "offsetByCodePoints(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/offsetByCodePoints(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getChars(II[CI)V"(thread: JVMThread, args: [number, number, JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/getChars(II[CI)V"(thread: JVMThread, args: [number, number, JVMArray<number>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "setCharAt(IC)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/setCharAt(IC)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "append(Ljava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/StringBuffer;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/StringBuffer;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_StringBuffer], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/AbstractStringBuilder;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_AbstractStringBuilder], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/AbstractStringBuilder;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_AbstractStringBuilder], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "appendNull()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/appendNull()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append([C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append([C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append([CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append([CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(Z)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(Z)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(J)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(J)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(F)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(F)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "append(D)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/append(D)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "delete(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/delete(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "appendCodePoint(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/appendCodePoint(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "deleteCharAt(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/deleteCharAt(I)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "replace(IILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/replace(IILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "substring(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/AbstractStringBuilder/substring(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "subSequence(II)Ljava/lang/CharSequence;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_CharSequence) => void): void;
    public "java/lang/AbstractStringBuilder/subSequence(II)Ljava/lang/CharSequence;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_CharSequence) => void): void;
    public "substring(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/AbstractStringBuilder/substring(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "insert(I[CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(I[CII)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(ILjava/lang/Object;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(ILjava/lang/String;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(I[C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(I[C)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(ILjava/lang/CharSequence;)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ILjava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(ILjava/lang/CharSequence;II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IZ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(IZ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IC)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(IC)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(II)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IJ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(IJ)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(IF)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(IF)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "insert(ID)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/insert(ID)Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: [number, number, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "indexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/indexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "indexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/indexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lastIndexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/lastIndexOf(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lastIndexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/AbstractStringBuilder/lastIndexOf(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "reverse()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "java/lang/AbstractStringBuilder/reverse()Ljava/lang/AbstractStringBuilder;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_AbstractStringBuilder) => void): void;
    public "reverseAllValidSurrogatePairs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/AbstractStringBuilder/reverseAllValidSurrogatePairs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/AbstractStringBuilder/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getValue()[C"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "java/lang/AbstractStringBuilder/getValue()[C"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    public "append(C)Ljava/lang/Appendable;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/AbstractStringBuilder/append(C)Ljava/lang/Appendable;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "append(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/CharSequence;II)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "append(Ljava/lang/CharSequence;)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    public "java/lang/AbstractStringBuilder/append(Ljava/lang/CharSequence;)Ljava/lang/Appendable;"(thread: JVMThread, args: [java_lang_CharSequence], cb?: (e?: java_lang_Throwable, rv?: java_lang_Appendable) => void): void;
    "chars()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "codePoints()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "lambda$codePoints$1()Ljava/util/Spliterator$OfInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfInt) => void): void;
    "lambda$chars$0()Ljava/util/Spliterator$OfInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfInt) => void): void;
  }
  export class java_util_Random extends java_lang_Object implements java_io_Serializable {
    public static "java/util/Random/serialVersionUID": Long;
    public "java/util/Random/seed": java_util_concurrent_atomic_AtomicLong;
    public static "java/util/Random/multiplier": Long;
    public static "java/util/Random/addend": Long;
    public static "java/util/Random/mask": Long;
    public static "java/util/Random/DOUBLE_UNIT": number;
    public static "java/util/Random/BadBound": java_lang_String;
    public static "java/util/Random/BadRange": java_lang_String;
    public static "java/util/Random/BadSize": java_lang_String;
    public static "java/util/Random/seedUniquifier": java_util_concurrent_atomic_AtomicLong;
    public "java/util/Random/nextNextGaussian": number;
    public "java/util/Random/haveNextNextGaussian": number;
    public static "java/util/Random/serialPersistentFields": JVMArray<java_io_ObjectStreamField>;
    public static "java/util/Random/unsafe": sun_misc_Unsafe;
    public static "java/util/Random/seedOffset": Long;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Random/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "seedUniquifier()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/util/Random/seedUniquifier()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Random/<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "initialScramble(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/util/Random/initialScramble(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "setSeed(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Random/setSeed(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "next(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/next(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nextBytes([B)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Random/nextBytes([B)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "internalNextLong(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/Random/internalNextLong(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "internalNextInt(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/internalNextInt(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "internalNextDouble(DD)D"(thread: JVMThread, args: [number, any, number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/internalNextDouble(DD)D"(thread: JVMThread, args: [number, any, number, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nextInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/nextInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nextInt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/nextInt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nextLong()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/Random/nextLong()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "nextBoolean()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/nextBoolean()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nextFloat()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/nextFloat()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nextDouble()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/nextDouble()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nextGaussian()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/Random/nextGaussian()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ints(J)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "java/util/Random/ints(J)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "ints()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "java/util/Random/ints()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "ints(JII)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [Long, any, number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "java/util/Random/ints(JII)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [Long, any, number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "ints(II)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "java/util/Random/ints(II)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    public "longs(J)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "java/util/Random/longs(J)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "longs()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "java/util/Random/longs()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "longs(JJJ)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "java/util/Random/longs(JJJ)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "longs(JJ)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "java/util/Random/longs(JJ)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    public "doubles(J)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "java/util/Random/doubles(J)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "doubles()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "java/util/Random/doubles()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "doubles(JDD)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [Long, any, number, any, number, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "java/util/Random/doubles(JDD)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [Long, any, number, any, number, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "doubles(DD)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [number, any, number, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "java/util/Random/doubles(DD)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [number, any, number, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Random/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Random/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "resetSeed(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/Random/resetSeed(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/Random/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_io_ObjectStreamField extends java_lang_Object implements java_lang_Comparable {
    public "java/io/ObjectStreamField/name": java_lang_String;
    public "java/io/ObjectStreamField/signature": java_lang_String;
    public "java/io/ObjectStreamField/type": java_lang_Class;
    public "java/io/ObjectStreamField/unshared": number;
    public "java/io/ObjectStreamField/field": java_lang_reflect_Field;
    public "java/io/ObjectStreamField/offset": number;
    public "<init>(Ljava/lang/String;Ljava/lang/Class;)V"(thread: JVMThread, args: [java_lang_String, java_lang_Class], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/ObjectStreamField/<init>(Ljava/lang/String;Ljava/lang/Class;)V"(thread: JVMThread, args: [java_lang_String, java_lang_Class], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;Ljava/lang/Class;Z)V"(thread: JVMThread, args: [java_lang_String, java_lang_Class, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/ObjectStreamField/<init>(Ljava/lang/String;Ljava/lang/Class;Z)V"(thread: JVMThread, args: [java_lang_String, java_lang_Class, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;Ljava/lang/String;Z)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/ObjectStreamField/<init>(Ljava/lang/String;Ljava/lang/String;Z)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/reflect/Field;ZZ)V"(thread: JVMThread, args: [java_lang_reflect_Field, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/ObjectStreamField/<init>(Ljava/lang/reflect/Field;ZZ)V"(thread: JVMThread, args: [java_lang_reflect_Field, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/io/ObjectStreamField/getName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getType()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public "java/io/ObjectStreamField/getType()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public "getTypeCode()C"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/io/ObjectStreamField/getTypeCode()C"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getTypeString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/io/ObjectStreamField/getTypeString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getOffset()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/io/ObjectStreamField/getOffset()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setOffset(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/ObjectStreamField/setOffset(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "isPrimitive()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/io/ObjectStreamField/isPrimitive()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isUnshared()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/io/ObjectStreamField/isUnshared()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/io/ObjectStreamField/compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/io/ObjectStreamField/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getField()Ljava/lang/reflect/Field;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_reflect_Field) => void): void;
    public "java/io/ObjectStreamField/getField()Ljava/lang/reflect/Field;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_reflect_Field) => void): void;
    public "getSignature()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/io/ObjectStreamField/getSignature()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "getClassSignature(Ljava/lang/Class;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/io/ObjectStreamField/getClassSignature(Ljava/lang/Class;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
  }
  export class java_lang_Number extends java_lang_Object implements java_io_Serializable {
    public static "java/lang/Number/serialVersionUID": Long;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Number/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Number/intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/lang/Number/longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Number/floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Number/doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "byteValue()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Number/byteValue()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "shortValue()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Number/shortValue()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_util_LongSummaryStatistics extends java_lang_Object implements java_util_function_LongConsumer, java_util_function_IntConsumer {
    public "java/util/LongSummaryStatistics/count": Long;
    public "java/util/LongSummaryStatistics/sum": Long;
    public "java/util/LongSummaryStatistics/min": Long;
    public "java/util/LongSummaryStatistics/max": Long;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/LongSummaryStatistics/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "accept(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/LongSummaryStatistics/accept(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "accept(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/LongSummaryStatistics/accept(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "combine(Ljava/util/LongSummaryStatistics;)V"(thread: JVMThread, args: [java_util_LongSummaryStatistics], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/LongSummaryStatistics/combine(Ljava/util/LongSummaryStatistics;)V"(thread: JVMThread, args: [java_util_LongSummaryStatistics], cb?: (e?: java_lang_Throwable) => void): void;
    public "getCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/LongSummaryStatistics/getCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getSum()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/LongSummaryStatistics/getSum()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getMin()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/LongSummaryStatistics/getMin()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getMax()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/LongSummaryStatistics/getMax()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getAverage()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/LongSummaryStatistics/getAverage()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/LongSummaryStatistics/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "andThen(Ljava/util/function/LongConsumer;)Ljava/util/function/LongConsumer;"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/LongConsumer;J)V"(thread: JVMThread, args: [java_util_function_LongConsumer, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    "andThen(Ljava/util/function/IntConsumer;)Ljava/util/function/IntConsumer;"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/IntConsumer;I)V"(thread: JVMThread, args: [java_util_function_IntConsumer, number], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_ObjLongConsumer extends java_lang_Object {
    "accept(Ljava/lang/Object;J)V"(thread: JVMThread, args: [java_lang_Object, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_OptionalLong extends java_lang_Object {
    public static "java/util/OptionalLong/EMPTY": java_util_OptionalLong;
    public "java/util/OptionalLong/isPresent": number;
    public "java/util/OptionalLong/value": Long;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalLong/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "empty()Ljava/util/OptionalLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    public static "java/util/OptionalLong/empty()Ljava/util/OptionalLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    public "<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalLong/<init>(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "of(J)Ljava/util/OptionalLong;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    public static "java/util/OptionalLong/of(J)Ljava/util/OptionalLong;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalLong) => void): void;
    public "getAsLong()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/OptionalLong/getAsLong()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalLong/isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ifPresent(Ljava/util/function/LongConsumer;)V"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalLong/ifPresent(Ljava/util/function/LongConsumer;)V"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "orElse(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/OptionalLong/orElse(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "orElseGet(Ljava/util/function/LongSupplier;)J"(thread: JVMThread, args: [java_util_function_LongSupplier], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/OptionalLong/orElseGet(Ljava/util/function/LongSupplier;)J"(thread: JVMThread, args: [java_util_function_LongSupplier], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "orElseThrow(Ljava/util/function/Supplier;)J"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/OptionalLong/orElseThrow(Ljava/util/function/Supplier;)J"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalLong/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalLong/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/OptionalLong/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/OptionalLong/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_LongBinaryOperator extends java_lang_Object {
    "applyAsLong(JJ)J"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export interface java_util_function_LongConsumer extends java_lang_Object {
    "accept(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    "andThen(Ljava/util/function/LongConsumer;)Ljava/util/function/LongConsumer;"(thread: JVMThread, args: [java_util_function_LongConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/LongConsumer;J)V"(thread: JVMThread, args: [java_util_function_LongConsumer, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_LongToDoubleFunction extends java_lang_Object {
    "applyAsDouble(J)D"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_LongToIntFunction extends java_lang_Object {
    "applyAsInt(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_LongFunction extends java_lang_Object {
    "apply(J)Ljava/lang/Object;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_function_LongUnaryOperator extends java_lang_Object {
    "applyAsLong(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "compose(Ljava/util/function/LongUnaryOperator;)Ljava/util/function/LongUnaryOperator;"(thread: JVMThread, args: [java_util_function_LongUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongUnaryOperator) => void): void;
    "andThen(Ljava/util/function/LongUnaryOperator;)Ljava/util/function/LongUnaryOperator;"(thread: JVMThread, args: [java_util_function_LongUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongUnaryOperator) => void): void;
    "lambda$andThen$1(Ljava/util/function/LongUnaryOperator;J)J"(thread: JVMThread, args: [java_util_function_LongUnaryOperator, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "lambda$compose$0(Ljava/util/function/LongUnaryOperator;J)J"(thread: JVMThread, args: [java_util_function_LongUnaryOperator, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export interface java_util_function_LongPredicate extends java_lang_Object {
    "test(J)Z"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "and(Ljava/util/function/LongPredicate;)Ljava/util/function/LongPredicate;"(thread: JVMThread, args: [java_util_function_LongPredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongPredicate) => void): void;
    "negate()Ljava/util/function/LongPredicate;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongPredicate) => void): void;
    "or(Ljava/util/function/LongPredicate;)Ljava/util/function/LongPredicate;"(thread: JVMThread, args: [java_util_function_LongPredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_LongPredicate) => void): void;
    "lambda$or$2(Ljava/util/function/LongPredicate;J)Z"(thread: JVMThread, args: [java_util_function_LongPredicate, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$negate$1(J)Z"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$and$0(Ljava/util/function/LongPredicate;J)Z"(thread: JVMThread, args: [java_util_function_LongPredicate, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_ToIntFunction extends java_lang_Object {
    "applyAsInt(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_stream_IntStream extends java_lang_Object, java_util_stream_BaseStream {
    "filter(Ljava/util/function/IntPredicate;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_IntPredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "map(Ljava/util/function/IntUnaryOperator;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_IntUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "mapToObj(Ljava/util/function/IntFunction;)Ljava/util/stream/Stream;"(thread: JVMThread, args: [java_util_function_IntFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "mapToLong(Ljava/util/function/IntToLongFunction;)Ljava/util/stream/LongStream;"(thread: JVMThread, args: [java_util_function_IntToLongFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "mapToDouble(Ljava/util/function/IntToDoubleFunction;)Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: [java_util_function_IntToDoubleFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "flatMap(Ljava/util/function/IntFunction;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_IntFunction], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "distinct()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "sorted()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "peek(Ljava/util/function/IntConsumer;)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "limit(J)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "skip(J)Ljava/util/stream/IntStream;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "forEach(Ljava/util/function/IntConsumer;)V"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachOrdered(Ljava/util/function/IntConsumer;)V"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "toArray()[I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<number>) => void): void;
    "reduce(ILjava/util/function/IntBinaryOperator;)I"(thread: JVMThread, args: [number, java_util_function_IntBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "reduce(Ljava/util/function/IntBinaryOperator;)Ljava/util/OptionalInt;"(thread: JVMThread, args: [java_util_function_IntBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    "collect(Ljava/util/function/Supplier;Ljava/util/function/ObjIntConsumer;Ljava/util/function/BiConsumer;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_function_Supplier, java_util_function_ObjIntConsumer, java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "sum()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "min()Ljava/util/OptionalInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    "max()Ljava/util/OptionalInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    "count()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "average()Ljava/util/OptionalDouble;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalDouble) => void): void;
    "summaryStatistics()Ljava/util/IntSummaryStatistics;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_IntSummaryStatistics) => void): void;
    "anyMatch(Ljava/util/function/IntPredicate;)Z"(thread: JVMThread, args: [java_util_function_IntPredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "allMatch(Ljava/util/function/IntPredicate;)Z"(thread: JVMThread, args: [java_util_function_IntPredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "noneMatch(Ljava/util/function/IntPredicate;)Z"(thread: JVMThread, args: [java_util_function_IntPredicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "findFirst()Ljava/util/OptionalInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    "findAny()Ljava/util/OptionalInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    "asLongStream()Ljava/util/stream/LongStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_LongStream) => void): void;
    "asDoubleStream()Ljava/util/stream/DoubleStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_DoubleStream) => void): void;
    "boxed()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "sequential()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "parallel()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "iterator()Ljava/util/PrimitiveIterator$OfInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_PrimitiveIterator$OfInt) => void): void;
    "spliterator()Ljava/util/Spliterator$OfInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator$OfInt) => void): void;
    "parallel()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "sequential()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "isParallel()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "unordered()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "onClose(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_IntSupplier extends java_lang_Object {
    "getAsInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_stream_IntStream$Builder extends java_lang_Object, java_util_function_IntConsumer {
    "accept(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    "add(I)Ljava/util/stream/IntStream$Builder;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream$Builder) => void): void;
    "build()Ljava/util/stream/IntStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_IntStream) => void): void;
    "andThen(Ljava/util/function/IntConsumer;)Ljava/util/function/IntConsumer;"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/IntConsumer;I)V"(thread: JVMThread, args: [java_util_function_IntConsumer, number], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_PrimitiveIterator$OfInt extends java_lang_Object, java_util_PrimitiveIterator {
    "nextInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/IntConsumer;)V"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "next()Ljava/lang/Integer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "next()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "hasNext()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_Integer extends java_lang_Number implements java_lang_Comparable {
    public unbox(): number;
    public static box(val: number): java_lang_Integer;
    public static "java/lang/Integer/MIN_VALUE": number;
    public static "java/lang/Integer/MAX_VALUE": number;
    public static "java/lang/Integer/TYPE": java_lang_Class;
    public static "java/lang/Integer/digits": JVMArray<number>;
    public static "java/lang/Integer/DigitTens": JVMArray<number>;
    public static "java/lang/Integer/DigitOnes": JVMArray<number>;
    public static "java/lang/Integer/sizeTable": JVMArray<number>;
    public "java/lang/Integer/value": number;
    public static "java/lang/Integer/SIZE": number;
    public static "java/lang/Integer/BYTES": number;
    public static "java/lang/Integer/serialVersionUID": Long;
    public static "toString(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toString(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toUnsignedString(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toUnsignedString(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toHexString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toHexString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toOctalString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toOctalString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toBinaryString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toBinaryString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toUnsignedString0(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toUnsignedString0(II)Ljava/lang/String;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "formatUnsignedInt(II[CII)I"(thread: JVMThread, args: [number, number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/formatUnsignedInt(II[CII)I"(thread: JVMThread, args: [number, number, JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "toString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "toUnsignedString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Integer/toUnsignedString(I)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "getChars(II[C)V"(thread: JVMThread, args: [number, number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/Integer/getChars(II[C)V"(thread: JVMThread, args: [number, number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "stringSize(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/stringSize(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "parseInt(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/parseInt(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "parseInt(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/parseInt(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "parseUnsignedInt(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/parseUnsignedInt(Ljava/lang/String;I)I"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "parseUnsignedInt(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/parseUnsignedInt(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "valueOf(Ljava/lang/String;I)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "java/lang/Integer/valueOf(Ljava/lang/String;I)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "valueOf(Ljava/lang/String;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "java/lang/Integer/valueOf(Ljava/lang/String;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "valueOf(I)Ljava/lang/Integer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "java/lang/Integer/valueOf(I)Ljava/lang/Integer;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Integer/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Integer/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "byteValue()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/byteValue()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "shortValue()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/shortValue()S"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/lang/Integer/longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/Integer/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "hashCode(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/hashCode(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "getInteger(Ljava/lang/String;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "java/lang/Integer/getInteger(Ljava/lang/String;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "getInteger(Ljava/lang/String;I)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "java/lang/Integer/getInteger(Ljava/lang/String;I)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "getInteger(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String, java_lang_Integer], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "java/lang/Integer/getInteger(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String, java_lang_Integer], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "decode(Ljava/lang/String;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public static "java/lang/Integer/decode(Ljava/lang/String;)Ljava/lang/Integer;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Integer) => void): void;
    public "compareTo(Ljava/lang/Integer;)I"(thread: JVMThread, args: [java_lang_Integer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/compareTo(Ljava/lang/Integer;)I"(thread: JVMThread, args: [java_lang_Integer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "compare(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/compare(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "compareUnsigned(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/compareUnsigned(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "toUnsignedLong(I)J"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/lang/Integer/toUnsignedLong(I)J"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "divideUnsigned(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/divideUnsigned(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "remainderUnsigned(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/remainderUnsigned(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "highestOneBit(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/highestOneBit(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "lowestOneBit(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/lowestOneBit(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "numberOfLeadingZeros(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/numberOfLeadingZeros(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "numberOfTrailingZeros(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/numberOfTrailingZeros(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "bitCount(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/bitCount(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "rotateLeft(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/rotateLeft(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "rotateRight(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/rotateRight(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "reverse(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/reverse(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "signum(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/signum(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "reverseBytes(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/reverseBytes(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sum(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/sum(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "max(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/max(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "min(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Integer/min(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Integer/compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/Integer/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_IntSummaryStatistics extends java_lang_Object implements java_util_function_IntConsumer {
    public "java/util/IntSummaryStatistics/count": Long;
    public "java/util/IntSummaryStatistics/sum": Long;
    public "java/util/IntSummaryStatistics/min": number;
    public "java/util/IntSummaryStatistics/max": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/IntSummaryStatistics/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "accept(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/IntSummaryStatistics/accept(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "combine(Ljava/util/IntSummaryStatistics;)V"(thread: JVMThread, args: [java_util_IntSummaryStatistics], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/IntSummaryStatistics/combine(Ljava/util/IntSummaryStatistics;)V"(thread: JVMThread, args: [java_util_IntSummaryStatistics], cb?: (e?: java_lang_Throwable) => void): void;
    public "getCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/IntSummaryStatistics/getCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getSum()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/IntSummaryStatistics/getSum()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getMin()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/IntSummaryStatistics/getMin()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getMax()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/IntSummaryStatistics/getMax()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAverage()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/IntSummaryStatistics/getAverage()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/IntSummaryStatistics/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "andThen(Ljava/util/function/IntConsumer;)Ljava/util/function/IntConsumer;"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntConsumer) => void): void;
    "lambda$andThen$0(Ljava/util/function/IntConsumer;I)V"(thread: JVMThread, args: [java_util_function_IntConsumer, number], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_ObjIntConsumer extends java_lang_Object {
    "accept(Ljava/lang/Object;I)V"(thread: JVMThread, args: [java_lang_Object, number], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_OptionalInt extends java_lang_Object {
    public static "java/util/OptionalInt/EMPTY": java_util_OptionalInt;
    public "java/util/OptionalInt/isPresent": number;
    public "java/util/OptionalInt/value": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalInt/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "empty()Ljava/util/OptionalInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    public static "java/util/OptionalInt/empty()Ljava/util/OptionalInt;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalInt/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "of(I)Ljava/util/OptionalInt;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    public static "java/util/OptionalInt/of(I)Ljava/util/OptionalInt;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_util_OptionalInt) => void): void;
    public "getAsInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalInt/getAsInt()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalInt/isPresent()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ifPresent(Ljava/util/function/IntConsumer;)V"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/OptionalInt/ifPresent(Ljava/util/function/IntConsumer;)V"(thread: JVMThread, args: [java_util_function_IntConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "orElse(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalInt/orElse(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "orElseGet(Ljava/util/function/IntSupplier;)I"(thread: JVMThread, args: [java_util_function_IntSupplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalInt/orElseGet(Ljava/util/function/IntSupplier;)I"(thread: JVMThread, args: [java_util_function_IntSupplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "orElseThrow(Ljava/util/function/Supplier;)I"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalInt/orElseThrow(Ljava/util/function/Supplier;)I"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalInt/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/OptionalInt/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/OptionalInt/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/OptionalInt/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_function_IntBinaryOperator extends java_lang_Object {
    "applyAsInt(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_IntToDoubleFunction extends java_lang_Object {
    "applyAsDouble(I)D"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_IntToLongFunction extends java_lang_Object {
    "applyAsLong(I)J"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export interface java_util_function_IntUnaryOperator extends java_lang_Object {
    "applyAsInt(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "compose(Ljava/util/function/IntUnaryOperator;)Ljava/util/function/IntUnaryOperator;"(thread: JVMThread, args: [java_util_function_IntUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntUnaryOperator) => void): void;
    "andThen(Ljava/util/function/IntUnaryOperator;)Ljava/util/function/IntUnaryOperator;"(thread: JVMThread, args: [java_util_function_IntUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntUnaryOperator) => void): void;
    "lambda$andThen$1(Ljava/util/function/IntUnaryOperator;I)I"(thread: JVMThread, args: [java_util_function_IntUnaryOperator, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$compose$0(Ljava/util/function/IntUnaryOperator;I)I"(thread: JVMThread, args: [java_util_function_IntUnaryOperator, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_function_IntPredicate extends java_lang_Object {
    "test(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "and(Ljava/util/function/IntPredicate;)Ljava/util/function/IntPredicate;"(thread: JVMThread, args: [java_util_function_IntPredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntPredicate) => void): void;
    "negate()Ljava/util/function/IntPredicate;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntPredicate) => void): void;
    "or(Ljava/util/function/IntPredicate;)Ljava/util/function/IntPredicate;"(thread: JVMThread, args: [java_util_function_IntPredicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_IntPredicate) => void): void;
    "lambda$or$2(Ljava/util/function/IntPredicate;I)Z"(thread: JVMThread, args: [java_util_function_IntPredicate, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$negate$1(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$and$0(Ljava/util/function/IntPredicate;I)Z"(thread: JVMThread, args: [java_util_function_IntPredicate, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_stream_BaseStream extends java_lang_Object, java_lang_AutoCloseable {
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "isParallel()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "sequential()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "parallel()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "unordered()Ljava/util/stream/BaseStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "onClose(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_BaseStream) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_lang_AutoCloseable extends java_lang_Object {
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_Spliterator extends java_lang_Object {
    "tryAdvance(Ljava/util/function/Consumer;)Z"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "trySplit()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "estimateSize()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "getExactSizeIfKnown()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "characteristics()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hasCharacteristics(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getComparator()Ljava/util/Comparator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Comparator) => void): void;
  }
  export interface java_util_function_Predicate extends java_lang_Object {
    "test(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "and(Ljava/util/function/Predicate;)Ljava/util/function/Predicate;"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Predicate) => void): void;
    "negate()Ljava/util/function/Predicate;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Predicate) => void): void;
    "or(Ljava/util/function/Predicate;)Ljava/util/function/Predicate;"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: java_util_function_Predicate) => void): void;
    "lambda$or$2(Ljava/util/function/Predicate;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_util_function_Predicate, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$negate$1(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lambda$and$0(Ljava/util/function/Predicate;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_util_function_Predicate, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_Iterator extends java_lang_Object {
    "hasNext()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "next()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_lang_Iterable extends java_lang_Object {
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
  }
  export interface java_util_Set extends java_lang_Object, java_util_Collection {
    "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "containsAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "addAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "retainAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
  }
  export class sun_reflect_NativeConstructorAccessorImpl extends sun_reflect_ConstructorAccessorImpl {
    public "sun/reflect/NativeConstructorAccessorImpl/c": java_lang_reflect_Constructor;
    public "sun/reflect/NativeConstructorAccessorImpl/parent": sun_reflect_DelegatingConstructorAccessorImpl;
    public "sun/reflect/NativeConstructorAccessorImpl/numInvocations": number;
    public "<init>(Ljava/lang/reflect/Constructor;)V"(thread: JVMThread, args: [java_lang_reflect_Constructor], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/NativeConstructorAccessorImpl/<init>(Ljava/lang/reflect/Constructor;)V"(thread: JVMThread, args: [java_lang_reflect_Constructor], cb?: (e?: java_lang_Throwable) => void): void;
    public "newInstance([Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/reflect/NativeConstructorAccessorImpl/newInstance([Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "setParent(Lsun/reflect/DelegatingConstructorAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_DelegatingConstructorAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/NativeConstructorAccessorImpl/setParent(Lsun/reflect/DelegatingConstructorAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_DelegatingConstructorAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public static "newInstance0(Ljava/lang/reflect/Constructor;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_reflect_Constructor, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "sun/reflect/NativeConstructorAccessorImpl/newInstance0(Ljava/lang/reflect/Constructor;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_reflect_Constructor, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class sun_reflect_DelegatingConstructorAccessorImpl extends sun_reflect_ConstructorAccessorImpl {
    public "sun/reflect/DelegatingConstructorAccessorImpl/delegate": sun_reflect_ConstructorAccessorImpl;
    public "<init>(Lsun/reflect/ConstructorAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_ConstructorAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/DelegatingConstructorAccessorImpl/<init>(Lsun/reflect/ConstructorAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_ConstructorAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "newInstance([Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/reflect/DelegatingConstructorAccessorImpl/newInstance([Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "setDelegate(Lsun/reflect/ConstructorAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_ConstructorAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/DelegatingConstructorAccessorImpl/setDelegate(Lsun/reflect/ConstructorAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_ConstructorAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_reflect_ConstructorAccessorImpl extends sun_reflect_MagicAccessorImpl implements sun_reflect_ConstructorAccessor {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/ConstructorAccessorImpl/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "newInstance([Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/reflect/ConstructorAccessorImpl/newInstance([Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface sun_reflect_ConstructorAccessor extends java_lang_Object {
    "newInstance([Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class sun_reflect_MagicAccessorImpl extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/MagicAccessorImpl/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_reflect_NativeMethodAccessorImpl extends sun_reflect_MethodAccessorImpl {
    public "sun/reflect/NativeMethodAccessorImpl/method": java_lang_reflect_Method;
    public "sun/reflect/NativeMethodAccessorImpl/parent": sun_reflect_DelegatingMethodAccessorImpl;
    public "sun/reflect/NativeMethodAccessorImpl/numInvocations": number;
    public "<init>(Ljava/lang/reflect/Method;)V"(thread: JVMThread, args: [java_lang_reflect_Method], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/NativeMethodAccessorImpl/<init>(Ljava/lang/reflect/Method;)V"(thread: JVMThread, args: [java_lang_reflect_Method], cb?: (e?: java_lang_Throwable) => void): void;
    public "invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/reflect/NativeMethodAccessorImpl/invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "setParent(Lsun/reflect/DelegatingMethodAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_DelegatingMethodAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/NativeMethodAccessorImpl/setParent(Lsun/reflect/DelegatingMethodAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_DelegatingMethodAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public static "invoke0(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_reflect_Method, java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "sun/reflect/NativeMethodAccessorImpl/invoke0(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_reflect_Method, java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class sun_reflect_DelegatingMethodAccessorImpl extends sun_reflect_MethodAccessorImpl {
    public "sun/reflect/DelegatingMethodAccessorImpl/delegate": sun_reflect_MethodAccessorImpl;
    public "<init>(Lsun/reflect/MethodAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_MethodAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/DelegatingMethodAccessorImpl/<init>(Lsun/reflect/MethodAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_MethodAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/reflect/DelegatingMethodAccessorImpl/invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "setDelegate(Lsun/reflect/MethodAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_MethodAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/DelegatingMethodAccessorImpl/setDelegate(Lsun/reflect/MethodAccessorImpl;)V"(thread: JVMThread, args: [sun_reflect_MethodAccessorImpl], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_reflect_MethodAccessorImpl extends sun_reflect_MagicAccessorImpl implements sun_reflect_MethodAccessor {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/reflect/MethodAccessorImpl/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/reflect/MethodAccessorImpl/invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface sun_reflect_MethodAccessor extends java_lang_Object {
    "invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class sun_nio_ch_sctp_SctpServerChannelImpl extends com_sun_nio_sctp_SctpServerChannel implements sun_nio_ch_SelChImpl {
    public "sun/nio/ch/sctp/SctpServerChannelImpl/fd": java_io_FileDescriptor;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/fdVal": number;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/thread": Long;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/lock": java_lang_Object;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/stateLock": java_lang_Object;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/state": sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/port": number;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/localAddresses": java_util_HashSet;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/wildcard": number;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl/$assertionsDisabled": number;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "bind(Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/bind(Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "bindUnbindAddress(Ljava/net/InetAddress;Z)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/bindUnbindAddress(Ljava/net/InetAddress;Z)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "acceptCleanup()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/acceptCleanup()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "accept()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/accept()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "implConfigureBlocking(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/implConfigureBlocking(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "implCloseSelectableChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/implCloseSelectableChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "kill()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/kill()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getFD()Ljava/io/FileDescriptor;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/getFD()Ljava/io/FileDescriptor;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "getFDVal()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/getFDVal()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateReadyOps(IILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/translateReadyOps(IILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateAndUpdateReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/translateAndUpdateReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateAndSetReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/translateAndSetReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateAndSetInterestOps(ILsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/translateAndSetInterestOps(ILsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl/getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "initIDs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl/initIDs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "accept0(Ljava/io/FileDescriptor;Ljava/io/FileDescriptor;[Ljava/net/InetSocketAddress;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_io_FileDescriptor, JVMArray<java_net_InetSocketAddress>], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl/accept0(Ljava/io/FileDescriptor;Ljava/io/FileDescriptor;[Ljava/net/InetSocketAddress;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_io_FileDescriptor, JVMArray<java_net_InetSocketAddress>], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface com_sun_nio_sctp_SctpSocketOption extends java_lang_Object, java_net_SocketOption {
    "name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "type()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
  }
  export interface java_net_SocketOption extends java_lang_Object {
    "name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "type()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
  }
  export class sun_nio_ch_SelectionKeyImpl extends java_nio_channels_spi_AbstractSelectionKey {
    public "sun/nio/ch/SelectionKeyImpl/channel": sun_nio_ch_SelChImpl;
    public "sun/nio/ch/SelectionKeyImpl/selector": sun_nio_ch_SelectorImpl;
    public "sun/nio/ch/SelectionKeyImpl/index": number;
    public "sun/nio/ch/SelectionKeyImpl/interestOps": number;
    public "sun/nio/ch/SelectionKeyImpl/readyOps": number;
    public "<init>(Lsun/nio/ch/SelChImpl;Lsun/nio/ch/SelectorImpl;)V"(thread: JVMThread, args: [sun_nio_ch_SelChImpl, sun_nio_ch_SelectorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/<init>(Lsun/nio/ch/SelChImpl;Lsun/nio/ch/SelectorImpl;)V"(thread: JVMThread, args: [sun_nio_ch_SelChImpl, sun_nio_ch_SelectorImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "channel()Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/channel()Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "selector()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/selector()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "getIndex()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/getIndex()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setIndex(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/setIndex(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "ensureValid()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/ensureValid()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "interestOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/interestOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "interestOps(I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/interestOps(I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "readyOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/readyOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nioReadyOps(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/nioReadyOps(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "nioReadyOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/nioReadyOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "nioInterestOps(I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/nioInterestOps(I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "nioInterestOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectionKeyImpl/nioInterestOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_nio_channels_SelectionKey extends java_lang_Object {
    public static "java/nio/channels/SelectionKey/OP_READ": number;
    public static "java/nio/channels/SelectionKey/OP_WRITE": number;
    public static "java/nio/channels/SelectionKey/OP_CONNECT": number;
    public static "java/nio/channels/SelectionKey/OP_ACCEPT": number;
    public "java/nio/channels/SelectionKey/attachment": java_lang_Object;
    public static "java/nio/channels/SelectionKey/attachmentUpdater": java_util_concurrent_atomic_AtomicReferenceFieldUpdater;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/SelectionKey/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "channel()Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "java/nio/channels/SelectionKey/channel()Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "selector()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "java/nio/channels/SelectionKey/selector()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectionKey/isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "cancel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/SelectionKey/cancel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "interestOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectionKey/interestOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "interestOps(I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/SelectionKey/interestOps(I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "readyOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectionKey/readyOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isReadable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectionKey/isReadable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isWritable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectionKey/isWritable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isConnectable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectionKey/isConnectable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isAcceptable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectionKey/isAcceptable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "attach(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/nio/channels/SelectionKey/attach(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "attachment()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/nio/channels/SelectionKey/attachment()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/SelectionKey/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_concurrent_atomic_AtomicReferenceFieldUpdater extends java_lang_Object {
    public static "newUpdater(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;"(thread: JVMThread, args: [java_lang_Class, java_lang_Class, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_atomic_AtomicReferenceFieldUpdater) => void): void;
    public static "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/newUpdater(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;"(thread: JVMThread, args: [java_lang_Class, java_lang_Class, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_atomic_AtomicReferenceFieldUpdater) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "compareAndSet(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/compareAndSet(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "weakCompareAndSet(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/weakCompareAndSet(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "set(Ljava/lang/Object;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/set(Ljava/lang/Object;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "lazySet(Ljava/lang/Object;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/lazySet(Ljava/lang/Object;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "get(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/get(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "getAndSet(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/getAndSet(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "getAndUpdate(Ljava/lang/Object;Ljava/util/function/UnaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_UnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/getAndUpdate(Ljava/lang/Object;Ljava/util/function/UnaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_UnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "updateAndGet(Ljava/lang/Object;Ljava/util/function/UnaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_UnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/updateAndGet(Ljava/lang/Object;Ljava/util/function/UnaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_UnaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "getAndAccumulate(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BinaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/getAndAccumulate(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BinaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "accumulateAndGet(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BinaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/concurrent/atomic/AtomicReferenceFieldUpdater/accumulateAndGet(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BinaryOperator;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BinaryOperator], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class java_nio_channels_Selector extends java_lang_Object implements java_io_Closeable {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/Selector/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public static "java/nio/channels/Selector/open()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/Selector/isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "java/nio/channels/Selector/provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "keys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/nio/channels/Selector/keys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "selectedKeys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/nio/channels/Selector/selectedKeys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "selectNow()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/Selector/selectNow()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "select(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/Selector/select(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "select()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/Selector/select()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "wakeup()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "java/nio/channels/Selector/wakeup()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/Selector/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_io_Closeable extends java_lang_Object, java_lang_AutoCloseable {
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_SelectableChannel extends java_nio_channels_spi_AbstractInterruptibleChannel implements java_nio_channels_Channel {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/SelectableChannel/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "java/nio/channels/SelectableChannel/provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectableChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isRegistered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectableChannel/isRegistered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "keyFor(Ljava/nio/channels/Selector;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/SelectableChannel/keyFor(Ljava/nio/channels/Selector;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "register(Ljava/nio/channels/Selector;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/SelectableChannel/register(Ljava/nio/channels/Selector;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "register(Ljava/nio/channels/Selector;I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/SelectableChannel/register(Ljava/nio/channels/Selector;I)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "configureBlocking(Z)Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "java/nio/channels/SelectableChannel/configureBlocking(Z)Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "isBlocking()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SelectableChannel/isBlocking()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "blockingLock()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/nio/channels/SelectableChannel/blockingLock()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_nio_channels_Channel extends java_lang_Object, java_io_Closeable {
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_spi_AbstractInterruptibleChannel extends java_lang_Object implements java_nio_channels_Channel, java_nio_channels_InterruptibleChannel {
    public "java/nio/channels/spi/AbstractInterruptibleChannel/closeLock": java_lang_Object;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/open": number;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/interruptor": sun_nio_ch_Interruptible;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/interrupted": java_lang_Thread;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "implCloseChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/implCloseChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "begin()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/begin()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "end(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractInterruptibleChannel/end(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "blockedOn(Lsun/nio/ch/Interruptible;)V"(thread: JVMThread, args: [sun_nio_ch_Interruptible], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/spi/AbstractInterruptibleChannel/blockedOn(Lsun/nio/ch/Interruptible;)V"(thread: JVMThread, args: [sun_nio_ch_Interruptible], cb?: (e?: java_lang_Throwable) => void): void;
    public static "access$000(Ljava/nio/channels/spi/AbstractInterruptibleChannel;)Ljava/lang/Object;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "java/nio/channels/spi/AbstractInterruptibleChannel/access$000(Ljava/nio/channels/spi/AbstractInterruptibleChannel;)Ljava/lang/Object;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "access$100(Ljava/nio/channels/spi/AbstractInterruptibleChannel;)Z"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/nio/channels/spi/AbstractInterruptibleChannel/access$100(Ljava/nio/channels/spi/AbstractInterruptibleChannel;)Z"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$102(Ljava/nio/channels/spi/AbstractInterruptibleChannel;Z)Z"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/nio/channels/spi/AbstractInterruptibleChannel/access$102(Ljava/nio/channels/spi/AbstractInterruptibleChannel;Z)Z"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$202(Ljava/nio/channels/spi/AbstractInterruptibleChannel;Ljava/lang/Thread;)Ljava/lang/Thread;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel, java_lang_Thread], cb?: (e?: java_lang_Throwable, rv?: java_lang_Thread) => void): void;
    public static "java/nio/channels/spi/AbstractInterruptibleChannel/access$202(Ljava/nio/channels/spi/AbstractInterruptibleChannel;Ljava/lang/Thread;)Ljava/lang/Thread;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractInterruptibleChannel, java_lang_Thread], cb?: (e?: java_lang_Throwable, rv?: java_lang_Thread) => void): void;
  }
  export interface sun_nio_ch_Interruptible extends java_lang_Object {
    "interrupt(Ljava/lang/Thread;)V"(thread: JVMThread, args: [java_lang_Thread], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_channels_InterruptibleChannel extends java_lang_Object, java_nio_channels_Channel {
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class sun_nio_ch_SelectorImpl extends java_nio_channels_spi_AbstractSelector {
    public "sun/nio/ch/SelectorImpl/selectedKeys": java_util_Set;
    public "sun/nio/ch/SelectorImpl/keys": java_util_HashSet;
    public "sun/nio/ch/SelectorImpl/publicKeys": java_util_Set;
    public "sun/nio/ch/SelectorImpl/publicSelectedKeys": java_util_Set;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectorImpl/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "keys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "sun/nio/ch/SelectorImpl/keys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "selectedKeys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "sun/nio/ch/SelectorImpl/selectedKeys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "doSelect(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectorImpl/doSelect(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lockAndDoSelect(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectorImpl/lockAndDoSelect(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "select(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectorImpl/select(J)I"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "select()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectorImpl/select()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "selectNow()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/SelectorImpl/selectNow()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "implCloseSelector()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectorImpl/implCloseSelector()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "implClose()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectorImpl/implClose()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "putEventOps(Lsun/nio/ch/SelectionKeyImpl;I)V"(thread: JVMThread, args: [sun_nio_ch_SelectionKeyImpl, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectorImpl/putEventOps(Lsun/nio/ch/SelectionKeyImpl;I)V"(thread: JVMThread, args: [sun_nio_ch_SelectionKeyImpl, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "register(Ljava/nio/channels/spi/AbstractSelectableChannel;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractSelectableChannel, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "sun/nio/ch/SelectorImpl/register(Ljava/nio/channels/spi/AbstractSelectableChannel;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractSelectableChannel, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "implRegister(Lsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectorImpl/implRegister(Lsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "processDeregisterQueue()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectorImpl/processDeregisterQueue()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "implDereg(Lsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/SelectorImpl/implDereg(Lsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "wakeup()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
    public "sun/nio/ch/SelectorImpl/wakeup()Ljava/nio/channels/Selector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Selector) => void): void;
  }
  export class java_nio_channels_spi_AbstractSelectableChannel extends java_nio_channels_SelectableChannel {
    public "java/nio/channels/spi/AbstractSelectableChannel/provider": java_nio_channels_spi_SelectorProvider;
    public "java/nio/channels/spi/AbstractSelectableChannel/keys": JVMArray<java_nio_channels_SelectionKey>;
    public "java/nio/channels/spi/AbstractSelectableChannel/keyCount": number;
    public "java/nio/channels/spi/AbstractSelectableChannel/keyLock": java_lang_Object;
    public "java/nio/channels/spi/AbstractSelectableChannel/regLock": java_lang_Object;
    public "java/nio/channels/spi/AbstractSelectableChannel/blocking": number;
    public static "java/nio/channels/spi/AbstractSelectableChannel/$assertionsDisabled": number;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "addKey(Ljava/nio/channels/SelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_SelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/addKey(Ljava/nio/channels/SelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_SelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "findKey(Ljava/nio/channels/Selector;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/findKey(Ljava/nio/channels/Selector;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "removeKey(Ljava/nio/channels/SelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_SelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/removeKey(Ljava/nio/channels/SelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_SelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "haveValidKeys()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/haveValidKeys()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isRegistered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/isRegistered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "keyFor(Ljava/nio/channels/Selector;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/keyFor(Ljava/nio/channels/Selector;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "register(Ljava/nio/channels/Selector;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/register(Ljava/nio/channels/Selector;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_Selector, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "implCloseChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/implCloseChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "implCloseSelectableChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/implCloseSelectableChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isBlocking()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/isBlocking()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "blockingLock()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/blockingLock()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "configureBlocking(Z)Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/configureBlocking(Z)Ljava/nio/channels/SelectableChannel;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectableChannel) => void): void;
    public "implConfigureBlocking(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectableChannel/implConfigureBlocking(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/spi/AbstractSelectableChannel/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_spi_AbstractSelector extends java_nio_channels_Selector {
    public "java/nio/channels/spi/AbstractSelector/selectorOpen": java_util_concurrent_atomic_AtomicBoolean;
    public "java/nio/channels/spi/AbstractSelector/provider": java_nio_channels_spi_SelectorProvider;
    public "java/nio/channels/spi/AbstractSelector/cancelledKeys": java_util_Set;
    public "java/nio/channels/spi/AbstractSelector/interruptor": sun_nio_ch_Interruptible;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelector/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "cancel(Ljava/nio/channels/SelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_SelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelector/cancel(Ljava/nio/channels/SelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_SelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelector/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "implCloseSelector()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelector/implCloseSelector()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/spi/AbstractSelector/isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "java/nio/channels/spi/AbstractSelector/provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "cancelledKeys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/nio/channels/spi/AbstractSelector/cancelledKeys()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "register(Ljava/nio/channels/spi/AbstractSelectableChannel;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractSelectableChannel, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "java/nio/channels/spi/AbstractSelector/register(Ljava/nio/channels/spi/AbstractSelectableChannel;ILjava/lang/Object;)Ljava/nio/channels/SelectionKey;"(thread: JVMThread, args: [java_nio_channels_spi_AbstractSelectableChannel, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SelectionKey) => void): void;
    public "deregister(Ljava/nio/channels/spi/AbstractSelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_spi_AbstractSelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelector/deregister(Ljava/nio/channels/spi/AbstractSelectionKey;)V"(thread: JVMThread, args: [java_nio_channels_spi_AbstractSelectionKey], cb?: (e?: java_lang_Throwable) => void): void;
    public "begin()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelector/begin()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "end()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelector/end()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_concurrent_atomic_AtomicBoolean extends java_lang_Object implements java_io_Serializable {
    public static "java/util/concurrent/atomic/AtomicBoolean/serialVersionUID": Long;
    public static "java/util/concurrent/atomic/AtomicBoolean/unsafe": sun_misc_Unsafe;
    public static "java/util/concurrent/atomic/AtomicBoolean/valueOffset": Long;
    public "java/util/concurrent/atomic/AtomicBoolean/value": number;
    public "<init>(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/<init>(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "get()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/get()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareAndSet(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/compareAndSet(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "weakCompareAndSet(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/weakCompareAndSet(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "set(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/set(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "lazySet(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/lazySet(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getAndSet(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/getAndSet(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/concurrent/atomic/AtomicBoolean/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/concurrent/atomic/AtomicBoolean/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_spi_AbstractSelectionKey extends java_nio_channels_SelectionKey {
    public "java/nio/channels/spi/AbstractSelectionKey/valid": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectionKey/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/spi/AbstractSelectionKey/isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "invalidate()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectionKey/invalidate()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "cancel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AbstractSelectionKey/cancel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_SctpChannel extends java_nio_channels_spi_AbstractSelectableChannel {
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/SctpChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public static "com/sun/nio/sctp/SctpChannel/open()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public static "open(Ljava/net/SocketAddress;II)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public static "com/sun/nio/sctp/SctpChannel/open(Ljava/net/SocketAddress;II)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "com/sun/nio/sctp/SctpChannel/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "bind(Ljava/net/SocketAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "com/sun/nio/sctp/SctpChannel/bind(Ljava/net/SocketAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "com/sun/nio/sctp/SctpChannel/bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "com/sun/nio/sctp/SctpChannel/unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "connect(Ljava/net/SocketAddress;)Z"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SctpChannel/connect(Ljava/net/SocketAddress;)Z"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "connect(Ljava/net/SocketAddress;II)Z"(thread: JVMThread, args: [java_net_SocketAddress, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SctpChannel/connect(Ljava/net/SocketAddress;II)Z"(thread: JVMThread, args: [java_net_SocketAddress, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isConnectionPending()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SctpChannel/isConnectionPending()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "finishConnect()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SctpChannel/finishConnect()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "com/sun/nio/sctp/SctpChannel/getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getRemoteAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "com/sun/nio/sctp/SctpChannel/getRemoteAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "shutdown()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "com/sun/nio/sctp/SctpChannel/shutdown()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "com/sun/nio/sctp/SctpChannel/getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "com/sun/nio/sctp/SctpChannel/setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "com/sun/nio/sctp/SctpChannel/supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SctpChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "receive(Ljava/nio/ByteBuffer;Ljava/lang/Object;Lcom/sun/nio/sctp/NotificationHandler;)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, com_sun_nio_sctp_NotificationHandler], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "com/sun/nio/sctp/SctpChannel/receive(Ljava/nio/ByteBuffer;Ljava/lang/Object;Lcom/sun/nio/sctp/NotificationHandler;)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, com_sun_nio_sctp_NotificationHandler], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "send(Ljava/nio/ByteBuffer;Lcom/sun/nio/sctp/MessageInfo;)I"(thread: JVMThread, args: [java_nio_ByteBuffer, com_sun_nio_sctp_MessageInfo], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SctpChannel/send(Ljava/nio/ByteBuffer;Lcom/sun/nio/sctp/MessageInfo;)I"(thread: JVMThread, args: [java_nio_ByteBuffer, com_sun_nio_sctp_MessageInfo], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface com_sun_nio_sctp_NotificationHandler extends java_lang_Object {
    "handleNotification(Lcom/sun/nio/sctp/Notification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_Notification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
  }
  export interface com_sun_nio_sctp_Notification extends java_lang_Object {
    "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
  }
  export class com_sun_nio_sctp_HandlerResult extends java_lang_Enum {
    public static "com/sun/nio/sctp/HandlerResult/CONTINUE": com_sun_nio_sctp_HandlerResult;
    public static "com/sun/nio/sctp/HandlerResult/RETURN": com_sun_nio_sctp_HandlerResult;
    public static "com/sun/nio/sctp/HandlerResult/$VALUES": JVMArray<com_sun_nio_sctp_HandlerResult>;
    public static "values()[Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<com_sun_nio_sctp_HandlerResult>) => void): void;
    public static "com/sun/nio/sctp/HandlerResult/values()[Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<com_sun_nio_sctp_HandlerResult>) => void): void;
    public static "valueOf(Ljava/lang/String;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public static "com/sun/nio/sctp/HandlerResult/valueOf(Ljava/lang/String;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/HandlerResult/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "com/sun/nio/sctp/HandlerResult/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_MessageInfo extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/MessageInfo/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "createOutgoing(Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public static "com/sun/nio/sctp/MessageInfo/createOutgoing(Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public static "createOutgoing(Lcom/sun/nio/sctp/Association;Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [com_sun_nio_sctp_Association, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public static "com/sun/nio/sctp/MessageInfo/createOutgoing(Lcom/sun/nio/sctp/Association;Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [com_sun_nio_sctp_Association, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "com/sun/nio/sctp/MessageInfo/address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "com/sun/nio/sctp/MessageInfo/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "bytes()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/MessageInfo/bytes()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isComplete()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/MessageInfo/isComplete()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "complete(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "com/sun/nio/sctp/MessageInfo/complete(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "isUnordered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/MessageInfo/isUnordered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "unordered(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "com/sun/nio/sctp/MessageInfo/unordered(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "payloadProtocolID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/MessageInfo/payloadProtocolID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "payloadProtocolID(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "com/sun/nio/sctp/MessageInfo/payloadProtocolID(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/MessageInfo/streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "streamNumber(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "com/sun/nio/sctp/MessageInfo/streamNumber(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "timeToLive()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "com/sun/nio/sctp/MessageInfo/timeToLive()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "timeToLive(J)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "com/sun/nio/sctp/MessageInfo/timeToLive(J)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
  }
  export class com_sun_nio_sctp_Association extends java_lang_Object {
    public "com/sun/nio/sctp/Association/associationID": number;
    public "com/sun/nio/sctp/Association/maxInStreams": number;
    public "com/sun/nio/sctp/Association/maxOutStreams": number;
    public "<init>(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/Association/<init>(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "associationID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/Association/associationID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "maxInboundStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/Association/maxInboundStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "maxOutboundStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/Association/maxOutboundStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_nio_channels_spi_SelectorProvider extends java_lang_Object {
    public static "java/nio/channels/spi/SelectorProvider/lock": java_lang_Object;
    public static "java/nio/channels/spi/SelectorProvider/provider": java_nio_channels_spi_SelectorProvider;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/SelectorProvider/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "loadProviderFromProperty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/loadProviderFromProperty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "loadProviderAsService()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/loadProviderAsService()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/provider()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public "openDatagramChannel()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "java/nio/channels/spi/SelectorProvider/openDatagramChannel()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "openDatagramChannel(Ljava/net/ProtocolFamily;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_ProtocolFamily], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "java/nio/channels/spi/SelectorProvider/openDatagramChannel(Ljava/net/ProtocolFamily;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_ProtocolFamily], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "openPipe()Ljava/nio/channels/Pipe;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe) => void): void;
    public "java/nio/channels/spi/SelectorProvider/openPipe()Ljava/nio/channels/Pipe;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe) => void): void;
    public "openSelector()Ljava/nio/channels/spi/AbstractSelector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AbstractSelector) => void): void;
    public "java/nio/channels/spi/SelectorProvider/openSelector()Ljava/nio/channels/spi/AbstractSelector;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AbstractSelector) => void): void;
    public "openServerSocketChannel()Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "java/nio/channels/spi/SelectorProvider/openServerSocketChannel()Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "openSocketChannel()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "java/nio/channels/spi/SelectorProvider/openSocketChannel()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "inheritedChannel()Ljava/nio/channels/Channel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Channel) => void): void;
    public "java/nio/channels/spi/SelectorProvider/inheritedChannel()Ljava/nio/channels/Channel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Channel) => void): void;
    public static "access$000()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/access$000()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$100()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/access$100()Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public static "access$200()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/access$200()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$102(Ljava/nio/channels/spi/SelectorProvider;)Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/access$102(Ljava/nio/channels/spi/SelectorProvider;)Ljava/nio/channels/spi/SelectorProvider;"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_SelectorProvider) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/spi/SelectorProvider/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_SocketChannel extends java_nio_channels_spi_AbstractSelectableChannel implements java_nio_channels_ByteChannel, java_nio_channels_ScatteringByteChannel, java_nio_channels_GatheringByteChannel, java_nio_channels_NetworkChannel {
    public static "java/nio/channels/SocketChannel/$assertionsDisabled": number;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/SocketChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public static "java/nio/channels/SocketChannel/open()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public static "open(Ljava/net/SocketAddress;)Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public static "java/nio/channels/SocketChannel/open(Ljava/net/SocketAddress;)Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SocketChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "java/nio/channels/SocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "java/nio/channels/SocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "shutdownInput()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "java/nio/channels/SocketChannel/shutdownInput()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "shutdownOutput()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "java/nio/channels/SocketChannel/shutdownOutput()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "socket()Ljava/net/Socket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_Socket) => void): void;
    public "java/nio/channels/SocketChannel/socket()Ljava/net/Socket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_Socket) => void): void;
    public "isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SocketChannel/isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isConnectionPending()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SocketChannel/isConnectionPending()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "connect(Ljava/net/SocketAddress;)Z"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SocketChannel/connect(Ljava/net/SocketAddress;)Z"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "finishConnect()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SocketChannel/finishConnect()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getRemoteAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/SocketChannel/getRemoteAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SocketChannel/read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/SocketChannel/read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/SocketChannel/read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/SocketChannel/write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/SocketChannel/write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/SocketChannel/write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/SocketChannel/getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/SocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/SocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/SocketChannel/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
  }
  export class java_net_Socket extends java_lang_Object implements java_io_Closeable {
    public "java/net/Socket/created": number;
    public "java/net/Socket/bound": number;
    public "java/net/Socket/connected": number;
    public "java/net/Socket/closed": number;
    public "java/net/Socket/closeLock": java_lang_Object;
    public "java/net/Socket/shutIn": number;
    public "java/net/Socket/shutOut": number;
    public "java/net/Socket/impl": java_net_SocketImpl;
    public "java/net/Socket/oldImpl": number;
    public static "java/net/Socket/factory": java_net_SocketImplFactory;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/Proxy;)V"(thread: JVMThread, args: [java_net_Proxy], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/net/Proxy;)V"(thread: JVMThread, args: [java_net_Proxy], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/SocketImpl;)V"(thread: JVMThread, args: [java_net_SocketImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/net/SocketImpl;)V"(thread: JVMThread, args: [java_net_SocketImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;ILjava/net/InetAddress;I)V"(thread: JVMThread, args: [java_lang_String, number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/lang/String;ILjava/net/InetAddress;I)V"(thread: JVMThread, args: [java_lang_String, number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/InetAddress;ILjava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/net/InetAddress;ILjava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;IZ)V"(thread: JVMThread, args: [java_lang_String, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/lang/String;IZ)V"(thread: JVMThread, args: [java_lang_String, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/InetAddress;IZ)V"(thread: JVMThread, args: [java_net_InetAddress, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/net/InetAddress;IZ)V"(thread: JVMThread, args: [java_net_InetAddress, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/SocketAddress;Ljava/net/SocketAddress;Z)V"(thread: JVMThread, args: [java_net_SocketAddress, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/<init>(Ljava/net/SocketAddress;Ljava/net/SocketAddress;Z)V"(thread: JVMThread, args: [java_net_SocketAddress, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "createImpl(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/createImpl(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkOldImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/checkOldImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getImpl()Ljava/net/SocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketImpl) => void): void;
    public "java/net/Socket/getImpl()Ljava/net/SocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketImpl) => void): void;
    public "connect(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/connect(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "connect(Ljava/net/SocketAddress;I)V"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/connect(Ljava/net/SocketAddress;I)V"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "bind(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/bind(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkAddress(Ljava/net/InetAddress;Ljava/lang/String;)V"(thread: JVMThread, args: [java_net_InetAddress, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/checkAddress(Ljava/net/InetAddress;Ljava/lang/String;)V"(thread: JVMThread, args: [java_net_InetAddress, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "postAccept()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/postAccept()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setCreated()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setCreated()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setBound()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setBound()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setConnected()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setConnected()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getInetAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "java/net/Socket/getInetAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "getLocalAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "java/net/Socket/getLocalAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "getPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getRemoteSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/net/Socket/getRemoteSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "getLocalSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/net/Socket/getLocalSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "getChannel()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "java/net/Socket/getChannel()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "getInputStream()Ljava/io/InputStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_InputStream) => void): void;
    public "java/net/Socket/getInputStream()Ljava/io/InputStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_InputStream) => void): void;
    public "getOutputStream()Ljava/io/OutputStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_OutputStream) => void): void;
    public "java/net/Socket/getOutputStream()Ljava/io/OutputStream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_OutputStream) => void): void;
    public "setTcpNoDelay(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setTcpNoDelay(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getTcpNoDelay()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getTcpNoDelay()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setSoLinger(ZI)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setSoLinger(ZI)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getSoLinger()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getSoLinger()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sendUrgentData(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/sendUrgentData(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "setOOBInline(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setOOBInline(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getOOBInline()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getOOBInline()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setSoTimeout(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setSoTimeout(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getSoTimeout()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getSoTimeout()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setSendBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setSendBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getSendBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getSendBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setReceiveBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setReceiveBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getReceiveBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getReceiveBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setKeepAlive(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setKeepAlive(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getKeepAlive()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getKeepAlive()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setTrafficClass(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setTrafficClass(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getTrafficClass()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getTrafficClass()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setReuseAddress(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setReuseAddress(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getReuseAddress()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/getReuseAddress()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdownInput()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/shutdownInput()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdownOutput()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/shutdownOutput()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/Socket/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isClosed()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/isClosed()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isInputShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/isInputShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isOutputShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/Socket/isOutputShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "setSocketImplFactory(Ljava/net/SocketImplFactory;)V"(thread: JVMThread, args: [java_net_SocketImplFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/Socket/setSocketImplFactory(Ljava/net/SocketImplFactory;)V"(thread: JVMThread, args: [java_net_SocketImplFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "setPerformancePreferences(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/Socket/setPerformancePreferences(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/Socket/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_io_OutputStream extends java_lang_Object implements java_io_Closeable, java_io_Flushable {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/OutputStream/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "write(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/OutputStream/write(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "write([B)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/OutputStream/write([B)V"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public "write([BII)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/OutputStream/write([BII)V"(thread: JVMThread, args: [JVMArray<number>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "flush()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/OutputStream/flush()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/io/OutputStream/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_io_Flushable extends java_lang_Object {
    "flush()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_net_SocketImplFactory extends java_lang_Object {
    "createSocketImpl()Ljava/net/SocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketImpl) => void): void;
  }
  export interface java_nio_channels_NetworkChannel extends java_lang_Object, java_nio_channels_Channel {
    "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_channels_GatheringByteChannel extends java_lang_Object, java_nio_channels_WritableByteChannel {
    "write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_channels_WritableByteChannel extends java_lang_Object, java_nio_channels_Channel {
    "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_channels_ScatteringByteChannel extends java_lang_Object, java_nio_channels_ReadableByteChannel {
    "read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_channels_ReadableByteChannel extends java_lang_Object, java_nio_channels_Channel {
    "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_channels_ByteChannel extends java_lang_Object, java_nio_channels_ReadableByteChannel, java_nio_channels_WritableByteChannel {
    "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_nio_channels_ServerSocketChannel extends java_nio_channels_spi_AbstractSelectableChannel implements java_nio_channels_NetworkChannel {
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/ServerSocketChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open()Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public static "java/nio/channels/ServerSocketChannel/open()Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/ServerSocketChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "java/nio/channels/ServerSocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;I)Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "java/nio/channels/ServerSocketChannel/bind(Ljava/net/SocketAddress;I)Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "java/nio/channels/ServerSocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "socket()Ljava/net/ServerSocket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_ServerSocket) => void): void;
    public "java/nio/channels/ServerSocketChannel/socket()Ljava/net/ServerSocket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_ServerSocket) => void): void;
    public "accept()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "java/nio/channels/ServerSocketChannel/accept()Ljava/nio/channels/SocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SocketChannel) => void): void;
    public "getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/ServerSocketChannel/getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/ServerSocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/ServerSocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
  }
  export class java_net_ServerSocket extends java_lang_Object implements java_io_Closeable {
    public "java/net/ServerSocket/created": number;
    public "java/net/ServerSocket/bound": number;
    public "java/net/ServerSocket/closed": number;
    public "java/net/ServerSocket/closeLock": java_lang_Object;
    public "java/net/ServerSocket/impl": java_net_SocketImpl;
    public "java/net/ServerSocket/oldImpl": number;
    public static "java/net/ServerSocket/factory": java_net_SocketImplFactory;
    public "<init>(Ljava/net/SocketImpl;)V"(thread: JVMThread, args: [java_net_SocketImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/<init>(Ljava/net/SocketImpl;)V"(thread: JVMThread, args: [java_net_SocketImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/<init>(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(IILjava/net/InetAddress;)V"(thread: JVMThread, args: [number, number, java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/<init>(IILjava/net/InetAddress;)V"(thread: JVMThread, args: [number, number, java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "getImpl()Ljava/net/SocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketImpl) => void): void;
    public "java/net/ServerSocket/getImpl()Ljava/net/SocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketImpl) => void): void;
    public "checkOldImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/checkOldImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/setImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "createImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/createImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "bind(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/bind(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "bind(Ljava/net/SocketAddress;I)V"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/bind(Ljava/net/SocketAddress;I)V"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getInetAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "java/net/ServerSocket/getInetAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/ServerSocket/getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getLocalSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/net/ServerSocket/getLocalSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "accept()Ljava/net/Socket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_Socket) => void): void;
    public "java/net/ServerSocket/accept()Ljava/net/Socket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_Socket) => void): void;
    public "implAccept(Ljava/net/Socket;)V"(thread: JVMThread, args: [java_net_Socket], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/implAccept(Ljava/net/Socket;)V"(thread: JVMThread, args: [java_net_Socket], cb?: (e?: java_lang_Throwable) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getChannel()Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "java/net/ServerSocket/getChannel()Ljava/nio/channels/ServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_ServerSocketChannel) => void): void;
    public "isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/ServerSocket/isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isClosed()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/ServerSocket/isClosed()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setSoTimeout(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/setSoTimeout(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getSoTimeout()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/ServerSocket/getSoTimeout()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setReuseAddress(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/setReuseAddress(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getReuseAddress()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/ServerSocket/getReuseAddress()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/ServerSocket/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "setBound()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/setBound()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setCreated()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/setCreated()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "setSocketFactory(Ljava/net/SocketImplFactory;)V"(thread: JVMThread, args: [java_net_SocketImplFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/ServerSocket/setSocketFactory(Ljava/net/SocketImplFactory;)V"(thread: JVMThread, args: [java_net_SocketImplFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "setReceiveBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/setReceiveBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getReceiveBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/ServerSocket/getReceiveBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setPerformancePreferences(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/ServerSocket/setPerformancePreferences(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "access$000(Ljava/net/ServerSocket;)Ljava/net/SocketImpl;"(thread: JVMThread, args: [java_net_ServerSocket], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketImpl) => void): void;
    public static "java/net/ServerSocket/access$000(Ljava/net/ServerSocket;)Ljava/net/SocketImpl;"(thread: JVMThread, args: [java_net_ServerSocket], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketImpl) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/ServerSocket/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_Pipe extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/Pipe/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "source()Ljava/nio/channels/Pipe$SourceChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe$SourceChannel) => void): void;
    public "java/nio/channels/Pipe/source()Ljava/nio/channels/Pipe$SourceChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe$SourceChannel) => void): void;
    public "sink()Ljava/nio/channels/Pipe$SinkChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe$SinkChannel) => void): void;
    public "java/nio/channels/Pipe/sink()Ljava/nio/channels/Pipe$SinkChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe$SinkChannel) => void): void;
    public static "open()Ljava/nio/channels/Pipe;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe) => void): void;
    public static "java/nio/channels/Pipe/open()Ljava/nio/channels/Pipe;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Pipe) => void): void;
  }
  export class java_nio_channels_Pipe$SinkChannel extends java_nio_channels_spi_AbstractSelectableChannel implements java_nio_channels_WritableByteChannel, java_nio_channels_GatheringByteChannel {
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/Pipe$SinkChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/Pipe$SinkChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export class java_nio_channels_Pipe$SourceChannel extends java_nio_channels_spi_AbstractSelectableChannel implements java_nio_channels_ReadableByteChannel, java_nio_channels_ScatteringByteChannel {
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/Pipe$SourceChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/Pipe$SourceChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export interface java_net_ProtocolFamily extends java_lang_Object {
    "name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
  }
  export class java_nio_channels_DatagramChannel extends java_nio_channels_spi_AbstractSelectableChannel implements java_nio_channels_ByteChannel, java_nio_channels_ScatteringByteChannel, java_nio_channels_GatheringByteChannel, java_nio_channels_MulticastChannel {
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/DatagramChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public static "java/nio/channels/DatagramChannel/open()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public static "open(Ljava/net/ProtocolFamily;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_ProtocolFamily], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public static "java/nio/channels/DatagramChannel/open(Ljava/net/ProtocolFamily;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_ProtocolFamily], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/DatagramChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "java/nio/channels/DatagramChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "java/nio/channels/DatagramChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "socket()Ljava/net/DatagramSocket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_DatagramSocket) => void): void;
    public "java/nio/channels/DatagramChannel/socket()Ljava/net/DatagramSocket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_DatagramSocket) => void): void;
    public "isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/DatagramChannel/isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "connect(Ljava/net/SocketAddress;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "java/nio/channels/DatagramChannel/connect(Ljava/net/SocketAddress;)Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "disconnect()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "java/nio/channels/DatagramChannel/disconnect()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "getRemoteAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/DatagramChannel/getRemoteAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "receive(Ljava/nio/ByteBuffer;)Ljava/net/SocketAddress;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/DatagramChannel/receive(Ljava/nio/ByteBuffer;)Ljava/net/SocketAddress;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "send(Ljava/nio/ByteBuffer;Ljava/net/SocketAddress;)I"(thread: JVMThread, args: [java_nio_ByteBuffer, java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/DatagramChannel/send(Ljava/nio/ByteBuffer;Ljava/net/SocketAddress;)I"(thread: JVMThread, args: [java_nio_ByteBuffer, java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/DatagramChannel/read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/DatagramChannel/read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/DatagramChannel/read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/DatagramChannel/write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/DatagramChannel/write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/DatagramChannel/write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/DatagramChannel/getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/DatagramChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/DatagramChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "join(Ljava/net/InetAddress;Ljava/net/NetworkInterface;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress, java_net_NetworkInterface], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    "join(Ljava/net/InetAddress;Ljava/net/NetworkInterface;Ljava/net/InetAddress;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress, java_net_NetworkInterface, java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
  }
  export class java_nio_channels_MembershipKey extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/MembershipKey/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/MembershipKey/isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "drop()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/MembershipKey/drop()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "block(Ljava/net/InetAddress;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    public "java/nio/channels/MembershipKey/block(Ljava/net/InetAddress;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    public "unblock(Ljava/net/InetAddress;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    public "java/nio/channels/MembershipKey/unblock(Ljava/net/InetAddress;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    public "channel()Ljava/nio/channels/MulticastChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MulticastChannel) => void): void;
    public "java/nio/channels/MembershipKey/channel()Ljava/nio/channels/MulticastChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MulticastChannel) => void): void;
    public "group()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "java/nio/channels/MembershipKey/group()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "networkInterface()Ljava/net/NetworkInterface;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_NetworkInterface) => void): void;
    public "java/nio/channels/MembershipKey/networkInterface()Ljava/net/NetworkInterface;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_NetworkInterface) => void): void;
    public "sourceAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "java/nio/channels/MembershipKey/sourceAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
  }
  export class java_net_DatagramSocket extends java_lang_Object implements java_io_Closeable {
    public "java/net/DatagramSocket/created": number;
    public "java/net/DatagramSocket/bound": number;
    public "java/net/DatagramSocket/closed": number;
    public "java/net/DatagramSocket/closeLock": java_lang_Object;
    public "java/net/DatagramSocket/impl": java_net_DatagramSocketImpl;
    public "java/net/DatagramSocket/oldImpl": number;
    public "java/net/DatagramSocket/explicitFilter": number;
    public "java/net/DatagramSocket/bytesLeftToFilter": number;
    public static "java/net/DatagramSocket/ST_NOT_CONNECTED": number;
    public static "java/net/DatagramSocket/ST_CONNECTED": number;
    public static "java/net/DatagramSocket/ST_CONNECTED_NO_IMPL": number;
    public "java/net/DatagramSocket/connectState": number;
    public "java/net/DatagramSocket/connectedAddress": java_net_InetAddress;
    public "java/net/DatagramSocket/connectedPort": number;
    public static "java/net/DatagramSocket/implClass": java_lang_Class;
    public static "java/net/DatagramSocket/factory": java_net_DatagramSocketImplFactory;
    public "connectInternal(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/connectInternal(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/DatagramSocketImpl;)V"(thread: JVMThread, args: [java_net_DatagramSocketImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/<init>(Ljava/net/DatagramSocketImpl;)V"(thread: JVMThread, args: [java_net_DatagramSocketImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/<init>(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(ILjava/net/InetAddress;)V"(thread: JVMThread, args: [number, java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/<init>(ILjava/net/InetAddress;)V"(thread: JVMThread, args: [number, java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkOldImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/checkOldImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "createImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/createImpl()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getImpl()Ljava/net/DatagramSocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_DatagramSocketImpl) => void): void;
    public "java/net/DatagramSocket/getImpl()Ljava/net/DatagramSocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_DatagramSocketImpl) => void): void;
    public "bind(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/bind(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkAddress(Ljava/net/InetAddress;Ljava/lang/String;)V"(thread: JVMThread, args: [java_net_InetAddress, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/checkAddress(Ljava/net/InetAddress;Ljava/lang/String;)V"(thread: JVMThread, args: [java_net_InetAddress, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "connect(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/connect(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "connect(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/connect(Ljava/net/SocketAddress;)V"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "disconnect()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/disconnect()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getInetAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "java/net/DatagramSocket/getInetAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "getPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getRemoteSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/net/DatagramSocket/getRemoteSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "getLocalSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/net/DatagramSocket/getLocalSocketAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "send(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/send(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "receive(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/receive(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkFiltering(Ljava/net/DatagramPacket;)Z"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/checkFiltering(Ljava/net/DatagramPacket;)Z"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getLocalAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "java/net/DatagramSocket/getLocalAddress()Ljava/net/InetAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_InetAddress) => void): void;
    public "getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setSoTimeout(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/setSoTimeout(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getSoTimeout()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getSoTimeout()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setSendBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/setSendBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getSendBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getSendBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setReceiveBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/setReceiveBufferSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getReceiveBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getReceiveBufferSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setReuseAddress(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/setReuseAddress(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getReuseAddress()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getReuseAddress()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setBroadcast(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/setBroadcast(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getBroadcast()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getBroadcast()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setTrafficClass(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/setTrafficClass(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getTrafficClass()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/getTrafficClass()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocket/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isClosed()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocket/isClosed()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getChannel()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public "java/net/DatagramSocket/getChannel()Ljava/nio/channels/DatagramChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_DatagramChannel) => void): void;
    public static "setDatagramSocketImplFactory(Ljava/net/DatagramSocketImplFactory;)V"(thread: JVMThread, args: [java_net_DatagramSocketImplFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/DatagramSocket/setDatagramSocketImplFactory(Ljava/net/DatagramSocketImplFactory;)V"(thread: JVMThread, args: [java_net_DatagramSocketImplFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/DatagramSocket/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_net_DatagramSocketImplFactory extends java_lang_Object {
    "createDatagramSocketImpl()Ljava/net/DatagramSocketImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_DatagramSocketImpl) => void): void;
  }
  export class java_net_DatagramSocketImpl extends java_lang_Object implements java_net_SocketOptions {
    public "java/net/DatagramSocketImpl/localPort": number;
    public "java/net/DatagramSocketImpl/fd": java_io_FileDescriptor;
    public "java/net/DatagramSocketImpl/socket": java_net_DatagramSocket;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "dataAvailable()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocketImpl/dataAvailable()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setDatagramSocket(Ljava/net/DatagramSocket;)V"(thread: JVMThread, args: [java_net_DatagramSocket], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/setDatagramSocket(Ljava/net/DatagramSocket;)V"(thread: JVMThread, args: [java_net_DatagramSocket], cb?: (e?: java_lang_Throwable) => void): void;
    public "getDatagramSocket()Ljava/net/DatagramSocket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_DatagramSocket) => void): void;
    public "java/net/DatagramSocketImpl/getDatagramSocket()Ljava/net/DatagramSocket;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_DatagramSocket) => void): void;
    public "create()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/create()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "bind(ILjava/net/InetAddress;)V"(thread: JVMThread, args: [number, java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/bind(ILjava/net/InetAddress;)V"(thread: JVMThread, args: [number, java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "send(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/send(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "connect(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/connect(Ljava/net/InetAddress;I)V"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "disconnect()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/disconnect()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "peek(Ljava/net/InetAddress;)I"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocketImpl/peek(Ljava/net/InetAddress;)I"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "peekData(Ljava/net/DatagramPacket;)I"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocketImpl/peekData(Ljava/net/DatagramPacket;)I"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "receive(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/receive(Ljava/net/DatagramPacket;)V"(thread: JVMThread, args: [java_net_DatagramPacket], cb?: (e?: java_lang_Throwable) => void): void;
    public "setTTL(B)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/setTTL(B)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getTTL()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocketImpl/getTTL()B"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setTimeToLive(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/setTimeToLive(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getTimeToLive()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocketImpl/getTimeToLive()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "join(Ljava/net/InetAddress;)V"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/join(Ljava/net/InetAddress;)V"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "leave(Ljava/net/InetAddress;)V"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/leave(Ljava/net/InetAddress;)V"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "joinGroup(Ljava/net/SocketAddress;Ljava/net/NetworkInterface;)V"(thread: JVMThread, args: [java_net_SocketAddress, java_net_NetworkInterface], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/joinGroup(Ljava/net/SocketAddress;Ljava/net/NetworkInterface;)V"(thread: JVMThread, args: [java_net_SocketAddress, java_net_NetworkInterface], cb?: (e?: java_lang_Throwable) => void): void;
    public "leaveGroup(Ljava/net/SocketAddress;Ljava/net/NetworkInterface;)V"(thread: JVMThread, args: [java_net_SocketAddress, java_net_NetworkInterface], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/leaveGroup(Ljava/net/SocketAddress;Ljava/net/NetworkInterface;)V"(thread: JVMThread, args: [java_net_SocketAddress, java_net_NetworkInterface], cb?: (e?: java_lang_Throwable) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/DatagramSocketImpl/getLocalPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/DatagramSocketImpl/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/net/DatagramSocketImpl/getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "getFileDescriptor()Ljava/io/FileDescriptor;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "java/net/DatagramSocketImpl/getFileDescriptor()Ljava/io/FileDescriptor;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    "setOption(ILjava/lang/Object;)V"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "getOption(I)Ljava/lang/Object;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_net_SocketOptions extends java_lang_Object {
    "setOption(ILjava/lang/Object;)V"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "getOption(I)Ljava/lang/Object;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_nio_channels_MulticastChannel extends java_lang_Object, java_nio_channels_NetworkChannel {
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "join(Ljava/net/InetAddress;Ljava/net/NetworkInterface;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress, java_net_NetworkInterface], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    "join(Ljava/net/InetAddress;Ljava/net/NetworkInterface;Ljava/net/InetAddress;)Ljava/nio/channels/MembershipKey;"(thread: JVMThread, args: [java_net_InetAddress, java_net_NetworkInterface, java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_MembershipKey) => void): void;
    "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_util_HashSet extends java_util_AbstractSet implements java_util_Set, java_lang_Cloneable, java_io_Serializable {
    public static "java/util/HashSet/serialVersionUID": Long;
    public "java/util/HashSet/map": java_util_HashMap;
    public static "java/util/HashSet/PRESENT": java_lang_Object;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/util/Collection;)V"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/<init>(Ljava/util/Collection;)V"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(IF)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/<init>(IF)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(IFZ)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/<init>(IFZ)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    public "java/util/HashSet/iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    public "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashSet/size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashSet/isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashSet/contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashSet/add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashSet/remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashSet/clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashSet/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    public "java/util/HashSet/spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/HashSet/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_HashMap extends java_util_AbstractMap implements java_util_Map, java_lang_Cloneable, java_io_Serializable {
    public static "java/util/HashMap/serialVersionUID": Long;
    public static "java/util/HashMap/DEFAULT_INITIAL_CAPACITY": number;
    public static "java/util/HashMap/MAXIMUM_CAPACITY": number;
    public static "java/util/HashMap/DEFAULT_LOAD_FACTOR": number;
    public static "java/util/HashMap/TREEIFY_THRESHOLD": number;
    public static "java/util/HashMap/UNTREEIFY_THRESHOLD": number;
    public static "java/util/HashMap/MIN_TREEIFY_CAPACITY": number;
    public "java/util/HashMap/table": JVMArray<java_util_HashMap$Node>;
    public "java/util/HashMap/entrySet": java_util_Set;
    public "java/util/HashMap/size": number;
    public "java/util/HashMap/modCount": number;
    public "java/util/HashMap/threshold": number;
    public "java/util/HashMap/loadFactor": number;
    public static "hash(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/HashMap/hash(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "comparableClassFor(Ljava/lang/Object;)Ljava/lang/Class;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "java/util/HashMap/comparableClassFor(Ljava/lang/Object;)Ljava/lang/Class;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
    public static "compareComparables(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Class, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/HashMap/compareComparables(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Class, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "tableSizeFor(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/HashMap/tableSizeFor(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "<init>(IF)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/<init>(IF)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/util/Map;)V"(thread: JVMThread, args: [java_util_Map], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/<init>(Ljava/util/Map;)V"(thread: JVMThread, args: [java_util_Map], cb?: (e?: java_lang_Throwable) => void): void;
    public "putMapEntries(Ljava/util/Map;Z)V"(thread: JVMThread, args: [java_util_Map, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/putMapEntries(Ljava/util/Map;Z)V"(thread: JVMThread, args: [java_util_Map, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "get(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/get(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "getNode(ILjava/lang/Object;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "java/util/HashMap/getNode(ILjava/lang/Object;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "containsKey(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/containsKey(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "putVal(ILjava/lang/Object;Ljava/lang/Object;ZZ)Ljava/lang/Object;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/putVal(ILjava/lang/Object;Ljava/lang/Object;ZZ)Ljava/lang/Object;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, number, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "resize()[Ljava/util/HashMap$Node;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_util_HashMap$Node>) => void): void;
    public "java/util/HashMap/resize()[Ljava/util/HashMap$Node;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_util_HashMap$Node>) => void): void;
    public "treeifyBin([Ljava/util/HashMap$Node;I)V"(thread: JVMThread, args: [JVMArray<java_util_HashMap$Node>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/treeifyBin([Ljava/util/HashMap$Node;I)V"(thread: JVMThread, args: [JVMArray<java_util_HashMap$Node>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "putAll(Ljava/util/Map;)V"(thread: JVMThread, args: [java_util_Map], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/putAll(Ljava/util/Map;)V"(thread: JVMThread, args: [java_util_Map], cb?: (e?: java_lang_Throwable) => void): void;
    public "remove(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/remove(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "removeNode(ILjava/lang/Object;Ljava/lang/Object;ZZ)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "java/util/HashMap/removeNode(ILjava/lang/Object;Ljava/lang/Object;ZZ)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "containsValue(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/containsValue(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "keySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/util/HashMap/keySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "values()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "java/util/HashMap/values()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "entrySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/util/HashMap/entrySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "remove(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/remove(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "forEach(Ljava/util/function/BiConsumer;)V"(thread: JVMThread, args: [java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/forEach(Ljava/util/function/BiConsumer;)V"(thread: JVMThread, args: [java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    public "replaceAll(Ljava/util/function/BiFunction;)V"(thread: JVMThread, args: [java_util_function_BiFunction], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/replaceAll(Ljava/util/function/BiFunction;)V"(thread: JVMThread, args: [java_util_function_BiFunction], cb?: (e?: java_lang_Throwable) => void): void;
    public "clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap/clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "loadFactor()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/loadFactor()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap/capacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "newNode(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "java/util/HashMap/newNode(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "replacementNode(Ljava/util/HashMap$Node;Ljava/util/HashMap$Node;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [java_util_HashMap$Node, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "java/util/HashMap/replacementNode(Ljava/util/HashMap$Node;Ljava/util/HashMap$Node;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [java_util_HashMap$Node, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "newTreeNode(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "java/util/HashMap/newTreeNode(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "replacementTreeNode(Ljava/util/HashMap$Node;Ljava/util/HashMap$Node;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$Node, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "java/util/HashMap/replacementTreeNode(Ljava/util/HashMap$Node;Ljava/util/HashMap$Node;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$Node, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "reinitialize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/reinitialize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "afterNodeAccess(Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/afterNodeAccess(Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "afterNodeInsertion(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/afterNodeInsertion(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "afterNodeRemoval(Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/afterNodeRemoval(Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "internalWriteEntries(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap/internalWriteEntries(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "forEach(Ljava/util/function/BiConsumer;)V"(thread: JVMThread, args: [java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "replaceAll(Ljava/util/function/BiFunction;)V"(thread: JVMThread, args: [java_util_function_BiFunction], cb?: (e?: java_lang_Throwable) => void): void;
    "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "remove(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class java_util_HashMap$TreeNode extends java_util_LinkedHashMap$Entry {
    public "java/util/HashMap$TreeNode/parent": java_util_HashMap$TreeNode;
    public "java/util/HashMap$TreeNode/left": java_util_HashMap$TreeNode;
    public "java/util/HashMap$TreeNode/right": java_util_HashMap$TreeNode;
    public "java/util/HashMap$TreeNode/prev": java_util_HashMap$TreeNode;
    public "java/util/HashMap$TreeNode/red": number;
    public static "java/util/HashMap$TreeNode/$assertionsDisabled": number;
    public "<init>(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap$TreeNode/<init>(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "root()Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "java/util/HashMap$TreeNode/root()Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "moveRootToFront([Ljava/util/HashMap$Node;Ljava/util/HashMap$TreeNode;)V"(thread: JVMThread, args: [JVMArray<java_util_HashMap$Node>, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/HashMap$TreeNode/moveRootToFront([Ljava/util/HashMap$Node;Ljava/util/HashMap$TreeNode;)V"(thread: JVMThread, args: [JVMArray<java_util_HashMap$Node>, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable) => void): void;
    public "find(ILjava/lang/Object;Ljava/lang/Class;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "java/util/HashMap$TreeNode/find(ILjava/lang/Object;Ljava/lang/Class;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "getTreeNode(ILjava/lang/Object;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "java/util/HashMap$TreeNode/getTreeNode(ILjava/lang/Object;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "tieBreakOrder(Ljava/lang/Object;Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/HashMap$TreeNode/tieBreakOrder(Ljava/lang/Object;Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "treeify([Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [JVMArray<java_util_HashMap$Node>], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap$TreeNode/treeify([Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [JVMArray<java_util_HashMap$Node>], cb?: (e?: java_lang_Throwable) => void): void;
    public "untreeify(Ljava/util/HashMap;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [java_util_HashMap], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "java/util/HashMap$TreeNode/untreeify(Ljava/util/HashMap;)Ljava/util/HashMap$Node;"(thread: JVMThread, args: [java_util_HashMap], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$Node) => void): void;
    public "putTreeVal(Ljava/util/HashMap;[Ljava/util/HashMap$Node;ILjava/lang/Object;Ljava/lang/Object;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap, JVMArray<java_util_HashMap$Node>, number, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "java/util/HashMap$TreeNode/putTreeVal(Ljava/util/HashMap;[Ljava/util/HashMap$Node;ILjava/lang/Object;Ljava/lang/Object;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap, JVMArray<java_util_HashMap$Node>, number, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public "removeTreeNode(Ljava/util/HashMap;[Ljava/util/HashMap$Node;Z)V"(thread: JVMThread, args: [java_util_HashMap, JVMArray<java_util_HashMap$Node>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap$TreeNode/removeTreeNode(Ljava/util/HashMap;[Ljava/util/HashMap$Node;Z)V"(thread: JVMThread, args: [java_util_HashMap, JVMArray<java_util_HashMap$Node>, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "split(Ljava/util/HashMap;[Ljava/util/HashMap$Node;II)V"(thread: JVMThread, args: [java_util_HashMap, JVMArray<java_util_HashMap$Node>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap$TreeNode/split(Ljava/util/HashMap;[Ljava/util/HashMap$Node;II)V"(thread: JVMThread, args: [java_util_HashMap, JVMArray<java_util_HashMap$Node>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "rotateLeft(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "java/util/HashMap$TreeNode/rotateLeft(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "rotateRight(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "java/util/HashMap$TreeNode/rotateRight(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "balanceInsertion(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "java/util/HashMap$TreeNode/balanceInsertion(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "balanceDeletion(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "java/util/HashMap$TreeNode/balanceDeletion(Ljava/util/HashMap$TreeNode;Ljava/util/HashMap$TreeNode;)Ljava/util/HashMap$TreeNode;"(thread: JVMThread, args: [java_util_HashMap$TreeNode, java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: java_util_HashMap$TreeNode) => void): void;
    public static "checkInvariants(Ljava/util/HashMap$TreeNode;)Z"(thread: JVMThread, args: [java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/HashMap$TreeNode/checkInvariants(Ljava/util/HashMap$TreeNode;)Z"(thread: JVMThread, args: [java_util_HashMap$TreeNode], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/HashMap$TreeNode/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_LinkedHashMap$Entry extends java_util_HashMap$Node {
    public "java/util/LinkedHashMap$Entry/before": java_util_LinkedHashMap$Entry;
    public "java/util/LinkedHashMap$Entry/after": java_util_LinkedHashMap$Entry;
    public "<init>(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/LinkedHashMap$Entry/<init>(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_HashMap$Node extends java_lang_Object implements java_util_Map$Entry {
    public "java/util/HashMap$Node/hash": number;
    public "java/util/HashMap$Node/key": java_lang_Object;
    public "java/util/HashMap$Node/value": java_lang_Object;
    public "java/util/HashMap$Node/next": java_util_HashMap$Node;
    public "<init>(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/HashMap$Node/<init>(ILjava/lang/Object;Ljava/lang/Object;Ljava/util/HashMap$Node;)V"(thread: JVMThread, args: [number, java_lang_Object, java_lang_Object, java_util_HashMap$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "getKey()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap$Node/getKey()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "getValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap$Node/getValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/HashMap$Node/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap$Node/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setValue(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/HashMap$Node/setValue(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/HashMap$Node/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_Map$Entry extends java_lang_Object {
    "getKey()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "getValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "setValue(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_util_AbstractMap extends java_lang_Object implements java_util_Map {
    public "java/util/AbstractMap/keySet": java_util_Set;
    public "java/util/AbstractMap/values": java_util_Collection;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/AbstractMap/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractMap/size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractMap/isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "containsValue(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractMap/containsValue(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "containsKey(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractMap/containsKey(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "get(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/AbstractMap/get(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/AbstractMap/put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "remove(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/AbstractMap/remove(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "putAll(Ljava/util/Map;)V"(thread: JVMThread, args: [java_util_Map], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/AbstractMap/putAll(Ljava/util/Map;)V"(thread: JVMThread, args: [java_util_Map], cb?: (e?: java_lang_Throwable) => void): void;
    public "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/AbstractMap/clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "keySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/util/AbstractMap/keySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "values()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "java/util/AbstractMap/values()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "entrySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/util/AbstractMap/entrySet()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractMap/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractMap/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/AbstractMap/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/util/AbstractMap/clone()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "eq(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/AbstractMap/eq(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$000(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/AbstractMap/access$000(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "forEach(Ljava/util/function/BiConsumer;)V"(thread: JVMThread, args: [java_util_function_BiConsumer], cb?: (e?: java_lang_Throwable) => void): void;
    "replaceAll(Ljava/util/function/BiFunction;)V"(thread: JVMThread, args: [java_util_function_BiFunction], cb?: (e?: java_lang_Throwable) => void): void;
    "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "remove(Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_Function], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object, java_lang_Object, java_util_function_BiFunction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_lang_Cloneable extends java_lang_Object {
  }
  export class java_util_AbstractSet extends java_util_AbstractCollection implements java_util_Set {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/AbstractSet/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractSet/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractSet/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractSet/removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_AbstractCollection extends java_lang_Object implements java_util_Collection {
    public static "java/util/AbstractCollection/MAX_ARRAY_SIZE": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/AbstractCollection/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    public "java/util/AbstractCollection/iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    public "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    public "java/util/AbstractCollection/toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    public "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    public "java/util/AbstractCollection/toArray([Ljava/lang/Object;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    public static "finishToArray([Ljava/lang/Object;Ljava/util/Iterator;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>, java_util_Iterator], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    public static "java/util/AbstractCollection/finishToArray([Ljava/lang/Object;Ljava/util/Iterator;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>, java_util_Iterator], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    public static "hugeCapacity(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/AbstractCollection/hugeCapacity(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "containsAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/containsAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "addAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/addAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "retainAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/AbstractCollection/retainAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/AbstractCollection/clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/AbstractCollection/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState extends java_lang_Enum {
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/UNINITIALIZED": sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/INUSE": sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/KILLPENDING": sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/KILLED": sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/$VALUES": JVMArray<sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState>;
    public static "values()[Lsun/nio/ch/sctp/SctpServerChannelImpl$ChannelState;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState>) => void): void;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/values()[Lsun/nio/ch/sctp/SctpServerChannelImpl$ChannelState;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState>) => void): void;
    public static "valueOf(Ljava/lang/String;)Lsun/nio/ch/sctp/SctpServerChannelImpl$ChannelState;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState) => void): void;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/valueOf(Ljava/lang/String;)Lsun/nio/ch/sctp/SctpServerChannelImpl$ChannelState;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SctpServerChannelImpl$ChannelState) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpServerChannelImpl$ChannelState/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface sun_nio_ch_SelChImpl extends java_lang_Object, java_nio_channels_Channel {
    "getFD()Ljava/io/FileDescriptor;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    "getFDVal()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "translateAndUpdateReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "translateAndSetReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "translateAndSetInterestOps(ILsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "kill()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_SctpServerChannel extends java_nio_channels_spi_AbstractSelectableChannel {
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open()Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public static "com/sun/nio/sctp/SctpServerChannel/open()Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "accept()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/accept()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/bind(Ljava/net/SocketAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/bind(Ljava/net/SocketAddress;I)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpServerChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpServerChannel) => void): void;
    public "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SctpServerChannel/validOps()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_net_SocketAddress extends java_lang_Object implements java_io_Serializable {
    public static "java/net/SocketAddress/serialVersionUID": Long;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/SocketAddress/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_sctp_SctpNet extends java_lang_Object {
    public static "sun/nio/ch/sctp/SctpNet/osName": java_lang_String;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpNet/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "IPv4MappedAddresses()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/IPv4MappedAddresses()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "throwAlreadyBoundException()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/throwAlreadyBoundException()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "listen(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/listen(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "connect(ILjava/net/InetAddress;I)I"(thread: JVMThread, args: [number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/connect(ILjava/net/InetAddress;I)I"(thread: JVMThread, args: [number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "close(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/close(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "preClose(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/preClose(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "socket(Z)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/socket(Z)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public static "bindx(I[Ljava/net/InetAddress;IZ)V"(thread: JVMThread, args: [number, JVMArray<java_net_InetAddress>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/bindx(I[Ljava/net/InetAddress;IZ)V"(thread: JVMThread, args: [number, JVMArray<java_net_InetAddress>, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getLocalAddresses(I)Ljava/util/Set;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getLocalAddresses(I)Ljava/util/Set;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "getRevealedLocalAddressSet([Ljava/net/SocketAddress;)Ljava/util/Set;"(thread: JVMThread, args: [JVMArray<java_net_SocketAddress>], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getRevealedLocalAddressSet([Ljava/net/SocketAddress;)Ljava/util/Set;"(thread: JVMThread, args: [JVMArray<java_net_SocketAddress>], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "getRevealedLocalAddress(Ljava/net/SocketAddress;Ljava/lang/SecurityManager;)Ljava/net/SocketAddress;"(thread: JVMThread, args: [java_net_SocketAddress, java_lang_SecurityManager], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getRevealedLocalAddress(Ljava/net/SocketAddress;Ljava/lang/SecurityManager;)Ljava/net/SocketAddress;"(thread: JVMThread, args: [java_net_SocketAddress, java_lang_SecurityManager], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public static "getRemoteAddresses(II)Ljava/util/Set;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getRemoteAddresses(II)Ljava/util/Set;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "setSocketOption(ILcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;I)V"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption, java_lang_Object, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/setSocketOption(ILcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;I)V"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption, java_lang_Object, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getSocketOption(ILcom/sun/nio/sctp/SctpSocketOption;I)Ljava/lang/Object;"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getSocketOption(ILcom/sun/nio/sctp/SctpSocketOption;I)Ljava/lang/Object;"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "setIntOption(ILcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)V"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/setIntOption(ILcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)V"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getIntOption(ILcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getIntOption(ILcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [number, com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "shutdown(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/shutdown(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "branch(II)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/branch(II)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public static "socket0(Z)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/socket0(Z)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "listen0(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/listen0(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "connect0(ILjava/net/InetAddress;I)I"(thread: JVMThread, args: [number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/connect0(ILjava/net/InetAddress;I)I"(thread: JVMThread, args: [number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "close0(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/close0(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "preClose0(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/preClose0(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "bindx(I[Ljava/net/InetAddress;IIZZ)V"(thread: JVMThread, args: [number, JVMArray<java_net_InetAddress>, number, number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/bindx(I[Ljava/net/InetAddress;IIZZ)V"(thread: JVMThread, args: [number, JVMArray<java_net_InetAddress>, number, number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getIntOption0(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getIntOption0(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "setIntOption0(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/setIntOption0(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getLocalAddresses0(I)[Ljava/net/SocketAddress;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_net_SocketAddress>) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getLocalAddresses0(I)[Ljava/net/SocketAddress;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_net_SocketAddress>) => void): void;
    public static "getRemoteAddresses0(II)[Ljava/net/SocketAddress;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_net_SocketAddress>) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getRemoteAddresses0(II)[Ljava/net/SocketAddress;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_net_SocketAddress>) => void): void;
    public static "branch0(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/branch0(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "setPrimAddrOption0(IILjava/net/InetAddress;I)V"(thread: JVMThread, args: [number, number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/setPrimAddrOption0(IILjava/net/InetAddress;I)V"(thread: JVMThread, args: [number, number, java_net_InetAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "setPeerPrimAddrOption0(IILjava/net/InetAddress;IZ)V"(thread: JVMThread, args: [number, number, java_net_InetAddress, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/setPeerPrimAddrOption0(IILjava/net/InetAddress;IZ)V"(thread: JVMThread, args: [number, number, java_net_InetAddress, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "getPrimAddrOption0(II)Ljava/net/SocketAddress;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getPrimAddrOption0(II)Ljava/net/SocketAddress;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public static "getInitMsgOption0(I[I)V"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/getInitMsgOption0(I[I)V"(thread: JVMThread, args: [number, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "setInitMsgOption0(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/setInitMsgOption0(III)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "shutdown0(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/shutdown0(II)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "init()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/init()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpNet/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_sctp_ResultContainer extends java_lang_Object {
    public static "sun/nio/ch/sctp/ResultContainer/NOTHING": number;
    public static "sun/nio/ch/sctp/ResultContainer/MESSAGE": number;
    public static "sun/nio/ch/sctp/ResultContainer/SEND_FAILED": number;
    public static "sun/nio/ch/sctp/ResultContainer/ASSOCIATION_CHANGED": number;
    public static "sun/nio/ch/sctp/ResultContainer/PEER_ADDRESS_CHANGED": number;
    public static "sun/nio/ch/sctp/ResultContainer/SHUTDOWN": number;
    public "sun/nio/ch/sctp/ResultContainer/value": java_lang_Object;
    public "sun/nio/ch/sctp/ResultContainer/type": number;
    public static "sun/nio/ch/sctp/ResultContainer/$assertionsDisabled": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "type()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/type()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hasSomething()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/hasSomething()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isNotification()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/isNotification()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "notification()Lsun/nio/ch/sctp/SctpNotification;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SctpNotification) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/notification()Lsun/nio/ch/sctp/SctpNotification;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SctpNotification) => void): void;
    public "getMessageInfo()Lsun/nio/ch/sctp/MessageInfoImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_MessageInfoImpl) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/getMessageInfo()Lsun/nio/ch/sctp/MessageInfoImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_MessageInfoImpl) => void): void;
    public "getSendFailed()Lsun/nio/ch/sctp/SendFailed;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SendFailed) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/getSendFailed()Lsun/nio/ch/sctp/SendFailed;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SendFailed) => void): void;
    public "getAssociationChanged()Lsun/nio/ch/sctp/AssociationChange;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_AssociationChange) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/getAssociationChanged()Lsun/nio/ch/sctp/AssociationChange;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_AssociationChange) => void): void;
    public "getPeerAddressChanged()Lsun/nio/ch/sctp/PeerAddrChange;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_PeerAddrChange) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/getPeerAddressChanged()Lsun/nio/ch/sctp/PeerAddrChange;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_PeerAddrChange) => void): void;
    public "getShutdown()Lsun/nio/ch/sctp/Shutdown;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_Shutdown) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/getShutdown()Lsun/nio/ch/sctp/Shutdown;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_Shutdown) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "sun/nio/ch/sctp/ResultContainer/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/ResultContainer/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_sctp_Shutdown extends com_sun_nio_sctp_ShutdownNotification implements sun_nio_ch_sctp_SctpNotification {
    public "sun/nio/ch/sctp/Shutdown/association": com_sun_nio_sctp_Association;
    public "sun/nio/ch/sctp/Shutdown/assocId": number;
    public static "sun/nio/ch/sctp/Shutdown/$assertionsDisabled": number;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/Shutdown/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/Shutdown/assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/Shutdown/setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "sun/nio/ch/sctp/Shutdown/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "sun/nio/ch/sctp/Shutdown/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/Shutdown/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_ShutdownNotification extends java_lang_Object implements com_sun_nio_sctp_Notification {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/ShutdownNotification/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "com/sun/nio/sctp/ShutdownNotification/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
  }
  export class sun_nio_ch_sctp_PeerAddrChange extends com_sun_nio_sctp_PeerAddressChangeNotification implements sun_nio_ch_sctp_SctpNotification {
    public static "sun/nio/ch/sctp/PeerAddrChange/SCTP_ADDR_AVAILABLE": number;
    public static "sun/nio/ch/sctp/PeerAddrChange/SCTP_ADDR_UNREACHABLE": number;
    public static "sun/nio/ch/sctp/PeerAddrChange/SCTP_ADDR_REMOVED": number;
    public static "sun/nio/ch/sctp/PeerAddrChange/SCTP_ADDR_ADDED": number;
    public static "sun/nio/ch/sctp/PeerAddrChange/SCTP_ADDR_MADE_PRIM": number;
    public static "sun/nio/ch/sctp/PeerAddrChange/SCTP_ADDR_CONFIRMED": number;
    public "sun/nio/ch/sctp/PeerAddrChange/association": com_sun_nio_sctp_Association;
    public "sun/nio/ch/sctp/PeerAddrChange/assocId": number;
    public "sun/nio/ch/sctp/PeerAddrChange/address": java_net_SocketAddress;
    public "sun/nio/ch/sctp/PeerAddrChange/event": com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent;
    public static "sun/nio/ch/sctp/PeerAddrChange/$assertionsDisabled": number;
    public "<init>(ILjava/net/SocketAddress;I)V"(thread: JVMThread, args: [number, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/PeerAddrChange/<init>(ILjava/net/SocketAddress;I)V"(thread: JVMThread, args: [number, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/PeerAddrChange/assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/PeerAddrChange/setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "sun/nio/ch/sctp/PeerAddrChange/address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "sun/nio/ch/sctp/PeerAddrChange/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "event()Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent) => void): void;
    public "sun/nio/ch/sctp/PeerAddrChange/event()Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "sun/nio/ch/sctp/PeerAddrChange/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/PeerAddrChange/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent extends java_lang_Enum {
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/ADDR_AVAILABLE": com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/ADDR_UNREACHABLE": com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/ADDR_REMOVED": com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/ADDR_ADDED": com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/ADDR_MADE_PRIMARY": com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/ADDR_CONFIRMED": com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/$VALUES": JVMArray<com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent>;
    public static "values()[Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent>) => void): void;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/values()[Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent>) => void): void;
    public static "valueOf(Ljava/lang/String;)Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent) => void): void;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/valueOf(Ljava/lang/String;)Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "com/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_PeerAddressChangeNotification extends java_lang_Object implements com_sun_nio_sctp_Notification {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/PeerAddressChangeNotification/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "com/sun/nio/sctp/PeerAddressChangeNotification/address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "com/sun/nio/sctp/PeerAddressChangeNotification/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "event()Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent) => void): void;
    public "com/sun/nio/sctp/PeerAddressChangeNotification/event()Lcom/sun/nio/sctp/PeerAddressChangeNotification$AddressChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_PeerAddressChangeNotification$AddressChangeEvent) => void): void;
  }
  export class sun_nio_ch_sctp_AssociationChange extends com_sun_nio_sctp_AssociationChangeNotification implements sun_nio_ch_sctp_SctpNotification {
    public static "sun/nio/ch/sctp/AssociationChange/SCTP_COMM_UP": number;
    public static "sun/nio/ch/sctp/AssociationChange/SCTP_COMM_LOST": number;
    public static "sun/nio/ch/sctp/AssociationChange/SCTP_RESTART": number;
    public static "sun/nio/ch/sctp/AssociationChange/SCTP_SHUTDOWN": number;
    public static "sun/nio/ch/sctp/AssociationChange/SCTP_CANT_START": number;
    public "sun/nio/ch/sctp/AssociationChange/association": com_sun_nio_sctp_Association;
    public "sun/nio/ch/sctp/AssociationChange/assocId": number;
    public "sun/nio/ch/sctp/AssociationChange/event": com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent;
    public "sun/nio/ch/sctp/AssociationChange/maxOutStreams": number;
    public "sun/nio/ch/sctp/AssociationChange/maxInStreams": number;
    public static "sun/nio/ch/sctp/AssociationChange/$assertionsDisabled": number;
    public "<init>(IIII)V"(thread: JVMThread, args: [number, number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/<init>(IIII)V"(thread: JVMThread, args: [number, number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "event()Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/event()Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent) => void): void;
    public "maxOutStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/maxOutStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "maxInStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/maxInStreams()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "sun/nio/ch/sctp/AssociationChange/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/AssociationChange/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent extends java_lang_Enum {
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/COMM_UP": com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/COMM_LOST": com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/RESTART": com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/SHUTDOWN": com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/CANT_START": com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/$VALUES": JVMArray<com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent>;
    public static "values()[Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent>) => void): void;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/values()[Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent>) => void): void;
    public static "valueOf(Ljava/lang/String;)Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent) => void): void;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/valueOf(Ljava/lang/String;)Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "com/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_AssociationChangeNotification extends java_lang_Object implements com_sun_nio_sctp_Notification {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/AssociationChangeNotification/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "com/sun/nio/sctp/AssociationChangeNotification/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "event()Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent) => void): void;
    public "com/sun/nio/sctp/AssociationChangeNotification/event()Lcom/sun/nio/sctp/AssociationChangeNotification$AssocChangeEvent;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_AssociationChangeNotification$AssocChangeEvent) => void): void;
  }
  export class sun_nio_ch_sctp_SendFailed extends com_sun_nio_sctp_SendFailedNotification implements sun_nio_ch_sctp_SctpNotification {
    public "sun/nio/ch/sctp/SendFailed/association": com_sun_nio_sctp_Association;
    public "sun/nio/ch/sctp/SendFailed/assocId": number;
    public "sun/nio/ch/sctp/SendFailed/address": java_net_SocketAddress;
    public "sun/nio/ch/sctp/SendFailed/buffer": java_nio_ByteBuffer;
    public "sun/nio/ch/sctp/SendFailed/errorCode": number;
    public "sun/nio/ch/sctp/SendFailed/streamNumber": number;
    public static "sun/nio/ch/sctp/SendFailed/$assertionsDisabled": number;
    public "<init>(ILjava/net/SocketAddress;Ljava/nio/ByteBuffer;II)V"(thread: JVMThread, args: [number, java_net_SocketAddress, java_nio_ByteBuffer, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SendFailed/<init>(ILjava/net/SocketAddress;Ljava/nio/ByteBuffer;II)V"(thread: JVMThread, args: [number, java_net_SocketAddress, java_nio_ByteBuffer, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SendFailed/assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SendFailed/setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "sun/nio/ch/sctp/SendFailed/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "sun/nio/ch/sctp/SendFailed/address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "buffer()Ljava/nio/ByteBuffer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_ByteBuffer) => void): void;
    public "sun/nio/ch/sctp/SendFailed/buffer()Ljava/nio/ByteBuffer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_ByteBuffer) => void): void;
    public "errorCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SendFailed/errorCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SendFailed/streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "sun/nio/ch/sctp/SendFailed/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SendFailed/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_SendFailedNotification extends java_lang_Object implements com_sun_nio_sctp_Notification {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/SendFailedNotification/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "com/sun/nio/sctp/SendFailedNotification/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "com/sun/nio/sctp/SendFailedNotification/address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "buffer()Ljava/nio/ByteBuffer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_ByteBuffer) => void): void;
    public "com/sun/nio/sctp/SendFailedNotification/buffer()Ljava/nio/ByteBuffer;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_ByteBuffer) => void): void;
    public "errorCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SendFailedNotification/errorCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "com/sun/nio/sctp/SendFailedNotification/streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class sun_nio_ch_sctp_MessageInfoImpl extends com_sun_nio_sctp_MessageInfo {
    public "sun/nio/ch/sctp/MessageInfoImpl/address": java_net_SocketAddress;
    public "sun/nio/ch/sctp/MessageInfoImpl/bytes": number;
    public "sun/nio/ch/sctp/MessageInfoImpl/association": com_sun_nio_sctp_Association;
    public "sun/nio/ch/sctp/MessageInfoImpl/assocId": number;
    public "sun/nio/ch/sctp/MessageInfoImpl/streamNumber": number;
    public "sun/nio/ch/sctp/MessageInfoImpl/complete": number;
    public "sun/nio/ch/sctp/MessageInfoImpl/unordered": number;
    public "sun/nio/ch/sctp/MessageInfoImpl/timeToLive": Long;
    public "sun/nio/ch/sctp/MessageInfoImpl/ppid": number;
    public "<init>(Lcom/sun/nio/sctp/Association;Ljava/net/SocketAddress;I)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/<init>(Lcom/sun/nio/sctp/Association;Ljava/net/SocketAddress;I)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association, java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(ILjava/net/SocketAddress;IIZZI)V"(thread: JVMThread, args: [number, java_net_SocketAddress, number, number, number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/<init>(ILjava/net/SocketAddress;IIZZI)V"(thread: JVMThread, args: [number, java_net_SocketAddress, number, number, number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "associationID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/associationID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/address()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "bytes()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/bytes()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/streamNumber()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "streamNumber(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/streamNumber(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "payloadProtocolID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/payloadProtocolID()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "payloadProtocolID(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/payloadProtocolID(I)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "isComplete()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/isComplete()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "complete(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/complete(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "isUnordered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/isUnordered()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "unordered(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/unordered(Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "timeToLive()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/timeToLive()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "timeToLive(J)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/timeToLive(J)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "sun/nio/ch/sctp/MessageInfoImpl/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
  }
  export interface sun_nio_ch_sctp_SctpNotification extends java_lang_Object, com_sun_nio_sctp_Notification {
    "assocId()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "setAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
  }
  export class sun_nio_ch_sctp_SctpChannelImpl extends com_sun_nio_sctp_SctpChannel implements sun_nio_ch_SelChImpl {
    public "sun/nio/ch/sctp/SctpChannelImpl/fd": java_io_FileDescriptor;
    public "sun/nio/ch/sctp/SctpChannelImpl/fdVal": number;
    public "sun/nio/ch/sctp/SctpChannelImpl/receiverThread": Long;
    public "sun/nio/ch/sctp/SctpChannelImpl/senderThread": Long;
    public "sun/nio/ch/sctp/SctpChannelImpl/receiveLock": java_lang_Object;
    public "sun/nio/ch/sctp/SctpChannelImpl/sendLock": java_lang_Object;
    public "sun/nio/ch/sctp/SctpChannelImpl/receiveInvoked": java_lang_ThreadLocal;
    public "sun/nio/ch/sctp/SctpChannelImpl/stateLock": java_lang_Object;
    public "sun/nio/ch/sctp/SctpChannelImpl/state": sun_nio_ch_sctp_SctpChannelImpl$ChannelState;
    public "sun/nio/ch/sctp/SctpChannelImpl/port": number;
    public "sun/nio/ch/sctp/SctpChannelImpl/localAddresses": java_util_HashSet;
    public "sun/nio/ch/sctp/SctpChannelImpl/wildcard": number;
    public "sun/nio/ch/sctp/SctpChannelImpl/readyToConnect": number;
    public "sun/nio/ch/sctp/SctpChannelImpl/isShutdown": number;
    public "sun/nio/ch/sctp/SctpChannelImpl/association": com_sun_nio_sctp_Association;
    public "sun/nio/ch/sctp/SctpChannelImpl/remoteAddresses": java_util_Set;
    public "sun/nio/ch/sctp/SctpChannelImpl/internalNotificationHandler": sun_nio_ch_sctp_SctpChannelImpl$InternalNotificationHandler;
    public static "sun/nio/ch/sctp/SctpChannelImpl/$assertionsDisabled": number;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/<init>(Ljava/nio/channels/spi/SelectorProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/<init>(Ljava/nio/channels/spi/SelectorProvider;Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/nio/channels/spi/SelectorProvider;Ljava/io/FileDescriptor;Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider, java_io_FileDescriptor, com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/<init>(Ljava/nio/channels/spi/SelectorProvider;Ljava/io/FileDescriptor;Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [java_nio_channels_spi_SelectorProvider, java_io_FileDescriptor, com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "bind(Ljava/net/SocketAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/bind(Ljava/net/SocketAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/bindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/unbindAddress(Ljava/net/InetAddress;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "bindUnbindAddress(Ljava/net/InetAddress;Z)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/bindUnbindAddress(Ljava/net/InetAddress;Z)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [java_net_InetAddress, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/isBound()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/isConnected()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ensureOpenAndUnconnected()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/ensureOpenAndUnconnected()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "ensureReceiveOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/ensureReceiveOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ensureSendOpen()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/ensureSendOpen()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "receiverCleanup()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/receiverCleanup()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "senderCleanup()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/senderCleanup()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/association()Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public "connect(Ljava/net/SocketAddress;)Z"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/connect(Ljava/net/SocketAddress;)Z"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "connect(Ljava/net/SocketAddress;II)Z"(thread: JVMThread, args: [java_net_SocketAddress, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/connect(Ljava/net/SocketAddress;II)Z"(thread: JVMThread, args: [java_net_SocketAddress, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isConnectionPending()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/isConnectionPending()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "finishConnect()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/finishConnect()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "implConfigureBlocking(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/implConfigureBlocking(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "implCloseSelectableChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/implCloseSelectableChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getFD()Ljava/io/FileDescriptor;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/getFD()Ljava/io/FileDescriptor;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "getFDVal()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/getFDVal()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateReadyOps(IILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/translateReadyOps(IILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateAndUpdateReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/translateAndUpdateReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateAndSetReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/translateAndSetReadyOps(ILsun/nio/ch/SelectionKeyImpl;)Z"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "translateAndSetInterestOps(ILsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/translateAndSetInterestOps(ILsun/nio/ch/SelectionKeyImpl;)V"(thread: JVMThread, args: [number, sun_nio_ch_SelectionKeyImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "kill()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/kill()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/setOption(Lcom/sun/nio/sctp/SctpSocketOption;Ljava/lang/Object;)Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/getOption(Lcom/sun/nio/sctp/SctpSocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [com_sun_nio_sctp_SctpSocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "receive(Ljava/nio/ByteBuffer;Ljava/lang/Object;Lcom/sun/nio/sctp/NotificationHandler;)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, com_sun_nio_sctp_NotificationHandler], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/receive(Ljava/nio/ByteBuffer;Ljava/lang/Object;Lcom/sun/nio/sctp/NotificationHandler;)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, com_sun_nio_sctp_NotificationHandler], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "receive(Ljava/nio/ByteBuffer;Ljava/lang/Object;Lcom/sun/nio/sctp/NotificationHandler;Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, com_sun_nio_sctp_NotificationHandler, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/receive(Ljava/nio/ByteBuffer;Ljava/lang/Object;Lcom/sun/nio/sctp/NotificationHandler;Z)Lcom/sun/nio/sctp/MessageInfo;"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, com_sun_nio_sctp_NotificationHandler, number], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_MessageInfo) => void): void;
    public "receive(ILjava/nio/ByteBuffer;Lsun/nio/ch/sctp/ResultContainer;Z)I"(thread: JVMThread, args: [number, java_nio_ByteBuffer, sun_nio_ch_sctp_ResultContainer, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/receive(ILjava/nio/ByteBuffer;Lsun/nio/ch/sctp/ResultContainer;Z)I"(thread: JVMThread, args: [number, java_nio_ByteBuffer, sun_nio_ch_sctp_ResultContainer, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "receiveIntoNativeBuffer(ILsun/nio/ch/sctp/ResultContainer;Ljava/nio/ByteBuffer;IIZ)I"(thread: JVMThread, args: [number, sun_nio_ch_sctp_ResultContainer, java_nio_ByteBuffer, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/receiveIntoNativeBuffer(ILsun/nio/ch/sctp/ResultContainer;Ljava/nio/ByteBuffer;IIZ)I"(thread: JVMThread, args: [number, sun_nio_ch_sctp_ResultContainer, java_nio_ByteBuffer, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "handleNotificationInternal(Lsun/nio/ch/sctp/ResultContainer;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_ResultContainer], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/handleNotificationInternal(Lsun/nio/ch/sctp/ResultContainer;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_ResultContainer], cb?: (e?: java_lang_Throwable) => void): void;
    public "invokeNotificationHandler(Lsun/nio/ch/sctp/ResultContainer;Lcom/sun/nio/sctp/NotificationHandler;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [sun_nio_ch_sctp_ResultContainer, com_sun_nio_sctp_NotificationHandler, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/invokeNotificationHandler(Lsun/nio/ch/sctp/ResultContainer;Lcom/sun/nio/sctp/NotificationHandler;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [sun_nio_ch_sctp_ResultContainer, com_sun_nio_sctp_NotificationHandler, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "checkAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/checkAssociation(Lcom/sun/nio/sctp/Association;)V"(thread: JVMThread, args: [com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkStreamNumber(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/checkStreamNumber(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "send(Ljava/nio/ByteBuffer;Lcom/sun/nio/sctp/MessageInfo;)I"(thread: JVMThread, args: [java_nio_ByteBuffer, com_sun_nio_sctp_MessageInfo], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/send(Ljava/nio/ByteBuffer;Lcom/sun/nio/sctp/MessageInfo;)I"(thread: JVMThread, args: [java_nio_ByteBuffer, com_sun_nio_sctp_MessageInfo], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "send(ILjava/nio/ByteBuffer;Lcom/sun/nio/sctp/MessageInfo;)I"(thread: JVMThread, args: [number, java_nio_ByteBuffer, com_sun_nio_sctp_MessageInfo], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/send(ILjava/nio/ByteBuffer;Lcom/sun/nio/sctp/MessageInfo;)I"(thread: JVMThread, args: [number, java_nio_ByteBuffer, com_sun_nio_sctp_MessageInfo], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sendFromNativeBuffer(ILjava/nio/ByteBuffer;Ljava/net/SocketAddress;IZI)I"(thread: JVMThread, args: [number, java_nio_ByteBuffer, java_net_SocketAddress, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/sendFromNativeBuffer(ILjava/nio/ByteBuffer;Ljava/net/SocketAddress;IZI)I"(thread: JVMThread, args: [number, java_nio_ByteBuffer, java_net_SocketAddress, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "shutdown()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/shutdown()Lcom/sun/nio/sctp/SctpChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_SctpChannel) => void): void;
    public "getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/getAllLocalAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getRemoteAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl/getRemoteAddresses()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public static "initIDs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl/initIDs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "receive0(ILsun/nio/ch/sctp/ResultContainer;JIZ)I"(thread: JVMThread, args: [number, sun_nio_ch_sctp_ResultContainer, Long, any, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl/receive0(ILsun/nio/ch/sctp/ResultContainer;JIZ)I"(thread: JVMThread, args: [number, sun_nio_ch_sctp_ResultContainer, Long, any, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "send0(IJILjava/net/InetAddress;IIIZI)I"(thread: JVMThread, args: [number, Long, any, number, java_net_InetAddress, number, number, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl/send0(IJILjava/net/InetAddress;IIIZI)I"(thread: JVMThread, args: [number, Long, any, number, java_net_InetAddress, number, number, number, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "checkConnect(Ljava/io/FileDescriptor;ZZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl/checkConnect(Ljava/io/FileDescriptor;ZZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$100(Lsun/nio/ch/sctp/SctpChannelImpl;)Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl/access$100(Lsun/nio/ch/sctp/SctpChannelImpl;)Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public static "access$102(Lsun/nio/ch/sctp/SctpChannelImpl;Lcom/sun/nio/sctp/Association;)Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl, com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl/access$102(Lsun/nio/ch/sctp/SctpChannelImpl;Lcom/sun/nio/sctp/Association;)Lcom/sun/nio/sctp/Association;"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl, com_sun_nio_sctp_Association], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_Association) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_sctp_SctpChannelImpl$InternalNotificationHandler extends com_sun_nio_sctp_AbstractNotificationHandler {
    public "sun/nio/ch/sctp/SctpChannelImpl$InternalNotificationHandler/this$0": sun_nio_ch_sctp_SctpChannelImpl;
    public "<init>(Lsun/nio/ch/sctp/SctpChannelImpl;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl$InternalNotificationHandler/<init>(Lsun/nio/ch/sctp/SctpChannelImpl;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "handleNotification(Lcom/sun/nio/sctp/AssociationChangeNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_AssociationChangeNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl$InternalNotificationHandler/handleNotification(Lcom/sun/nio/sctp/AssociationChangeNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_AssociationChangeNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "<init>(Lsun/nio/ch/sctp/SctpChannelImpl;Lsun/nio/ch/sctp/SctpChannelImpl$1;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl, sun_nio_ch_sctp_SctpChannelImpl$1], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl$InternalNotificationHandler/<init>(Lsun/nio/ch/sctp/SctpChannelImpl;Lsun/nio/ch/sctp/SctpChannelImpl$1;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl, sun_nio_ch_sctp_SctpChannelImpl$1], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_sctp_SctpChannelImpl$1 extends java_lang_ThreadLocal {
    public "sun/nio/ch/sctp/SctpChannelImpl$1/this$0": sun_nio_ch_sctp_SctpChannelImpl;
    public "<init>(Lsun/nio/ch/sctp/SctpChannelImpl;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl$1/<init>(Lsun/nio/ch/sctp/SctpChannelImpl;)V"(thread: JVMThread, args: [sun_nio_ch_sctp_SctpChannelImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "initialValue()Ljava/lang/Boolean;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Boolean) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl$1/initialValue()Ljava/lang/Boolean;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Boolean) => void): void;
    public "initialValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl$1/initialValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class java_lang_Boolean extends java_lang_Object implements java_io_Serializable, java_lang_Comparable {
    public unbox(): number;
    public static box(val: number): java_lang_Boolean;
    public static "java/lang/Boolean/TRUE": java_lang_Boolean;
    public static "java/lang/Boolean/FALSE": java_lang_Boolean;
    public static "java/lang/Boolean/TYPE": java_lang_Class;
    public "java/lang/Boolean/value": number;
    public static "java/lang/Boolean/serialVersionUID": Long;
    public "<init>(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Boolean/<init>(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Boolean/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public static "parseBoolean(Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Boolean/parseBoolean(Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "booleanValue()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Boolean/booleanValue()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "valueOf(Z)Ljava/lang/Boolean;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Boolean) => void): void;
    public static "java/lang/Boolean/valueOf(Z)Ljava/lang/Boolean;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Boolean) => void): void;
    public static "valueOf(Ljava/lang/String;)Ljava/lang/Boolean;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Boolean) => void): void;
    public static "java/lang/Boolean/valueOf(Ljava/lang/String;)Ljava/lang/Boolean;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_Boolean) => void): void;
    public static "toString(Z)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/lang/Boolean/toString(Z)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/lang/Boolean/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Boolean/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "hashCode(Z)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Boolean/hashCode(Z)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Boolean/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "getBoolean(Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Boolean/getBoolean(Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareTo(Ljava/lang/Boolean;)I"(thread: JVMThread, args: [java_lang_Boolean], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Boolean/compareTo(Ljava/lang/Boolean;)I"(thread: JVMThread, args: [java_lang_Boolean], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "compare(ZZ)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Boolean/compare(ZZ)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "logicalAnd(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Boolean/logicalAnd(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "logicalOr(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Boolean/logicalOr(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "logicalXor(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/Boolean/logicalXor(ZZ)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/Boolean/compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/Boolean/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class com_sun_nio_sctp_AbstractNotificationHandler extends java_lang_Object implements com_sun_nio_sctp_NotificationHandler {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "com/sun/nio/sctp/AbstractNotificationHandler/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "handleNotification(Lcom/sun/nio/sctp/Notification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_Notification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "com/sun/nio/sctp/AbstractNotificationHandler/handleNotification(Lcom/sun/nio/sctp/Notification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_Notification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "handleNotification(Lcom/sun/nio/sctp/AssociationChangeNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_AssociationChangeNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "com/sun/nio/sctp/AbstractNotificationHandler/handleNotification(Lcom/sun/nio/sctp/AssociationChangeNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_AssociationChangeNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "handleNotification(Lcom/sun/nio/sctp/PeerAddressChangeNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_PeerAddressChangeNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "com/sun/nio/sctp/AbstractNotificationHandler/handleNotification(Lcom/sun/nio/sctp/PeerAddressChangeNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_PeerAddressChangeNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "handleNotification(Lcom/sun/nio/sctp/SendFailedNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_SendFailedNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "com/sun/nio/sctp/AbstractNotificationHandler/handleNotification(Lcom/sun/nio/sctp/SendFailedNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_SendFailedNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "handleNotification(Lcom/sun/nio/sctp/ShutdownNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_ShutdownNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
    public "com/sun/nio/sctp/AbstractNotificationHandler/handleNotification(Lcom/sun/nio/sctp/ShutdownNotification;Ljava/lang/Object;)Lcom/sun/nio/sctp/HandlerResult;"(thread: JVMThread, args: [com_sun_nio_sctp_ShutdownNotification, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: com_sun_nio_sctp_HandlerResult) => void): void;
  }
  export class sun_nio_ch_sctp_SctpChannelImpl$ChannelState extends java_lang_Enum {
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/UNINITIALIZED": sun_nio_ch_sctp_SctpChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/UNCONNECTED": sun_nio_ch_sctp_SctpChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/PENDING": sun_nio_ch_sctp_SctpChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/CONNECTED": sun_nio_ch_sctp_SctpChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/KILLPENDING": sun_nio_ch_sctp_SctpChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/KILLED": sun_nio_ch_sctp_SctpChannelImpl$ChannelState;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/$VALUES": JVMArray<sun_nio_ch_sctp_SctpChannelImpl$ChannelState>;
    public static "values()[Lsun/nio/ch/sctp/SctpChannelImpl$ChannelState;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<sun_nio_ch_sctp_SctpChannelImpl$ChannelState>) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/values()[Lsun/nio/ch/sctp/SctpChannelImpl$ChannelState;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<sun_nio_ch_sctp_SctpChannelImpl$ChannelState>) => void): void;
    public static "valueOf(Ljava/lang/String;)Lsun/nio/ch/sctp/SctpChannelImpl$ChannelState;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SctpChannelImpl$ChannelState) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/valueOf(Ljava/lang/String;)Lsun/nio/ch/sctp/SctpChannelImpl$ChannelState;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_sctp_SctpChannelImpl$ChannelState) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/sctp/SctpChannelImpl$ChannelState/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_ThreadLocal extends java_lang_Object {
    public "java/lang/ThreadLocal/threadLocalHashCode": number;
    public static "java/lang/ThreadLocal/nextHashCode": java_util_concurrent_atomic_AtomicInteger;
    public static "java/lang/ThreadLocal/HASH_INCREMENT": number;
    public static "nextHashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/ThreadLocal/nextHashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "initialValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/lang/ThreadLocal/initialValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "withInitial(Ljava/util/function/Supplier;)Ljava/lang/ThreadLocal;"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal) => void): void;
    public static "java/lang/ThreadLocal/withInitial(Ljava/util/function/Supplier;)Ljava/lang/ThreadLocal;"(thread: JVMThread, args: [java_util_function_Supplier], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/lang/ThreadLocal/get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "setInitialValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/lang/ThreadLocal/setInitialValue()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "set(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal/set(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal/remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getMap(Ljava/lang/Thread;)Ljava/lang/ThreadLocal$ThreadLocalMap;"(thread: JVMThread, args: [java_lang_Thread], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap) => void): void;
    public "java/lang/ThreadLocal/getMap(Ljava/lang/Thread;)Ljava/lang/ThreadLocal$ThreadLocalMap;"(thread: JVMThread, args: [java_lang_Thread], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap) => void): void;
    public "createMap(Ljava/lang/Thread;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Thread, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal/createMap(Ljava/lang/Thread;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Thread, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public static "createInheritedMap(Ljava/lang/ThreadLocal$ThreadLocalMap;)Ljava/lang/ThreadLocal$ThreadLocalMap;"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap) => void): void;
    public static "java/lang/ThreadLocal/createInheritedMap(Ljava/lang/ThreadLocal$ThreadLocalMap;)Ljava/lang/ThreadLocal$ThreadLocalMap;"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap) => void): void;
    public "childValue(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "java/lang/ThreadLocal/childValue(Ljava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "access$400(Ljava/lang/ThreadLocal;)I"(thread: JVMThread, args: [java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/ThreadLocal/access$400(Ljava/lang/ThreadLocal;)I"(thread: JVMThread, args: [java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/ThreadLocal/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_ThreadLocal$ThreadLocalMap extends java_lang_Object {
    public static "java/lang/ThreadLocal$ThreadLocalMap/INITIAL_CAPACITY": number;
    public "java/lang/ThreadLocal$ThreadLocalMap/table": JVMArray<java_lang_ThreadLocal$ThreadLocalMap$Entry>;
    public "java/lang/ThreadLocal$ThreadLocalMap/size": number;
    public "java/lang/ThreadLocal$ThreadLocalMap/threshold": number;
    public "setThreshold(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/setThreshold(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "nextIndex(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/ThreadLocal$ThreadLocalMap/nextIndex(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "prevIndex(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/lang/ThreadLocal$ThreadLocalMap/prevIndex(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "<init>(Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/<init>(Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/ThreadLocal$ThreadLocalMap;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/<init>(Ljava/lang/ThreadLocal$ThreadLocalMap;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap], cb?: (e?: java_lang_Throwable) => void): void;
    public "getEntry(Ljava/lang/ThreadLocal;)Ljava/lang/ThreadLocal$ThreadLocalMap$Entry;"(thread: JVMThread, args: [java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap$Entry) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/getEntry(Ljava/lang/ThreadLocal;)Ljava/lang/ThreadLocal$ThreadLocalMap$Entry;"(thread: JVMThread, args: [java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap$Entry) => void): void;
    public "getEntryAfterMiss(Ljava/lang/ThreadLocal;ILjava/lang/ThreadLocal$ThreadLocalMap$Entry;)Ljava/lang/ThreadLocal$ThreadLocalMap$Entry;"(thread: JVMThread, args: [java_lang_ThreadLocal, number, java_lang_ThreadLocal$ThreadLocalMap$Entry], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap$Entry) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/getEntryAfterMiss(Ljava/lang/ThreadLocal;ILjava/lang/ThreadLocal$ThreadLocalMap$Entry;)Ljava/lang/ThreadLocal$ThreadLocalMap$Entry;"(thread: JVMThread, args: [java_lang_ThreadLocal, number, java_lang_ThreadLocal$ThreadLocalMap$Entry], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap$Entry) => void): void;
    public "set(Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/set(Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "remove(Ljava/lang/ThreadLocal;)V"(thread: JVMThread, args: [java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/remove(Ljava/lang/ThreadLocal;)V"(thread: JVMThread, args: [java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable) => void): void;
    public "replaceStaleEntry(Ljava/lang/ThreadLocal;Ljava/lang/Object;I)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/replaceStaleEntry(Ljava/lang/ThreadLocal;Ljava/lang/Object;I)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "expungeStaleEntry(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/expungeStaleEntry(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "cleanSomeSlots(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/cleanSomeSlots(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "rehash()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/rehash()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "resize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/resize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "expungeStaleEntries()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/expungeStaleEntries()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "access$000(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal;)Ljava/lang/ThreadLocal$ThreadLocalMap$Entry;"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap$Entry) => void): void;
    public static "java/lang/ThreadLocal$ThreadLocalMap/access$000(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal;)Ljava/lang/ThreadLocal$ThreadLocalMap$Entry;"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable, rv?: java_lang_ThreadLocal$ThreadLocalMap$Entry) => void): void;
    public static "access$100(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/ThreadLocal$ThreadLocalMap/access$100(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public static "access$200(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/ThreadLocal$ThreadLocalMap/access$200(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal$1;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal$1], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap/<init>(Ljava/lang/ThreadLocal$ThreadLocalMap;Ljava/lang/ThreadLocal$1;)V"(thread: JVMThread, args: [java_lang_ThreadLocal$ThreadLocalMap, java_lang_ThreadLocal$1], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_ThreadLocal$1 extends java_lang_Object {
  }
  export class java_lang_ThreadLocal$ThreadLocalMap$Entry extends java_lang_ref_WeakReference {
    public "java/lang/ThreadLocal$ThreadLocalMap$Entry/value": java_lang_Object;
    public "<init>(Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ThreadLocal$ThreadLocalMap$Entry/<init>(Ljava/lang/ThreadLocal;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_ThreadLocal, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_ref_WeakReference extends java_lang_ref_Reference {
    public "<init>(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ref/WeakReference/<init>(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_ref_ReferenceQueue], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ref/WeakReference/<init>(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_ref_ReferenceQueue], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_ref_ReferenceQueue extends java_lang_Object {
    public static "java/lang/ref/ReferenceQueue/NULL": java_lang_ref_ReferenceQueue;
    public static "java/lang/ref/ReferenceQueue/ENQUEUED": java_lang_ref_ReferenceQueue;
    public "java/lang/ref/ReferenceQueue/lock": java_lang_ref_ReferenceQueue$Lock;
    public "java/lang/ref/ReferenceQueue/head": java_lang_ref_Reference;
    public "java/lang/ref/ReferenceQueue/queueLength": Long;
    public static "java/lang/ref/ReferenceQueue/$assertionsDisabled": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ref/ReferenceQueue/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "enqueue(Ljava/lang/ref/Reference;)Z"(thread: JVMThread, args: [java_lang_ref_Reference], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/lang/ref/ReferenceQueue/enqueue(Ljava/lang/ref/Reference;)Z"(thread: JVMThread, args: [java_lang_ref_Reference], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "reallyPoll()Ljava/lang/ref/Reference;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public "java/lang/ref/ReferenceQueue/reallyPoll()Ljava/lang/ref/Reference;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public "poll()Ljava/lang/ref/Reference;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public "java/lang/ref/ReferenceQueue/poll()Ljava/lang/ref/Reference;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public "remove(J)Ljava/lang/ref/Reference;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public "java/lang/ref/ReferenceQueue/remove(J)Ljava/lang/ref/Reference;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public "remove()Ljava/lang/ref/Reference;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public "java/lang/ref/ReferenceQueue/remove()Ljava/lang/ref/Reference;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_ref_Reference) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/ref/ReferenceQueue/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_ref_ReferenceQueue$Lock extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ref/ReferenceQueue$Lock/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/ref/ReferenceQueue$1;)V"(thread: JVMThread, args: [java_lang_ref_ReferenceQueue$1], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/ref/ReferenceQueue$Lock/<init>(Ljava/lang/ref/ReferenceQueue$1;)V"(thread: JVMThread, args: [java_lang_ref_ReferenceQueue$1], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_lang_ref_ReferenceQueue$1 extends java_lang_Object {
  }
  export class java_util_concurrent_atomic_AtomicInteger extends java_lang_Number implements java_io_Serializable {
    public static "java/util/concurrent/atomic/AtomicInteger/serialVersionUID": Long;
    public static "java/util/concurrent/atomic/AtomicInteger/unsafe": sun_misc_Unsafe;
    public static "java/util/concurrent/atomic/AtomicInteger/valueOffset": Long;
    public "java/util/concurrent/atomic/AtomicInteger/value": number;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "get()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/get()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "set(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/set(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "lazySet(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/lazySet(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getAndSet(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/getAndSet(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareAndSet(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/compareAndSet(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "weakCompareAndSet(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/weakCompareAndSet(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAndIncrement()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/getAndIncrement()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAndDecrement()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/getAndDecrement()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAndAdd(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/getAndAdd(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "incrementAndGet()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/incrementAndGet()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "decrementAndGet()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/decrementAndGet()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "addAndGet(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/addAndGet(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAndUpdate(Ljava/util/function/IntUnaryOperator;)I"(thread: JVMThread, args: [java_util_function_IntUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/getAndUpdate(Ljava/util/function/IntUnaryOperator;)I"(thread: JVMThread, args: [java_util_function_IntUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "updateAndGet(Ljava/util/function/IntUnaryOperator;)I"(thread: JVMThread, args: [java_util_function_IntUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/updateAndGet(Ljava/util/function/IntUnaryOperator;)I"(thread: JVMThread, args: [java_util_function_IntUnaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getAndAccumulate(ILjava/util/function/IntBinaryOperator;)I"(thread: JVMThread, args: [number, java_util_function_IntBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/getAndAccumulate(ILjava/util/function/IntBinaryOperator;)I"(thread: JVMThread, args: [number, java_util_function_IntBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "accumulateAndGet(ILjava/util/function/IntBinaryOperator;)I"(thread: JVMThread, args: [number, java_util_function_IntBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/accumulateAndGet(ILjava/util/function/IntBinaryOperator;)I"(thread: JVMThread, args: [number, java_util_function_IntBinaryOperator], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/intValue()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/longValue()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/floatValue()F"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/atomic/AtomicInteger/doubleValue()D"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/concurrent/atomic/AtomicInteger/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_FileChannelImpl extends java_nio_channels_FileChannel {
    public static "sun/nio/ch/FileChannelImpl/allocationGranularity": Long;
    public "sun/nio/ch/FileChannelImpl/nd": sun_nio_ch_FileDispatcher;
    public "sun/nio/ch/FileChannelImpl/fd": java_io_FileDescriptor;
    public "sun/nio/ch/FileChannelImpl/writable": number;
    public "sun/nio/ch/FileChannelImpl/readable": number;
    public "sun/nio/ch/FileChannelImpl/append": number;
    public "sun/nio/ch/FileChannelImpl/parent": java_lang_Object;
    public "sun/nio/ch/FileChannelImpl/path": java_lang_String;
    public "sun/nio/ch/FileChannelImpl/threads": sun_nio_ch_NativeThreadSet;
    public "sun/nio/ch/FileChannelImpl/positionLock": java_lang_Object;
    public static "sun/nio/ch/FileChannelImpl/transferSupported": number;
    public static "sun/nio/ch/FileChannelImpl/pipeSupported": number;
    public static "sun/nio/ch/FileChannelImpl/fileSupported": number;
    public static "sun/nio/ch/FileChannelImpl/MAPPED_TRANSFER_SIZE": Long;
    public static "sun/nio/ch/FileChannelImpl/TRANSFER_SIZE": number;
    public static "sun/nio/ch/FileChannelImpl/MAP_RO": number;
    public static "sun/nio/ch/FileChannelImpl/MAP_RW": number;
    public static "sun/nio/ch/FileChannelImpl/MAP_PV": number;
    public "sun/nio/ch/FileChannelImpl/fileLockTable": sun_nio_ch_FileLockTable;
    public static "sun/nio/ch/FileChannelImpl/isSharedFileLockTable": number;
    public static "sun/nio/ch/FileChannelImpl/propertyChecked": number;
    public static "sun/nio/ch/FileChannelImpl/$assertionsDisabled": number;
    public "<init>(Ljava/io/FileDescriptor;Ljava/lang/String;ZZZLjava/lang/Object;)V"(thread: JVMThread, args: [java_io_FileDescriptor, java_lang_String, number, number, number, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileChannelImpl/<init>(Ljava/io/FileDescriptor;Ljava/lang/String;ZZZLjava/lang/Object;)V"(thread: JVMThread, args: [java_io_FileDescriptor, java_lang_String, number, number, number, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open(Ljava/io/FileDescriptor;Ljava/lang/String;ZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_io_FileDescriptor, java_lang_String, number, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public static "sun/nio/ch/FileChannelImpl/open(Ljava/io/FileDescriptor;Ljava/lang/String;ZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_io_FileDescriptor, java_lang_String, number, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public static "open(Ljava/io/FileDescriptor;Ljava/lang/String;ZZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_io_FileDescriptor, java_lang_String, number, number, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public static "sun/nio/ch/FileChannelImpl/open(Ljava/io/FileDescriptor;Ljava/lang/String;ZZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_io_FileDescriptor, java_lang_String, number, number, number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "ensureOpen()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileChannelImpl/ensureOpen()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "implCloseChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileChannelImpl/implCloseChannel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileChannelImpl/read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileChannelImpl/write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "position()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/position()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "position(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "sun/nio/ch/FileChannelImpl/position(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "truncate(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "sun/nio/ch/FileChannelImpl/truncate(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "force(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileChannelImpl/force(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "transferToDirectlyInternal(JILjava/nio/channels/WritableByteChannel;Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [Long, any, number, java_nio_channels_WritableByteChannel, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferToDirectlyInternal(JILjava/nio/channels/WritableByteChannel;Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [Long, any, number, java_nio_channels_WritableByteChannel, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferToDirectly(JILjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, number, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferToDirectly(JILjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, number, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferToTrustedChannel(JJLjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, Long, any, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferToTrustedChannel(JJLjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, Long, any, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferToArbitraryChannel(JILjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, number, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferToArbitraryChannel(JILjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, number, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferTo(JJLjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, Long, any, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferTo(JJLjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, Long, any, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferFromFileChannel(Lsun/nio/ch/FileChannelImpl;JJ)J"(thread: JVMThread, args: [sun_nio_ch_FileChannelImpl, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferFromFileChannel(Lsun/nio/ch/FileChannelImpl;JJ)J"(thread: JVMThread, args: [sun_nio_ch_FileChannelImpl, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferFromArbitraryChannel(Ljava/nio/channels/ReadableByteChannel;JJ)J"(thread: JVMThread, args: [java_nio_channels_ReadableByteChannel, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferFromArbitraryChannel(Ljava/nio/channels/ReadableByteChannel;JJ)J"(thread: JVMThread, args: [java_nio_channels_ReadableByteChannel, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferFrom(Ljava/nio/channels/ReadableByteChannel;JJ)J"(thread: JVMThread, args: [java_nio_channels_ReadableByteChannel, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferFrom(Ljava/nio/channels/ReadableByteChannel;JJ)J"(thread: JVMThread, args: [java_nio_channels_ReadableByteChannel, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "read(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileChannelImpl/read(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "readInternal(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileChannelImpl/readInternal(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "write(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileChannelImpl/write(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "writeInternal(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileChannelImpl/writeInternal(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "unmap(Ljava/nio/MappedByteBuffer;)V"(thread: JVMThread, args: [java_nio_MappedByteBuffer], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileChannelImpl/unmap(Ljava/nio/MappedByteBuffer;)V"(thread: JVMThread, args: [java_nio_MappedByteBuffer], cb?: (e?: java_lang_Throwable) => void): void;
    public "map(Ljava/nio/channels/FileChannel$MapMode;JJ)Ljava/nio/MappedByteBuffer;"(thread: JVMThread, args: [java_nio_channels_FileChannel$MapMode, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_MappedByteBuffer) => void): void;
    public "sun/nio/ch/FileChannelImpl/map(Ljava/nio/channels/FileChannel$MapMode;JJ)Ljava/nio/MappedByteBuffer;"(thread: JVMThread, args: [java_nio_channels_FileChannel$MapMode, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_MappedByteBuffer) => void): void;
    public static "getMappedBufferPool()Lsun/misc/JavaNioAccess$BufferPool;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_misc_JavaNioAccess$BufferPool) => void): void;
    public static "sun/nio/ch/FileChannelImpl/getMappedBufferPool()Lsun/misc/JavaNioAccess$BufferPool;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_misc_JavaNioAccess$BufferPool) => void): void;
    public static "isSharedFileLockTable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileChannelImpl/isSharedFileLockTable()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "fileLockTable()Lsun/nio/ch/FileLockTable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_FileLockTable) => void): void;
    public "sun/nio/ch/FileChannelImpl/fileLockTable()Lsun/nio/ch/FileLockTable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_FileLockTable) => void): void;
    public "lock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "sun/nio/ch/FileChannelImpl/lock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "tryLock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "sun/nio/ch/FileChannelImpl/tryLock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "release(Lsun/nio/ch/FileLockImpl;)V"(thread: JVMThread, args: [sun_nio_ch_FileLockImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileChannelImpl/release(Lsun/nio/ch/FileLockImpl;)V"(thread: JVMThread, args: [sun_nio_ch_FileLockImpl], cb?: (e?: java_lang_Throwable) => void): void;
    public "map0(IJJ)J"(thread: JVMThread, args: [number, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/map0(IJJ)J"(thread: JVMThread, args: [number, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "unmap0(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileChannelImpl/unmap0(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "transferTo0(Ljava/io/FileDescriptor;JJLjava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/transferTo0(Ljava/io/FileDescriptor;JJLjava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "position0(Ljava/io/FileDescriptor;J)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileChannelImpl/position0(Ljava/io/FileDescriptor;J)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "initIDs()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/FileChannelImpl/initIDs()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "truncate(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public "sun/nio/ch/FileChannelImpl/truncate(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public "position(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public "sun/nio/ch/FileChannelImpl/position(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public static "access$000(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileChannelImpl/access$000(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileChannelImpl/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_channels_SeekableByteChannel extends java_lang_Object, java_nio_channels_ByteChannel {
    "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "position()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "position(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    "size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "truncate(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_FileLockImpl extends java_nio_channels_FileLock {
    public "sun/nio/ch/FileLockImpl/valid": number;
    public static "sun/nio/ch/FileLockImpl/$assertionsDisabled": number;
    public "<init>(Ljava/nio/channels/FileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_FileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockImpl/<init>(Ljava/nio/channels/FileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_FileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/nio/channels/AsynchronousFileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_AsynchronousFileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockImpl/<init>(Ljava/nio/channels/AsynchronousFileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_AsynchronousFileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileLockImpl/isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "invalidate()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockImpl/invalidate()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "release()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockImpl/release()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileLockImpl/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_AsynchronousFileChannel extends java_lang_Object implements java_nio_channels_AsynchronousChannel {
    public static "java/nio/channels/AsynchronousFileChannel/NO_ATTRIBUTES": JVMArray<java_nio_file_attribute_FileAttribute>;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open(Ljava/nio/file/Path;Ljava/util/Set;Ljava/util/concurrent/ExecutorService;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/AsynchronousFileChannel;"(thread: JVMThread, args: [java_nio_file_Path, java_util_Set, java_util_concurrent_ExecutorService, JVMArray<java_nio_file_attribute_FileAttribute>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousFileChannel) => void): void;
    public static "java/nio/channels/AsynchronousFileChannel/open(Ljava/nio/file/Path;Ljava/util/Set;Ljava/util/concurrent/ExecutorService;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/AsynchronousFileChannel;"(thread: JVMThread, args: [java_nio_file_Path, java_util_Set, java_util_concurrent_ExecutorService, JVMArray<java_nio_file_attribute_FileAttribute>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousFileChannel) => void): void;
    public static "open(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/nio/channels/AsynchronousFileChannel;"(thread: JVMThread, args: [java_nio_file_Path, JVMArray<java_nio_file_OpenOption>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousFileChannel) => void): void;
    public static "java/nio/channels/AsynchronousFileChannel/open(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/nio/channels/AsynchronousFileChannel;"(thread: JVMThread, args: [java_nio_file_Path, JVMArray<java_nio_file_OpenOption>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousFileChannel) => void): void;
    public "size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "truncate(J)Ljava/nio/channels/AsynchronousFileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousFileChannel) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/truncate(J)Ljava/nio/channels/AsynchronousFileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousFileChannel) => void): void;
    public "force(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/force(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "lock(JJZLjava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [Long, any, Long, any, number, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/lock(JJZLjava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [Long, any, Long, any, number, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "lock(Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/lock(Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "lock(JJZ)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/lock(JJZ)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "lock()Ljava/util/concurrent/Future;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/lock()Ljava/util/concurrent/Future;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "tryLock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/tryLock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "tryLock()Ljava/nio/channels/FileLock;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/tryLock()Ljava/nio/channels/FileLock;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "read(Ljava/nio/ByteBuffer;JLjava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/read(Ljava/nio/ByteBuffer;JLjava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "read(Ljava/nio/ByteBuffer;J)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/read(Ljava/nio/ByteBuffer;J)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "write(Ljava/nio/ByteBuffer;JLjava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/write(Ljava/nio/ByteBuffer;JLjava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "write(Ljava/nio/ByteBuffer;J)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousFileChannel/write(Ljava/nio/ByteBuffer;J)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/AsynchronousFileChannel/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_concurrent_Future extends java_lang_Object {
    "cancel(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isCancelled()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isDone()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "get(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export class java_util_concurrent_TimeUnit extends java_lang_Enum {
    public static "java/util/concurrent/TimeUnit/NANOSECONDS": java_util_concurrent_TimeUnit;
    public static "java/util/concurrent/TimeUnit/MICROSECONDS": java_util_concurrent_TimeUnit;
    public static "java/util/concurrent/TimeUnit/MILLISECONDS": java_util_concurrent_TimeUnit;
    public static "java/util/concurrent/TimeUnit/SECONDS": java_util_concurrent_TimeUnit;
    public static "java/util/concurrent/TimeUnit/MINUTES": java_util_concurrent_TimeUnit;
    public static "java/util/concurrent/TimeUnit/HOURS": java_util_concurrent_TimeUnit;
    public static "java/util/concurrent/TimeUnit/DAYS": java_util_concurrent_TimeUnit;
    public static "java/util/concurrent/TimeUnit/C0": Long;
    public static "java/util/concurrent/TimeUnit/C1": Long;
    public static "java/util/concurrent/TimeUnit/C2": Long;
    public static "java/util/concurrent/TimeUnit/C3": Long;
    public static "java/util/concurrent/TimeUnit/C4": Long;
    public static "java/util/concurrent/TimeUnit/C5": Long;
    public static "java/util/concurrent/TimeUnit/C6": Long;
    public static "java/util/concurrent/TimeUnit/MAX": Long;
    public static "java/util/concurrent/TimeUnit/$VALUES": JVMArray<java_util_concurrent_TimeUnit>;
    public static "values()[Ljava/util/concurrent/TimeUnit;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_util_concurrent_TimeUnit>) => void): void;
    public static "java/util/concurrent/TimeUnit/values()[Ljava/util/concurrent/TimeUnit;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_util_concurrent_TimeUnit>) => void): void;
    public static "valueOf(Ljava/lang/String;)Ljava/util/concurrent/TimeUnit;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_TimeUnit) => void): void;
    public static "java/util/concurrent/TimeUnit/valueOf(Ljava/lang/String;)Ljava/util/concurrent/TimeUnit;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_TimeUnit) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/TimeUnit/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "x(JJJ)J"(thread: JVMThread, args: [Long, any, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/util/concurrent/TimeUnit/x(JJJ)J"(thread: JVMThread, args: [Long, any, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "convert(JLjava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/convert(JLjava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toNanos(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/toNanos(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toMicros(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/toMicros(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toMillis(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/toMillis(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toSeconds(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/toSeconds(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toMinutes(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/toMinutes(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toHours(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/toHours(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toDays(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit/toDays(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "excessNanos(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/TimeUnit/excessNanos(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "timedWait(Ljava/lang/Object;J)V"(thread: JVMThread, args: [java_lang_Object, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/TimeUnit/timedWait(Ljava/lang/Object;J)V"(thread: JVMThread, args: [java_lang_Object, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "timedJoin(Ljava/lang/Thread;J)V"(thread: JVMThread, args: [java_lang_Thread, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/TimeUnit/timedJoin(Ljava/lang/Thread;J)V"(thread: JVMThread, args: [java_lang_Thread, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "sleep(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/TimeUnit/sleep(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;ILjava/util/concurrent/TimeUnit$1;)V"(thread: JVMThread, args: [java_lang_String, number, java_util_concurrent_TimeUnit$1], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/TimeUnit/<init>(Ljava/lang/String;ILjava/util/concurrent/TimeUnit$1;)V"(thread: JVMThread, args: [java_lang_String, number, java_util_concurrent_TimeUnit$1], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/concurrent/TimeUnit/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_concurrent_TimeUnit$1 extends java_util_concurrent_TimeUnit {
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/TimeUnit$1/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "toNanos(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/toNanos(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toMicros(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/toMicros(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toMillis(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/toMillis(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toSeconds(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/toSeconds(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toMinutes(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/toMinutes(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toHours(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/toHours(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toDays(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/toDays(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "convert(JLjava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/TimeUnit$1/convert(JLjava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "excessNanos(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/TimeUnit$1/excessNanos(JJ)I"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_nio_channels_CompletionHandler extends java_lang_Object {
    "completed(Ljava/lang/Object;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "failed(Ljava/lang/Throwable;Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Throwable, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_file_OpenOption extends java_lang_Object {
  }
  export interface java_util_concurrent_ExecutorService extends java_lang_Object, java_util_concurrent_Executor {
    "shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "shutdownNow()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "isShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isTerminated()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "awaitTermination(JLjava/util/concurrent/TimeUnit;)Z"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "submit(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_util_concurrent_Callable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "submit(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "submit(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "invokeAll(Ljava/util/Collection;)Ljava/util/List;"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "invokeAll(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/util/List;"(thread: JVMThread, args: [java_util_Collection, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "invokeAny(Ljava/util/Collection;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "invokeAny(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_Collection, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_concurrent_Callable extends java_lang_Object {
    "call()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_List extends java_lang_Object, java_util_Collection {
    "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "containsAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "addAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "addAll(ILjava/util/Collection;)Z"(thread: JVMThread, args: [number, java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "retainAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "replaceAll(Ljava/util/function/UnaryOperator;)V"(thread: JVMThread, args: [java_util_function_UnaryOperator], cb?: (e?: java_lang_Throwable) => void): void;
    "sort(Ljava/util/Comparator;)V"(thread: JVMThread, args: [java_util_Comparator], cb?: (e?: java_lang_Throwable) => void): void;
    "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "get(I)Ljava/lang/Object;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "set(ILjava/lang/Object;)Ljava/lang/Object;"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "add(ILjava/lang/Object;)V"(thread: JVMThread, args: [number, java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "remove(I)Ljava/lang/Object;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "indexOf(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "lastIndexOf(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "listIterator()Ljava/util/ListIterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_ListIterator) => void): void;
    "listIterator(I)Ljava/util/ListIterator;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_util_ListIterator) => void): void;
    "subList(II)Ljava/util/List;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
  }
  export interface java_util_ListIterator extends java_lang_Object, java_util_Iterator {
    "hasNext()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "next()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "hasPrevious()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "previous()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "nextIndex()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "previousIndex()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "set(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "add(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "forEachRemaining(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "remove()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_concurrent_Executor extends java_lang_Object {
    "execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_file_Path extends java_lang_Object, java_lang_Comparable, java_lang_Iterable, java_nio_file_Watchable {
    "getFileSystem()Ljava/nio/file/FileSystem;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_FileSystem) => void): void;
    "isAbsolute()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getRoot()Ljava/nio/file/Path;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "getFileName()Ljava/nio/file/Path;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "getParent()Ljava/nio/file/Path;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "getNameCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getName(I)Ljava/nio/file/Path;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "subpath(II)Ljava/nio/file/Path;"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "startsWith(Ljava/nio/file/Path;)Z"(thread: JVMThread, args: [java_nio_file_Path], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "startsWith(Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "endsWith(Ljava/nio/file/Path;)Z"(thread: JVMThread, args: [java_nio_file_Path], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "endsWith(Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "normalize()Ljava/nio/file/Path;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "resolve(Ljava/nio/file/Path;)Ljava/nio/file/Path;"(thread: JVMThread, args: [java_nio_file_Path], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "resolve(Ljava/lang/String;)Ljava/nio/file/Path;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "resolveSibling(Ljava/nio/file/Path;)Ljava/nio/file/Path;"(thread: JVMThread, args: [java_nio_file_Path], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "resolveSibling(Ljava/lang/String;)Ljava/nio/file/Path;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "relativize(Ljava/nio/file/Path;)Ljava/nio/file/Path;"(thread: JVMThread, args: [java_nio_file_Path], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "toUri()Ljava/net/URI;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    "toAbsolutePath()Ljava/nio/file/Path;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "toRealPath([Ljava/nio/file/LinkOption;)Ljava/nio/file/Path;"(thread: JVMThread, args: [JVMArray<java_nio_file_LinkOption>], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    "toFile()Ljava/io/File;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_io_File) => void): void;
    "register(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;[Ljava/nio/file/WatchEvent$Modifier;)Ljava/nio/file/WatchKey;"(thread: JVMThread, args: [java_nio_file_WatchService, JVMArray<java_nio_file_WatchEvent$Kind>, JVMArray<java_nio_file_WatchEvent$Modifier>], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchKey) => void): void;
    "register(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;)Ljava/nio/file/WatchKey;"(thread: JVMThread, args: [java_nio_file_WatchService, JVMArray<java_nio_file_WatchEvent$Kind>], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchKey) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "compareTo(Ljava/nio/file/Path;)I"(thread: JVMThread, args: [java_nio_file_Path], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
  }
  export interface java_nio_file_WatchEvent$Modifier extends java_lang_Object {
    "name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
  }
  export interface java_nio_file_WatchEvent$Kind extends java_lang_Object {
    "name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "type()Ljava/lang/Class;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Class) => void): void;
  }
  export interface java_nio_file_WatchService extends java_lang_Object, java_io_Closeable {
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "poll()Ljava/nio/file/WatchKey;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchKey) => void): void;
    "poll(JLjava/util/concurrent/TimeUnit;)Ljava/nio/file/WatchKey;"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchKey) => void): void;
    "take()Ljava/nio/file/WatchKey;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchKey) => void): void;
  }
  export interface java_nio_file_WatchKey extends java_lang_Object {
    "isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "pollEvents()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "reset()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "cancel()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "watchable()Ljava/nio/file/Watchable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Watchable) => void): void;
  }
  export class java_nio_file_LinkOption extends java_lang_Enum implements java_nio_file_OpenOption, java_nio_file_CopyOption {
    public static "java/nio/file/LinkOption/NOFOLLOW_LINKS": java_nio_file_LinkOption;
    public static "java/nio/file/LinkOption/$VALUES": JVMArray<java_nio_file_LinkOption>;
    public static "values()[Ljava/nio/file/LinkOption;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_nio_file_LinkOption>) => void): void;
    public static "java/nio/file/LinkOption/values()[Ljava/nio/file/LinkOption;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_nio_file_LinkOption>) => void): void;
    public static "valueOf(Ljava/lang/String;)Ljava/nio/file/LinkOption;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_LinkOption) => void): void;
    public static "java/nio/file/LinkOption/valueOf(Ljava/lang/String;)Ljava/nio/file/LinkOption;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_LinkOption) => void): void;
    public "<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/file/LinkOption/<init>(Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/file/LinkOption/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_file_CopyOption extends java_lang_Object {
  }
  export class java_net_URI extends java_lang_Object implements java_lang_Comparable, java_io_Serializable {
    public static "java/net/URI/serialVersionUID": Long;
    public "java/net/URI/scheme": java_lang_String;
    public "java/net/URI/fragment": java_lang_String;
    public "java/net/URI/authority": java_lang_String;
    public "java/net/URI/userInfo": java_lang_String;
    public "java/net/URI/host": java_lang_String;
    public "java/net/URI/port": number;
    public "java/net/URI/path": java_lang_String;
    public "java/net/URI/query": java_lang_String;
    public "java/net/URI/schemeSpecificPart": java_lang_String;
    public "java/net/URI/hash": number;
    public "java/net/URI/decodedUserInfo": java_lang_String;
    public "java/net/URI/decodedAuthority": java_lang_String;
    public "java/net/URI/decodedPath": java_lang_String;
    public "java/net/URI/decodedQuery": java_lang_String;
    public "java/net/URI/decodedFragment": java_lang_String;
    public "java/net/URI/decodedSchemeSpecificPart": java_lang_String;
    public "java/net/URI/string": java_lang_String;
    public static "java/net/URI/L_DIGIT": Long;
    public static "java/net/URI/H_DIGIT": Long;
    public static "java/net/URI/L_UPALPHA": Long;
    public static "java/net/URI/H_UPALPHA": Long;
    public static "java/net/URI/L_LOWALPHA": Long;
    public static "java/net/URI/H_LOWALPHA": Long;
    public static "java/net/URI/L_ALPHA": Long;
    public static "java/net/URI/H_ALPHA": Long;
    public static "java/net/URI/L_ALPHANUM": Long;
    public static "java/net/URI/H_ALPHANUM": Long;
    public static "java/net/URI/L_HEX": Long;
    public static "java/net/URI/H_HEX": Long;
    public static "java/net/URI/L_MARK": Long;
    public static "java/net/URI/H_MARK": Long;
    public static "java/net/URI/L_UNRESERVED": Long;
    public static "java/net/URI/H_UNRESERVED": Long;
    public static "java/net/URI/L_RESERVED": Long;
    public static "java/net/URI/H_RESERVED": Long;
    public static "java/net/URI/L_ESCAPED": Long;
    public static "java/net/URI/H_ESCAPED": Long;
    public static "java/net/URI/L_URIC": Long;
    public static "java/net/URI/H_URIC": Long;
    public static "java/net/URI/L_PCHAR": Long;
    public static "java/net/URI/H_PCHAR": Long;
    public static "java/net/URI/L_PATH": Long;
    public static "java/net/URI/H_PATH": Long;
    public static "java/net/URI/L_DASH": Long;
    public static "java/net/URI/H_DASH": Long;
    public static "java/net/URI/L_DOT": Long;
    public static "java/net/URI/H_DOT": Long;
    public static "java/net/URI/L_USERINFO": Long;
    public static "java/net/URI/H_USERINFO": Long;
    public static "java/net/URI/L_REG_NAME": Long;
    public static "java/net/URI/H_REG_NAME": Long;
    public static "java/net/URI/L_SERVER": Long;
    public static "java/net/URI/H_SERVER": Long;
    public static "java/net/URI/L_SERVER_PERCENT": Long;
    public static "java/net/URI/H_SERVER_PERCENT": Long;
    public static "java/net/URI/L_LEFT_BRACKET": Long;
    public static "java/net/URI/H_LEFT_BRACKET": Long;
    public static "java/net/URI/L_SCHEME": Long;
    public static "java/net/URI/H_SCHEME": Long;
    public static "java/net/URI/L_URIC_NO_SLASH": Long;
    public static "java/net/URI/H_URIC_NO_SLASH": Long;
    public static "java/net/URI/hexDigits": JVMArray<number>;
    public static "java/net/URI/$assertionsDisabled": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public static "create(Ljava/lang/String;)Ljava/net/URI;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public static "java/net/URI/create(Ljava/lang/String;)Ljava/net/URI;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "parseServerAuthority()Ljava/net/URI;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "java/net/URI/parseServerAuthority()Ljava/net/URI;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "normalize()Ljava/net/URI;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "java/net/URI/normalize()Ljava/net/URI;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "resolve(Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "java/net/URI/resolve(Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "resolve(Ljava/lang/String;)Ljava/net/URI;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "java/net/URI/resolve(Ljava/lang/String;)Ljava/net/URI;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "relativize(Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "java/net/URI/relativize(Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public "toURL()Ljava/net/URL;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_URL) => void): void;
    public "java/net/URI/toURL()Ljava/net/URL;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_URL) => void): void;
    public "getScheme()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getScheme()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "isAbsolute()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/URI/isAbsolute()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isOpaque()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/URI/isOpaque()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getRawSchemeSpecificPart()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getRawSchemeSpecificPart()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getSchemeSpecificPart()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getSchemeSpecificPart()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getRawAuthority()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getRawAuthority()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getAuthority()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getAuthority()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getRawUserInfo()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getRawUserInfo()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getUserInfo()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getUserInfo()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getHost()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getHost()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/URI/getPort()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getRawPath()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getRawPath()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getPath()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getPath()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getRawQuery()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getRawQuery()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getQuery()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getQuery()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getRawFragment()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getRawFragment()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getFragment()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/getFragment()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/URI/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/URI/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareTo(Ljava/net/URI;)I"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/URI/compareTo(Ljava/net/URI;)I"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "toASCIIString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/toASCIIString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public static "toLower(C)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/toLower(C)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "toUpper(C)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/toUpper(C)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "equal(Ljava/lang/String;Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/equal(Ljava/lang/String;Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "equalIgnoringCase(Ljava/lang/String;Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/equalIgnoringCase(Ljava/lang/String;Ljava/lang/String;)Z"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "hash(ILjava/lang/String;)I"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/hash(ILjava/lang/String;)I"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "normalizedHash(ILjava/lang/String;)I"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/normalizedHash(ILjava/lang/String;)I"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "hashIgnoringCase(ILjava/lang/String;)I"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/hashIgnoringCase(ILjava/lang/String;)I"(thread: JVMThread, args: [number, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "compare(Ljava/lang/String;Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/compare(Ljava/lang/String;Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "compareIgnoringCase(Ljava/lang/String;Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/compareIgnoringCase(Ljava/lang/String;Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "checkPath(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/URI/checkPath(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "appendAuthority(Ljava/lang/StringBuffer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_StringBuffer, java_lang_String, java_lang_String, java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/appendAuthority(Ljava/lang/StringBuffer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V"(thread: JVMThread, args: [java_lang_StringBuffer, java_lang_String, java_lang_String, java_lang_String, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "appendSchemeSpecificPart(Ljava/lang/StringBuffer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_StringBuffer, java_lang_String, java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/appendSchemeSpecificPart(Ljava/lang/StringBuffer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_StringBuffer, java_lang_String, java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "appendFragment(Ljava/lang/StringBuffer;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_StringBuffer, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/appendFragment(Ljava/lang/StringBuffer;Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_StringBuffer, java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "toString(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/net/URI/toString(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String, java_lang_String, java_lang_String, java_lang_String, java_lang_String, number, java_lang_String, java_lang_String, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "defineSchemeSpecificPart()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/defineSchemeSpecificPart()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "defineString()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/net/URI/defineString()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "resolvePath(Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String, java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/resolvePath(Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String, java_lang_String, number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "resolve(Ljava/net/URI;Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI, java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public static "java/net/URI/resolve(Ljava/net/URI;Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI, java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public static "normalize(Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public static "java/net/URI/normalize(Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public static "relativize(Ljava/net/URI;Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI, java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public static "java/net/URI/relativize(Ljava/net/URI;Ljava/net/URI;)Ljava/net/URI;"(thread: JVMThread, args: [java_net_URI, java_net_URI], cb?: (e?: java_lang_Throwable, rv?: java_net_URI) => void): void;
    public static "needsNormalization(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/needsNormalization(Ljava/lang/String;)I"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "split([C[I)V"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/URI/split([C[I)V"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "join([C[I)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/join([C[I)I"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "removeDots([C[I)V"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/URI/removeDots([C[I)V"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "maybeAddLeadingDot([C[I)V"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/URI/maybeAddLeadingDot([C[I)V"(thread: JVMThread, args: [JVMArray<number>, JVMArray<number>], cb?: (e?: java_lang_Throwable) => void): void;
    public static "normalize(Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/normalize(Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "lowMask(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/lowMask(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "highMask(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/highMask(Ljava/lang/String;)J"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "lowMask(CC)J"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/lowMask(CC)J"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "highMask(CC)J"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/highMask(CC)J"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "match(CJJ)Z"(thread: JVMThread, args: [number, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/match(CJJ)Z"(thread: JVMThread, args: [number, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "appendEscape(Ljava/lang/StringBuffer;B)V"(thread: JVMThread, args: [java_lang_StringBuffer, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/URI/appendEscape(Ljava/lang/StringBuffer;B)V"(thread: JVMThread, args: [java_lang_StringBuffer, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "appendEncoded(Ljava/lang/StringBuffer;C)V"(thread: JVMThread, args: [java_lang_StringBuffer, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/URI/appendEncoded(Ljava/lang/StringBuffer;C)V"(thread: JVMThread, args: [java_lang_StringBuffer, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "quote(Ljava/lang/String;JJ)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/quote(Ljava/lang/String;JJ)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "encode(Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/encode(Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "decode(C)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/decode(C)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "decode(CC)B"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/decode(CC)B"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "decode(Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/decode(Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/net/URI/compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$002(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$002(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$100()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$100()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$200()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$200()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$300(CJJ)Z"(thread: JVMThread, args: [number, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/access$300(CJJ)Z"(thread: JVMThread, args: [number, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$400()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$400()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$500()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$500()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$600()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$600()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$702(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$702(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$800()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$800()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$900()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$900()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$1002(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$1002(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$1102(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$1102(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$1200()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$1200()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$1300()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$1300()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$1402(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$1402(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$1502(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$1502(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$1600()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$1600()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$1700()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$1700()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$1800()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$1800()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$1900()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$1900()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$2000()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$2000()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$2100()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$2100()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$2202(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$2202(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$2302(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$2302(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$2402(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "java/net/URI/access$2402(Ljava/net/URI;Ljava/lang/String;)Ljava/lang/String;"(thread: JVMThread, args: [java_net_URI, java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "access$2502(Ljava/net/URI;I)I"(thread: JVMThread, args: [java_net_URI, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/net/URI/access$2502(Ljava/net/URI;I)I"(thread: JVMThread, args: [java_net_URI, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$2600()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$2600()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$2700()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$2700()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$2800()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$2800()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$2900()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$2900()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$3000()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$3000()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$3100()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$3100()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$3200()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$3200()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$3300()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$3300()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "access$3400()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "java/net/URI/access$3400()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/net/URI/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_file_FileSystem extends java_lang_Object implements java_io_Closeable {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/file/FileSystem/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "provider()Ljava/nio/file/spi/FileSystemProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_spi_FileSystemProvider) => void): void;
    public "java/nio/file/FileSystem/provider()Ljava/nio/file/spi/FileSystemProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_spi_FileSystemProvider) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/file/FileSystem/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/file/FileSystem/isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isReadOnly()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/file/FileSystem/isReadOnly()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getSeparator()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/nio/file/FileSystem/getSeparator()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "getRootDirectories()Ljava/lang/Iterable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Iterable) => void): void;
    public "java/nio/file/FileSystem/getRootDirectories()Ljava/lang/Iterable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Iterable) => void): void;
    public "getFileStores()Ljava/lang/Iterable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Iterable) => void): void;
    public "java/nio/file/FileSystem/getFileStores()Ljava/lang/Iterable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Iterable) => void): void;
    public "supportedFileAttributeViews()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "java/nio/file/FileSystem/supportedFileAttributeViews()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getPath(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;"(thread: JVMThread, args: [java_lang_String, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    public "java/nio/file/FileSystem/getPath(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;"(thread: JVMThread, args: [java_lang_String, JVMArray<java_lang_String>], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_Path) => void): void;
    public "getPathMatcher(Ljava/lang/String;)Ljava/nio/file/PathMatcher;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_PathMatcher) => void): void;
    public "java/nio/file/FileSystem/getPathMatcher(Ljava/lang/String;)Ljava/nio/file/PathMatcher;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_PathMatcher) => void): void;
    public "getUserPrincipalLookupService()Ljava/nio/file/attribute/UserPrincipalLookupService;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_attribute_UserPrincipalLookupService) => void): void;
    public "java/nio/file/FileSystem/getUserPrincipalLookupService()Ljava/nio/file/attribute/UserPrincipalLookupService;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_attribute_UserPrincipalLookupService) => void): void;
    public "newWatchService()Ljava/nio/file/WatchService;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchService) => void): void;
    public "java/nio/file/FileSystem/newWatchService()Ljava/nio/file/WatchService;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchService) => void): void;
  }
  export class java_nio_file_attribute_UserPrincipalLookupService extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/file/attribute/UserPrincipalLookupService/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "lookupPrincipalByName(Ljava/lang/String;)Ljava/nio/file/attribute/UserPrincipal;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_attribute_UserPrincipal) => void): void;
    public "java/nio/file/attribute/UserPrincipalLookupService/lookupPrincipalByName(Ljava/lang/String;)Ljava/nio/file/attribute/UserPrincipal;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_attribute_UserPrincipal) => void): void;
    public "lookupPrincipalByGroupName(Ljava/lang/String;)Ljava/nio/file/attribute/GroupPrincipal;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_attribute_GroupPrincipal) => void): void;
    public "java/nio/file/attribute/UserPrincipalLookupService/lookupPrincipalByGroupName(Ljava/lang/String;)Ljava/nio/file/attribute/GroupPrincipal;"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_attribute_GroupPrincipal) => void): void;
  }
  export interface java_nio_file_attribute_GroupPrincipal extends java_lang_Object, java_nio_file_attribute_UserPrincipal {
    "getName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "implies(Ljavax/security/auth/Subject;)Z"(thread: JVMThread, args: [javax_security_auth_Subject], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class javax_security_auth_Subject extends java_lang_Object implements java_io_Serializable {
    public static "javax/security/auth/Subject/serialVersionUID": Long;
    public "javax/security/auth/Subject/principals": java_util_Set;
    public "javax/security/auth/Subject/pubCredentials": java_util_Set;
    public "javax/security/auth/Subject/privCredentials": java_util_Set;
    public "javax/security/auth/Subject/readOnly": number;
    public static "javax/security/auth/Subject/PRINCIPAL_SET": number;
    public static "javax/security/auth/Subject/PUB_CREDENTIAL_SET": number;
    public static "javax/security/auth/Subject/PRIV_CREDENTIAL_SET": number;
    public static "javax/security/auth/Subject/NULL_PD_ARRAY": JVMArray<java_security_ProtectionDomain>;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "javax/security/auth/Subject/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(ZLjava/util/Set;Ljava/util/Set;Ljava/util/Set;)V"(thread: JVMThread, args: [number, java_util_Set, java_util_Set, java_util_Set], cb?: (e?: java_lang_Throwable) => void): void;
    public "javax/security/auth/Subject/<init>(ZLjava/util/Set;Ljava/util/Set;Ljava/util/Set;)V"(thread: JVMThread, args: [number, java_util_Set, java_util_Set, java_util_Set], cb?: (e?: java_lang_Throwable) => void): void;
    public "setReadOnly()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "javax/security/auth/Subject/setReadOnly()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isReadOnly()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "javax/security/auth/Subject/isReadOnly()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "getSubject(Ljava/security/AccessControlContext;)Ljavax/security/auth/Subject;"(thread: JVMThread, args: [java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: javax_security_auth_Subject) => void): void;
    public static "javax/security/auth/Subject/getSubject(Ljava/security/AccessControlContext;)Ljavax/security/auth/Subject;"(thread: JVMThread, args: [java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: javax_security_auth_Subject) => void): void;
    public static "doAs(Ljavax/security/auth/Subject;Ljava/security/PrivilegedAction;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedAction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "javax/security/auth/Subject/doAs(Ljavax/security/auth/Subject;Ljava/security/PrivilegedAction;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedAction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "doAs(Ljavax/security/auth/Subject;Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedExceptionAction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "javax/security/auth/Subject/doAs(Ljavax/security/auth/Subject;Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedExceptionAction], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "doAsPrivileged(Ljavax/security/auth/Subject;Ljava/security/PrivilegedAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedAction, java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "javax/security/auth/Subject/doAsPrivileged(Ljavax/security/auth/Subject;Ljava/security/PrivilegedAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedAction, java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "doAsPrivileged(Ljavax/security/auth/Subject;Ljava/security/PrivilegedExceptionAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedExceptionAction, java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "javax/security/auth/Subject/doAsPrivileged(Ljavax/security/auth/Subject;Ljava/security/PrivilegedExceptionAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_PrivilegedExceptionAction, java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "createContext(Ljavax/security/auth/Subject;Ljava/security/AccessControlContext;)Ljava/security/AccessControlContext;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: java_security_AccessControlContext) => void): void;
    public static "javax/security/auth/Subject/createContext(Ljavax/security/auth/Subject;Ljava/security/AccessControlContext;)Ljava/security/AccessControlContext;"(thread: JVMThread, args: [javax_security_auth_Subject, java_security_AccessControlContext], cb?: (e?: java_lang_Throwable, rv?: java_security_AccessControlContext) => void): void;
    public "getPrincipals()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "javax/security/auth/Subject/getPrincipals()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getPrincipals(Ljava/lang/Class;)Ljava/util/Set;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "javax/security/auth/Subject/getPrincipals(Ljava/lang/Class;)Ljava/util/Set;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getPublicCredentials()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "javax/security/auth/Subject/getPublicCredentials()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getPrivateCredentials()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "javax/security/auth/Subject/getPrivateCredentials()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getPublicCredentials(Ljava/lang/Class;)Ljava/util/Set;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "javax/security/auth/Subject/getPublicCredentials(Ljava/lang/Class;)Ljava/util/Set;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "getPrivateCredentials(Ljava/lang/Class;)Ljava/util/Set;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "javax/security/auth/Subject/getPrivateCredentials(Ljava/lang/Class;)Ljava/util/Set;"(thread: JVMThread, args: [java_lang_Class], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
    public "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "javax/security/auth/Subject/equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "javax/security/auth/Subject/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "toString(Z)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "javax/security/auth/Subject/toString(Z)Ljava/lang/String;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "javax/security/auth/Subject/hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getCredHashCode(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "javax/security/auth/Subject/getCredHashCode(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "javax/security/auth/Subject/writeObject(Ljava/io/ObjectOutputStream;)V"(thread: JVMThread, args: [java_io_ObjectOutputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public "javax/security/auth/Subject/readObject(Ljava/io/ObjectInputStream;)V"(thread: JVMThread, args: [java_io_ObjectInputStream], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "javax/security/auth/Subject/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_nio_file_attribute_UserPrincipal extends java_lang_Object, java_security_Principal {
    "getName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "implies(Ljavax/security/auth/Subject;)Z"(thread: JVMThread, args: [javax_security_auth_Subject], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_security_Principal extends java_lang_Object {
    "equals(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "hashCode()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "implies(Ljavax/security/auth/Subject;)Z"(thread: JVMThread, args: [javax_security_auth_Subject], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_nio_file_PathMatcher extends java_lang_Object {
    "matches(Ljava/nio/file/Path;)Z"(thread: JVMThread, args: [java_nio_file_Path], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_nio_file_Watchable extends java_lang_Object {
    "register(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;[Ljava/nio/file/WatchEvent$Modifier;)Ljava/nio/file/WatchKey;"(thread: JVMThread, args: [java_nio_file_WatchService, JVMArray<java_nio_file_WatchEvent$Kind>, JVMArray<java_nio_file_WatchEvent$Modifier>], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchKey) => void): void;
    "register(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;)Ljava/nio/file/WatchKey;"(thread: JVMThread, args: [java_nio_file_WatchService, JVMArray<java_nio_file_WatchEvent$Kind>], cb?: (e?: java_lang_Throwable, rv?: java_nio_file_WatchKey) => void): void;
  }
  export interface java_nio_file_attribute_FileAttribute extends java_lang_Object {
    "name()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "value()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_nio_channels_AsynchronousChannel extends java_lang_Object, java_nio_channels_Channel {
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_nio_channels_FileLock extends java_lang_Object implements java_lang_AutoCloseable {
    public "java/nio/channels/FileLock/channel": java_nio_channels_Channel;
    public "java/nio/channels/FileLock/position": Long;
    public "java/nio/channels/FileLock/size": Long;
    public "java/nio/channels/FileLock/shared": number;
    public "<init>(Ljava/nio/channels/FileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_FileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/FileLock/<init>(Ljava/nio/channels/FileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_FileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Ljava/nio/channels/AsynchronousFileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_AsynchronousFileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/FileLock/<init>(Ljava/nio/channels/AsynchronousFileChannel;JJZ)V"(thread: JVMThread, args: [java_nio_channels_AsynchronousFileChannel, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "channel()Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "java/nio/channels/FileLock/channel()Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "acquiredBy()Ljava/nio/channels/Channel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Channel) => void): void;
    public "java/nio/channels/FileLock/acquiredBy()Ljava/nio/channels/Channel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_Channel) => void): void;
    public "position()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileLock/position()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileLock/size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "isShared()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/FileLock/isShared()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "overlaps(JJ)Z"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/FileLock/overlaps(JJ)Z"(thread: JVMThread, args: [Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/FileLock/isValid()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "release()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/FileLock/release()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/FileLock/close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/nio/channels/FileLock/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
  }
  export interface sun_misc_JavaNioAccess$BufferPool extends java_lang_Object {
    "getName()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    "getCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "getTotalCapacity()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "getMemoryUsed()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
  }
  export class java_nio_channels_FileChannel$MapMode extends java_lang_Object {
    public static "java/nio/channels/FileChannel$MapMode/READ_ONLY": java_nio_channels_FileChannel$MapMode;
    public static "java/nio/channels/FileChannel$MapMode/READ_WRITE": java_nio_channels_FileChannel$MapMode;
    public static "java/nio/channels/FileChannel$MapMode/PRIVATE": java_nio_channels_FileChannel$MapMode;
    public "java/nio/channels/FileChannel$MapMode/name": java_lang_String;
    public "<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/FileChannel$MapMode/<init>(Ljava/lang/String;)V"(thread: JVMThread, args: [java_lang_String], cb?: (e?: java_lang_Throwable) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/nio/channels/FileChannel$MapMode/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/FileChannel$MapMode/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_FileLockTable extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockTable/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "newSharedFileLockTable(Ljava/nio/channels/Channel;Ljava/io/FileDescriptor;)Lsun/nio/ch/FileLockTable;"(thread: JVMThread, args: [java_nio_channels_Channel, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_FileLockTable) => void): void;
    public static "sun/nio/ch/FileLockTable/newSharedFileLockTable(Ljava/nio/channels/Channel;Ljava/io/FileDescriptor;)Lsun/nio/ch/FileLockTable;"(thread: JVMThread, args: [java_nio_channels_Channel, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_FileLockTable) => void): void;
    public "add(Ljava/nio/channels/FileLock;)V"(thread: JVMThread, args: [java_nio_channels_FileLock], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockTable/add(Ljava/nio/channels/FileLock;)V"(thread: JVMThread, args: [java_nio_channels_FileLock], cb?: (e?: java_lang_Throwable) => void): void;
    public "remove(Ljava/nio/channels/FileLock;)V"(thread: JVMThread, args: [java_nio_channels_FileLock], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockTable/remove(Ljava/nio/channels/FileLock;)V"(thread: JVMThread, args: [java_nio_channels_FileLock], cb?: (e?: java_lang_Throwable) => void): void;
    public "removeAll()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "sun/nio/ch/FileLockTable/removeAll()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "replace(Ljava/nio/channels/FileLock;Ljava/nio/channels/FileLock;)V"(thread: JVMThread, args: [java_nio_channels_FileLock, java_nio_channels_FileLock], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileLockTable/replace(Ljava/nio/channels/FileLock;Ljava/nio/channels/FileLock;)V"(thread: JVMThread, args: [java_nio_channels_FileLock, java_nio_channels_FileLock], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_NativeThreadSet extends java_lang_Object {
    public "sun/nio/ch/NativeThreadSet/elts": JVMArray<Long>;
    public "sun/nio/ch/NativeThreadSet/used": number;
    public "sun/nio/ch/NativeThreadSet/waitingToEmpty": number;
    public static "sun/nio/ch/NativeThreadSet/$assertionsDisabled": number;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/NativeThreadSet/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "add()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/NativeThreadSet/add()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "remove(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/NativeThreadSet/remove(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "signalAndWait()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/NativeThreadSet/signalAndWait()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/NativeThreadSet/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_FileDispatcher extends sun_nio_ch_NativeDispatcher {
    public static "sun/nio/ch/FileDispatcher/NO_LOCK": number;
    public static "sun/nio/ch/FileDispatcher/LOCKED": number;
    public static "sun/nio/ch/FileDispatcher/RET_EX_LOCK": number;
    public static "sun/nio/ch/FileDispatcher/INTERRUPTED": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileDispatcher/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "force(Ljava/io/FileDescriptor;Z)I"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcher/force(Ljava/io/FileDescriptor;Z)I"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "truncate(Ljava/io/FileDescriptor;J)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcher/truncate(Ljava/io/FileDescriptor;J)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "size(Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileDispatcher/size(Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "lock(Ljava/io/FileDescriptor;ZJJZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcher/lock(Ljava/io/FileDescriptor;ZJJZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "release(Ljava/io/FileDescriptor;JJ)V"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileDispatcher/release(Ljava/io/FileDescriptor;JJ)V"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "duplicateForMapping(Ljava/io/FileDescriptor;)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "sun/nio/ch/FileDispatcher/duplicateForMapping(Ljava/io/FileDescriptor;)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "canTransferToDirectly(Ljava/nio/channels/SelectableChannel;)Z"(thread: JVMThread, args: [java_nio_channels_SelectableChannel], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcher/canTransferToDirectly(Ljava/nio/channels/SelectableChannel;)Z"(thread: JVMThread, args: [java_nio_channels_SelectableChannel], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "transferToDirectlyNeedsPositionLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcher/transferToDirectlyNeedsPositionLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class sun_nio_ch_NativeDispatcher extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/NativeDispatcher/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "read(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/NativeDispatcher/read(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "needsPositionLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/NativeDispatcher/needsPositionLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "pread(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/NativeDispatcher/pread(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "readv(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/NativeDispatcher/readv(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/NativeDispatcher/write(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "pwrite(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/NativeDispatcher/pwrite(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "writev(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/NativeDispatcher/writev(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "close(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/NativeDispatcher/close(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "preClose(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/NativeDispatcher/preClose(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_FileChannel extends java_nio_channels_spi_AbstractInterruptibleChannel implements java_nio_channels_SeekableByteChannel, java_nio_channels_GatheringByteChannel, java_nio_channels_ScatteringByteChannel {
    public static "java/nio/channels/FileChannel/NO_ATTRIBUTES": JVMArray<java_nio_file_attribute_FileAttribute>;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/FileChannel/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "open(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_nio_file_Path, java_util_Set, JVMArray<java_nio_file_attribute_FileAttribute>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public static "java/nio/channels/FileChannel/open(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_nio_file_Path, java_util_Set, JVMArray<java_nio_file_attribute_FileAttribute>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public static "open(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_nio_file_Path, JVMArray<java_nio_file_OpenOption>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public static "java/nio/channels/FileChannel/open(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [java_nio_file_Path, JVMArray<java_nio_file_OpenOption>], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/FileChannel/read(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/read([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/read([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/FileChannel/write(Ljava/nio/ByteBuffer;)I"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/write([Ljava/nio/ByteBuffer;II)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/write([Ljava/nio/ByteBuffer;)J"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "position()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/position()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "position(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "java/nio/channels/FileChannel/position(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/size()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "truncate(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "java/nio/channels/FileChannel/truncate(J)Ljava/nio/channels/FileChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileChannel) => void): void;
    public "force(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/FileChannel/force(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "transferTo(JJLjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, Long, any, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/transferTo(JJLjava/nio/channels/WritableByteChannel;)J"(thread: JVMThread, args: [Long, any, Long, any, java_nio_channels_WritableByteChannel], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "transferFrom(Ljava/nio/channels/ReadableByteChannel;JJ)J"(thread: JVMThread, args: [java_nio_channels_ReadableByteChannel, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/nio/channels/FileChannel/transferFrom(Ljava/nio/channels/ReadableByteChannel;JJ)J"(thread: JVMThread, args: [java_nio_channels_ReadableByteChannel, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "read(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/FileChannel/read(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "write(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/nio/channels/FileChannel/write(Ljava/nio/ByteBuffer;J)I"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "map(Ljava/nio/channels/FileChannel$MapMode;JJ)Ljava/nio/MappedByteBuffer;"(thread: JVMThread, args: [java_nio_channels_FileChannel$MapMode, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_MappedByteBuffer) => void): void;
    public "java/nio/channels/FileChannel/map(Ljava/nio/channels/FileChannel$MapMode;JJ)Ljava/nio/MappedByteBuffer;"(thread: JVMThread, args: [java_nio_channels_FileChannel$MapMode, Long, any, Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_MappedByteBuffer) => void): void;
    public "lock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "java/nio/channels/FileChannel/lock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "lock()Ljava/nio/channels/FileLock;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "java/nio/channels/FileChannel/lock()Ljava/nio/channels/FileLock;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "tryLock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "java/nio/channels/FileChannel/tryLock(JJZ)Ljava/nio/channels/FileLock;"(thread: JVMThread, args: [Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "tryLock()Ljava/nio/channels/FileLock;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "java/nio/channels/FileChannel/tryLock()Ljava/nio/channels/FileLock;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_FileLock) => void): void;
    public "truncate(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public "java/nio/channels/FileChannel/truncate(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public "position(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public "java/nio/channels/FileChannel/position(J)Ljava/nio/channels/SeekableByteChannel;"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_SeekableByteChannel) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/nio/channels/FileChannel/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_IOUtil extends java_lang_Object {
    public static "sun/nio/ch/IOUtil/IOV_MAX": number;
    public static "sun/nio/ch/IOUtil/$assertionsDisabled": number;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/IOUtil/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "write(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/write(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "writeFromNativeBuffer(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/writeFromNativeBuffer(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "write(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;Lsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/IOUtil/write(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;Lsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "write(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;IILsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, number, number, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/IOUtil/write(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;IILsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, number, number, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "read(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/read(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "readIntoNativeBuffer(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/readIntoNativeBuffer(Ljava/io/FileDescriptor;Ljava/nio/ByteBuffer;JLsun/nio/ch/NativeDispatcher;)I"(thread: JVMThread, args: [java_io_FileDescriptor, java_nio_ByteBuffer, Long, any, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "read(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;Lsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/IOUtil/read(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;Lsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "read(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;IILsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, number, number, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/IOUtil/read(Ljava/io/FileDescriptor;[Ljava/nio/ByteBuffer;IILsun/nio/ch/NativeDispatcher;)J"(thread: JVMThread, args: [java_io_FileDescriptor, JVMArray<java_nio_ByteBuffer>, number, number, sun_nio_ch_NativeDispatcher], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "newFD(I)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public static "sun/nio/ch/IOUtil/newFD(I)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public static "randomBytes([B)Z"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/randomBytes([B)Z"(thread: JVMThread, args: [JVMArray<number>], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "makePipe(Z)J"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/IOUtil/makePipe(Z)J"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "drain(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/drain(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "configureBlocking(Ljava/io/FileDescriptor;Z)V"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/IOUtil/configureBlocking(Ljava/io/FileDescriptor;Z)V"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "fdVal(Ljava/io/FileDescriptor;)I"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/fdVal(Ljava/io/FileDescriptor;)I"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "setfdVal(Ljava/io/FileDescriptor;I)V"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/IOUtil/setfdVal(Ljava/io/FileDescriptor;I)V"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "fdLimit()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/fdLimit()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "iovMax()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/IOUtil/iovMax()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "initIDs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/IOUtil/initIDs()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "load()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/IOUtil/load()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/IOUtil/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_FileDispatcherImpl extends sun_nio_ch_FileDispatcher {
    public "<init>(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/<init>(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "read(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/read(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "pread(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/pread(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "readv(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/readv(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "write(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/write(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "pwrite(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/pwrite(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "writev(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/writev(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "force(Ljava/io/FileDescriptor;Z)I"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/force(Ljava/io/FileDescriptor;Z)I"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "truncate(Ljava/io/FileDescriptor;J)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/truncate(Ljava/io/FileDescriptor;J)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "size(Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/size(Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "lock(Ljava/io/FileDescriptor;ZJJZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/lock(Ljava/io/FileDescriptor;ZJJZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "release(Ljava/io/FileDescriptor;JJ)V"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/release(Ljava/io/FileDescriptor;JJ)V"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public "close(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/close(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "preClose(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/preClose(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public "duplicateForMapping(Ljava/io/FileDescriptor;)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/duplicateForMapping(Ljava/io/FileDescriptor;)Ljava/io/FileDescriptor;"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: java_io_FileDescriptor) => void): void;
    public "canTransferToDirectly(Ljava/nio/channels/SelectableChannel;)Z"(thread: JVMThread, args: [java_nio_channels_SelectableChannel], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/canTransferToDirectly(Ljava/nio/channels/SelectableChannel;)Z"(thread: JVMThread, args: [java_nio_channels_SelectableChannel], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "transferToDirectlyNeedsPositionLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/FileDispatcherImpl/transferToDirectlyNeedsPositionLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "read0(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/read0(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "pread0(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/pread0(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "readv0(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/readv0(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "write0(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/write0(Ljava/io/FileDescriptor;JI)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "pwrite0(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/pwrite0(Ljava/io/FileDescriptor;JIJ)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "writev0(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/writev0(Ljava/io/FileDescriptor;JI)J"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "force0(Ljava/io/FileDescriptor;Z)I"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/force0(Ljava/io/FileDescriptor;Z)I"(thread: JVMThread, args: [java_io_FileDescriptor, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "truncate0(Ljava/io/FileDescriptor;J)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/truncate0(Ljava/io/FileDescriptor;J)I"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "size0(Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/size0(Ljava/io/FileDescriptor;)J"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "lock0(Ljava/io/FileDescriptor;ZJJZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/lock0(Ljava/io/FileDescriptor;ZJJZ)I"(thread: JVMThread, args: [java_io_FileDescriptor, number, Long, any, Long, any, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "release0(Ljava/io/FileDescriptor;JJ)V"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/release0(Ljava/io/FileDescriptor;JJ)V"(thread: JVMThread, args: [java_io_FileDescriptor, Long, any, Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "close0(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/close0(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public static "preClose0(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/preClose0(Ljava/io/FileDescriptor;)V"(thread: JVMThread, args: [java_io_FileDescriptor], cb?: (e?: java_lang_Throwable) => void): void;
    public static "closeIntFD(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/closeIntFD(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "init()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/init()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/FileDispatcherImpl/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_NativeThread extends java_lang_Object {
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/NativeThread/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "current()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "sun/nio/ch/NativeThread/current()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public static "signal(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/NativeThread/signal(J)V"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable) => void): void;
    public static "init()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/NativeThread/init()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/NativeThread/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_UnixAsynchronousSocketChannelImpl extends sun_nio_ch_AsynchronousSocketChannelImpl implements sun_nio_ch_Port$PollableChannel {
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/nd": sun_nio_ch_NativeDispatcher;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/disableSynchronousRead": number;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/port": sun_nio_ch_Port;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/fdVal": number;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/updateLock": java_lang_Object;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/connectPending": number;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/connectHandler": java_nio_channels_CompletionHandler;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/connectAttachment": java_lang_Object;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/connectFuture": sun_nio_ch_PendingFuture;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/pendingRemote": java_net_SocketAddress;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readPending": number;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/isScatteringRead": number;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readBuffer": java_nio_ByteBuffer;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readBuffers": JVMArray<java_nio_ByteBuffer>;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readHandler": java_nio_channels_CompletionHandler;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readAttachment": java_lang_Object;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readFuture": sun_nio_ch_PendingFuture;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readTimer": java_util_concurrent_Future;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writePending": number;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/isGatheringWrite": number;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writeBuffer": java_nio_ByteBuffer;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writeBuffers": JVMArray<java_nio_ByteBuffer>;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writeHandler": java_nio_channels_CompletionHandler;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writeAttachment": java_lang_Object;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writeFuture": sun_nio_ch_PendingFuture;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writeTimer": java_util_concurrent_Future;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/readTimeoutTask": java_lang_Runnable;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/writeTimeoutTask": java_lang_Runnable;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/$assertionsDisabled": number;
    public "<init>(Lsun/nio/ch/Port;)V"(thread: JVMThread, args: [sun_nio_ch_Port], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/<init>(Lsun/nio/ch/Port;)V"(thread: JVMThread, args: [sun_nio_ch_Port], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(Lsun/nio/ch/Port;Ljava/io/FileDescriptor;Ljava/net/InetSocketAddress;)V"(thread: JVMThread, args: [sun_nio_ch_Port, java_io_FileDescriptor, java_net_InetSocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/<init>(Lsun/nio/ch/Port;Ljava/io/FileDescriptor;Ljava/net/InetSocketAddress;)V"(thread: JVMThread, args: [sun_nio_ch_Port, java_io_FileDescriptor, java_net_InetSocketAddress], cb?: (e?: java_lang_Throwable) => void): void;
    public "group()Lsun/nio/ch/AsynchronousChannelGroupImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_AsynchronousChannelGroupImpl) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/group()Lsun/nio/ch/AsynchronousChannelGroupImpl;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_AsynchronousChannelGroupImpl) => void): void;
    public "updateEvents()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/updateEvents()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "lockAndUpdateEvents()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/lockAndUpdateEvents()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "finish(ZZZ)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/finish(ZZZ)V"(thread: JVMThread, args: [number, number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "onEvent(IZ)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/onEvent(IZ)V"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "implClose()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/implClose()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "onCancel(Lsun/nio/ch/PendingFuture;)V"(thread: JVMThread, args: [sun_nio_ch_PendingFuture], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/onCancel(Lsun/nio/ch/PendingFuture;)V"(thread: JVMThread, args: [sun_nio_ch_PendingFuture], cb?: (e?: java_lang_Throwable) => void): void;
    public "setConnected()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/setConnected()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "finishConnect(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/finishConnect(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "implConnect(Ljava/net/SocketAddress;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_net_SocketAddress, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/implConnect(Ljava/net/SocketAddress;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_net_SocketAddress, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "finishRead(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/finishRead(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "implRead(ZLjava/nio/ByteBuffer;[Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [number, java_nio_ByteBuffer, JVMArray<java_nio_ByteBuffer>, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/implRead(ZLjava/nio/ByteBuffer;[Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [number, java_nio_ByteBuffer, JVMArray<java_nio_ByteBuffer>, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "finishWrite(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/finishWrite(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "implWrite(ZLjava/nio/ByteBuffer;[Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [number, java_nio_ByteBuffer, JVMArray<java_nio_ByteBuffer>, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "sun/nio/ch/UnixAsynchronousSocketChannelImpl/implWrite(ZLjava/nio/ByteBuffer;[Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [number, java_nio_ByteBuffer, JVMArray<java_nio_ByteBuffer>, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public static "checkConnect(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/checkConnect(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public static "access$000(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/lang/Object;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$000(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/lang/Object;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "access$100(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$100(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$102(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;Z)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$102(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;Z)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$200(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/nio/channels/CompletionHandler;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_CompletionHandler) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$200(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/nio/channels/CompletionHandler;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_CompletionHandler) => void): void;
    public static "access$300(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/lang/Object;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$300(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/lang/Object;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "access$400(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Lsun/nio/ch/PendingFuture;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_PendingFuture) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$400(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Lsun/nio/ch/PendingFuture;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_PendingFuture) => void): void;
    public static "access$500(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$500(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$502(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;Z)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$502(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;Z)Z"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "access$600(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/nio/channels/CompletionHandler;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_CompletionHandler) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$600(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/nio/channels/CompletionHandler;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_CompletionHandler) => void): void;
    public static "access$700(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/lang/Object;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$700(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Ljava/lang/Object;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public static "access$800(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Lsun/nio/ch/PendingFuture;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_PendingFuture) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/access$800(Lsun/nio/ch/UnixAsynchronousSocketChannelImpl;)Lsun/nio/ch/PendingFuture;"(thread: JVMThread, args: [sun_nio_ch_UnixAsynchronousSocketChannelImpl], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_PendingFuture) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/UnixAsynchronousSocketChannelImpl/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class sun_nio_ch_AsynchronousChannelGroupImpl extends java_nio_channels_AsynchronousChannelGroup implements java_util_concurrent_Executor {
    public static "sun/nio/ch/AsynchronousChannelGroupImpl/internalThreadCount": number;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/pool": sun_nio_ch_ThreadPool;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/threadCount": java_util_concurrent_atomic_AtomicInteger;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/timeoutExecutor": java_util_concurrent_ScheduledThreadPoolExecutor;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/taskQueue": java_util_Queue;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/shutdown": java_util_concurrent_atomic_AtomicBoolean;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/shutdownNowLock": java_lang_Object;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/terminateInitiated": number;
    public "<init>(Ljava/nio/channels/spi/AsynchronousChannelProvider;Lsun/nio/ch/ThreadPool;)V"(thread: JVMThread, args: [java_nio_channels_spi_AsynchronousChannelProvider, sun_nio_ch_ThreadPool], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/<init>(Ljava/nio/channels/spi/AsynchronousChannelProvider;Lsun/nio/ch/ThreadPool;)V"(thread: JVMThread, args: [java_nio_channels_spi_AsynchronousChannelProvider, sun_nio_ch_ThreadPool], cb?: (e?: java_lang_Throwable) => void): void;
    public "executor()Ljava/util/concurrent/ExecutorService;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ExecutorService) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/executor()Ljava/util/concurrent/ExecutorService;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ExecutorService) => void): void;
    public "isFixedThreadPool()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/isFixedThreadPool()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "fixedThreadCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/fixedThreadCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "bindToGroup(Ljava/lang/Runnable;)Ljava/lang/Runnable;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_lang_Runnable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/bindToGroup(Ljava/lang/Runnable;)Ljava/lang/Runnable;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_lang_Runnable) => void): void;
    public "startInternalThread(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/startInternalThread(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "startThreads(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/startThreads(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "threadCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/threadCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "threadExit(Ljava/lang/Runnable;Z)I"(thread: JVMThread, args: [java_lang_Runnable, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/threadExit(Ljava/lang/Runnable;Z)I"(thread: JVMThread, args: [java_lang_Runnable, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "executeOnHandlerTask(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/executeOnHandlerTask(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "executeOnPooledThread(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/executeOnPooledThread(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "offerTask(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/offerTask(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "pollTask()Ljava/lang/Runnable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Runnable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/pollTask()Ljava/lang/Runnable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Runnable) => void): void;
    public "schedule(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/schedule(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "isShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/isShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isTerminated()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/isTerminated()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "attachForeignChannel(Ljava/nio/channels/Channel;Ljava/io/FileDescriptor;)Ljava/lang/Object;"(thread: JVMThread, args: [java_nio_channels_Channel, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/attachForeignChannel(Ljava/nio/channels/Channel;Ljava/io/FileDescriptor;)Ljava/lang/Object;"(thread: JVMThread, args: [java_nio_channels_Channel, java_io_FileDescriptor], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    public "detachForeignChannel(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/detachForeignChannel(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    public "closeAllChannels()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/closeAllChannels()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdownHandlerTasks()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/shutdownHandlerTasks()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdownExecutors()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/shutdownExecutors()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdownNow()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/shutdownNow()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "detachFromThreadPool()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/detachFromThreadPool()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "awaitTermination(JLjava/util/concurrent/TimeUnit;)Z"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/awaitTermination(JLjava/util/concurrent/TimeUnit;)Z"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "sun/nio/ch/AsynchronousChannelGroupImpl/execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public static "access$000(Lsun/nio/ch/AsynchronousChannelGroupImpl;)Lsun/nio/ch/ThreadPool;"(thread: JVMThread, args: [sun_nio_ch_AsynchronousChannelGroupImpl], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_ThreadPool) => void): void;
    public static "sun/nio/ch/AsynchronousChannelGroupImpl/access$000(Lsun/nio/ch/AsynchronousChannelGroupImpl;)Lsun/nio/ch/ThreadPool;"(thread: JVMThread, args: [sun_nio_ch_AsynchronousChannelGroupImpl], cb?: (e?: java_lang_Throwable, rv?: sun_nio_ch_ThreadPool) => void): void;
    public static "access$100(Lsun/nio/ch/AsynchronousChannelGroupImpl;)Ljava/util/concurrent/ScheduledThreadPoolExecutor;"(thread: JVMThread, args: [sun_nio_ch_AsynchronousChannelGroupImpl], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledThreadPoolExecutor) => void): void;
    public static "sun/nio/ch/AsynchronousChannelGroupImpl/access$100(Lsun/nio/ch/AsynchronousChannelGroupImpl;)Ljava/util/concurrent/ScheduledThreadPoolExecutor;"(thread: JVMThread, args: [sun_nio_ch_AsynchronousChannelGroupImpl], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledThreadPoolExecutor) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "sun/nio/ch/AsynchronousChannelGroupImpl/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_nio_channels_spi_AsynchronousChannelProvider extends java_lang_Object {
    public static "checkPermission()Ljava/lang/Void;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Void) => void): void;
    public static "java/nio/channels/spi/AsynchronousChannelProvider/checkPermission()Ljava/lang/Void;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Void) => void): void;
    public "<init>(Ljava/lang/Void;)V"(thread: JVMThread, args: [java_lang_Void], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AsynchronousChannelProvider/<init>(Ljava/lang/Void;)V"(thread: JVMThread, args: [java_lang_Void], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/spi/AsynchronousChannelProvider/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "provider()Ljava/nio/channels/spi/AsynchronousChannelProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AsynchronousChannelProvider) => void): void;
    public static "java/nio/channels/spi/AsynchronousChannelProvider/provider()Ljava/nio/channels/spi/AsynchronousChannelProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AsynchronousChannelProvider) => void): void;
    public "openAsynchronousChannelGroup(ILjava/util/concurrent/ThreadFactory;)Ljava/nio/channels/AsynchronousChannelGroup;"(thread: JVMThread, args: [number, java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousChannelGroup) => void): void;
    public "java/nio/channels/spi/AsynchronousChannelProvider/openAsynchronousChannelGroup(ILjava/util/concurrent/ThreadFactory;)Ljava/nio/channels/AsynchronousChannelGroup;"(thread: JVMThread, args: [number, java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousChannelGroup) => void): void;
    public "openAsynchronousChannelGroup(Ljava/util/concurrent/ExecutorService;I)Ljava/nio/channels/AsynchronousChannelGroup;"(thread: JVMThread, args: [java_util_concurrent_ExecutorService, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousChannelGroup) => void): void;
    public "java/nio/channels/spi/AsynchronousChannelProvider/openAsynchronousChannelGroup(Ljava/util/concurrent/ExecutorService;I)Ljava/nio/channels/AsynchronousChannelGroup;"(thread: JVMThread, args: [java_util_concurrent_ExecutorService, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousChannelGroup) => void): void;
    public "openAsynchronousServerSocketChannel(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "java/nio/channels/spi/AsynchronousChannelProvider/openAsynchronousServerSocketChannel(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "openAsynchronousSocketChannel(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "java/nio/channels/spi/AsynchronousChannelProvider/openAsynchronousSocketChannel(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
  }
  export class java_nio_channels_AsynchronousSocketChannel extends java_lang_Object implements java_nio_channels_AsynchronousByteChannel, java_nio_channels_NetworkChannel {
    public "java/nio/channels/AsynchronousSocketChannel/provider": java_nio_channels_spi_AsynchronousChannelProvider;
    public "<init>(Ljava/nio/channels/spi/AsynchronousChannelProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_AsynchronousChannelProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/<init>(Ljava/nio/channels/spi/AsynchronousChannelProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_AsynchronousChannelProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "provider()Ljava/nio/channels/spi/AsynchronousChannelProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AsynchronousChannelProvider) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/provider()Ljava/nio/channels/spi/AsynchronousChannelProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AsynchronousChannelProvider) => void): void;
    public static "open(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public static "java/nio/channels/AsynchronousSocketChannel/open(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public static "open()Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public static "java/nio/channels/AsynchronousSocketChannel/open()Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "shutdownInput()Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/shutdownInput()Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "shutdownOutput()Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/shutdownOutput()Ljava/nio/channels/AsynchronousSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousSocketChannel) => void): void;
    public "getRemoteAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/getRemoteAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "connect(Ljava/net/SocketAddress;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_net_SocketAddress, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/connect(Ljava/net/SocketAddress;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_net_SocketAddress, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "connect(Ljava/net/SocketAddress;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/connect(Ljava/net/SocketAddress;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "read(Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/read(Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "read(Ljava/nio/ByteBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/read(Ljava/nio/ByteBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "read(Ljava/nio/ByteBuffer;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/read(Ljava/nio/ByteBuffer;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "read([Ljava/nio/ByteBuffer;IIJLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/read([Ljava/nio/ByteBuffer;IIJLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "write(Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/write(Ljava/nio/ByteBuffer;JLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "write(Ljava/nio/ByteBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/write(Ljava/nio/ByteBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "write(Ljava/nio/ByteBuffer;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/write(Ljava/nio/ByteBuffer;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "write([Ljava/nio/ByteBuffer;IIJLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/write([Ljava/nio/ByteBuffer;IIJLjava/util/concurrent/TimeUnit;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [JVMArray<java_nio_ByteBuffer>, number, number, Long, any, java_util_concurrent_TimeUnit, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/AsynchronousSocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
  }
  export interface java_nio_channels_AsynchronousByteChannel extends java_lang_Object, java_nio_channels_AsynchronousChannel {
    "read(Ljava/nio/ByteBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    "read(Ljava/nio/ByteBuffer;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "write(Ljava/nio/ByteBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_nio_ByteBuffer, java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    "write(Ljava/nio/ByteBuffer;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_nio_ByteBuffer], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export class java_nio_channels_AsynchronousServerSocketChannel extends java_lang_Object implements java_nio_channels_AsynchronousChannel, java_nio_channels_NetworkChannel {
    public "java/nio/channels/AsynchronousServerSocketChannel/provider": java_nio_channels_spi_AsynchronousChannelProvider;
    public "<init>(Ljava/nio/channels/spi/AsynchronousChannelProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_AsynchronousChannelProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/<init>(Ljava/nio/channels/spi/AsynchronousChannelProvider;)V"(thread: JVMThread, args: [java_nio_channels_spi_AsynchronousChannelProvider], cb?: (e?: java_lang_Throwable) => void): void;
    public "provider()Ljava/nio/channels/spi/AsynchronousChannelProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AsynchronousChannelProvider) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/provider()Ljava/nio/channels/spi/AsynchronousChannelProvider;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_spi_AsynchronousChannelProvider) => void): void;
    public static "open(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public static "java/nio/channels/AsynchronousServerSocketChannel/open(Ljava/nio/channels/AsynchronousChannelGroup;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_nio_channels_AsynchronousChannelGroup], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public static "open()Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public static "java/nio/channels/AsynchronousServerSocketChannel/open()Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;I)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/bind(Ljava/net/SocketAddress;I)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketAddress, number], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/AsynchronousServerSocketChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_AsynchronousServerSocketChannel) => void): void;
    public "accept(Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/accept(Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V"(thread: JVMThread, args: [java_lang_Object, java_nio_channels_CompletionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "accept()Ljava/util/concurrent/Future;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/accept()Ljava/util/concurrent/Future;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/getLocalAddress()Ljava/net/SocketAddress;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_net_SocketAddress) => void): void;
    public "setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/setOption(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketOption, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    public "java/nio/channels/AsynchronousServerSocketChannel/bind(Ljava/net/SocketAddress;)Ljava/nio/channels/NetworkChannel;"(thread: JVMThread, args: [java_net_SocketAddress], cb?: (e?: java_lang_Throwable, rv?: java_nio_channels_NetworkChannel) => void): void;
    "close()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "isOpen()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "getOption(Ljava/net/SocketOption;)Ljava/lang/Object;"(thread: JVMThread, args: [java_net_SocketOption], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "supportedOptions()Ljava/util/Set;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Set) => void): void;
  }
  export interface java_util_concurrent_ThreadFactory extends java_lang_Object {
    "newThread(Ljava/lang/Runnable;)Ljava/lang/Thread;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_lang_Thread) => void): void;
  }
  export class java_lang_Void extends java_lang_Object {
    public unbox(): number;
    public static box(): java_lang_Void;
    public static "java/lang/Void/TYPE": java_lang_Class;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/lang/Void/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/lang/Void/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_Queue extends java_lang_Object, java_util_Collection {
    "add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "offer(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "poll()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "element()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "peek()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "containsAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "addAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "retainAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_concurrent_ScheduledThreadPoolExecutor extends java_util_concurrent_ThreadPoolExecutor implements java_util_concurrent_ScheduledExecutorService {
    public "java/util/concurrent/ScheduledThreadPoolExecutor/continueExistingPeriodicTasksAfterShutdown": number;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/executeExistingDelayedTasksAfterShutdown": number;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/removeOnCancel": number;
    public static "java/util/concurrent/ScheduledThreadPoolExecutor/sequencer": java_util_concurrent_atomic_AtomicLong;
    public "now()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/now()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "canRunInCurrentRunState(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/canRunInCurrentRunState(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "delayedExecute(Ljava/util/concurrent/RunnableScheduledFuture;)V"(thread: JVMThread, args: [java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/delayedExecute(Ljava/util/concurrent/RunnableScheduledFuture;)V"(thread: JVMThread, args: [java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable) => void): void;
    public "reExecutePeriodic(Ljava/util/concurrent/RunnableScheduledFuture;)V"(thread: JVMThread, args: [java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/reExecutePeriodic(Ljava/util/concurrent/RunnableScheduledFuture;)V"(thread: JVMThread, args: [java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable) => void): void;
    public "onShutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/onShutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "decorateTask(Ljava/lang/Runnable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_RunnableScheduledFuture) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/decorateTask(Ljava/lang/Runnable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_RunnableScheduledFuture) => void): void;
    public "decorateTask(Ljava/util/concurrent/Callable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;"(thread: JVMThread, args: [java_util_concurrent_Callable, java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_RunnableScheduledFuture) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/decorateTask(Ljava/util/concurrent/Callable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;"(thread: JVMThread, args: [java_util_concurrent_Callable, java_util_concurrent_RunnableScheduledFuture], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_RunnableScheduledFuture) => void): void;
    public "<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/<init>(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(ILjava/util/concurrent/ThreadFactory;)V"(thread: JVMThread, args: [number, java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/<init>(ILjava/util/concurrent/ThreadFactory;)V"(thread: JVMThread, args: [number, java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(ILjava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/<init>(ILjava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(ILjava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, java_util_concurrent_ThreadFactory, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/<init>(ILjava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, java_util_concurrent_ThreadFactory, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "triggerTime(JLjava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/triggerTime(JLjava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "triggerTime(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/triggerTime(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "overflowFree(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/overflowFree(J)J"(thread: JVMThread, args: [Long, any], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "schedule(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/schedule(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "schedule(Ljava/util/concurrent/Callable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_util_concurrent_Callable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/schedule(Ljava/util/concurrent/Callable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_util_concurrent_Callable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "scheduleAtFixedRate(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/scheduleAtFixedRate(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "scheduleWithFixedDelay(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/scheduleWithFixedDelay(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    public "execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "submit(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/submit(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "submit(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/submit(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "submit(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_util_concurrent_Callable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/submit(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_util_concurrent_Callable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    public "setContinueExistingPeriodicTasksAfterShutdownPolicy(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/setContinueExistingPeriodicTasksAfterShutdownPolicy(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getContinueExistingPeriodicTasksAfterShutdownPolicy()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/getContinueExistingPeriodicTasksAfterShutdownPolicy()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setExecuteExistingDelayedTasksAfterShutdownPolicy(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/setExecuteExistingDelayedTasksAfterShutdownPolicy(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getExecuteExistingDelayedTasksAfterShutdownPolicy()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/getExecuteExistingDelayedTasksAfterShutdownPolicy()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setRemoveOnCancelPolicy(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/setRemoveOnCancelPolicy(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getRemoveOnCancelPolicy()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/getRemoveOnCancelPolicy()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdownNow()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/shutdownNow()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "getQueue()Ljava/util/concurrent/BlockingQueue;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_BlockingQueue) => void): void;
    public "java/util/concurrent/ScheduledThreadPoolExecutor/getQueue()Ljava/util/concurrent/BlockingQueue;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_BlockingQueue) => void): void;
    public static "access$000()Ljava/util/concurrent/atomic/AtomicLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_atomic_AtomicLong) => void): void;
    public static "java/util/concurrent/ScheduledThreadPoolExecutor/access$000()Ljava/util/concurrent/atomic/AtomicLong;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_atomic_AtomicLong) => void): void;
    public static "access$100(Ljava/util/concurrent/ScheduledThreadPoolExecutor;)Z"(thread: JVMThread, args: [java_util_concurrent_ScheduledThreadPoolExecutor], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/ScheduledThreadPoolExecutor/access$100(Ljava/util/concurrent/ScheduledThreadPoolExecutor;)Z"(thread: JVMThread, args: [java_util_concurrent_ScheduledThreadPoolExecutor], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/concurrent/ScheduledThreadPoolExecutor/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_concurrent_BlockingQueue extends java_lang_Object, java_util_Queue {
    "add(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "offer(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "put(Ljava/lang/Object;)V"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable) => void): void;
    "offer(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z"(thread: JVMThread, args: [java_lang_Object, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "take()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "poll(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "remainingCapacity()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "contains(Ljava/lang/Object;)Z"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "drainTo(Ljava/util/Collection;)I"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "drainTo(Ljava/util/Collection;I)I"(thread: JVMThread, args: [java_util_Collection, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "remove()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "poll()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "element()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "peek()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "size()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isEmpty()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "iterator()Ljava/util/Iterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Iterator) => void): void;
    "toArray()[Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"(thread: JVMThread, args: [JVMArray<java_lang_Object>], cb?: (e?: java_lang_Throwable, rv?: JVMArray<java_lang_Object>) => void): void;
    "containsAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "addAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "removeIf(Ljava/util/function/Predicate;)Z"(thread: JVMThread, args: [java_util_function_Predicate], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "retainAll(Ljava/util/Collection;)Z"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "clear()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "spliterator()Ljava/util/Spliterator;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Spliterator) => void): void;
    "stream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "parallelStream()Ljava/util/stream/Stream;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_stream_Stream) => void): void;
    "forEach(Ljava/util/function/Consumer;)V"(thread: JVMThread, args: [java_util_function_Consumer], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_concurrent_ScheduledFuture extends java_lang_Object, java_util_concurrent_Delayed, java_util_concurrent_Future {
    "getDelay(Ljava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "cancel(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isCancelled()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isDone()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "get(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_concurrent_Delayed extends java_lang_Object, java_lang_Comparable {
    "getDelay(Ljava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_concurrent_RejectedExecutionHandler extends java_lang_Object {
    "rejectedExecution(Ljava/lang/Runnable;Ljava/util/concurrent/ThreadPoolExecutor;)V"(thread: JVMThread, args: [java_lang_Runnable, java_util_concurrent_ThreadPoolExecutor], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export interface java_util_concurrent_RunnableScheduledFuture extends java_lang_Object, java_util_concurrent_RunnableFuture, java_util_concurrent_ScheduledFuture {
    "isPeriodic()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "run()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "cancel(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isCancelled()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isDone()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "get(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "getDelay(Ljava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    "compareTo(Ljava/lang/Object;)I"(thread: JVMThread, args: [java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
  }
  export interface java_util_concurrent_RunnableFuture extends java_lang_Object, java_lang_Runnable, java_util_concurrent_Future {
    "run()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "cancel(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isCancelled()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isDone()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "get()Ljava/lang/Object;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "get(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
  }
  export interface java_util_concurrent_ScheduledExecutorService extends java_lang_Object, java_util_concurrent_ExecutorService {
    "schedule(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    "schedule(Ljava/util/concurrent/Callable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_util_concurrent_Callable, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    "scheduleAtFixedRate(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    "scheduleWithFixedDelay(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;"(thread: JVMThread, args: [java_lang_Runnable, Long, any, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ScheduledFuture) => void): void;
    "shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    "shutdownNow()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "isShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "isTerminated()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "awaitTermination(JLjava/util/concurrent/TimeUnit;)Z"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    "submit(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_util_concurrent_Callable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "submit(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable, java_lang_Object], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "submit(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_Future) => void): void;
    "invokeAll(Ljava/util/Collection;)Ljava/util/List;"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "invokeAll(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/util/List;"(thread: JVMThread, args: [java_util_Collection, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    "invokeAny(Ljava/util/Collection;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_Collection], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "invokeAny(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"(thread: JVMThread, args: [java_util_Collection, Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: java_lang_Object) => void): void;
    "execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_concurrent_ThreadPoolExecutor extends java_util_concurrent_AbstractExecutorService {
    public "java/util/concurrent/ThreadPoolExecutor/ctl": java_util_concurrent_atomic_AtomicInteger;
    public static "java/util/concurrent/ThreadPoolExecutor/COUNT_BITS": number;
    public static "java/util/concurrent/ThreadPoolExecutor/CAPACITY": number;
    public static "java/util/concurrent/ThreadPoolExecutor/RUNNING": number;
    public static "java/util/concurrent/ThreadPoolExecutor/SHUTDOWN": number;
    public static "java/util/concurrent/ThreadPoolExecutor/STOP": number;
    public static "java/util/concurrent/ThreadPoolExecutor/TIDYING": number;
    public static "java/util/concurrent/ThreadPoolExecutor/TERMINATED": number;
    public "java/util/concurrent/ThreadPoolExecutor/workQueue": java_util_concurrent_BlockingQueue;
    public "java/util/concurrent/ThreadPoolExecutor/mainLock": java_util_concurrent_locks_ReentrantLock;
    public "java/util/concurrent/ThreadPoolExecutor/workers": java_util_HashSet;
    public "java/util/concurrent/ThreadPoolExecutor/termination": java_util_concurrent_locks_Condition;
    public "java/util/concurrent/ThreadPoolExecutor/largestPoolSize": number;
    public "java/util/concurrent/ThreadPoolExecutor/completedTaskCount": Long;
    public "java/util/concurrent/ThreadPoolExecutor/threadFactory": java_util_concurrent_ThreadFactory;
    public "java/util/concurrent/ThreadPoolExecutor/handler": java_util_concurrent_RejectedExecutionHandler;
    public "java/util/concurrent/ThreadPoolExecutor/keepAliveTime": Long;
    public "java/util/concurrent/ThreadPoolExecutor/allowCoreThreadTimeOut": number;
    public "java/util/concurrent/ThreadPoolExecutor/corePoolSize": number;
    public "java/util/concurrent/ThreadPoolExecutor/maximumPoolSize": number;
    public static "java/util/concurrent/ThreadPoolExecutor/defaultHandler": java_util_concurrent_RejectedExecutionHandler;
    public static "java/util/concurrent/ThreadPoolExecutor/shutdownPerm": java_lang_RuntimePermission;
    public static "java/util/concurrent/ThreadPoolExecutor/ONLY_ONE": number;
    public static "runStateOf(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/ThreadPoolExecutor/runStateOf(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "workerCountOf(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/ThreadPoolExecutor/workerCountOf(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "ctlOf(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/ThreadPoolExecutor/ctlOf(II)I"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "runStateLessThan(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/ThreadPoolExecutor/runStateLessThan(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "runStateAtLeast(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/ThreadPoolExecutor/runStateAtLeast(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "isRunning(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/ThreadPoolExecutor/isRunning(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareAndIncrementWorkerCount(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/compareAndIncrementWorkerCount(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "compareAndDecrementWorkerCount(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/compareAndDecrementWorkerCount(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "decrementWorkerCount()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/decrementWorkerCount()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "advanceRunState(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/advanceRunState(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "tryTerminate()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/tryTerminate()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "checkShutdownAccess()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/checkShutdownAccess()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "interruptWorkers()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/interruptWorkers()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "interruptIdleWorkers(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/interruptIdleWorkers(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "interruptIdleWorkers()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/interruptIdleWorkers()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "reject(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/reject(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "onShutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/onShutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isRunningOrShutdown(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/isRunningOrShutdown(Z)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "drainQueue()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/drainQueue()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "addWorker(Ljava/lang/Runnable;Z)Z"(thread: JVMThread, args: [java_lang_Runnable, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/addWorker(Ljava/lang/Runnable;Z)Z"(thread: JVMThread, args: [java_lang_Runnable, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "addWorkerFailed(Ljava/util/concurrent/ThreadPoolExecutor$Worker;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor$Worker], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/addWorkerFailed(Ljava/util/concurrent/ThreadPoolExecutor$Worker;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor$Worker], cb?: (e?: java_lang_Throwable) => void): void;
    public "processWorkerExit(Ljava/util/concurrent/ThreadPoolExecutor$Worker;Z)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor$Worker, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/processWorkerExit(Ljava/util/concurrent/ThreadPoolExecutor$Worker;Z)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor$Worker, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getTask()Ljava/lang/Runnable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Runnable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getTask()Ljava/lang/Runnable;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Runnable) => void): void;
    public "runWorker(Ljava/util/concurrent/ThreadPoolExecutor$Worker;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor$Worker], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/runWorker(Ljava/util/concurrent/ThreadPoolExecutor$Worker;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor$Worker], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue, java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue, java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue, java_util_concurrent_ThreadFactory, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/<init>(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [number, number, Long, any, java_util_concurrent_TimeUnit, java_util_concurrent_BlockingQueue, java_util_concurrent_ThreadFactory, java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/execute(Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/shutdown()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "shutdownNow()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/shutdownNow()Ljava/util/List;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_List) => void): void;
    public "isShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/isShutdown()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isTerminating()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/isTerminating()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isTerminated()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/isTerminated()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "awaitTermination(JLjava/util/concurrent/TimeUnit;)Z"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/awaitTermination(JLjava/util/concurrent/TimeUnit;)Z"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "finalize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/finalize()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setThreadFactory(Ljava/util/concurrent/ThreadFactory;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/setThreadFactory(Ljava/util/concurrent/ThreadFactory;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadFactory], cb?: (e?: java_lang_Throwable) => void): void;
    public "getThreadFactory()Ljava/util/concurrent/ThreadFactory;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ThreadFactory) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getThreadFactory()Ljava/util/concurrent/ThreadFactory;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_ThreadFactory) => void): void;
    public "setRejectedExecutionHandler(Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/setRejectedExecutionHandler(Ljava/util/concurrent/RejectedExecutionHandler;)V"(thread: JVMThread, args: [java_util_concurrent_RejectedExecutionHandler], cb?: (e?: java_lang_Throwable) => void): void;
    public "getRejectedExecutionHandler()Ljava/util/concurrent/RejectedExecutionHandler;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_RejectedExecutionHandler) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getRejectedExecutionHandler()Ljava/util/concurrent/RejectedExecutionHandler;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_RejectedExecutionHandler) => void): void;
    public "setCorePoolSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/setCorePoolSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getCorePoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getCorePoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "prestartCoreThread()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/prestartCoreThread()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "ensurePrestart()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/ensurePrestart()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "prestartAllCoreThreads()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/prestartAllCoreThreads()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "allowsCoreThreadTimeOut()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/allowsCoreThreadTimeOut()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "allowCoreThreadTimeOut(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/allowCoreThreadTimeOut(Z)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "setMaximumPoolSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/setMaximumPoolSize(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "getMaximumPoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getMaximumPoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setKeepAliveTime(JLjava/util/concurrent/TimeUnit;)V"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/setKeepAliveTime(JLjava/util/concurrent/TimeUnit;)V"(thread: JVMThread, args: [Long, any, java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable) => void): void;
    public "getKeepAliveTime(Ljava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getKeepAliveTime(Ljava/util/concurrent/TimeUnit;)J"(thread: JVMThread, args: [java_util_concurrent_TimeUnit], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getQueue()Ljava/util/concurrent/BlockingQueue;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_BlockingQueue) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getQueue()Ljava/util/concurrent/BlockingQueue;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_BlockingQueue) => void): void;
    public "remove(Ljava/lang/Runnable;)Z"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/remove(Ljava/lang/Runnable;)Z"(thread: JVMThread, args: [java_lang_Runnable], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "purge()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/purge()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getPoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getPoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getActiveCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getActiveCount()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getLargestPoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getLargestPoolSize()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getTaskCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getTaskCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "getCompletedTaskCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/getCompletedTaskCount()J"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: Long) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "beforeExecute(Ljava/lang/Thread;Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Thread, java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/beforeExecute(Ljava/lang/Thread;Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_lang_Thread, java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "afterExecute(Ljava/lang/Runnable;Ljava/lang/Throwable;)V"(thread: JVMThread, args: [java_lang_Runnable, java_lang_Throwable], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/afterExecute(Ljava/lang/Runnable;Ljava/lang/Throwable;)V"(thread: JVMThread, args: [java_lang_Runnable, java_lang_Throwable], cb?: (e?: java_lang_Throwable) => void): void;
    public "terminated()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor/terminated()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/concurrent/ThreadPoolExecutor/<clinit>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_concurrent_ThreadPoolExecutor$Worker extends java_util_concurrent_locks_AbstractQueuedSynchronizer implements java_lang_Runnable {
    public static "java/util/concurrent/ThreadPoolExecutor$Worker/serialVersionUID": Long;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/thread": java_lang_Thread;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/firstTask": java_lang_Runnable;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/completedTasks": Long;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/this$0": java_util_concurrent_ThreadPoolExecutor;
    public "<init>(Ljava/util/concurrent/ThreadPoolExecutor;Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor, java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/<init>(Ljava/util/concurrent/ThreadPoolExecutor;Ljava/lang/Runnable;)V"(thread: JVMThread, args: [java_util_concurrent_ThreadPoolExecutor, java_lang_Runnable], cb?: (e?: java_lang_Throwable) => void): void;
    public "run()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/run()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isHeldExclusively()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/isHeldExclusively()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "tryAcquire(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/tryAcquire(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "tryRelease(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/tryRelease(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "lock()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/lock()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "tryLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/tryLock()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "unlock()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/unlock()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "isLocked()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/isLocked()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "interruptIfStarted()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/ThreadPoolExecutor$Worker/interruptIfStarted()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
  }
  export class java_util_concurrent_locks_AbstractQueuedSynchronizer extends java_util_concurrent_locks_AbstractOwnableSynchronizer implements java_io_Serializable {
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/serialVersionUID": Long;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/head": java_util_concurrent_locks_AbstractQueuedSynchronizer$Node;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/tail": java_util_concurrent_locks_AbstractQueuedSynchronizer$Node;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/state": number;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/spinForTimeoutThreshold": Long;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/unsafe": sun_misc_Unsafe;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/stateOffset": Long;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/headOffset": Long;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/tailOffset": Long;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/waitStatusOffset": Long;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/nextOffset": Long;
    public "<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/<init>()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "getState()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/getState()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "setState(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/setState(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "compareAndSetState(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/compareAndSetState(II)Z"(thread: JVMThread, args: [number, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "enq(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_locks_AbstractQueuedSynchronizer$Node) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/enq(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_locks_AbstractQueuedSynchronizer$Node) => void): void;
    public "addWaiter(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_locks_AbstractQueuedSynchronizer$Node) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/addWaiter(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: java_util_concurrent_locks_AbstractQueuedSynchronizer$Node) => void): void;
    public "setHead(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/setHead(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "unparkSuccessor(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/unparkSuccessor(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "doReleaseShared()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/doReleaseShared()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "setHeadAndPropagate(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;I)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/setHeadAndPropagate(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;I)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node, number], cb?: (e?: java_lang_Throwable) => void): void;
    public "cancelAcquire(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/cancelAcquire(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)V"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable) => void): void;
    public static "shouldParkAfterFailedAcquire(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node, java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/shouldParkAfterFailedAcquire(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node, java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public static "selfInterrupt()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public static "java/util/concurrent/locks/AbstractQueuedSynchronizer/selfInterrupt()V"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable) => void): void;
    public "parkAndCheckInterrupt()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/parkAndCheckInterrupt()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "acquireQueued(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;I)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/acquireQueued(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;I)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node, number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "doAcquireInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/doAcquireInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "doAcquireNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/doAcquireNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "doAcquireShared(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/doAcquireShared(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "doAcquireSharedInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/doAcquireSharedInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "doAcquireSharedNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/doAcquireSharedNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "tryAcquire(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/tryAcquire(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "tryRelease(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/tryRelease(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "tryAcquireShared(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/tryAcquireShared(I)I"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "tryReleaseShared(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/tryReleaseShared(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "isHeldExclusively()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/isHeldExclusively()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "acquire(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/acquire(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "acquireInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/acquireInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "tryAcquireNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/tryAcquireNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "release(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/release(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "acquireShared(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/acquireShared(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "acquireSharedInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/acquireSharedInterruptibly(I)V"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable) => void): void;
    public "tryAcquireSharedNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/tryAcquireSharedNanos(IJ)Z"(thread: JVMThread, args: [number, Long, any], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "releaseShared(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/releaseShared(I)Z"(thread: JVMThread, args: [number], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hasQueuedThreads()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/hasQueuedThreads()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hasContended()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/hasContended()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getFirstQueuedThread()Ljava/lang/Thread;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Thread) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/getFirstQueuedThread()Ljava/lang/Thread;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Thread) => void): void;
    public "fullGetFirstQueuedThread()Ljava/lang/Thread;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Thread) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/fullGetFirstQueuedThread()Ljava/lang/Thread;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_Thread) => void): void;
    public "isQueued(Ljava/lang/Thread;)Z"(thread: JVMThread, args: [java_lang_Thread], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/isQueued(Ljava/lang/Thread;)Z"(thread: JVMThread, args: [java_lang_Thread], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "apparentlyFirstQueuedIsExclusive()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/apparentlyFirstQueuedIsExclusive()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "hasQueuedPredecessors()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/hasQueuedPredecessors()Z"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getQueueLength()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/getQueueLength()I"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "getQueuedThreads()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/getQueuedThreads()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "getExclusiveQueuedThreads()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/getExclusiveQueuedThreads()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "getSharedQueuedThreads()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/getSharedQueuedThreads()Ljava/util/Collection;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_util_Collection) => void): void;
    public "toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/toString()Ljava/lang/String;"(thread: JVMThread, args: {}[], cb?: (e?: java_lang_Throwable, rv?: java_lang_String) => void): void;
    public "isOnSyncQueue(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/isOnSyncQueue(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "findNodeFromTail(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/findNodeFromTail(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "transferForSignal(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/transferForSignal(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "transferAfterCancelledWait(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "java/util/concurrent/locks/AbstractQueuedSynchronizer/transferAfterCancelledWait(Ljava/util/concurrent/locks/AbstractQueuedSynchronizer$Node;)Z"(thread: JVMThread, args: [java_util_concurrent_locks_AbstractQueuedSynchronizer$Node], cb?: (e?: java_lang_Throwable, rv?: number) => void): void;
    public "f