'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _escapeMap = require('../utils/escapeMap');

var _escapeMap2 = _interopRequireDefault(_escapeMap);

var _unionClassNames = require('union-class-names');

var _unionClassNames2 = _interopRequireDefault(_unionClassNames);

var _mappedUnicode = require('../utils/mappedUnicode');

var _mappedUnicode2 = _interopRequireDefault(_mappedUnicode);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var Emoji = function Emoji(_ref) {
  var _ref$theme = _ref.theme;
  var theme = _ref$theme === undefined ? {} : _ref$theme;
  var cacheBustParam = _ref.cacheBustParam;
  var imagePath = _ref.imagePath;
  var className = _ref.className;
  var decoratedText = _ref.decoratedText;

  var props = _objectWithoutProperties(_ref, ['theme', 'cacheBustParam', 'imagePath', 'className', 'decoratedText']);

  var unicode = _escapeMap2.default[decoratedText];
  var backgroundImage = 'url(' + imagePath + unicode + '.svg' + cacheBustParam + ')';
  var combinedClassName = (0, _unionClassNames2.default)(theme.emoji, className);
  var characterClassName = (0, _unionClassNames2.default)(theme.emojiCharacter);
  return _react2.default.createElement(
    'span',
    {
      className: combinedClassName,
      title: _mappedUnicode2.default[unicode],
      style: { backgroundImage: backgroundImage }
    },
    _react2.default.createElement(
      'span',
      { className: characterClassName },
      props.children
    )
  );
};

exports.default = Emoji;