"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var getWordAt = function getWordAt(string, position) {
  // Perform type conversions.
  var str = String(string);
  var pos = Number(position) >>> 0;

  // Search for the word's beginning and end.
  var left = str.slice(0, pos + 1).search(/\S+$/);
  var right = str.slice(pos).search(/\s/);

  // The last word in the string is a special case.
  if (right < 0) {
    return {
      word: str.slice(left),
      begin: left,
      end: str.length
    };
  }

  // Return the word, using the located bounds to extract it from the string.
  return {
    word: str.slice(left, right + pos),
    begin: left,
    end: right + pos
  };
};

exports.default = getWordAt;