'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _emojioneList = require('./emojioneList');

var _emojioneList2 = _interopRequireDefault(_emojioneList);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapUnicode = function mapUnicode() {
  var unicodes = {};
  for (var shortname in _emojioneList2.default) {
    if (!_emojioneList2.default.hasOwnProperty(shortname)) {
      continue;
    }

    for (var i = 0, len = _emojioneList2.default[shortname].length; i < len; i++) {
      unicodes[_emojioneList2.default[shortname][i]] = shortname;
    }
  }

  return unicodes;
};

exports.default = mapUnicode();