'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.imageStyles = exports.imageCreator = undefined;

var _image = require('./components/image');

var _image2 = _interopRequireDefault(_image);

var _style = {
  "imageWrapper": "draftJsEmojiPlugin__imageWrapper__o63QA",
  "imageButton": "draftJsEmojiPlugin__imageButton__IvvDa",
  "image": "draftJsEmojiPlugin__image__1gkdB",
  "imageLoader": "draftJsEmojiPlugin__imageLoader__1rOmo"
};

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var imagePlugin = function imagePlugin(config) {
  var type = config.type || 'block-image';
  var theme = config.theme ? config.theme : _style2.default;
  var component = config.component || (0, _image2.default)({ theme: theme });
  return {
    // Handle 'block-image' block-type with Image component
    blockRendererFn: function blockRendererFn(contentBlock) {
      var blockType = contentBlock.getType();
      if (blockType === type) {
        return {
          component: component
        };
      }return undefined;
    }
  };
};

exports.default = imagePlugin;
var imageCreator = exports.imageCreator = _image2.default;
var imageStyles = exports.imageStyles = _style2.default;