'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _draftJs = require('draft-js');

var moveToEndOfSelectedBlock = function moveToEndOfSelectedBlock(editorState, onChange) {
  if (onChange === undefined) return;
  var selection = editorState.getSelection();
  var block = editorState.getCurrentContent().getBlockForKey(selection.getAnchorKey());
  var size = block.getLength();
  if (selection.getAnchorOffset() !== size || selection.getFocusOffset() !== size) {
    var newSelection = selection.merge({
      anchorOffset: size,
      focusOffset: size
    });
    var newEditorState = _draftJs.EditorState.forceSelection(editorState, newSelection);
    onChange(newEditorState);
  }
};

exports.default = moveToEndOfSelectedBlock;