'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _draftJs = require('draft-js');

var moveToEndOfSelectedBlock = function moveToEndOfSelectedBlock(editorState, onChange) {
  if (onChange === undefined) return;
  var selection = editorState.getSelection();
  if (selection.getAnchorOffset() !== 0 || selection.getFocusOffset() !== 0) {
    var newSelection = selection.merge({
      anchorOffset: 0,
      focusOffset: 0
    });
    var newEditorState = _draftJs.EditorState.forceSelection(editorState, newSelection);
    onChange(newEditorState);
  }
};

exports.default = moveToEndOfSelectedBlock;