'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _draftJs = require('draft-js');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Sticker = function (_Component) {
  _inherits(Sticker, _Component);

  function Sticker() {
    var _Object$getPrototypeO;

    var _temp, _this, _ret;

    _classCallCheck(this, Sticker);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_Object$getPrototypeO = Object.getPrototypeOf(Sticker)).call.apply(_Object$getPrototypeO, [this].concat(args))), _this), _this.remove = function (event) {
      // Note: important to avoid a content edit change
      event.preventDefault();
      event.stopPropagation();

      _this.props.blockProps.onRemove(_this.props.block.getKey());
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Sticker, [{
    key: 'render',
    value: function render() {
      var _props = this.props;
      var block = _props.block;
      var stickers = _props.stickers;
      var _props$theme = _props.theme;
      var theme = _props$theme === undefined ? {} : _props$theme;

      var removeButton = _react2.default.createElement(
        'span',
        {
          className: theme.stickerRemoveButton,
          onClick: this.remove,
          role: 'button'
        },
        '✕'
      );

      var data = _draftJs.Entity.get(block.getEntityAt(0)).getData();
      return _react2.default.createElement(
        'figure',
        {
          contentEditable: false,
          'data-offset-key': block.get('key') + '-0-0',
          className: theme.sticker
        },
        _react2.default.createElement('img', {
          className: theme.stickerImage,
          src: stickers.getIn(['data', data.id, 'url']),
          role: 'presentation'
        }),
        this.props.attachRemoveButton ? removeButton : null
      );
    }
  }]);

  return Sticker;
}(_react.Component);

exports.default = Sticker;